/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.LayerManager;
import org.tigris.gef.base.ModeCreate;
import org.tigris.gef.base.SelectionButtons;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;

public class ModeCreateEdgeAndNode
extends ModeCreate {
    private static final Log LOG = LogFactory.getLog(ModeCreateEdgeAndNode.class);
    private static int dragsToExisting = 0;
    private static int dragsToNew = 0;
    private Object startPort;
    private Fig startPortFig;
    private FigNode sourceFigNode;
    private Object newEdge;
    private boolean destToSource = false;
    private Handle handle = new Handle(-1);
    private FigNode fn;
    private FigEdge fe;
    private boolean postProcessEdge = false;
    static final long serialVersionUID = -427957543380196265L;

    public ModeCreateEdgeAndNode() {
    }

    public ModeCreateEdgeAndNode(Editor ed, Object edgeType, Object nodeType, boolean post) {
        super(ed);
        this.setArg("edgeClass", edgeType);
        this.setArg("nodeClass", nodeType);
        this.postProcessEdge = post;
        LOG.debug((Object)("postprocessing: " + this.postProcessEdge));
    }

    public ModeCreateEdgeAndNode(Editor ed, Object edgeType, boolean post, SelectionButtons nodeCreator) {
        super(ed);
        this.setArg("edgeClass", edgeType);
        this.setArg("nodeCreator", nodeCreator);
        this.postProcessEdge = post;
        LOG.debug((Object)("postprocessing: " + this.postProcessEdge));
    }

    public void setup(FigNode fignode, Object port, int x, int y, boolean reverse) {
        this.start();
        this.sourceFigNode = fignode;
        this.startPortFig = fignode.getPortFig(port);
        this.startPort = port;
        this._newItem = this.createNewItem(null, x, y);
        this.destToSource = reverse;
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public String instructions() {
        return "Drag to define an edge (and a new node)";
    }

    @Override
    public Fig createNewItem(MouseEvent me, int snapX, int snapY) {
        FigPoly p = new FigPoly(snapX, snapY);
        p.setLineColor(Globals.getPrefs().getRubberbandColor());
        p.setFillColor(null);
        p.addPoint(snapX, snapY);
        return p;
    }

    @Override
    public void done() {
        super.done();
        if (this._newItem != null) {
            this.editor.damaged(this._newItem);
        }
        this._newItem = null;
        this.sourceFigNode = null;
        this.startPort = null;
        this.startPortFig = null;
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        GraphModel gm;
        if (me.isConsumed()) {
            return;
        }
        if (this.sourceFigNode == null) {
            this.done();
            return;
        }
        boolean nodeWasCreated = false;
        int x = me.getX();
        int y = me.getY();
        Editor ce = Globals.curEditor();
        Fig f = ce.hit(x, y);
        if (f == null) {
            f = ce.hit(x - 16, y - 16, 32, 32);
        }
        if (!((gm = ce.getGraphModel()) instanceof MutableGraphModel)) {
            f = null;
        }
        MutableGraphModel mgm = (MutableGraphModel)gm;
        if (f == null) {
            LOG.debug((Object)"make new node");
            ++dragsToNew;
            Object newNode = null;
            SelectionButtons sb = (SelectionButtons)this.getArg("nodeCreator");
            if (sb != null) {
                newNode = sb.getNewNode(0);
            } else {
                Class nodeClass = (Class)this.getArg("nodeClass");
                try {
                    newNode = nodeClass.newInstance();
                }
                catch (IllegalAccessException ignore) {
                    LOG.error((Object)ignore);
                    return;
                }
                catch (InstantiationException ignore) {
                    LOG.error((Object)ignore);
                    return;
                }
            }
            if (newNode instanceof GraphNodeHooks) {
                ((GraphNodeHooks)newNode).initialize(this._args);
            }
            if (mgm.canAddNode(newNode)) {
                GraphNodeRenderer renderer = this.editor.getGraphNodeRenderer();
                Layer lay = this.editor.getLayerManager().getActiveLayer();
                this.fn = renderer.getFigNodeFor(gm, lay, newNode, null);
                this.editor.add(this.fn);
                mgm.addNode(newNode);
                Fig encloser = null;
                Rectangle bbox = this.fn.getBounds();
                List otherFigs = lay.getContents();
                for (Fig otherFig : otherFigs) {
                    Rectangle trap;
                    if (!(otherFig instanceof FigNode) || otherFig.equals(this.fn) || (trap = otherFig.getTrapRect()) == null || !trap.contains(bbox.x, bbox.y) || !trap.contains(bbox.x + bbox.width, bbox.y + bbox.height)) continue;
                    encloser = otherFig;
                }
                this.fn.setEnclosingFig(encloser);
                if (newNode instanceof GraphNodeHooks) {
                    ((GraphNodeHooks)newNode).postPlacement(this.editor);
                }
                this.editor.getSelectionManager().select(this.fn);
                nodeWasCreated = true;
                f = this.fn;
                f.setLocation(x - f.getWidth() / 2, y - f.getHeight() / 2);
            }
        } else {
            ++dragsToExisting;
        }
        if (f instanceof FigNode) {
            Iterator it;
            FigNode destFigNode = (FigNode)f;
            Object foundPort = destFigNode.deepHitPort(x, y);
            if (foundPort == null && (it = destFigNode.getPortFigs().iterator()).hasNext()) {
                foundPort = ((Fig)it.next()).getOwner();
            }
            FigPoly p = (FigPoly)this._newItem;
            this.editor.damaged(p);
            p.setComplete(true);
            if (foundPort != null && foundPort != this.startPort) {
                Fig destPortFig = destFigNode.getPortFig(foundPort);
                Object edgeType = this.getArg("edgeClass");
                if (this.destToSource) {
                    Object temp = this.startPort;
                    this.startPort = foundPort;
                    foundPort = temp;
                    FigNode tempFN = destFigNode;
                    destFigNode = this.sourceFigNode;
                    this.sourceFigNode = tempFN;
                    Fig tempFigPort = this.startPortFig;
                    this.startPortFig = destPortFig;
                    destPortFig = tempFigPort;
                }
                this.newEdge = edgeType != null ? mgm.connect(this.startPort, foundPort, (Class)edgeType) : mgm.connect(this.startPort, foundPort);
                if (this.newEdge != null) {
                    if (this.postProcessEdge) {
                        LOG.debug((Object)"postprocess edge.");
                        this.postProcessEdge();
                    }
                    ce.damaged(this._newItem);
                    this.sourceFigNode.damage();
                    destFigNode.damage();
                    LayerManager lm = ce.getLayerManager();
                    this.fe = (FigEdge)lm.getActiveLayer().presentationFor(this.newEdge);
                    this._newItem.setLineColor(Color.black);
                    this.fe.setLineColor(Color.black);
                    this.fe.setFig(this._newItem);
                    this.fe.setSourcePortFig(this.startPortFig);
                    this.fe.setSourceFigNode(this.sourceFigNode);
                    this.fe.setDestPortFig(destPortFig);
                    this.fe.setDestFigNode(destFigNode);
                    this.fe.setSourcePortFig(this.startPortFig);
                    this.fe.setSourceFigNode(this.sourceFigNode);
                    this.fe.setDestPortFig(destPortFig);
                    this.fe.setDestFigNode(destFigNode);
                    if (this.fe != null && !nodeWasCreated) {
                        ce.getSelectionManager().select(this.fe);
                    }
                    this.done();
                    this._newItem = null;
                    if (this.fe instanceof MouseListener) {
                        ((MouseListener)((Object)this.fe)).mouseReleased(me);
                    }
                    if (this.sourceFigNode != null) {
                        this.sourceFigNode.updateEdges();
                    }
                    if (destFigNode != null) {
                        destFigNode.updateEdges();
                    }
                    return;
                }
                LOG.warn((Object)"connection return null");
            } else {
                LOG.warn((Object)"in dest node but no port");
            }
        }
        this.sourceFigNode.damage();
        ce.damaged(this._newItem);
        this._newItem = null;
        this.done();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.mouseDragged(me);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        int x = me.getX();
        int y = me.getY();
        if (this._newItem == null) {
            me.consume();
            return;
        }
        FigPoly p = (FigPoly)this._newItem;
        this.editor.damaged(this._newItem);
        Point snapPt = new Point(x, y);
        this.editor.snap(snapPt);
        this.handle.index = p.getNumPoints() - 1;
        p.moveVertex(this.handle, snapPt.x, snapPt.y, true);
        this.editor.damaged(this._newItem);
        me.consume();
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        if (ke.getKeyChar() == '\u001b') {
            this.done();
            ke.consume();
        }
    }

    protected void postProcessEdge() {
    }
}

