/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.ModeCreate;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigImage;

public class ModeCreateFigImage
extends ModeCreate {
    private static final long serialVersionUID = -3062009802693268691L;
    protected Image _image;

    public Image image() {
        return this._image;
    }

    public void image(Image i) {
        this._image = i;
    }

    @Override
    public String instructions() {
        return "Click to place an image";
    }

    @Override
    public Fig createNewItem(MouseEvent me, int snapX, int snapY) {
        if (null == this._image) {
            String dURL = "http://www.ics.uci.edu/~jrobbins/banners/gef_banner.gif";
            String urlString = (String)this._args.get("imageURL");
            if (urlString == null) {
                urlString = dURL;
            }
            this._image = Globals.getImage(urlString);
            Globals.waitForImages();
        }
        return new FigImage(snapX, snapY, this._image);
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        this.start();
        this.anchorX = x;
        this.anchorY = y;
        Point snapPt = new Point(x, y);
        this.editor.snap(snapPt);
        if (null == this._newItem) {
            this._newItem = this.createNewItem(me, snapPt.x, snapPt.y);
        }
        me.consume();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.editor.damageAll();
        me.consume();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        me.consume();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        if (this._newItem == null) {
            System.out.println("null _newItem");
            me.consume();
            return;
        }
        this.editor.damageAll();
        Point snapPt = new Point(x, y);
        this.editor.snap(snapPt);
        this._newItem.setLocation(snapPt.x, snapPt.y);
        this.editor.damageAll();
        me.consume();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.mouseMoved(me);
    }
}

