/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class NearAction
extends UndoableAction {
    private static final long serialVersionUID = -4295539588596245495L;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    private int direction;
    private int magnitude;

    public NearAction(String name, int direction) {
        this(name, direction, 1, false);
    }

    public NearAction(String name, int direction, int magnitude) {
        this(name, direction, magnitude, false);
    }

    public NearAction(String name, Icon icon, int direction) {
        this(name, icon, direction, 1, false);
    }

    public NearAction(String name, Icon icon, int direction, int magnitude) {
        this(name, icon, direction, magnitude, false);
    }

    public NearAction(String name, int direction, boolean localize) {
        this(name, direction, 1, localize);
    }

    public NearAction(String name, int direction, int magnitude, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
        this.direction = direction;
        this.magnitude = magnitude;
    }

    public NearAction(String name, Icon icon, int direction, boolean localize) {
        this(name, icon, direction, 1, localize);
    }

    public NearAction(String name, Icon icon, int direction, int magnitude, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
        this.direction = direction;
        this.magnitude = magnitude;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Editor ce = Globals.curEditor();
        SelectionManager sm = ce.getSelectionManager();
        if (sm.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            return;
        }
        int dx = 0;
        int dy = 0;
        switch (this.direction) {
            case 1: {
                dx = 0 - this.magnitude;
                break;
            }
            case 2: {
                dx = this.magnitude;
                break;
            }
            case 3: {
                dy = 0 - this.magnitude;
                break;
            }
            case 4: {
                dy = this.magnitude;
            }
        }
        sm.translate(dx, dy);
        sm.endTrans();
    }
}

