/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.graph.presentation.JGraphFrame;
import org.tigris.gef.persistence.svg.SvgParser;
import org.tigris.gef.util.Localizer;
import org.tigris.gef.util.Util;

public class OpenSVGAction
extends AbstractAction
implements FilenameFilter {
    private static final long serialVersionUID = 596114767338320391L;
    private Dimension dimension;

    public OpenSVGAction(String name) {
        this(name, null, false);
    }

    public OpenSVGAction(String name, Dimension dimension) {
        this(name, dimension, false);
    }

    public OpenSVGAction(String name, Icon icon) {
        this(name, icon, null, false);
    }

    public OpenSVGAction(String name, Icon icon, Dimension dimension) {
        this(name, icon, dimension, false);
    }

    public OpenSVGAction(String name, Dimension dimension, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
        this.dimension = dimension;
    }

    public OpenSVGAction(String name, Icon icon, Dimension dimension, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
        this.dimension = dimension;
    }

    @Override
    public boolean accept(File dir, String name) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Editor ce = Globals.curEditor();
        FileDialog fd = new FileDialog(ce.findFrame(), "Open...", 0);
        fd.setFilenameFilter(this);
        fd.setDirectory(Globals.getLastDirectory());
        fd.setVisible(true);
        String filename = fd.getFile();
        String path = fd.getDirectory();
        Globals.setLastDirectory(path);
        if (filename != null) {
            try {
                Globals.showStatus("Reading " + path + filename + "...");
                URL url = Util.fileToURL(new File(path + filename));
                Diagram diag = SvgParser.SINGLETON.readDiagram(url);
                Editor ed = new Editor(diag);
                Globals.showStatus("Read " + path + filename);
                JGraphFrame jgf = new JGraphFrame(path + filename, ed);
                if (this.dimension != null) {
                    jgf.setSize(this.dimension);
                }
                jgf.setVisible(true);
            }
            catch (MalformedURLException murle) {
                System.out.println("bad URL");
            }
            catch (IOException e) {
                System.out.println("IOExcept in opensvg");
            }
        }
    }
}

