/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.tigris.gef.base.Globals;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class OpenWindowAction
extends UndoableAction {
    private static final long serialVersionUID = 8660792603517868506L;
    private String className;

    public OpenWindowAction(String name, String className) {
        this(name, className, false);
    }

    public OpenWindowAction(String name, String className, Icon icon) {
        this(name, icon, className, false);
    }

    public OpenWindowAction(String name, String className, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
        this.className = className;
    }

    public OpenWindowAction(String name, Icon icon, String className, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
        this.className = className;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.className != null) {
            Frame window;
            Class<?> clazz;
            Globals.showStatus("Opening window for " + this.className);
            try {
                clazz = Class.forName(this.className);
            }
            catch (ClassNotFoundException ignore) {
                return;
            }
            try {
                window = (Frame)clazz.newInstance();
            }
            catch (IllegalAccessException ignore) {
                return;
            }
            catch (InstantiationException ignore) {
                return;
            }
            window.setVisible(true);
            return;
        }
        System.out.println("invalid window name");
    }
}

