/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.util.Localizer;

public class SaveAction
extends AbstractAction
implements FilenameFilter {
    private static final long serialVersionUID = -7423650789224426733L;

    public SaveAction() {
        super("Save");
    }

    public SaveAction(String name) {
        this(name, false);
    }

    public SaveAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public SaveAction(String name, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public SaveAction(String name, Icon icon, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Editor ce = Globals.curEditor();
            FileDialog fd = new FileDialog(ce.findFrame(), "Save Diagram", 1);
            fd.setFilenameFilter(this);
            fd.setDirectory(Globals.getLastDirectory());
            fd.setVisible(true);
            String filename = fd.getFile();
            String path = fd.getDirectory();
            Globals.setLastDirectory(path);
            if (filename != null) {
                Globals.showStatus("Writing " + path + filename + "...");
                FileOutputStream f = new FileOutputStream(path + filename);
                ObjectOutputStream s = new ObjectOutputStream(f);
                ce.preSave();
                s.writeObject(ce);
                ce.postSave();
                Globals.showStatus("Wrote " + path + filename);
                f.close();
            }
        }
        catch (FileNotFoundException ignore) {
            System.out.println("got an FileNotFoundException");
        }
        catch (IOException ignore) {
            System.out.println("got an IOException");
            ignore.printStackTrace();
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        return true;
    }
}

