/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerDiagram;
import org.tigris.gef.util.Localizer;

public abstract class SaveGraphicsAction
extends AbstractAction {
    private static Log LOG = LogFactory.getLog(LayerDiagram.class);
    protected int scale = 1;
    protected OutputStream outputStream;

    protected abstract void saveGraphics(OutputStream var1, Editor var2, Rectangle var3) throws IOException;

    public SaveGraphicsAction(String name) {
        this(name, false);
    }

    public SaveGraphicsAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public SaveGraphicsAction(String name, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public SaveGraphicsAction(String name, Icon icon, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    public void setStream(OutputStream s) {
        this.outputStream = s;
    }

    public void setScale(int s) {
        this.scale = s;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Editor ce = Globals.curEditor();
        Rectangle drawingArea = ce.getLayerManager().getActiveLayer().calcDrawingArea();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Bounding box: " + drawingArea));
        }
        if (drawingArea.width <= 0 || drawingArea.height <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Graphics generation aborted.");
            }
            return;
        }
        boolean h = ce.getGridHidden();
        ce.setGridHidden(true);
        try {
            this.saveGraphics(this.outputStream, ce, drawingArea);
        }
        catch (IOException e) {
            LOG.error((Object)"Error while exporting Graphics:", (Throwable)e);
        }
        ce.setGridHidden(h);
    }
}

