/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionLowerRight;
import org.tigris.gef.base.SelectionMove;
import org.tigris.gef.base.SelectionNoop;
import org.tigris.gef.base.SelectionReshape;
import org.tigris.gef.base.SelectionResize;
import org.tigris.gef.event.GraphSelectionEvent;
import org.tigris.gef.event.GraphSelectionListener;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.undo.Memento;
import org.tigris.gef.undo.UndoManager;
import org.tigris.gef.util.VetoableChangeEventSource;

public class SelectionManager
implements Serializable,
KeyListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 3232261288542010603L;
    private Vector _selections = new Vector();
    private Editor _editor;
    private EventListenerList _listeners = new EventListenerList();
    private DragMemento dragMemento;
    private Fig _dragTopMostFig;
    private Fig _dragLeftMostFig;
    private List _draggingNodes;
    private List _draggingMovingEdges;
    private List _draggingNonMovingEdges;
    private List _draggingOthers;

    public SelectionManager(Editor ed) {
        this._editor = ed;
    }

    protected void addSelection(Selection s) {
        this._selections.addElement(s);
    }

    protected void addFig(Fig f) {
        if (f.isSelectable()) {
            this._selections.addElement(SelectionManager.makeSelectionFor(f));
        }
    }

    protected void addAllFigs(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.addFig((Fig)it.next());
        }
    }

    protected void removeAllElements() {
        this._selections.removeAllElements();
    }

    protected void removeSelection(Selection s) {
        if (s != null) {
            this._selections.removeElement(s);
        }
    }

    protected void removeFig(Fig f) {
        Selection s = this.findSelectionFor(f);
        if (s != null) {
            this._selections.removeElement(s);
        }
    }

    protected void allDamaged() {
        Rectangle bounds = this.getBounds();
        this._editor.scaleRect(bounds);
        this._editor.damaged(bounds);
    }

    public void select(Fig f) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        this.allDamaged();
        this.removeAllElements();
        this.addFig(f);
        this._editor.damageAll();
        this.fireSelectionChanged();
    }

    public void addToSelection(Fig fig) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        this.addFig(fig);
        this._editor.damageAll();
        this.fireSelectionChanged();
    }

    public void deselect(Fig f) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        if (this.containsFig(f)) {
            this.removeFig(f);
            this._editor.damageAll();
            this.fireSelectionChanged();
        }
    }

    public void toggle(Fig f) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        this._editor.damageAll();
        if (this.containsFig(f)) {
            this.removeFig(f);
        } else {
            this.addFig(f);
        }
        this._editor.damageAll();
        this.fireSelectionChanged();
    }

    public void deselectAll() {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        Rectangle damagedArea = this.getBounds();
        this.removeAllElements();
        this._editor.damaged(damagedArea);
        this.fireSelectionChanged();
    }

    public void select(Collection items) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        this.allDamaged();
        this.removeAllElements();
        this.addAllFigs(items);
        this.allDamaged();
        this.fireSelectionChanged();
    }

    public void toggle(Vector items) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        this.allDamaged();
        Enumeration figs = ((Vector)items.clone()).elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            if (this.containsFig(f)) {
                this.removeFig(f);
                continue;
            }
            this.addFig(f);
        }
        this.allDamaged();
        this.fireSelectionChanged();
    }

    public Selection findSelectionFor(Fig f) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements()) {
            Selection sel = (Selection)sels.nextElement();
            if (!sel.contains(f)) continue;
            return sel;
        }
        return null;
    }

    public Selection findSelectionAt(int x, int y) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements()) {
            Selection sel = (Selection)sels.nextElement();
            if (!sel.contains(x, y)) continue;
            return sel;
        }
        return null;
    }

    public boolean contains(Selection s) {
        return this._selections.contains(s);
    }

    public boolean containsFig(Fig f) {
        return this.findSelectionFor(f) != null;
    }

    public boolean getLocked() {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements()) {
            if (!((Selection)sels.nextElement()).getLocked()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this._selections.size();
    }

    public Vector selections() {
        return this._selections;
    }

    public Vector getFigs() {
        Vector<Fig> figs = new Vector<Fig>(this._selections.size());
        int selCount = this._selections.size();
        for (int i = 0; i < selCount; ++i) {
            figs.addElement(((Selection)this._selections.get(i)).getContent());
        }
        return figs;
    }

    public void endTrans() {
        int selSize = this._selections.size();
        ArrayList affected = new ArrayList();
        for (int i = 0; i < selSize; ++i) {
            Selection s = (Selection)this._selections.elementAt(i);
            this.addEnclosed(affected, s.getContent());
        }
        int size = affected.size();
        for (int i = 0; i < size; ++i) {
            Fig f = (Fig)affected.get(i);
            f.endTrans();
        }
    }

    public void paint(Graphics g) {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements()) {
            ((Selection)sels.nextElement()).paint(g);
        }
    }

    public void damage() {
        Enumeration ss = this._selections.elements();
        while (ss.hasMoreElements()) {
            ((Selection)ss.nextElement()).damage();
        }
    }

    public boolean contains(int x, int y) {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements()) {
            if (!((Selection)sels.nextElement()).contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public boolean hit(Rectangle r) {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements()) {
            if (!((Selection)sels.nextElement()).hit(r)) continue;
            return true;
        }
        return false;
    }

    public Rectangle getBounds() {
        int size = this._selections.size();
        if (size == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle r = ((Selection)this._selections.elementAt(0)).getBounds();
        for (int i = 1; i < size; ++i) {
            Selection sel = (Selection)this._selections.elementAt(i);
            r.add(sel.getBounds());
        }
        return r;
    }

    public Rectangle getContentBounds() {
        Rectangle r = null;
        Enumeration sels = this._selections.elements();
        if (sels.hasMoreElements()) {
            r = ((Selection)sels.nextElement()).getContentBounds();
        } else {
            return new Rectangle(0, 0, 0, 0);
        }
        while (sels.hasMoreElements()) {
            Selection sel = (Selection)sels.nextElement();
            r.add(sel.getContentBounds());
        }
        return r;
    }

    public Point getLocation() {
        int size = this._selections.size();
        if (size < 1) {
            return new Point(0, 0);
        }
        Selection sel = null;
        int lowestX = Integer.MAX_VALUE;
        int lowestY = Integer.MAX_VALUE;
        Point pt = null;
        for (int i = 0; i < size; ++i) {
            sel = (Selection)this._selections.elementAt(i);
            pt = sel.getLocation();
            if (pt.getX() < (double)lowestX) {
                lowestX = (int)pt.getX();
            }
            if (!(pt.getY() < (double)lowestY)) continue;
            lowestY = (int)pt.getY();
        }
        pt = null;
        sel = null;
        return new Point(lowestX, lowestY);
    }

    public void reorder(int func, Layer lay) {
        Enumeration ss = this._selections.elements();
        while (ss.hasMoreElements()) {
            ((Selection)ss.nextElement()).reorder(func, lay);
        }
    }

    public void translate(int dx, int dy) {
        Fig f;
        int i;
        Vector affected = new Vector();
        Vector nonMovingEdges = new Vector();
        Vector movingEdges = new Vector();
        Vector<FigNode> nodes = new Vector<FigNode>();
        int selSize = this._selections.size();
        for (int i2 = 0; i2 < selSize; ++i2) {
            Selection s = (Selection)this._selections.elementAt(i2);
            this.addEnclosed(affected, s.getContent());
        }
        int size = affected.size();
        for (i = 0; i < size; ++i) {
            f = (Fig)affected.elementAt(i);
            int fx = f.getX();
            int fy = f.getY();
            dx = Math.max(-fx, dx);
            dy = Math.max(-fy, dy);
        }
        for (i = 0; i < size; ++i) {
            f = (Fig)affected.elementAt(i);
            if (!(f instanceof FigNode)) {
                f.translate(dx, dy);
                continue;
            }
            FigNode fn = (FigNode)f;
            nodes.addElement(fn);
            fn.superTranslate(dx, dy);
            Collection figEdges = fn.getFigEdges(null);
            for (Object fe : figEdges) {
                if (nonMovingEdges.contains(fe) && !movingEdges.contains(fe)) {
                    movingEdges.addElement(fe);
                    continue;
                }
                nonMovingEdges.addElement(fe);
            }
        }
        int meSize = movingEdges.size();
        for (int i3 = 0; i3 < meSize; ++i3) {
            FigEdge fe = (FigEdge)movingEdges.elementAt(i3);
            fe.translateEdge(dx, dy);
        }
        int fnSize = nodes.size();
        for (int i4 = 0; i4 < fnSize; ++i4) {
            FigNode fn = (FigNode)nodes.elementAt(i4);
            fn.updateEdges();
        }
    }

    protected void addEnclosed(Collection affected, Fig f) {
        if (!affected.contains(f)) {
            affected.add(f);
            Vector enclosed = f.getEnclosedFigs();
            if (enclosed != null) {
                int size = enclosed.size();
                for (int i = 0; i < size; ++i) {
                    this.addEnclosed(affected, (Fig)enclosed.get(i));
                }
            }
        }
    }

    public void startDrag() {
        ArrayList draggingFigs = new ArrayList();
        this._draggingNodes = new ArrayList();
        this._draggingMovingEdges = new ArrayList();
        this._draggingNonMovingEdges = new ArrayList();
        this._draggingOthers = new ArrayList();
        int selectionCount = this._selections.size();
        for (int selectionIndex = 0; selectionIndex < selectionCount; ++selectionIndex) {
            Selection selection = (Selection)this._selections.get(selectionIndex);
            this.addEnclosed(draggingFigs, selection.getContent());
        }
        int figCount = draggingFigs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig fig = (Fig)draggingFigs.get(figIndex);
            if (fig instanceof FigEdge) {
                FigEdge figEdge = (FigEdge)fig;
                this.checkDragEdge(figEdge, draggingFigs, this._draggingNonMovingEdges);
                continue;
            }
            if (!(fig instanceof FigNode)) {
                this._draggingOthers.add(fig);
                continue;
            }
            FigNode figNode = (FigNode)fig;
            this._draggingNodes.add(figNode);
            Collection figEdges = figNode.getFigEdges(null);
            for (FigEdge figEdge : figEdges) {
                this.checkDragEdge(figEdge, draggingFigs, this._draggingNonMovingEdges);
            }
        }
        List topLeftList = this._draggingNodes.size() > 0 ? this._draggingNodes : this._draggingOthers;
        int s = topLeftList.size();
        for (int i = 0; i < s; ++i) {
            Fig fig = (Fig)topLeftList.get(i);
            if (this._dragLeftMostFig == null || fig.getX() < this._dragLeftMostFig.getX()) {
                this._dragLeftMostFig = fig;
            }
            if (this._dragTopMostFig != null && fig.getY() >= this._dragTopMostFig.getY()) continue;
            this._dragTopMostFig = fig;
        }
        if (UndoManager.getInstance().isGenerateMementos()) {
            this.dragMemento = new DragMemento(this._draggingNodes, this._draggingOthers, this._draggingMovingEdges, this._draggingNonMovingEdges);
        }
        UndoManager.getInstance().addMementoLock(this);
    }

    private void checkDragEdge(FigEdge figEdge, List draggingFigs, List draggingNonMovingEdges) {
        FigNode dest = figEdge.getDestFigNode();
        FigNode source = figEdge.getSourceFigNode();
        if (draggingFigs.contains(dest) && draggingFigs.contains(source)) {
            if (!this._draggingMovingEdges.contains(figEdge)) {
                this._draggingMovingEdges.add(figEdge);
            }
        } else if (!draggingNonMovingEdges.contains(figEdge)) {
            draggingNonMovingEdges.add(figEdge);
        }
    }

    public void drag(int dx, int dy) {
        if (this._dragLeftMostFig == null || this._dragTopMostFig == null) {
            return;
        }
        Rectangle dirtyRegion = this._dragLeftMostFig.getBounds();
        Rectangle figBounds = this._dragLeftMostFig.getBounds();
        dx = Math.max(-this._dragLeftMostFig.getX(), dx);
        dy = Math.max(-this._dragTopMostFig.getY(), dy);
        int nodeCount = this._draggingNodes.size();
        for (int i = 0; i < nodeCount; ++i) {
            FigNode figNode = (FigNode)this._draggingNodes.get(i);
            figNode.getBounds(figBounds);
            dirtyRegion.add(figBounds.x, figBounds.y);
            dirtyRegion.add(figBounds.x + dx, figBounds.y + dy);
            dirtyRegion.add(figBounds.x + figBounds.width, figBounds.y + figBounds.height);
            dirtyRegion.add(figBounds.x + figBounds.width + dx, figBounds.y + figBounds.height + dy);
            figNode.superTranslate(dx, dy);
        }
        int otherCount = this._draggingOthers.size();
        for (int i = 0; i < otherCount; ++i) {
            Fig fig = (Fig)this._draggingOthers.get(i);
            fig.getBounds(figBounds);
            dirtyRegion.add(figBounds.x, figBounds.y);
            dirtyRegion.add(figBounds.x + dx, figBounds.y + dy);
            dirtyRegion.add(figBounds.x + figBounds.width, figBounds.y + figBounds.height);
            dirtyRegion.add(figBounds.x + figBounds.width + dx, figBounds.y + figBounds.height + dy);
            fig.translate(dx, dy);
            fig.translateAnnotations();
        }
        int movingEdgeCount = this._draggingMovingEdges.size();
        for (int i = 0; i < movingEdgeCount; ++i) {
            FigEdge figEdge = (FigEdge)this._draggingMovingEdges.get(i);
            figEdge.getBounds(figBounds);
            dirtyRegion.add(figBounds.x, figBounds.y);
            dirtyRegion.add(figBounds.x + dx, figBounds.y + dy);
            dirtyRegion.add(figBounds.x + figBounds.width, figBounds.y + figBounds.height);
            dirtyRegion.add(figBounds.x + figBounds.width + dx, figBounds.y + figBounds.height + dy);
            figEdge.translateEdge(dx, dy);
            figEdge.translateAnnotations();
        }
        int nonMovingEdgeCount = this._draggingNonMovingEdges.size();
        for (int i = 0; i < nonMovingEdgeCount; ++i) {
            FigEdge figEdge = (FigEdge)this._draggingNonMovingEdges.get(i);
            figEdge.getBounds(figBounds);
            dirtyRegion.add(figBounds);
            figEdge.computeRoute();
            figEdge.getBounds(figBounds);
            dirtyRegion.add(figBounds);
            figEdge.translateAnnotations();
        }
        int extraDirt = 24;
        dirtyRegion.x -= extraDirt;
        dirtyRegion.y -= extraDirt;
        dirtyRegion.width += 2 * extraDirt;
        dirtyRegion.height += 2 * extraDirt;
        Layer layer = this._dragLeftMostFig.getLayer();
        if (layer == null && this._dragLeftMostFig.getOwner() instanceof Fig) {
            layer = ((Fig)this._dragLeftMostFig.getOwner()).getLayer();
        }
        if (layer != null) {
            List editors = layer.getEditors();
            int editorCount = editors.size();
            Rectangle dirtyRegionScaled = new Rectangle();
            for (int editorIndex = 0; editorIndex < editorCount; ++editorIndex) {
                Editor editor = (Editor)editors.get(editorIndex);
                double editorScale = editor.getScale();
                dirtyRegionScaled.x = (int)Math.floor((double)dirtyRegion.x * editorScale);
                dirtyRegionScaled.y = (int)Math.floor((double)dirtyRegion.y * editorScale);
                dirtyRegionScaled.width = (int)Math.floor((double)dirtyRegion.width * editorScale) + 1;
                dirtyRegionScaled.height = (int)Math.floor((double)dirtyRegion.height * editorScale) + 1;
                editor.damaged(dirtyRegionScaled);
            }
        } else {
            System.out.println("Selection manager: layer is null");
        }
    }

    public void stopDrag() {
        UndoManager.getInstance().removeMementoLock(this);
        if (this.dragMemento != null) {
            UndoManager.getInstance().addMemento(this.dragMemento);
        }
        this.dragMemento = null;
        this.cleanup();
    }

    private void cleanup() {
        this._dragTopMostFig = null;
        this._dragLeftMostFig = null;
        this._draggingNodes = null;
        this._draggingMovingEdges = null;
        this._draggingNonMovingEdges = null;
        this._draggingOthers = null;
    }

    public Point getDragLocation() {
        return new Point(this._dragLeftMostFig.getX(), this._dragTopMostFig.getY());
    }

    public void hitHandle(Rectangle r, Handle h) {
        if (this.size() == 1) {
            ((Selection)this._selections.firstElement()).hitHandle(r, h);
        } else {
            h.index = -1;
        }
    }

    public void dragHandle(int mx, int my, int an_x, int an_y, Handle h) {
        if (this.size() != 1) {
            return;
        }
        Selection sel = (Selection)this._selections.firstElement();
        sel.dragHandle(mx, my, an_x, an_y, h);
    }

    public void cleanUp() {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements()) {
            Selection sel = (Selection)sels.nextElement();
            Fig f = sel.getContent();
            f.cleanUp();
        }
    }

    public void removeFromGraph() {
        Enumeration ss = ((Vector)this._selections.clone()).elements();
        while (ss.hasMoreElements()) {
            ((Selection)ss.nextElement()).delete();
        }
    }

    public void dispose() {
        Enumeration ss = ((Vector)this._selections.clone()).elements();
        while (ss.hasMoreElements()) {
            Selection s = (Selection)ss.nextElement();
            Fig f = s.getContent();
            Object o = f.getOwner();
            if (!(o instanceof VetoableChangeEventSource)) continue;
            Vector v = (Vector)((VetoableChangeEventSource)o).getVetoableChangeListeners().clone();
            Enumeration vv = v.elements();
            vv = v.elements();
            Object firstElem = null;
            boolean firstIteration = true;
            while (vv.hasMoreElements()) {
                Object elem = vv.nextElement();
                if (!(elem instanceof Fig)) continue;
                if (firstIteration) {
                    firstElem = elem;
                    firstIteration = false;
                    continue;
                }
                ((Fig)elem).removeFromDiagram();
            }
            ((Fig)firstElem).deleteFromModel();
        }
    }

    public void deleteFromModel() {
        Enumeration ss = ((Vector)this._selections.clone()).elements();
        while (ss.hasMoreElements()) {
            Selection s = (Selection)ss.nextElement();
            Fig f = s.getContent();
            f.deleteFromModel();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !ke.isConsumed()) {
            ((Selection)sels.nextElement()).keyTyped(ke);
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !ke.isConsumed()) {
            ((Selection)sels.nextElement()).keyReleased(ke);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !ke.isConsumed()) {
            ((Selection)sels.nextElement()).keyPressed(ke);
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mouseMoved(me);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        Enumeration sels = this._selections.elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mouseDragged(me);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mouseClicked(me);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mousePressed(me);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mouseReleased(me);
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mouseExited(me);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        Enumeration sels = ((Vector)this._selections.clone()).elements();
        while (sels.hasMoreElements() && !me.isConsumed()) {
            ((Selection)sels.nextElement()).mouseEntered(me);
        }
    }

    public void addGraphSelectionListener(GraphSelectionListener listener) {
        this._listeners.add(GraphSelectionListener.class, listener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener listener) {
        this._listeners.remove(GraphSelectionListener.class, listener);
    }

    protected void fireSelectionChanged() {
        this.cleanup();
        Object[] listeners = this._listeners.getListenerList();
        GraphSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GraphSelectionListener.class) continue;
            if (e == null) {
                e = new GraphSelectionEvent(this._editor, this.getFigs());
            }
            ((GraphSelectionListener)listeners[i + 1]).selectionChanged(e);
        }
        this.updatePropertySheet();
    }

    public void updatePropertySheet() {
    }

    public Class findCommonSuperClass() {
        Iterator selectionIter = this._selections.iterator();
        HashMap<String, Integer> superclasses = new HashMap<String, Integer>();
        int maxCount = 0;
        Class<?> maxClass = null;
        while (selectionIter.hasNext()) {
            Class<?> figClass = ((Selection)selectionIter.next()).getContent().getClass();
            int count = 0;
            if (superclasses.containsKey(figClass.getName())) {
                count = (Integer)superclasses.get(figClass.getName());
                superclasses.put(figClass.getName(), new Integer(++count));
            } else {
                count = 1;
                superclasses.put(figClass.getName(), new Integer(count));
            }
            if (count > maxCount) {
                maxCount = count;
                maxClass = figClass;
            }
            for (Class<?> superClass = figClass.getSuperclass(); superClass != null && !superClass.equals(Fig.class); superClass = superClass.getSuperclass()) {
                if (superclasses.containsKey(superClass.getName())) {
                    count = (Integer)superclasses.get(superClass.getName());
                    superclasses.put(superClass.getName(), new Integer(++count));
                } else {
                    count = 1;
                    superclasses.put(superClass.getName(), new Integer(count));
                }
                if (count <= maxCount) continue;
                maxCount = count;
                maxClass = superClass;
            }
        }
        if (maxCount == this._selections.size()) {
            return maxClass;
        }
        return Fig.class;
    }

    public Object findFirstSelectionOfType(Class type) {
        Iterator selectionIter = this._selections.iterator();
        while (selectionIter.hasNext()) {
            Fig selectionObj = ((Selection)selectionIter.next()).getContent();
            if (!selectionObj.getClass().equals(type)) continue;
            return selectionObj;
        }
        return null;
    }

    public static Selection makeSelectionFor(Fig f) {
        Selection customSelection = f.makeSelection();
        if (customSelection != null) {
            return customSelection;
        }
        if (f.isReshapable()) {
            return new SelectionReshape(f);
        }
        if (f.isLowerRightResizable()) {
            return new SelectionLowerRight(f);
        }
        if (f.isResizable()) {
            return new SelectionResize(f);
        }
        if (f.isMovable()) {
            return new SelectionMove(f);
        }
        return new SelectionNoop(f);
    }

    class SelectionMemento
    extends Memento {
        Vector prevSelections;

        public SelectionMemento() {
            this.prevSelections = new Vector(SelectionManager.this._selections);
        }

        @Override
        public void undo() {
            Vector curSelections = new Vector(SelectionManager.this._selections);
            SelectionManager.this._selections = this.prevSelections;
            this.prevSelections = curSelections;
            SelectionManager.this._editor.damageAll();
        }

        @Override
        public void redo() {
            this.undo();
        }

        @Override
        public String toString() {
            return (this.isStartChain() ? "*" : " ") + "SelectionMemento";
        }
    }

    class DragMemento
    extends Memento {
        List draggingNodes;
        List draggingOthers;
        List bounds;
        List movingEdges;
        List nonMovingEdges;
        List points;

        public DragMemento(List draggingNodes, List draggingOthers, List movingEdges, List nonMovingEdges) {
            this.bounds = new ArrayList(draggingNodes.size() + draggingOthers.size());
            this.draggingNodes = draggingNodes;
            for (FigNode node : draggingNodes) {
                Rectangle rect = node.getBounds();
                this.bounds.add(rect);
            }
            this.draggingOthers = draggingOthers;
            for (Fig fig : draggingOthers) {
                Rectangle rect = fig.getBounds();
                this.bounds.add(rect);
            }
            this.points = new ArrayList(nonMovingEdges.size() + movingEdges.size());
            this.movingEdges = movingEdges;
            for (FigEdge edge : movingEdges) {
                Point[] pts = edge.getPoints();
                this.points.add(pts);
            }
            this.nonMovingEdges = nonMovingEdges;
            for (FigEdge edge : nonMovingEdges) {
                Point[] pts = edge.getPoints();
                this.points.add(pts);
            }
        }

        @Override
        public void undo() {
            UndoManager.getInstance().addMementoLock(this);
            Iterator boundsIt = this.bounds.iterator();
            ArrayList<Rectangle> oldBounds = new ArrayList<Rectangle>(this.draggingNodes.size() + this.draggingOthers.size());
            for (FigNode figNode : this.draggingNodes) {
                Rectangle rect = (Rectangle)boundsIt.next();
                oldBounds.add(figNode.getBounds());
                figNode.setBounds(rect);
                figNode.damage();
            }
            for (Fig fig : this.draggingOthers) {
                Rectangle rect = (Rectangle)boundsIt.next();
                oldBounds.add(fig.getBounds());
                fig.setBounds(rect);
                fig.damage();
            }
            this.bounds = oldBounds;
            Iterator pointsIt = this.points.iterator();
            ArrayList<Point[]> oldPoints = new ArrayList<Point[]>(this.nonMovingEdges.size() + this.movingEdges.size());
            for (FigEdge figEdge : this.movingEdges) {
                Point[] pts = (Point[])pointsIt.next();
                oldPoints.add(figEdge.getPoints());
                figEdge.setPoints(pts);
                figEdge.damage();
            }
            for (FigEdge figEdge : this.nonMovingEdges) {
                Point[] pts = (Point[])pointsIt.next();
                oldPoints.add(figEdge.getPoints());
                figEdge.setPoints(pts);
                figEdge.damage();
            }
            this.points = oldPoints;
            UndoManager.getInstance().removeMementoLock(this);
        }

        @Override
        public void redo() {
            this.undo();
        }

        @Override
        public String toString() {
            return (this.isStartChain() ? "*" : " ") + "DragMemento";
        }
    }
}

