/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigEdgePoly;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.undo.Memento;
import org.tigris.gef.undo.UndoManager;

public class SelectionReshape
extends Selection
implements KeyListener {
    private static final long serialVersionUID = 2204649413528863935L;
    private int selectedHandle = -1;

    public SelectionReshape(Fig f) {
        super(f);
    }

    @Override
    public void hitHandle(Rectangle r, Handle h) {
        int i;
        Fig fig = this.getContent();
        int npoints = fig.getNumPoints();
        int[] xs = fig.getXs();
        int[] ys = fig.getYs();
        for (i = 0; i < npoints; ++i) {
            if (!r.contains(xs[i], ys[i])) continue;
            this.selectedHandle = i;
            h.index = i;
            h.instructions = "Move point";
            return;
        }
        if (fig instanceof FigEdgePoly) {
            for (i = 0; i < npoints - 1; ++i) {
                if (!Geometry.intersects(r, xs[i], ys[i], xs[i + 1], ys[i + 1])) continue;
                h.index = fig.getNumPoints();
                h.instructions = "Add a point";
                return;
            }
        }
        this.selectedHandle = -1;
        h.index = -1;
        h.instructions = "Move object(s)";
    }

    @Override
    public void paint(Graphics g) {
        Fig fig = this.getContent();
        int npoints = fig.getNumPoints();
        int[] xs = fig.getXs();
        int[] ys = fig.getYs();
        g.setColor(Globals.getPrefs().handleColorFor(fig));
        for (int i = 0; i < npoints; ++i) {
            g.fillRect(xs[i] - 3, ys[i] - 3, 6, 6);
        }
        if (this.selectedHandle != -1) {
            g.drawRect(xs[this.selectedHandle] - 3 - 2, ys[this.selectedHandle] - 3 - 2, 9, 9);
        }
    }

    @Override
    public void dragHandle(int mX, int mY, int anX, int anY, Handle h) {
        Fig selectedFig = this.getContent();
        if (selectedFig instanceof FigEdgePoly) {
            final FigEdgePoly figEdgePoly = (FigEdgePoly)selectedFig;
            if (UndoManager.getInstance().isGenerateMementos()) {
                class FigEdgeReshapeMemento
                extends Memento {
                    Polygon oldPolygon;

                    FigEdgeReshapeMemento(Polygon poly) {
                        this.oldPolygon = new Polygon(poly.xpoints, poly.ypoints, poly.npoints);
                    }

                    @Override
                    public void undo() {
                        UndoManager.getInstance().addMementoLock(this);
                        Polygon poly = figEdgePoly.getPolygon();
                        Polygon curPoly = new Polygon(poly.xpoints, poly.ypoints, poly.npoints);
                        figEdgePoly.setPolygon(this.oldPolygon);
                        this.oldPolygon = curPoly;
                        figEdgePoly.damage();
                        UndoManager.getInstance().removeMementoLock(this);
                    }

                    @Override
                    public void redo() {
                        this.undo();
                    }

                    @Override
                    public String toString() {
                        return (this.isStartChain() ? "*" : " ") + "ReshapeMemento " + this.oldPolygon;
                    }
                }
                FigEdgeReshapeMemento memento = new FigEdgeReshapeMemento(figEdgePoly.getPolygon());
                UndoManager.getInstance().startChain();
                UndoManager.getInstance().addMemento(memento);
            }
            int npoints = selectedFig.getNumPoints();
            int[] xs = selectedFig.getXs();
            int[] ys = selectedFig.getYs();
            Rectangle r = new Rectangle(anX - 4, anY - 4, 8, 8);
            if (h.index == figEdgePoly.getNumPoints()) {
                for (int i = 0; i < npoints - 1; ++i) {
                    if (!Geometry.intersects(r, xs[i], ys[i], xs[i + 1], ys[i + 1])) continue;
                    figEdgePoly.insertPoint(i, r.x, r.y);
                    h.index = i + 1;
                    break;
                }
            }
            if (h.index < 0 || h.index >= figEdgePoly.getNumPoints()) {
                System.out.println("mistake " + h.index);
            }
            if (h.index == 0 || h.index == figEdgePoly.getNumPoints() - 1) {
                this.updateEdgeEnds(figEdgePoly, h, mX, mY);
            }
        }
        if (selectedFig instanceof FigPoly) {
            FigPoly poly = (FigPoly)selectedFig;
            if (h.index == 0 || h.index == poly.getNumPoints() - 1) {
                Point moveTo = new Point(mX, mY);
                poly.setEndPoints(moveTo, moveTo);
            } else {
                poly.moveVertex(h, mX, mY, false);
            }
        } else {
            selectedFig.setPoint(h, mX, mY);
        }
    }

    public void updateEdgeEnds(FigEdge poly, Handle handle, int x, int y) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.isConsumed()) {
            return;
        }
        if (this.getContent() instanceof KeyListener) {
            ((KeyListener)((Object)this.getContent())).keyPressed(ke);
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.isConsumed()) {
            return;
        }
        if (this.getContent() instanceof KeyListener) {
            ((KeyListener)((Object)this.getContent())).keyReleased(ke);
        }
    }
}

