/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.graph.ConnectionConstrainer;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.graph.presentation.NetEdge;
import org.tigris.gef.graph.presentation.NetList;
import org.tigris.gef.graph.presentation.NetNode;
import org.tigris.gef.graph.presentation.NetPort;

public class DefaultGraphModel
extends MutableGraphSupport
implements Serializable {
    private static final long serialVersionUID = 8098329898758384131L;
    private NetList netList;
    private static Log LOG = LogFactory.getLog(DefaultGraphModel.class);

    public DefaultGraphModel() {
        this.netList = new NetList();
    }

    public DefaultGraphModel(ConnectionConstrainer cc) {
        super(cc);
        this.netList = new NetList();
    }

    public DefaultGraphModel(NetList nl) {
        this.netList = nl;
    }

    @Override
    public List getNodes() {
        return this.netList.getNodes();
    }

    @Override
    public List getEdges() {
        return this.netList.getEdges();
    }

    @Override
    public List getPorts(Object nodeOrEdge) {
        if (nodeOrEdge instanceof NetNode) {
            return ((NetNode)nodeOrEdge).getPorts();
        }
        if (nodeOrEdge instanceof NetEdge) {
            return ((NetEdge)nodeOrEdge).getPorts();
        }
        return null;
    }

    public Collection getNodes(Collection c) {
        return this.netList.getNodes(c);
    }

    public Collection getEdges(Collection c) {
        return this.netList.getEdges(c);
    }

    public Collection getPorts(Collection c, Object nodeOrEdge) {
        if (nodeOrEdge instanceof NetNode) {
            return ((NetNode)nodeOrEdge).getPorts();
        }
        if (nodeOrEdge instanceof NetEdge) {
            return ((NetEdge)nodeOrEdge).getPorts();
        }
        return null;
    }

    @Override
    public Object getOwner(Object port) {
        if (port instanceof NetPort) {
            return ((NetPort)port).getParent();
        }
        return null;
    }

    @Override
    public List getInEdges(Object port) {
        Vector<NetEdge> res = new Vector<NetEdge>();
        Vector edge = ((NetPort)port).getEdges();
        for (int i = 0; i < edge.size(); ++i) {
            NetEdge ne = (NetEdge)edge.elementAt(i);
            if (ne.getDestPort() != port) continue;
            res.add(ne);
        }
        return res;
    }

    @Override
    public List getOutEdges(Object port) {
        Vector<NetEdge> res = new Vector<NetEdge>();
        Vector edge = ((NetPort)port).getEdges();
        for (int i = 0; i < edge.size(); ++i) {
            NetEdge ne = (NetEdge)edge.elementAt(i);
            if (ne.getSourcePort() != port) continue;
            res.add(ne);
        }
        return res;
    }

    @Override
    public Object getSourcePort(Object edge) {
        if (edge instanceof NetEdge) {
            return ((NetEdge)edge).getSourcePort();
        }
        return null;
    }

    @Override
    public Object getDestPort(Object edge) {
        if (edge instanceof NetEdge) {
            return ((NetEdge)edge).getDestPort();
        }
        return null;
    }

    @Override
    public Object createNode(String name, Hashtable args) {
        Object newNode;
        try {
            newNode = Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
        catch (IllegalAccessException ignore) {
            return null;
        }
        catch (InstantiationException ignore) {
            return null;
        }
        if (newNode instanceof GraphNodeHooks) {
            ((GraphNodeHooks)newNode).initialize(args);
        }
        return newNode;
    }

    @Override
    public boolean canAddNode(Object node) {
        return node instanceof NetNode;
    }

    @Override
    public boolean canAddEdge(Object edge) {
        return edge instanceof NetEdge;
    }

    @Override
    public void removeNode(Object node) {
        NetNode n = (NetNode)node;
        this.netList.removeNode(n);
        LOG.debug((Object)"Removed node from graph model");
        super.removeNode(node);
    }

    @Override
    public boolean canDragNode(Object node) {
        return node instanceof NetNode;
    }

    @Override
    public void addNode(Object node) {
        NetNode n = (NetNode)node;
        this.netList.addNode(n);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added a node. There are now " + this.netList.getNodes(null).size() + " edges"));
        }
        super.addNode(node);
    }

    @Override
    public void addEdge(Object edge) {
        NetEdge e = (NetEdge)edge;
        this.netList.addEdge(e);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added an edge. There are now " + this.netList.getEdges(null).size() + " edges"));
        }
        super.addEdge(e);
    }

    @Override
    public void addNodeRelatedEdges(Object node) {
    }

    @Override
    public void removeEdge(Object edge) {
        LOG.debug((Object)"DefaultGraphModel::removeEdge");
        NetEdge e = (NetEdge)edge;
        this.netList.removeEdge(e);
        super.removeEdge(e);
    }

    @Override
    public void removeAllNodes() {
        LOG.debug((Object)"Removing all the nodes from the graph.");
        this.netList.removeAllNodes();
        super.removeAllNodes();
    }

    @Override
    public void removeAllEdges() {
        LOG.debug((Object)"Removing all the edges from the graph.");
        this.netList.removeAllEdges();
        super.removeAllEdges();
    }

    @Override
    public void removeAll() {
        this.netList.removeAllEdges();
        this.netList.removeAllNodes();
        super.removeAll();
    }

    @Override
    public void dragNode(Object node) {
        this.addNode(node);
    }

    @Override
    public boolean canConnect(Object srcPort, Object destPort) {
        if (srcPort instanceof NetPort && destPort instanceof NetPort) {
            NetPort s = (NetPort)srcPort;
            NetPort d = (NetPort)destPort;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking with ports to see if connection valid");
            }
            return s.canConnectTo(this, d) && d.canConnectTo(this, s);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"By default, cannot connect non-NetPort objects");
        }
        return false;
    }

    @Override
    public Object connect(Object srcPort, Object destPort) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to connect " + srcPort + " to " + destPort));
        }
        if (!this.canConnect(srcPort, destPort)) {
            LOG.warn((Object)"Connection not allowed");
            return null;
        }
        if (srcPort instanceof NetPort && destPort instanceof NetPort) {
            NetPort s = (NetPort)srcPort;
            NetPort d = (NetPort)destPort;
            NetEdge e = s.makeEdgeFor(d);
            return this.connectInternal(s, d, e);
        }
        return null;
    }

    @Override
    public Object connect(Object srcPort, Object destPort, Object edgeType) {
        return this.connect(srcPort, destPort, (Class)edgeType);
    }

    @Override
    public Object connect(Object srcPort, Object destPort, Class edgeClass) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to connect " + srcPort + " to " + destPort + " with " + edgeClass));
        }
        if (!this.canConnect(srcPort, destPort, edgeClass)) {
            LOG.warn((Object)"Connection not allowed");
            return null;
        }
        if (srcPort instanceof NetPort && destPort instanceof NetPort) {
            NetPort s = (NetPort)srcPort;
            NetPort d = (NetPort)destPort;
            try {
                NetEdge e = (NetEdge)edgeClass.newInstance();
                return this.connectInternal(s, d, e);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected Object connectInternal(NetPort s, NetPort d, NetEdge e) {
        if (e.connect(this, s, d)) {
            this.addEdge(e);
            return e;
        }
        return null;
    }

    @Override
    public boolean canChangeConnectedNode(Object newNode, Object oldNode, Object edge) {
        return false;
    }

    @Override
    public void changeConnectedNode(Object newNode, Object oldNode, Object edge, boolean isSource) {
    }
}

