/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import org.tigris.gef.base.AlignAction;
import org.tigris.gef.base.CmdAdjustGrid;
import org.tigris.gef.base.CmdAdjustGuide;
import org.tigris.gef.base.CmdAdjustPageBreaks;
import org.tigris.gef.base.CmdCopy;
import org.tigris.gef.base.CmdExit;
import org.tigris.gef.base.CmdGroup;
import org.tigris.gef.base.CmdOpen;
import org.tigris.gef.base.CmdOpenWindow;
import org.tigris.gef.base.CmdPaste;
import org.tigris.gef.base.CmdPrint;
import org.tigris.gef.base.CmdPrintPageSetup;
import org.tigris.gef.base.CmdRemoveFromGraph;
import org.tigris.gef.base.CmdReorder;
import org.tigris.gef.base.CmdSave;
import org.tigris.gef.base.CmdSavePGML;
import org.tigris.gef.base.CmdSaveSVG;
import org.tigris.gef.base.CmdSelectAll;
import org.tigris.gef.base.CmdSelectInvert;
import org.tigris.gef.base.CmdSelectNext;
import org.tigris.gef.base.CmdShowProperties;
import org.tigris.gef.base.CmdSpawn;
import org.tigris.gef.base.CmdUngroup;
import org.tigris.gef.base.CmdUseReshape;
import org.tigris.gef.base.CmdUseResize;
import org.tigris.gef.base.CmdUseRotate;
import org.tigris.gef.base.DistributeAction;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.ModeSelect;
import org.tigris.gef.base.NudgeAction;
import org.tigris.gef.event.ModeChangeEvent;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.presentation.JGraph;
import org.tigris.gef.ui.IStatusBar;
import org.tigris.gef.ui.PaletteFig;
import org.tigris.gef.ui.ToolBar;
import org.tigris.gef.undo.RedoAction;
import org.tigris.gef.undo.UndoAction;
import org.tigris.gef.util.Localizer;

public class JGraphFrame
extends JFrame
implements IStatusBar,
Cloneable,
ModeChangeListener {
    private static final long serialVersionUID = -8167010467922210977L;
    private ToolBar _toolbar = new PaletteFig();
    private JGraph _graph;
    private JLabel _statusbar = new JLabel(" ");
    private JPanel _mainPanel = new JPanel(new BorderLayout());
    private JPanel _graphPanel = new JPanel(new BorderLayout());
    private JMenuBar _menubar = new JMenuBar();

    public JGraphFrame() {
        this("untitled");
    }

    public JGraphFrame(boolean init_later) {
        super("untitled");
        if (!init_later) {
            this.init(new JGraph());
        }
    }

    public JGraphFrame(String title) {
        this(title, new JGraph());
    }

    public JGraphFrame(String title, Editor ed) {
        this(title, new JGraph(ed));
    }

    public JGraphFrame(String title, JGraph jg) {
        super(title);
        this.init(jg);
    }

    public void init() {
        this.init(new JGraph());
    }

    public void init(JGraph jg) {
        this._graph = jg;
        Container content = this.getContentPane();
        this.setUpMenus();
        content.setLayout(new BorderLayout());
        content.add((Component)this._menubar, "North");
        this._graphPanel.add((Component)this._graph, "Center");
        this._graphPanel.setBorder(new EtchedBorder(1));
        this._mainPanel.add((Component)this._toolbar, "North");
        this._mainPanel.add((Component)this._graphPanel, "Center");
        content.add((Component)this._mainPanel, "Center");
        content.add((Component)this._statusbar, "South");
        this.setSize(300, 250);
        this._graph.addModeChangeListener(this);
    }

    public JGraphFrame(GraphModel gm) {
        this("untitled");
        this.setGraphModel(gm);
    }

    public Object clone() {
        return null;
    }

    public JGraph getGraph() {
        return this._graph;
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        return this._graph.getEditor().getGraphEdgeRenderer();
    }

    public GraphModel getGraphModel() {
        return this._graph.getGraphModel();
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        return this._graph.getEditor().getGraphNodeRenderer();
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this._menubar;
    }

    public ToolBar getToolBar() {
        return this._toolbar;
    }

    @Override
    public void modeChange(ModeChangeEvent mce) {
        if (!Globals.getSticky() && Globals.mode() instanceof ModeSelect) {
            this._toolbar.unpressAllButtons();
        }
    }

    public void setGraph(JGraph g) {
        this._graph = g;
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer rend) {
        this._graph.getEditor().setGraphEdgeRenderer(rend);
    }

    public void setGraphModel(GraphModel gm) {
        this._graph.setGraphModel(gm);
    }

    public void setGraphNodeRenderer(GraphNodeRenderer rend) {
        this._graph.getEditor().setGraphNodeRenderer(rend);
    }

    @Override
    public void setJMenuBar(JMenuBar mb) {
        this._menubar = mb;
        this.getContentPane().add((Component)this._menubar, "North");
    }

    public void setToolBar(ToolBar tb) {
        this._toolbar = tb;
        this._mainPanel.add((Component)this._toolbar, "North");
    }

    protected void setUpMenus() {
        JMenu file = new JMenu(Localizer.localize("GefBase", "File"));
        file.setMnemonic('F');
        this._menubar.add(file);
        JMenuItem openItem = file.add(new CmdOpen());
        JMenuItem saveItem = file.add(new CmdSave());
        file.add(new CmdSavePGML());
        file.add(new CmdSaveSVG());
        CmdPrint cmdPrint = new CmdPrint();
        JMenuItem printItem = file.add(cmdPrint);
        file.add(new CmdPrintPageSetup(cmdPrint));
        file.add(new CmdOpenWindow("org.tigris.gef.base.PrefsEditor", "Preferences..."));
        JMenuItem exitItem = file.add(new CmdExit());
        JMenu edit = new JMenu(Localizer.localize("GefBase", "Edit"));
        edit.setMnemonic('E');
        this._menubar.add(edit);
        JMenuItem undoItem = edit.add(new UndoAction(Localizer.localize("GefBase", "Undo")));
        undoItem.setMnemonic(Localizer.localize("GefBase", "UndoMnemonic").charAt(0));
        JMenuItem redoItem = edit.add(new RedoAction(Localizer.localize("GefBase", "Redo")));
        redoItem.setMnemonic(Localizer.localize("GefBase", "RedoMnemonic").charAt(0));
        JMenu select = new JMenu(Localizer.localize("GefBase", "Select"));
        edit.add(select);
        select.add(new CmdSelectAll());
        select.add(new CmdSelectNext(false));
        select.add(new CmdSelectNext(true));
        select.add(new CmdSelectInvert());
        edit.addSeparator();
        JMenuItem copyItem = edit.add(new CmdCopy());
        copyItem.setMnemonic('C');
        JMenuItem pasteItem = edit.add(new CmdPaste());
        pasteItem.setMnemonic('P');
        JMenuItem deleteItem = edit.add(new CmdRemoveFromGraph());
        edit.addSeparator();
        edit.add(new CmdUseReshape());
        edit.add(new CmdUseResize());
        edit.add(new CmdUseRotate());
        JMenu view = new JMenu(Localizer.localize("GefBase", "View"));
        this._menubar.add(view);
        view.setMnemonic('V');
        view.add(new CmdSpawn());
        view.add(new CmdShowProperties());
        view.addSeparator();
        view.add(new CmdAdjustGrid());
        view.add(new CmdAdjustGuide());
        view.add(new CmdAdjustPageBreaks());
        JMenu arrange = new JMenu(Localizer.localize("GefBase", "Arrange"));
        this._menubar.add(arrange);
        arrange.setMnemonic('A');
        JMenuItem groupItem = arrange.add(new CmdGroup());
        groupItem.setMnemonic('G');
        JMenuItem ungroupItem = arrange.add(new CmdUngroup());
        ungroupItem.setMnemonic('U');
        JMenu align = new JMenu(Localizer.localize("GefBase", "Align"));
        arrange.add(align);
        align.add(new AlignAction(0));
        align.add(new AlignAction(1));
        align.add(new AlignAction(2));
        align.add(new AlignAction(3));
        align.add(new AlignAction(5));
        align.add(new AlignAction(6));
        align.add(new AlignAction(7));
        JMenu distribute = new JMenu(Localizer.localize("GefBase", "Distribute"));
        arrange.add(distribute);
        distribute.add(new DistributeAction(0));
        distribute.add(new DistributeAction(1));
        distribute.add(new DistributeAction(4));
        distribute.add(new DistributeAction(5));
        JMenu reorder = new JMenu(Localizer.localize("GefBase", "Reorder"));
        arrange.add(reorder);
        JMenuItem toBackItem = reorder.add(new CmdReorder(1));
        JMenuItem toFrontItem = reorder.add(new CmdReorder(2));
        JMenuItem backwardItem = reorder.add(new CmdReorder(3));
        JMenuItem forwardItem = reorder.add(new CmdReorder(4));
        JMenu nudge = new JMenu(Localizer.localize("GefBase", "Nudge"));
        arrange.add(nudge);
        nudge.add(new NudgeAction(1));
        nudge.add(new NudgeAction(2));
        nudge.add(new NudgeAction(3));
        nudge.add(new NudgeAction(4));
        KeyStroke ctrlO = KeyStroke.getKeyStroke(79, 2);
        KeyStroke ctrlS = KeyStroke.getKeyStroke(83, 2);
        KeyStroke ctrlP = KeyStroke.getKeyStroke(80, 2);
        KeyStroke altF4 = KeyStroke.getKeyStroke(115, 8);
        KeyStroke delKey = KeyStroke.getKeyStroke(127, 0);
        KeyStroke ctrlZ = KeyStroke.getKeyStroke(90, 2);
        KeyStroke ctrlY = KeyStroke.getKeyStroke(89, 2);
        KeyStroke ctrlC = KeyStroke.getKeyStroke(67, 2);
        KeyStroke ctrlV = KeyStroke.getKeyStroke(86, 2);
        KeyStroke ctrlG = KeyStroke.getKeyStroke(71, 2);
        KeyStroke ctrlU = KeyStroke.getKeyStroke(85, 2);
        KeyStroke ctrlB = KeyStroke.getKeyStroke(66, 2);
        KeyStroke ctrlF = KeyStroke.getKeyStroke(70, 2);
        KeyStroke sCtrlB = KeyStroke.getKeyStroke(66, 3);
        KeyStroke sCtrlF = KeyStroke.getKeyStroke(70, 3);
        openItem.setAccelerator(ctrlO);
        saveItem.setAccelerator(ctrlS);
        printItem.setAccelerator(ctrlP);
        exitItem.setAccelerator(altF4);
        deleteItem.setAccelerator(delKey);
        undoItem.setAccelerator(ctrlZ);
        redoItem.setAccelerator(ctrlY);
        copyItem.setAccelerator(ctrlC);
        pasteItem.setAccelerator(ctrlV);
        groupItem.setAccelerator(ctrlG);
        ungroupItem.setAccelerator(ctrlU);
        toBackItem.setAccelerator(sCtrlB);
        toFrontItem.setAccelerator(sCtrlF);
        backwardItem.setAccelerator(ctrlB);
        forwardItem.setAccelerator(ctrlF);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            Globals.setStatusBar(this);
        }
    }

    @Override
    public void showStatus(String msg) {
        if (this._statusbar != null) {
            this._statusbar.setText(msg);
        }
    }
}

