/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.graph.presentation.NetPort;
import org.tigris.gef.graph.presentation.NetPrimitive;
import org.tigris.gef.presentation.FigNode;

public abstract class NetNode
extends NetPrimitive
implements GraphNodeHooks,
Serializable {
    private List _ports;
    private static Log LOG = LogFactory.getLog(NetNode.class);

    public NetNode(NetNode deft, List ports) {
        this._ports = ports;
    }

    public NetNode() {
        this(null, new ArrayList());
    }

    @Override
    public abstract void initialize(Hashtable var1);

    public Object getAttributes() {
        return null;
    }

    public NetPort getPort(int i) {
        return (NetPort)this._ports.get(i);
    }

    public List getPorts() {
        return this._ports;
    }

    public void setPorts(List ports) {
        this._ports = ports;
    }

    public void addPort(NetPort p) {
        this._ports.add(p);
    }

    @Override
    public void deleteFromModel() {
        LOG.debug((Object)"Deleting from model");
        Iterator ps = this._ports.iterator();
        while (ps.hasNext()) {
            ((NetPort)ps.next()).deleteFromModel();
        }
        DefaultGraphModel gm = (DefaultGraphModel)Globals.curEditor().getGraphModel();
        gm.removeNode(this);
        this.firePropertyChange("disposed", false, true);
    }

    public FigNode presentationFor(Layer lay) {
        FigNode fn;
        if (lay != null && (fn = (FigNode)lay.presentationFor(this)) != null) {
            return fn;
        }
        fn = this.makePresentation(lay);
        return fn;
    }

    public abstract FigNode makePresentation(Layer var1);

    @Override
    public void postConnect(GraphModel gm, Object anotherNode, Object myPort, Object otherPort) {
    }

    @Override
    public void postDisconnect(GraphModel gm, Object anotherNode, Object myPort, Object otherPort) {
    }

    @Override
    public boolean canConnectTo(GraphModel gm, Object otherNode, Object otherPort, Object myPort) {
        return true;
    }

    @Override
    public void postPlacement(Editor ed) {
    }
}

