/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;

class WheelKeyListenerToggleAction
implements KeyListener {
    private int mask;
    private int down;
    private MouseWheelListener listener;
    private JPanel panel;

    public WheelKeyListenerToggleAction(JPanel panel, MouseWheelListener listener, int modifiersMask) {
        this.panel = panel;
        this.listener = listener;
        this.mask = modifiersMask;
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        if ((e.getModifiers() | this.mask) != this.mask) {
            return;
        }
        if (this.down == 0) {
            this.panel.addMouseWheelListener(this.listener);
        }
        this.down |= e.getModifiers();
    }

    @Override
    public synchronized void keyReleased(KeyEvent e) {
        if ((e.getModifiers() & this.mask) == 0) {
            this.panel.removeMouseWheelListener(this.listener);
        }
        this.down = e.getModifiers();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

