/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence.pgml;

import java.util.List;
import java.util.StringTokenizer;
import org.tigris.gef.persistence.pgml.BaseHandler;
import org.tigris.gef.persistence.pgml.Container;
import org.tigris.gef.persistence.pgml.PGMLStackParser;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigEdgePoly;
import org.tigris.gef.presentation.FigLine;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPoly;
import org.xml.sax.SAXException;

public class FigEdgeHandler
extends BaseHandler
implements Container {
    private FigEdge edge;

    public FigEdgeHandler(PGMLStackParser parser, FigEdge theEdge) {
        super(parser);
        this.edge = theEdge;
    }

    public FigEdge getFigEdge() {
        return this.edge;
    }

    @Override
    public void endElement(String uri, String localname, String qname) throws SAXException {
        Object owner = this.edge.getOwner();
        List edges = this.getPGMLStackParser().getDiagram().getEdges();
        if (!edges.contains(owner)) {
            edges.add(owner);
        }
        super.endElement(uri, localname, qname);
    }

    @Override
    public void addObject(Object o) throws SAXException {
        if (o instanceof FigLine || o instanceof FigPoly) {
            this.edge.setFig((Fig)o);
            if (o instanceof FigPoly) {
                ((FigPoly)o).setComplete(true);
            }
            this.edge.calcBounds();
            if (this.edge instanceof FigEdgePoly) {
                ((FigEdgePoly)this.edge).setInitiallyLaidOut(true);
            }
            this.edge.updateAnnotationPositions();
        }
        if (o instanceof String) {
            PGMLStackParser parser = this.getPGMLStackParser();
            Fig spf = null;
            Fig dpf = null;
            FigNode sfn = null;
            FigNode dfn = null;
            String body = (String)o;
            StringTokenizer st2 = new StringTokenizer(body, "=\"' \t\n");
            while (st2.hasMoreElements()) {
                String attribute = st2.nextToken();
                String value = st2.nextToken();
                if (attribute.equals("sourcePortFig")) {
                    spf = parser.findFig(value);
                }
                if (attribute.equals("destPortFig")) {
                    dpf = parser.findFig(value);
                }
                if (attribute.equals("sourceFigNode")) {
                    sfn = (FigNode)parser.findFig(value);
                }
                if (!attribute.equals("destFigNode")) continue;
                dfn = (FigNode)parser.findFig(value);
            }
            if (spf == null && sfn != null) {
                spf = (Fig)sfn.getPortFigs().get(0);
            }
            if (dpf == null && dfn != null) {
                dpf = (Fig)dfn.getPortFigs().get(0);
            }
            if (spf == null || dpf == null || sfn == null || dfn == null) {
                throw new SAXException("Can't find nodes for FigEdge: " + (String)o + ":" + this.edge.getId() + ":" + this.edge.toString());
            }
            this.edge.setSourcePortFig(spf);
            this.edge.setDestPortFig(dpf);
            this.edge.setSourceFigNode(sfn);
            this.edge.setDestFigNode(dfn);
        }
    }
}

