/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import org.tigris.gef.presentation.ArrowHead;

public class ArrowHeadDiamond
extends ArrowHead {
    private static final long serialVersionUID = 7056384380724728325L;
    public static ArrowHeadDiamond WhiteDiamond = new ArrowHeadDiamond(Color.black, Color.white);
    public static ArrowHeadDiamond BlackDiamond = new ArrowHeadDiamond(Color.black, Color.black);

    public ArrowHeadDiamond() {
    }

    public ArrowHeadDiamond(Color line, Color fill) {
        super(line, fill);
        this.arrow_height = 20;
        this.arrow_width = 5;
    }

    @Override
    public void paint(Object g, Point start, Point end) {
        int xTo = end.x;
        int xFrom = start.x;
        double dx = xTo - xFrom;
        int yTo = end.y;
        int yFrom = start.y;
        double dy = yTo - yFrom;
        double denom = this.dist(dx, dy);
        if (denom == 0.0) {
            return;
        }
        double cos = (double)(this.arrow_height / 2) / denom;
        double sin = (double)this.arrow_width / denom;
        double x = (double)xTo - cos * dx;
        double y = (double)yTo - cos * dy;
        int x1 = (int)(x - sin * dy);
        int y1 = (int)(y + sin * dx);
        int x2 = (int)(x + sin * dy);
        int y2 = (int)(y - sin * dx);
        Point topPoint = this.pointAlongLine(end, start, this.arrow_height);
        Polygon diamond = new Polygon();
        diamond.addPoint(xTo, yTo);
        diamond.addPoint(x1, y1);
        diamond.addPoint(topPoint.x, topPoint.y);
        diamond.addPoint(x2, y2);
        if (g instanceof Graphics) {
            Graphics graphics = (Graphics)g;
            graphics.setColor(this.arrowFillColor);
            graphics.fillPolygon(diamond);
            graphics.setColor(this.arrowLineColor);
            graphics.drawPolygon(diamond);
        }
    }
}

