/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import org.tigris.gef.presentation.ArrowHead;
import org.tigris.gef.presentation.FigText;

public class ArrowHeadQualifier
extends ArrowHead {
    private static final long serialVersionUID = -4833472749443682549L;

    @Override
    public void paint(Object g, Point start, Point end) {
        int box_height = 20;
        int box_width = 5;
        int xTo = end.x;
        int xFrom = start.x;
        double dx = xTo - xFrom;
        int yTo = end.y;
        int yFrom = start.y;
        double dy = yTo - yFrom;
        double denom = this.dist(dx, dy);
        if (denom == 0.0) {
            return;
        }
        double cos = (double)box_height / denom;
        double sin = (double)box_width / denom;
        double x = (double)xTo - cos * dx;
        double y = (double)yTo - cos * dy;
        int x1 = (int)(x - sin * dy);
        int y1 = (int)(y + sin * dx);
        int x2 = (int)(x + sin * dy);
        int y2 = (int)(y - sin * dx);
        int x3 = (int)((double)xTo - sin * dy);
        int y3 = (int)((double)yTo + sin * dx);
        int x4 = (int)((double)xTo + sin * dy);
        int y4 = (int)((double)yTo - sin * dx);
        Polygon qualifier = new Polygon();
        qualifier.addPoint(x1, y1);
        qualifier.addPoint(x2, y2);
        qualifier.addPoint(x4, y4);
        qualifier.addPoint(x3, y3);
        if (g instanceof Graphics) {
            Graphics graphics = (Graphics)g;
            graphics.setColor(this.arrowFillColor);
            graphics.fillPolygon(qualifier);
            graphics.setColor(this.arrowLineColor);
            graphics.drawPolygon(qualifier);
        }
        FigText temp = new FigText(x3, y3, x2, y2, Color.blue, "Times", 8);
        temp.setText("qualifier");
    }
}

