/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Point;
import java.util.Enumeration;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.AnnotationHelper;
import org.tigris.gef.presentation.AnnotationLineRemover;
import org.tigris.gef.presentation.AnnotationProperties;
import org.tigris.gef.presentation.AnnotationStrategy;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigEdgePoly;
import org.tigris.gef.presentation.FigLine;

public class EdgeAnnotationStrategy
extends AnnotationStrategy {
    private static final long serialVersionUID = 839904139158340787L;
    AnnotationHelper helper = AnnotationHelper.instance();

    @Override
    public Point restoreAnnotationPosition(Fig annotation) {
        Fig owner = annotation.getAnnotationOwner();
        if (owner instanceof FigEdge) {
            Point ende;
            Point start;
            AnnotationProperties prop = (AnnotationProperties)this.annotations.get(annotation);
            int d = prop.getOffset();
            float ratio = prop.getRatio();
            FigEdge edge = (FigEdge)owner;
            try {
                start = edge.getFirstPoint();
                ende = edge.getLastPoint();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                try {
                    start = edge.getSourcePortFig().getCenter();
                    ende = edge.getDestPortFig().getCenter();
                }
                catch (NullPointerException ne) {
                    start = new Point(10, 10);
                    ende = new Point(100, 10);
                }
            }
            if (start.x == ende.x && start.y == ende.y) {
                return annotation.getLocation();
            }
            float xdirection = ende.x - start.x;
            float ydirection = ende.y - start.y;
            double newX = (float)start.x + ratio * xdirection;
            double newY = (float)start.y + ratio * ydirection;
            return new Point((int)(newX += (double)d * ((double)ydirection / Math.sqrt(xdirection * xdirection + ydirection * ydirection))) - annotation.getWidth() / 2, (int)(newY += (double)(d * -1) * ((double)xdirection / Math.sqrt(xdirection * xdirection + ydirection * ydirection))) - annotation.getHeight() / 2);
        }
        return new Point(1, 1);
    }

    @Override
    public void storeAnnotationPosition(Fig annotation) {
        Fig owner = annotation.getAnnotationOwner();
        if (owner instanceof FigEdge) {
            Point ende;
            Point start;
            FigEdge edge = (FigEdge)owner;
            Point anPos = annotation.getCenter();
            try {
                start = edge.getFirstPoint();
                ende = edge.getLastPoint();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                start = edge.getSourcePortFig().getCenter();
                ende = edge.getDestPortFig().getCenter();
            }
            if (start.x == ende.x && start.y == ende.y) {
                return;
            }
            int d = AnnotationHelper.getNormOffset(anPos, start, ende);
            float ratio = AnnotationHelper.getRatio(anPos, start, ende);
            AnnotationProperties prop = this.getAnnotationProperties(annotation);
            prop.setRatio(ratio, prop.hasFixedRatio());
            prop.setOffset(d, prop.hasFixedOffset());
        }
        this.drawConnectingLine(annotation);
    }

    public void drawConnectingLine(Fig annotation) throws NullPointerException {
        if (!this.getAnnotationProperties(annotation).lineIsVisible(annotation)) {
            return;
        }
        Fig owner = annotation.getAnnotationOwner();
        AnnotationProperties prop = this.getAnnotationProperties(annotation);
        FigLine line = prop.getConnectingLine();
        if (((FigEdge)owner).getSourcePortFig().getCenter() == null || ((FigEdge)owner).getDestPortFig().getCenter() == null) {
            return;
        }
        try {
            if (owner instanceof FigEdgePoly) {
                line.setShape(annotation.getCenter(), AnnotationHelper.getClosestPoint(annotation.getCenter(), (FigEdgePoly)owner));
            } else {
                line.setShape(annotation.getCenter(), AnnotationHelper.getClosestPointOnEdge(annotation.getCenter(), ((FigEdge)owner).getFirstPoint(), ((FigEdge)owner).getLastPoint()));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            line.setShape(annotation.getCenter(), AnnotationHelper.getClosestPointOnEdge(annotation.getCenter(), ((FigEdge)owner).getSourcePortFig().getCenter(), ((FigEdge)owner).getDestPortFig().getCenter()));
        }
        line.setLineColor(this.getAnnotationProperties(annotation).getLineColor());
        line.setFillColor(this.getAnnotationProperties(annotation).getLineColor());
        line.setDashed(true);
        if (!Globals.curEditor().getLayerManager().getContents().contains(line)) {
            Globals.curEditor().add(line);
        }
        Globals.curEditor().getLayerManager().bringToFront(annotation);
        line.damage();
        annotation.damage();
        AnnotationLineRemover.instance().removeLineIn(this.getAnnotationProperties(annotation).getLineVisibilityDuration(), annotation);
    }

    @Override
    public void translateAnnotations(Fig owner) {
        Enumeration iter = this.annotations.keys();
        while (iter.hasMoreElements()) {
            Fig annotation = (Fig)iter.nextElement();
            annotation.setLocation(this.restoreAnnotationPosition(annotation));
            Globals.curEditor().getLayerManager().bringToFront(annotation);
            annotation.endTrans();
            annotation.damage();
        }
        owner.damage();
    }
}

