/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import org.tigris.gef.base.CmdReorder;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.di.GraphicElement;
import org.tigris.gef.graph.GraphEdgeHooks;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.GraphPortHooks;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.plot2d.Java2d;
import org.tigris.gef.plot2d.Plotter;
import org.tigris.gef.presentation.AnnotationStrategy;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.presentation.NoAnnotationStrategy;
import org.tigris.gef.properties.PropCategoryManager;
import org.tigris.gef.ui.PopupGenerator;
import org.tigris.gef.undo.Memento;
import org.tigris.gef.undo.UndoManager;
import org.tigris.gef.util.Localizer;

public abstract class Fig
implements GraphicElement,
Cloneable,
Serializable,
PropertyChangeListener,
PopupGenerator {
    protected static Plotter plotter = new Java2d();
    public final int MIN_SIZE = 4;
    private static final String[] DASHED_CHOICES = new String[]{"Solid", "Dashed", "LongDashed", "Dotted", "DotDash"};
    private static final float[][] DASH_ARRAYS = new float[][]{null, {5.0f, 5.0f}, {15.0f, 5.0f}, {3.0f, 10.0f}, {3.0f, 6.0f, 10.0f, 6.0f}};
    private static final int[] DASH_PERIOD = new int[]{0, 10, 20, 13, 25};
    boolean movable = true;
    boolean resizable = true;
    private transient Layer _layer = null;
    private boolean _locked = false;
    private transient Object _owner;
    protected int _x;
    protected int _y;
    protected int _w;
    protected int _h;
    private String _resource = "";
    Color _lineColor = Color.black;
    Color _fillColor = Color.white;
    int _lineWidth = 1;
    protected float[] _dashes = null;
    protected int _dashStyle = 0;
    protected int _dashPeriod = 0;
    protected boolean _filled = true;
    private Fig group = null;
    protected String _context = "";
    private boolean visible = true;
    protected boolean _allowsSaving = true;
    private transient boolean _selected = false;
    private boolean removeStarted;
    public final int BORDER = 8;
    protected AnnotationStrategy an = NoAnnotationStrategy.getInstance();
    protected boolean annotationStatus = false;
    protected Fig annotationOwner;

    public Fig() {
    }

    public Fig(int x, int y, int w, int h) {
        this(x, y, w, h, Color.black, Color.white, null);
    }

    public Fig(int x, int y, int w, int h, Color lineColor, Color fillColor) {
        this(x, y, w, h, lineColor, fillColor, null);
    }

    public Fig(int x, int y, int w, int h, Color lineColor, Color fillColor, Object own) {
        this();
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        if (lineColor != null) {
            this._lineColor = lineColor;
        } else {
            this._lineWidth = 0;
        }
        if (fillColor != null) {
            this._fillColor = fillColor;
        } else {
            this._filled = false;
        }
        this.setOwner(own);
    }

    public void setResource(String resource) {
        this._resource = resource;
    }

    public String getResource() {
        return this._resource;
    }

    public void setAnnotationOwner(Fig f) {
        this.annotationOwner = f;
        this.setAnnotationStatus(this.annotationOwner != null);
    }

    public void unsetAnnotationOwner() {
        this.annotationOwner = null;
        this.setAnnotationStatus(false);
    }

    public Fig getAnnotationOwner() {
        return this.annotationOwner;
    }

    public AnnotationStrategy getAnnotationStrategy() {
        return this.an;
    }

    public void setAnnotationStrategy(AnnotationStrategy a) {
        this.an = a;
    }

    public boolean isAnnotation() {
        return this.annotationStatus;
    }

    public void setAnnotationStatus(boolean newValue) {
        this.annotationStatus = newValue;
    }

    public final void addAnnotation(Fig annotation, String type, String context) {
    }

    public final void removeAnnotation(Fig annotationFig) {
        if (annotationFig.isAnnotation() && this == annotationFig.getAnnotationOwner()) {
            Globals.curEditor().remove(annotationFig);
            this.getAnnotationStrategy().removeAnnotation(annotationFig);
        }
    }

    public final void translateAnnotations() {
        SelectionManager selectionManager;
        if (this.isAnnotation() && !(selectionManager = Globals.curEditor().getSelectionManager()).containsFig(this.getAnnotationOwner()) && selectionManager.containsFig(this)) {
            this.getAnnotationOwner().an.storeAnnotationPosition(this);
        }
        if (!(this.getAnnotationStrategy() instanceof NoAnnotationStrategy)) {
            this.getAnnotationStrategy().translateAnnotations(this);
        }
    }

    public final void updateAnnotationPositions() {
        Enumeration annotations = this.getAnnotationStrategy().getAllAnnotations();
        while (annotations.hasMoreElements()) {
            Fig annotation = (Fig)annotations.nextElement();
            this.getAnnotationStrategy().storeAnnotationPosition(annotation);
            annotation.endTrans();
        }
        this.endTrans();
    }

    public final void initAnnotations() {
    }

    public void addPoint(int x, int y) {
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        Globals.addPropertyChangeListener(this, l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        Globals.removePropertyChangeListener(this, l);
    }

    public final void align(Rectangle r, int direction, Editor ed) {
        Rectangle bbox = this.getBounds();
        int dx = 0;
        int dy = 0;
        switch (direction) {
            case 0: {
                dy = r.y - bbox.y;
                break;
            }
            case 1: {
                dy = r.y + r.height - (bbox.y + bbox.height);
                break;
            }
            case 2: {
                dx = r.x - bbox.x;
                break;
            }
            case 3: {
                dx = r.x + r.width - (bbox.x + bbox.width);
                break;
            }
            case 4: {
                dx = r.x + r.width / 2 - (bbox.x + bbox.width / 2);
                dy = r.y + r.height / 2 - (bbox.y + bbox.height / 2);
                break;
            }
            case 5: {
                dx = r.x + r.width / 2 - (bbox.x + bbox.width / 2);
                break;
            }
            case 6: {
                dy = r.y + r.height / 2 - (bbox.y + bbox.height / 2);
                break;
            }
            case 7: {
                Point loc = this.getLocation();
                Point snapPt = new Point(loc.x, loc.y);
                ed.snap(snapPt);
                dx = snapPt.x - loc.x;
                dy = snapPt.y - loc.y;
            }
        }
        this.translate(dx, dy);
    }

    public void calcBounds() {
    }

    public final Point center() {
        return this.getCenter();
    }

    public Point getCenter() {
        Rectangle bbox = this.getBounds();
        return new Point(bbox.x + bbox.width / 2, bbox.y + bbox.height / 2);
    }

    public String classNameAndBounds() {
        return this.getClass().getName() + "[" + this.getX() + ", " + this.getY() + ", " + this.getWidth() + ", " + this.getHeight() + "]";
    }

    public void cleanUp() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isCopyable() {
        return true;
    }

    public boolean isCutable() {
        return true;
    }

    public Point connectionPoint(Point anotherPt) {
        List grav = this.getGravityPoints();
        if (grav != null && grav.size() > 0) {
            int ax = anotherPt.x;
            int ay = anotherPt.y;
            Point bestPoint = (Point)grav.get(0);
            int bestDist = Integer.MAX_VALUE;
            int size = grav.size();
            for (int i = 0; i < size; ++i) {
                Point gp = (Point)grav.get(i);
                int dx = gp.x - ax;
                int dy = gp.y - ay;
                int dist = dx * dx + dy * dy;
                if (dist >= bestDist) continue;
                bestDist = dist;
                bestPoint = gp;
            }
            return new Point(bestPoint.x, bestPoint.y);
        }
        return this.getClosestPoint(anotherPt);
    }

    public boolean contains(int x, int y) {
        return this._x <= x && x <= this._x + this._w && this._y <= y && y <= this._y + this._h;
    }

    public final boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public final boolean contains(Rectangle r) {
        return this.countCornersContained(r.x, r.y, r.width, r.height) == 4;
    }

    protected int countCornersContained(int x, int y, int w, int h) {
        int cornersHit = 0;
        if (this.contains(x, y)) {
            ++cornersHit;
        }
        if (this.contains(x + w, y)) {
            ++cornersHit;
        }
        if (this.contains(x, y + h)) {
            ++cornersHit;
        }
        if (this.contains(x + w, y + h)) {
            ++cornersHit;
        }
        return cornersHit;
    }

    public void createDrag(int anchorX, int anchorY, int x, int y, int snapX, int snapY) {
        int newX = Math.min(anchorX, snapX);
        int newY = Math.min(anchorY, snapY);
        int newW = Math.max(anchorX, snapX) - newX;
        int newH = Math.max(anchorY, snapY) - newY;
        this.setBounds(newX, newY, newW, newH);
    }

    public void endTrans() {
        this.translateAnnotations();
        this.damage();
    }

    public void damage() {
        Layer lay = this.getLayer();
        for (Fig group = this.getGroup(); lay == null && group != null; group = group.getGroup()) {
            lay = group.getLayer();
        }
        if (lay != null) {
            lay.damageAll();
        }
    }

    public Rectangle getHandleBox() {
        return this.getBounds();
    }

    public void setHandleBox(int x, int y, int w, int h) {
        this.setBounds(x, y, w, h);
    }

    public void removeFromDiagram() {
        if (UndoManager.getInstance().isGenerateMementos()) {
            class FigRemoveMemento
            extends Memento {
                Layer lay;
                Fig fig;
                Fig encFig;
                boolean vis;

                public FigRemoveMemento(Fig f) {
                    this.fig = f;
                    this.lay = this.fig.getLayer();
                    this.encFig = f.getEnclosingFig();
                    this.vis = this.fig.isVisible();
                }

                @Override
                public void undo() {
                    UndoManager.getInstance().addMementoLock(this);
                    this.fig.setEnclosingFig(this.encFig);
                    if (this.lay != null) {
                        this.lay.add(this.fig);
                    }
                    this.fig.visible = this.vis;
                    UndoManager.getInstance().removeMementoLock(this);
                }

                @Override
                public void redo() {
                    UndoManager.getInstance().addMementoLock(this);
                    this.fig.removeFromDiagram();
                    UndoManager.getInstance().removeMementoLock(this);
                }
            }
            UndoManager.getInstance().addMemento(new FigRemoveMemento(this));
        }
        this.removeStarted = true;
        this.visible = false;
        Enumeration iter = this.getAnnotationStrategy().getAllAnnotations();
        while (iter.hasMoreElements()) {
            Fig annotation = (Fig)iter.nextElement();
            this.getAnnotationStrategy().getAnnotationProperties(annotation).removeLine();
            this.removeAnnotation(annotation);
            annotation.removeFromDiagram();
        }
        if (this._layer != null) {
            Layer oldLayer = this._layer;
            this._layer.remove(this);
            oldLayer.deleted(this);
        }
        this.setEnclosingFig(null);
    }

    public void deleteFromModel() {
        this.removeStarted = true;
        Object own = this.getOwner();
        if (own instanceof GraphNodeHooks) {
            ((GraphNodeHooks)own).deleteFromModel();
        } else if (own instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)own).deleteFromModel();
        } else if (own instanceof GraphPortHooks) {
            ((GraphPortHooks)own).deleteFromModel();
        } else {
            this.removeFromDiagram();
        }
    }

    public final void firePropChange(String propName, int oldV, int newV) {
        this.firePropChange(propName, new Integer(oldV), new Integer(newV));
    }

    public final void firePropChange(String propName, Object oldV, Object newV) {
        Globals.firePropChange((Object)this, propName, oldV, newV);
        if (this.group != null) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, propName, oldV, newV);
            this.group.propertyChange(pce);
        }
    }

    public final void firePropChange(String propName, boolean oldV, boolean newV) {
        this.firePropChange(propName, new Boolean(oldV), new Boolean(newV));
    }

    public final Rectangle getBounds() {
        return this.getBounds(null);
    }

    public Rectangle getBounds(Rectangle r) {
        if (r == null) {
            return new Rectangle(this._x, this._y, this._w, this._h);
        }
        r.setBounds(this._x, this._y, this._w, this._h);
        return r;
    }

    public Point getClosestPoint(Point anotherPt) {
        return Geometry.ptClosestTo(this.getBounds(), anotherPt);
    }

    public boolean getDashed() {
        return this._dashes != null;
    }

    public final int getDashed01() {
        return this.getDashed() ? 1 : 0;
    }

    public final String getDashedString() {
        return this._dashes == null ? DASHED_CHOICES[0] : DASHED_CHOICES[1];
    }

    public Vector getEnclosedFigs() {
        return null;
    }

    public Fig getEnclosingFig() {
        return null;
    }

    public boolean hasFillColor() {
        return true;
    }

    public Color getFillColor() {
        return this._fillColor;
    }

    public boolean getFilled() {
        return this._filled;
    }

    public final int getFilled01() {
        return this._filled ? 1 : 0;
    }

    public boolean hasLineColor() {
        return true;
    }

    public Color getLineColor() {
        return this._lineColor;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public Point getFirstPoint() {
        return new Point();
    }

    public List getGravityPoints() {
        return null;
    }

    public final Fig getGroup() {
        return this.group;
    }

    public final String getContext() {
        return this._context;
    }

    public final int getHalfHeight() {
        return this._h / 2;
    }

    public final int getHalfWidth() {
        return this._w / 2;
    }

    @Override
    public String getId() {
        if (this.getGroup() != null) {
            String gID = this.getGroup().getId();
            if (this.getGroup() instanceof FigGroup) {
                return gID + "." + ((FigGroup)this.getGroup()).getFigs().indexOf(this);
            }
            if (this.getGroup() instanceof FigEdge) {
                return gID + "." + (((FigEdge)this.getGroup()).getPathItemFigs().indexOf(this) + 1);
            }
            return gID + ".0";
        }
        Layer layer = this.getLayer();
        if (layer == null) {
            return "LAYER_NULL";
        }
        List c = layer.getContents();
        int index = c.indexOf(this);
        return "Fig" + index;
    }

    public Point getLastPoint() {
        return new Point();
    }

    public final Layer getLayer() {
        return this._layer;
    }

    public final Point getLocation() {
        return new Point(this._x, this._y);
    }

    public final boolean getLocked() {
        return this._locked;
    }

    public Dimension getMinimumSize() {
        return new Dimension(4, 4);
    }

    public int getNumPoints() {
        return 0;
    }

    @Override
    public Object getOwner() {
        return this._owner;
    }

    public int getPerimeterLength() {
        return this._w + this._w + this._h + this._h;
    }

    public Point[] getPoints() {
        return new Point[0];
    }

    public Point getPoint(int i) {
        return null;
    }

    @Override
    public Vector getPopUpActions(MouseEvent me) {
        Vector<JMenu> popUpActions = new Vector<JMenu>();
        JMenu orderMenu = new JMenu(Localizer.localize("PresentationGef", "Ordering"));
        orderMenu.setMnemonic('O');
        orderMenu.add(CmdReorder.BringForward);
        orderMenu.add(CmdReorder.SendBackward);
        orderMenu.add(CmdReorder.BringToFront);
        orderMenu.add(CmdReorder.SendToBack);
        popUpActions.addElement(orderMenu);
        return popUpActions;
    }

    public final Dimension getPreferredSize() {
        return new Dimension(this._w, this._h);
    }

    public String getPrivateData() {
        return "";
    }

    public final boolean getSingle() {
        return false;
    }

    public Dimension getSize() {
        return new Dimension(this._w, this._h);
    }

    public String getTipString(MouseEvent me) {
        if (this._owner == null) {
            return this.toString();
        }
        return this._owner.toString();
    }

    public final Rectangle getTrapRect() {
        return this.getBounds();
    }

    public boolean getUseTrapRect() {
        return false;
    }

    public final int getVisState() {
        if (this.isVisible()) {
            return 1;
        }
        return 0;
    }

    public final int getWidth() {
        return this._w;
    }

    public final int getHeight() {
        return this._h;
    }

    public final int getX() {
        return this._x;
    }

    public final int getY() {
        return this._y;
    }

    public int[] getXs() {
        return new int[0];
    }

    public int[] getYs() {
        return new int[0];
    }

    public boolean hit(Rectangle r) {
        if (!this.isVisible() || !this.isSelectable()) {
            return false;
        }
        int cornersHit = this.countCornersContained(r.x, r.y, r.width, r.height);
        if (this._filled) {
            return cornersHit > 0;
        }
        return cornersHit > 0 && cornersHit < 4;
    }

    public void insertPoint(int i, int x, int y) {
    }

    public boolean intersects(Rectangle r) {
        return r.x + r.width >= this._x && r.y + r.height >= this._y && r.x <= this._x + this._w && r.y <= this._y + this._h;
    }

    public boolean intersectsPerimeter(Rectangle r) {
        return r.intersectsLine(this._x, this._y, this._x, this._y + this._h) && r.intersectsLine(this._x, this._y + this._h, this._x + this._w, this._y + this._h) && r.intersectsLine(this._x + this._w, this._y + this._h, this._x + this._w, this._y) && r.intersectsLine(this._x + this._w, this._y, this._x, this._y);
    }

    public final boolean isLowerRightResizable() {
        return false;
    }

    public final boolean isMovable() {
        return this.movable;
    }

    public boolean isReshapable() {
        return false;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean isRotatable() {
        return false;
    }

    public final boolean isSelected() {
        return this._selected;
    }

    public Selection makeSelection() {
        return null;
    }

    public void paint(Graphics g) {
        this.paint((Object)g);
    }

    public abstract void paint(Object var1);

    public abstract void appendSvg(StringBuffer var1);

    protected void appendSvgStyle(StringBuffer sb) {
        sb.append(" style='fill:rgb(").append(this.getFillColor().getRed()).append(",").append(this.getFillColor().getGreen()).append(",").append(this.getFillColor().getBlue()).append(");").append("stroke-width:").append(this.getLineWidth()).append(";").append("stroke:rgb(").append(this.getLineColor().getRed()).append(",").append(this.getLineColor().getGreen()).append(",").append(this.getLineColor().getBlue()).append(");'");
    }

    public final Point pointAlongPerimeter(int dist) {
        Point res = new Point();
        this.stuffPointAlongPerimeter(dist, res);
        return res;
    }

    public void postLoad() {
    }

    public void postSave() {
    }

    public void preSave() {
    }

    public final void print(Graphics g) {
        this.paint(g);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (this.group != null) {
            this.group.propertyChange(pce);
        }
    }

    public final void redraw() {
        Rectangle rect = this.getBounds();
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
        this.damage();
    }

    public void removePoint(int i) {
    }

    public final void reorder(int func, Layer lay) {
        lay.reorder(this, func);
    }

    @Override
    public final Rectangle routingRect() {
        return new Rectangle(this._x - 8, this._y - 8, this._w + 16, this._h + 16);
    }

    public final boolean savingAllowed() {
        return this._allowsSaving;
    }

    public final void setSavingAllowed(boolean newValue) {
        this._allowsSaving = newValue;
    }

    public final void setBounds(final int newX, final int newY, final int newWidth, final int newHeight) {
        if (this.group == null && (newX != this._x || newY != this._y || newWidth != this._w || newHeight != this._h)) {
            MutableGraphSupport.enableSaveAction();
            if (UndoManager.getInstance().isGenerateMementos()) {
                Memento memento = new Memento(){
                    int oldX;
                    int oldY;
                    int oldWidth;
                    int oldHeight;
                    {
                        this.oldX = Fig.this._x;
                        this.oldY = Fig.this._y;
                        this.oldWidth = Fig.this._w;
                        this.oldHeight = Fig.this._h;
                    }

                    @Override
                    public void undo() {
                        Fig.this.setBoundsImpl(this.oldX, this.oldY, this.oldWidth, this.oldHeight);
                        Fig.this.damage();
                    }

                    @Override
                    public void redo() {
                        Fig.this.setBoundsImpl(newX, newY, newWidth, newHeight);
                        Fig.this.damage();
                    }

                    @Override
                    public void dispose() {
                    }

                    @Override
                    public String toString() {
                        return (this.isStartChain() ? "*" : " ") + "BoundsMemento " + this.oldX + ", " + this.oldY + ", " + this.oldWidth + ", " + this.oldHeight;
                    }
                };
                UndoManager.getInstance().addMemento(memento);
            }
        }
        this.setBoundsImpl(newX, newY, newWidth, newHeight);
    }

    protected void setBoundsImpl(int x, int y, int w, int h) {
        Rectangle oldBounds = this.getBounds();
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public final void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public final void setCenter(Point p) {
        int newX = p.x - this._w / 2;
        int newY = p.y - this._h / 2;
        this.setLocation(newX, newY);
    }

    public void setEnclosingFig(Fig f) {
        if (f != null && f != this.getEnclosingFig() && this._layer != null) {
            this._layer.bringInFrontOf(this, f);
            this.damage();
        }
    }

    public final void setGroup(Fig f) {
        this.group = f;
    }

    public final void setContext(String context) {
        this._context = context;
    }

    public void setLayer(Layer lay) {
        this.firePropChange("layer", this._layer, lay);
        this._layer = lay;
    }

    public void setFillColor(Color col) {
        if (col == null ? this._fillColor == null : col.equals(this._fillColor)) {
            return;
        }
        if (col != null) {
            this.firePropChange("fillColor", this._fillColor, col);
            this._fillColor = col;
        } else {
            this.firePropChange("filled", this._filled, false);
            this._filled = false;
        }
        MutableGraphSupport.enableSaveAction();
    }

    public void setFilled(boolean f) {
        this.firePropChange("filled", this._filled, f);
        this._filled = f;
    }

    public void setLineColor(Color col) {
        if (col == null ? this._lineColor == null : col.equals(this._lineColor)) {
            return;
        }
        if (col != null) {
            this.firePropChange("lineColor", this._lineColor, col);
            this._lineColor = col;
        } else {
            this.firePropChange("lineWidth", this._lineWidth, 0);
            this._lineWidth = 0;
        }
        MutableGraphSupport.enableSaveAction();
    }

    public void setLineWidth(int w) {
        int newLW = Math.max(0, w);
        this.firePropChange("lineWidth", this._lineWidth, newLW);
        this._lineWidth = newLW;
    }

    public void setDashed(boolean now_dashed) {
        if (now_dashed) {
            this._dashes = DASH_ARRAYS[1];
            this._dashPeriod = DASH_PERIOD[1];
        } else {
            this._dashes = null;
        }
    }

    public void setDashedString(String dashString) {
        this.setDashed(dashString.equalsIgnoreCase("solid"));
    }

    public final void setLocation(int x, int y) {
        this.translate(x - this._x, y - this._y);
    }

    public final void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public final void setLocked(boolean b) {
        this.firePropChange("locked", this._locked, b);
        this._locked = b;
    }

    public void setNumPoints(int npoints) {
    }

    public void setOwner(Object own) {
        this.firePropChange("owner", this._owner, own);
        this._owner = own;
    }

    public void setPoints(Point[] ps) {
    }

    public void setPoint(int i, int x, int y) {
    }

    public final void setPoint(int i, Point p) {
        this.setPoint(i, p.x, p.y);
    }

    public void setPoint(Handle h, int x, int y) {
        this.setPoint(h.index, x, y);
    }

    public final void setPoint(Handle h, Point p) {
        this.setPoint(h, p.x, p.y);
    }

    public void setPrivateData(String data) {
    }

    public final void setSize(int w, int h) {
        this.setBounds(this._x, this._y, w, h);
    }

    public final void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public final void setWidth(int w) {
        this.setBounds(this._x, this._y, w, this._h);
    }

    public final void setHeight(int h) {
        this.setBounds(this._x, this._y, this._w, h);
    }

    public final void setX(int x) {
        this.setBounds(x, this._y, this._w, this._h);
    }

    public void setXs(int[] xs) {
    }

    public final void setY(int y) {
        this.setBounds(this._x, y, this._w, this._h);
    }

    public void setYs(int[] ys) {
    }

    public final void stuffBounds(Rectangle r) {
        r.setBounds(this._x, this._y, this._w, this._h);
    }

    public void stuffPointAlongPerimeter(int dist, Point res) {
        if (dist < this._w && dist >= 0) {
            res.x = this._x + dist;
            res.y = this._y;
        } else if (dist < this._w + this._h) {
            res.x = this._x + this._w;
            res.y = this._y + (dist - this._w);
        } else if (dist < this._w + this._h + this._w) {
            res.x = this._x + this._w - (dist - this._w - this._h);
            res.y = this._y + this._h;
        } else if (dist < this._w + this._h + this._w + this._h) {
            res.x = this._x;
            res.y = this._y + (this._w + this._h + this._w + this._h - dist);
        } else {
            res.x = this._x;
            res.y = this._y;
        }
    }

    public void translate(final int dx, final int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        if (this.group == null && UndoManager.getInstance().isGenerateMementos()) {
            class TranslateMemento
            extends Memento {
                int oldX;
                int oldY;
                int oldWidth;
                int oldHeight;

                TranslateMemento(int currentX, int currentY, int currentWidth, int currentHeight) {
                    this.oldX = currentX;
                    this.oldY = currentY;
                    this.oldWidth = currentWidth;
                    this.oldHeight = currentHeight;
                }

                @Override
                public void undo() {
                    Fig.this.setBoundsImpl(this.oldX, this.oldY, this.oldWidth, this.oldHeight);
                    Fig.this.damage();
                }

                @Override
                public void redo() {
                    Fig.this.translateImpl(dx, dy);
                    Fig.this.damage();
                }

                @Override
                public String toString() {
                    return (this.isStartChain() ? "*" : " ") + "TranslateMemento " + this.oldX + ", " + this.oldY;
                }
            }
            UndoManager.getInstance().addMemento(new TranslateMemento(this._x, this._y, this._w, this._h));
        }
        MutableGraphSupport.enableSaveAction();
        this.translateImpl(dx, dy);
    }

    protected void translateImpl(int dx, int dy) {
        Rectangle oldBounds = this.getBounds();
        this._x += dx;
        this._y += dy;
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public final boolean within(Rectangle r) {
        return r.contains(this._x, this._y) && r.contains(this._x + this._w, this._y + this._h);
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        MutableGraphSupport.enableSaveAction();
        this.visible = visible;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public void setMovable(boolean movable) {
        this.movable = movable;
    }

    public final boolean isRemoveStarted() {
        return this.removeStarted;
    }

    static {
        PropCategoryManager.categorizeProperty("Geometry", "x");
        PropCategoryManager.categorizeProperty("Geometry", "y");
        PropCategoryManager.categorizeProperty("Geometry", "width");
        PropCategoryManager.categorizeProperty("Geometry", "height");
        PropCategoryManager.categorizeProperty("Geometry", "filled");
        PropCategoryManager.categorizeProperty("Geometry", "locked");
        PropCategoryManager.categorizeProperty("Style", "lineWidth");
        PropCategoryManager.categorizeProperty("Style", "fillColor");
        PropCategoryManager.categorizeProperty("Style", "lineColor");
        PropCategoryManager.categorizeProperty("Style", "filled");
    }
}

