/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.PathConv;
import org.tigris.gef.di.GraphEdge;
import org.tigris.gef.graph.GraphEdgeHooks;
import org.tigris.gef.presentation.ArrowHead;
import org.tigris.gef.presentation.ArrowHeadNone;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.ui.Highlightable;
import org.tigris.gef.undo.Memento;
import org.tigris.gef.undo.UndoManager;

public abstract class FigEdge
extends Fig
implements GraphEdge {
    private Fig _sourcePortFig;
    private Fig _destPortFig;
    protected FigNode _sourceFigNode;
    protected FigNode _destFigNode;
    private Fig _fig;
    protected boolean _useNearest = false;
    protected boolean _highlight = false;
    protected ArrowHead _arrowHeadStart = ArrowHeadNone.TheInstance;
    protected ArrowHead _arrowHeadEnd = ArrowHeadNone.TheInstance;
    protected Vector _pathItems = new Vector();

    public FigEdge() {
        this.setFig(this.makeEdgeFig());
    }

    public FigEdge(Fig s, Fig d, FigNode sfn, FigNode dfn, Object edge) {
        this.setSourcePortFig(s);
        this.setDestPortFig(d);
        this.setSourceFigNode(sfn);
        this.setDestFigNode(dfn);
        this.setOwner(edge);
        this.setFig(this.makeEdgeFig());
        this._fig.setGroup(this);
        this._fig.setLayer(this.getLayer());
    }

    public final void addPathItem(Fig newFig, PathConv newPath) {
        this._pathItems.addElement(new PathItem(newFig, newPath));
        newFig.setGroup(this);
    }

    @Override
    public void calcBounds() {
        this._fig.calcBounds();
        Rectangle res = this._fig.getBounds();
        Point loc = new Point();
        int size = this._pathItems.size();
        for (int i = 0; i < size; ++i) {
            PathItem element = (PathItem)this._pathItems.elementAt(i);
            PathConv pc = element.getPath();
            Fig f = element.getFig();
            int oldX = f.getX();
            int oldY = f.getY();
            int halfWidth = f.getWidth() / 2;
            int halfHeight = f.getHeight() / 2;
            pc.stuffPoint(loc);
            if (oldX != loc.x || oldY != loc.y) {
                f.damage();
                f.setLocation(loc.x - halfWidth, loc.y - halfHeight);
            }
            res.add(f.getBounds());
        }
        this._x = res.x;
        this._y = res.y;
        this._w = res.width;
        this._h = res.height;
    }

    @Override
    public final void cleanUp() {
        this._fig.cleanUp();
    }

    public final void computeRoute() {
        if (UndoManager.getInstance().isGenerateMementos()) {
            Memento memento = new Memento(){
                Point[] points;
                {
                    this.points = FigEdge.this.getPoints();
                }

                @Override
                public void undo() {
                    UndoManager.getInstance().addMementoLock(this);
                    Point[] newpoints = FigEdge.this.getPoints();
                    FigEdge.this.setPoints(this.points);
                    this.points = newpoints;
                    FigEdge.this.damage();
                    UndoManager.getInstance().removeMementoLock(this);
                }

                @Override
                public void redo() {
                    this.undo();
                }

                @Override
                public void dispose() {
                }

                @Override
                public String toString() {
                    return (this.isStartChain() ? "*" : " ") + "ComputeRouteMemento " + this.points;
                }
            };
            UndoManager.getInstance().addMemento(memento);
        }
        this.computeRouteImpl();
    }

    public abstract void computeRouteImpl();

    @Override
    public final boolean contains(int x, int y) {
        if (this._fig.contains(x, y)) {
            return true;
        }
        int size = this._pathItems.size();
        for (int i = 0; i < size; ++i) {
            Fig f = ((PathItem)this._pathItems.elementAt(i)).getFig();
            if (!f.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeFromDiagram() {
        if (this._sourceFigNode instanceof FigNode) {
            this._sourceFigNode.removeFigEdge(this);
        }
        if (this._destFigNode instanceof FigNode) {
            this._destFigNode.removeFigEdge(this);
        }
        super.removeFromDiagram();
    }

    public final boolean getBetweenNearestPoints() {
        return this._useNearest;
    }

    @Override
    public final Rectangle getBounds(Rectangle r) {
        if (r == null) {
            r = new Rectangle();
        }
        this._fig.getBounds(r);
        int size = this._pathItems.size();
        for (int pathItemIndex = 0; pathItemIndex < size; ++pathItemIndex) {
            PathItem pathItem = (PathItem)this._pathItems.get(pathItemIndex);
            Fig f = pathItem.getFig();
            r.add(f.getBounds());
        }
        return r;
    }

    @Override
    public boolean getDashed() {
        return this._fig.getDashed();
    }

    public final ArrowHead getDestArrowHead() {
        return this._arrowHeadEnd;
    }

    public final FigNode getDestFigNode() {
        return this._destFigNode;
    }

    public Fig getDestPortFig() {
        return this._destPortFig;
    }

    public final Fig getFig() {
        return this._fig;
    }

    @Override
    public final Point getFirstPoint() {
        return this._fig.getFirstPoint();
    }

    @Override
    public final boolean getHighlight() {
        return this._highlight;
    }

    @Override
    public final Point getLastPoint() {
        return this._fig.getLastPoint();
    }

    @Override
    public final Color getLineColor() {
        return this._fig.getLineColor();
    }

    @Override
    public final boolean hasFillColor() {
        return false;
    }

    @Override
    public final int getLineWidth() {
        return this._fig.getLineWidth();
    }

    @Override
    public final int getNumPoints() {
        return this._fig.getNumPoints();
    }

    public final Fig getPathItem(PathConv pointOnPath) {
        return null;
    }

    public final Fig getPathItemFig(PathItem pathItem) {
        Fig fig = pathItem.getFig();
        return fig;
    }

    public final Vector getPathItemFigs() {
        Vector<Fig> figs = new Vector<Fig>();
        for (int i = 0; i < this._pathItems.size(); ++i) {
            figs.add(this.getPathItemFig((PathItem)this._pathItems.elementAt(i)));
        }
        return figs;
    }

    public final Vector getPathItemsRaw() {
        return this._pathItems;
    }

    @Override
    public final int getPerimeterLength() {
        return this._fig.getPerimeterLength();
    }

    @Override
    public final Point[] getPoints() {
        return this._fig.getPoints();
    }

    @Override
    public final Point getPoint(int i) {
        return this._fig.getPoint(i);
    }

    @Override
    public String getPrivateData() {
        Fig spf = this.getSourcePortFig();
        Fig dpf = this.getDestPortFig();
        FigNode sfn = this.getSourceFigNode();
        FigNode dfn = this.getDestFigNode();
        String data = "";
        if (spf != null) {
            data = data + "sourcePortFig=\"" + spf.getId() + "\" ";
        }
        if (dpf != null) {
            data = data + "destPortFig=\"" + dpf.getId() + "\" ";
        }
        if (sfn != null) {
            data = data + "sourceFigNode=\"" + sfn.getId() + "\" ";
        }
        if (dfn != null) {
            data = data + "destFigNode=\"" + dfn.getId() + "\" ";
        }
        return data;
    }

    public final ArrowHead getSourceArrowHead() {
        return this._arrowHeadStart;
    }

    public final FigNode getSourceFigNode() {
        return this._sourceFigNode;
    }

    public Fig getSourcePortFig() {
        return this._sourcePortFig;
    }

    @Override
    public final int[] getXs() {
        return this._fig.getXs();
    }

    @Override
    public final int[] getYs() {
        return this._fig.getYs();
    }

    @Override
    public boolean hit(Rectangle r) {
        if (this._fig.hit(r)) {
            return true;
        }
        int size = this._pathItems.size();
        for (int i = 0; i < size; ++i) {
            Fig f = ((PathItem)this._pathItems.elementAt(i)).getFig();
            if (!f.isAnnotation() || !f.hit(r)) continue;
            return true;
        }
        return false;
    }

    public final Fig hitFig(Rectangle r) {
        Enumeration iter = this._pathItems.elements();
        Fig res = null;
        if (this._fig.hit(r)) {
            res = this._fig;
        }
        while (iter.hasMoreElements()) {
            PathItem pi = (PathItem)iter.nextElement();
            Fig f = pi.getFig();
            if (!f.hit(r)) continue;
            res = f;
        }
        return res;
    }

    @Override
    public final boolean intersects(Rectangle r) {
        if (this._fig.intersectsPerimeter(r)) {
            return true;
        }
        int size = this._pathItems.size();
        for (int i = 0; i < size; ++i) {
            Fig f = ((PathItem)this._pathItems.elementAt(i)).getFig();
            if (f.getLayer() == null || !f.intersects(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isReshapable() {
        return this._fig.isReshapable();
    }

    @Override
    public final boolean isResizable() {
        return this._fig.isResizable();
    }

    @Override
    public final boolean isRotatable() {
        return this._fig.isRotatable();
    }

    protected abstract Fig makeEdgeFig();

    @Override
    public void paint(Object graphicContext) {
        Graphics g = (Graphics)graphicContext;
        this._fig.paint(g);
        this.paintArrowHeads(g);
        this.paintPathItems(g);
    }

    @Override
    public void appendSvg(StringBuffer sb) {
        this._fig.appendSvg(sb);
        this.appendSvgPathItems(sb);
    }

    protected final void paintArrowHeads(Object g) {
        this._arrowHeadStart.paintAtHead(g, this._fig);
        this._arrowHeadEnd.paintAtTail(g, this._fig);
    }

    public final void paintHighlightLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.setColor(Globals.getPrefs().getHighlightColor());
        double dx = x2 - x1;
        double dy = y2 - y1;
        double denom = Math.sqrt(dx * dx + dy * dy);
        if (denom == 0.0) {
            return;
        }
        double orthoX = dy / denom;
        double orthoY = -dx / denom;
        for (double i = 2.0; i < 5.0; i += 0.27) {
            int hx1 = (int)((double)x1 + i * orthoX);
            int hy1 = (int)((double)y1 + i * orthoY);
            int hx2 = (int)((double)x2 + i * orthoX);
            int hy2 = (int)((double)y2 + i * orthoY);
            g.drawLine(hx1, hy1, hx2, hy2);
        }
    }

    protected final void paintPathItems(Graphics g) {
        Vector pathVec = this.getPathItemsRaw();
        for (int i = 0; i < pathVec.size(); ++i) {
            PathItem element = (PathItem)pathVec.elementAt(i);
            Fig f = element.getFig();
            f.paint(g);
        }
    }

    protected final void appendSvgPathItems(StringBuffer sb) {
        Vector pathVec = this.getPathItemsRaw();
        for (int i = 0; i < pathVec.size(); ++i) {
            PathItem element = (PathItem)pathVec.elementAt(i);
            Fig f = element.getFig();
            f.appendSvg(sb);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String pName = pce.getPropertyName();
        Object src = pce.getSource();
        if (pName.equals("disposed") && src == this.getOwner()) {
            this.removeFromDiagram();
        }
        if (pName.equals("highlight") && src == this.getOwner()) {
            this._highlight = (Boolean)pce.getNewValue();
            this.damage();
        }
    }

    public final void removePathItem(PathItem goneItem) {
        this._pathItems.removeElement(goneItem);
        goneItem.getFig().setGroup(null);
    }

    public final void removePathItem(Fig goneFig) {
        for (int i = 0; i < this._pathItems.size(); ++i) {
            PathItem curItem = (PathItem)this._pathItems.elementAt(i);
            if (curItem.getFig() != goneFig) continue;
            this.removePathItem(curItem);
            return;
        }
    }

    public final void setBetweenNearestPoints(boolean un) {
        this._useNearest = un;
    }

    @Override
    public final void setDashed(boolean d) {
        this._fig.setDashed(d);
    }

    public final void setDestArrowHead(ArrowHead newArrow) {
        this._arrowHeadEnd = newArrow;
    }

    public void setDestFigNode(FigNode fn) {
        try {
            if (this._destFigNode instanceof FigNode) {
                this._destFigNode.removeFigEdge(this);
            }
            this._destFigNode = fn;
            fn.addFigEdge(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void setDestPortFig(Fig fig) {
        if (fig == null) {
            throw new IllegalArgumentException("A destination port must be supplied");
        }
        this._destPortFig = fig;
    }

    public void setFig(Fig f) {
        if (this._fig != null && this._fig.getGroup() == this) {
            this._fig.setGroup(null);
        }
        this._fig = f;
        this._fig.setGroup(this);
        this._fig.setLayer(this.getLayer());
    }

    @Override
    public final void setHighlight(boolean b) {
        this._highlight = b;
        this.damage();
    }

    @Override
    public final void setLineColor(Color c) {
        this._fig.setLineColor(c);
        this.getSourceArrowHead().setLineColor(c);
        this.getDestArrowHead().setLineColor(c);
    }

    @Override
    public final void setLineWidth(int w) {
        this._fig.setLineWidth(w);
    }

    @Override
    public final void setNumPoints(int npoints) {
        this._fig.setNumPoints(npoints);
        this.calcBounds();
    }

    @Override
    public void setOwner(Object own) {
        Object oldOwner = this.getOwner();
        if (oldOwner instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)oldOwner).removePropertyChangeListener(this);
        } else if (oldOwner instanceof Highlightable) {
            ((Highlightable)oldOwner).removePropertyChangeListener(this);
        }
        if (own instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)own).addPropertyChangeListener(this);
        } else if (own instanceof Highlightable) {
            ((Highlightable)own).addPropertyChangeListener(this);
        }
        super.setOwner(own);
    }

    @Override
    public final void setPoints(Point[] ps) {
        this._fig.setPoints(ps);
        this.calcBounds();
    }

    @Override
    public final void setPoint(int i, int x, int y) {
        this._fig.setPoint(i, x, y);
        this.calcBounds();
    }

    @Override
    public void setPoint(Handle h, int x, int y) {
        this._fig.setPoint(h, x, y);
        this.calcBounds();
    }

    public final void setSourceArrowHead(ArrowHead newArrow) {
        this._arrowHeadStart = newArrow;
    }

    public void setSourceFigNode(FigNode fn) {
        try {
            if (this._sourceFigNode instanceof FigNode) {
                this._sourceFigNode.removeFigEdge(this);
            }
            this._sourceFigNode = fn;
            fn.addFigEdge(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void setSourcePortFig(Fig fig) {
        if (fig == null) {
            throw new IllegalArgumentException("A source port must be supplied");
        }
        this._sourcePortFig = fig;
    }

    @Override
    public final void setXs(int[] xs) {
        this._fig.setXs(xs);
        this.calcBounds();
    }

    @Override
    public final void setYs(int[] ys) {
        this._fig.setYs(ys);
        this.calcBounds();
    }

    @Override
    public final void stuffPointAlongPerimeter(int dist, Point res) {
        this._fig.stuffPointAlongPerimeter(dist, res);
    }

    public final void translateEdge(int dx, int dy) {
        this._fig.translate(dx, dy);
        this.calcBounds();
    }

    @Override
    public void translateImpl(int dx, int dy) {
        this._fig.translate(dx, dy);
        this.calcBounds();
    }

    public final void updatePathItemLocations() {
        this.calcBounds();
    }

    private class PathItem
    implements Serializable {
        private static final long serialVersionUID = -5298572087861993804L;
        final Fig _fig;
        final PathConv _path;

        PathItem(Fig f, PathConv pc) {
            this._fig = f;
            this._path = pc;
        }

        public final PathConv getPath() {
            return this._path;
        }

        public final Fig getFig() {
            return this._fig;
        }
    }
}

