/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.Fig;

public class FigImage
extends Fig
implements ImageObserver {
    private static final long serialVersionUID = 2567695485399374706L;
    protected transient Image _image;
    protected URL _url;
    private static Log LOG = LogFactory.getLog(FigImage.class);

    public FigImage(int x, int y, int w, int h, Image img) {
        super(x, y, w, h);
        this._image = img;
    }

    public FigImage(int x, int y, Image i) {
        this(x, y, 0, 0, i);
        this.setSize(i.getWidth(this), i.getHeight(this));
    }

    public FigImage(int x, int y, URL imageUrl) {
        super(x, y, 0, 0);
        this._url = imageUrl;
        this._image = Globals.getImage(this._url);
        Globals.waitForImages();
        this.setSize(this._image.getWidth(this), this._image.getHeight(this));
    }

    @Override
    public void createDrag(int anchorX, int anchorY, int x, int y, int snapX, int snapY) {
        this.setLocation(snapX, snapY);
    }

    public URL getURL() {
        return this._url;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        boolean done = (infoflags & 0x70) != 0;
        return !done;
    }

    @Override
    public void paint(Object graphicContext) {
        if (this._image == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"reloading image");
            }
            if (this._url != null) {
                this._image = Globals.getImage(this._url);
                Globals.waitForImages();
            }
        }
        Graphics g = (Graphics)graphicContext;
        if (this._image != null) {
            g.drawImage(this._image, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this);
        } else {
            g.setColor(this.getFillColor());
            g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public void setURL(URL newURL) {
        this._url = newURL;
    }

    @Override
    public void appendSvg(StringBuffer sb) {
        sb.append("<image id='").append(this.getId()).append("' class='").append(this.getClass().getName()).append("' style='fill:none;' x='").append(this.getX()).append("' y='").append(this.getY()).append("' width='").append(this.getWidth()).append("' height='").append(this.getHeight()).append("' xlink:href='").append(this.getURL()).append(" />");
    }
}

