/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Point;
import java.util.Enumeration;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.AnnotationLineRemover;
import org.tigris.gef.presentation.AnnotationProperties;
import org.tigris.gef.presentation.AnnotationStrategy;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigLine;

public class NodeAnnotationStrategy
extends AnnotationStrategy {
    private static final long serialVersionUID = -7180345622697075103L;

    @Override
    public Point restoreAnnotationPosition(Fig annotation) {
        Fig owner = annotation.getAnnotationOwner();
        if (!(owner instanceof FigEdge) && !(owner instanceof FigLine)) {
            AnnotationProperties prop = (AnnotationProperties)this.annotations.get(annotation);
            int delta_x = prop.getOffset();
            float delta_y = prop.getRatio();
            int own_x = owner.getCenter().x;
            int own_y = owner.getCenter().y;
            int newX = own_x + delta_x;
            int newY = (int)((float)own_y + delta_y);
            return new Point(newX - annotation.getWidth() / 2, newY - annotation.getHeight() / 2);
        }
        return new Point(1, 1);
    }

    @Override
    public void storeAnnotationPosition(Fig annotation) {
        Fig owner = annotation.getAnnotationOwner();
        if (!(owner instanceof FigEdge) && !(owner instanceof FigLine)) {
            Point anPos = annotation.getCenter();
            Point ownerPos = owner.getCenter();
            int delta_x = anPos.x - ownerPos.x;
            float delta_y = anPos.y - ownerPos.y;
            AnnotationProperties prop = (AnnotationProperties)this.annotations.get(annotation);
            prop.setOffset(delta_x, prop.hasFixedOffset());
            prop.setRatio(delta_y, prop.hasFixedRatio());
        }
    }

    public void drawConnectingLine(Fig annotation) {
        if (this.getAnnotationProperties(annotation).getLineVisibilityDuration() == 0) {
            return;
        }
        Fig owner = annotation.getAnnotationOwner();
        AnnotationProperties prop = (AnnotationProperties)this.annotations.get(annotation);
        FigLine line = prop.getConnectingLine();
        line.setShape(annotation.getCenter(), owner.getCenter());
        line.setLineColor(Color.red);
        line.setFillColor(Color.red);
        line.setDashed(true);
        if (!Globals.curEditor().getLayerManager().getContents().contains(line)) {
            Globals.curEditor().add(line);
        }
        Globals.curEditor().getLayerManager().bringToFront(annotation);
        Globals.curEditor().getLayerManager().sendToBack(line);
        line.damage();
        annotation.damage();
        AnnotationLineRemover.instance().removeLineIn(this.getAnnotationProperties(annotation).getLineVisibilityDuration(), annotation);
    }

    @Override
    public void translateAnnotations(Fig owner) {
        Enumeration iter = this.annotations.keys();
        while (iter.hasMoreElements()) {
            Fig annotation = (Fig)iter.nextElement();
            annotation.setLocation(this.restoreAnnotationPosition(annotation));
            this.drawConnectingLine(annotation);
            annotation.endTrans();
            annotation.damage();
        }
    }
}

