/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.ui;

import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import org.tigris.gef.ui.TinyHTMLViewer;

class HtmlPane
extends JScrollPane
implements HyperlinkListener {
    public static String DEFAULT_PAGE = "/uci/gef/help/index.html";
    JEditorPane html;

    public HtmlPane(String startPage) {
        URL url = null;
        try {
            url = new URL(startPage);
        }
        catch (Exception ex) {
            try {
                url = TinyHTMLViewer.class.getResource(startPage);
            }
            catch (Exception ex2) {
                try {
                    url = DEFAULT_PAGE.startsWith("http") ? new URL(DEFAULT_PAGE) : TinyHTMLViewer.class.getResource(DEFAULT_PAGE);
                }
                catch (Exception ex3) {
                    url = null;
                }
            }
        }
        if (url != null) {
            try {
                this.html = new JEditorPane(url);
                this.html.setEditable(false);
                this.html.addHyperlinkListener(this);
                JViewport vp = this.getViewport();
                vp.add(this.html);
            }
            catch (Exception ex4) {
                System.out.println("could not open HTML pane");
            }
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(e.getURL());
        }
    }

    protected void linkActivated(URL u) {
        Cursor c = this.html.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.html.setCursor(waitCursor);
        SwingUtilities.invokeLater(new PageLoader(u, c));
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL u, Cursor c) {
            this.url = u;
            this.cursor = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.url == null) {
                HtmlPane.this.html.setCursor(this.cursor);
                Container parent = HtmlPane.this.html.getParent();
                parent.repaint();
            } else {
                Document doc = HtmlPane.this.html.getDocument();
                try {
                    HtmlPane.this.html.setPage(this.url);
                }
                catch (IOException ioe) {
                    HtmlPane.this.html.setDocument(doc);
                    HtmlPane.this.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

