/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.util;

import org.tigris.gef.util.Predicate;

public class PredicateType
implements Predicate {
    Class[] _patterns;
    int _numPats;
    String _printString = null;

    protected PredicateType(Class[] pats) {
        this(pats, pats.length);
    }

    protected PredicateType(Class[] pats, int numPats) {
        this._patterns = pats;
        this._numPats = numPats;
    }

    public static PredicateType create() {
        return new PredicateType(null, 0);
    }

    public static PredicateType create(Class c0) {
        Class[] classes = new Class[]{c0};
        return new PredicateType(classes);
    }

    public static PredicateType create(Class c0, Class c1) {
        Class[] classes = new Class[]{c0, c1};
        return new PredicateType(classes);
    }

    public static PredicateType create(Class c0, Class c1, Class c2) {
        Class[] classes = new Class[]{c0, c1, c2};
        return new PredicateType(classes);
    }

    @Override
    public boolean predicate(Object o) {
        if (this._numPats == 0) {
            return true;
        }
        for (int i = 0; i < this._numPats; ++i) {
            if (!this._patterns[i].isInstance(o)) continue;
            return true;
        }
        return false;
    }

    public boolean isPredicateFor(Object o) {
        for (int i = 0; i < this._numPats; ++i) {
            if (!this._patterns[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this._printString != null) {
            return this._printString;
        }
        if (this._numPats == 0) {
            return "Any Type";
        }
        String res = "";
        for (int i = 0; i < this._numPats; ++i) {
            String clsName = this._patterns[i].getName();
            int lastDot = clsName.lastIndexOf(".");
            clsName = clsName.substring(lastDot + 1);
            res = res + clsName;
            if (i >= this._numPats - 1) continue;
            res = res + ", ";
        }
        this._printString = res;
        return res;
    }
}

