/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.acces.contracte;

import java.awt.Component;
import java.io.File;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import ro.atreides.acces.ExternalDeviceListener;
import ro.atreides.acces.ExternalReaderBean;
import ro.atreides.acces.PlanOrarBean;
import ro.atreides.acces.advancedcontrol.AdvancedControlUtils;
import ro.atreides.acces.contracte.CardClientBean;
import ro.atreides.acces.contracte.ContracteDao;
import ro.atreides.acces.contracte.ContractePerioada;
import ro.atreides.acces.contracte.PerioadaEntry;
import ro.atreides.acces.contracte.StatusContractView;
import ro.atreides.acces.contracte.TipContract;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.pontaj.PontajLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.acces.gui.AbonamentChooser;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ProductPriceInterface;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataChooser;
import ro.atreides.utils.plati.TipPlataProvider;

public class ContracteLogic
extends EventGenerator {
    private static ContracteLogic instance;
    private ConnectionPool pool;
    private ProductPriceInterface priceInterface;
    public static final String CODED_KEY__USER_TEXT = "t";
    public static final String CODED_KEY__USER_STATUS = "s";
    public static final String CODED_KEY__ID_CLIENT = "u";
    public static final String lastSyncKey = "accesLastSyncTime";
    private Vector<ExternalDeviceListener> listeners = new Vector();

    private ContracteLogic() {
        this.pool = ConnectionPool.getInstance();
    }

    private synchronized ContracteDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        ContracteDao dao = null;
        while (dao == null) {
            dao = (ContracteDao)this.pool.getDao(ContracteDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(ContracteDao.class.getName(), connection);
        }
        return dao;
    }

    public static synchronized ContracteLogic getInstance() {
        if (instance == null) {
            instance = new ContracteLogic();
        }
        return instance;
    }

    public void addExternalDeviceListener(ExternalDeviceListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTipContract(String nume, int perioada, int idProdus, int renew, int graced, int sedinte) {
        try {
            this.getDao().addTipContract(nume, perioada, idProdus, renew, graced, sedinte);
            this.pool.commit();
            this.notifyListeners(801);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTipContract(TipContract tc) {
        try {
            this.getDao().deleteTipContract(tc.getId());
            this.pool.commit();
            this.notifyListeners(801);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<TipContract> getTipuriContract() {
        try {
            Vector contracte = this.getDao().getAllTipContract();
            Collections.sort(contracte);
            Vector vector = contracte;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<TipContract> vector = new Vector<TipContract>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public TipContract getTipContractByIdNoCommit(int id) throws SQLException {
        return this.getDao().getTipContractById(id);
    }

    public Vector<TipContract> getTipContractByPlanOrarNoCommit(int idPlan) throws SQLException {
        return this.getDao().getTipContractByIdPlan(idPlan);
    }

    public TipContract getTipContractByNameNoCommit(String name) throws SQLException {
        return this.getDao().getTipContractByName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TipContract getTipContractByName(String name) {
        try {
            TipContract tipContract = this.getTipContractByNameNoCommit(name);
            return tipContract;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            TipContract tipContract = null;
            return tipContract;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TipContract getTipContractById(int id) {
        try {
            TipContract tipContract = this.getTipContractByIdNoCommit(id);
            return tipContract;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            TipContract tipContract = null;
            return tipContract;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTipContract(TipContract tc) {
        try {
            this.getDao().updateTipContract(tc.getNume(), tc.getPerioada(), tc.getIdProdus(), tc.getRenew(), tc.getGraced(), tc.getNrSedinte(), tc.getId());
            this.pool.commit();
            this.notifyListeners(801);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addContract(int idClient, int idTipContract, int idPromotie, String card, String cardTemporar, boolean plataPartiala, int zilePlataPartiala) {
        try {
            int idContract = this.addContractNoCommit(idClient, idTipContract, idPromotie, card, cardTemporar, plataPartiala, zilePlataPartiala);
            this.pool.commit();
            int n = idContract;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return -1;
    }

    public int addContractNoCommit(int idClient, int idTipContract, int idPromotie, String card, String cardTemporar, boolean plataPartiala, int zilePlataPartiala) throws SQLException {
        this.getDao().addContract(idTipContract, idClient, idPromotie, card, cardTemporar, plataPartiala, zilePlataPartiala);
        return this.pool.getIdentityLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCarduriForClient(int idClient, String card1, String card2) {
        try {
            this.setCarduriForClientNoCommit(idClient, card1, card2);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void setCarduriForClientNoCommit(int idClient, String card1, String card2) throws SQLException {
        this.getDao().setCarduriForClient(idClient, card1, card2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContract(StatusContractView toUpdate) {
        try {
            this.getDao().updateContract(toUpdate.getIdClient(), toUpdate.getIdTipContract(), toUpdate.getCard(), toUpdate.getCardTemporar(), toUpdate.getStatus(), toUpdate.getIdPromotie(), toUpdate.isPlataPartiala(), toUpdate.getNrZilePlataPartiala(), toUpdate.getId());
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContract(StatusContractView toDelete) {
        try {
            this.deleteContractNoCommit(toDelete);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void deleteContractNoCommit(StatusContractView toDelete) throws SQLException {
        this.getDao().deleteContract(toDelete.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<StatusContractView> getContracte(Hashtable criteria) {
        try {
            Vector<StatusContractView> vector = this.getContracteNoCommit(criteria);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<StatusContractView> vector = new Vector<StatusContractView>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private Vector<StatusContractView> getContracteNoCommit(Hashtable criteria) throws SQLException {
        int idTipContract = -1;
        Object o1 = criteria.get("Tip abonament");
        if (o1 != null) {
            idTipContract = (Integer)o1;
        }
        int idClient = -1;
        Object o2 = criteria.get(Constants.CLIENT_KEY);
        if (o2 != null) {
            idClient = (Integer)o2;
        }
        int status = -1;
        Object o3 = criteria.get(Constants.STATUS_CONTRACT_KEY);
        if (o3 != null) {
            status = (Integer)o3;
        }
        return this.getDao().getContracte(idTipContract, idClient, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContractValid(StatusContractView scv) {
        try {
            ContractePerioada cp = ContracteLogic.getInstance().getCurrentPerioadaNoCommit(scv.getId());
            if (cp != null) {
                if (scv.isPlataPartiala()) {
                    boolean bl = true;
                    return bl;
                }
                if (scv.getNrSedinte() == -1 || cp.getSedinteConsumate() < scv.getNrSedinte()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeazaPerioada(int idPerioada) {
        try {
            this.activeazaPerioadaNoCommit(idPerioada);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void activeazaPerioadaNoCommit(int idPerioada) throws SQLException {
        this.getDao().updateStartDateForPerioada(idPerioada, DateUtils.getCurrentTimestamp());
        this.getDao().setPerioadaStatus(idPerioada, 1);
    }

    public void dezactiveazaPerioadaNoCommit(int idPerioada) throws SQLException {
        this.getDao().setPerioadaStatus(idPerioada, 2);
    }

    public Vector<ContractePerioada> getAllPerioadeActiveForAbonamentNoCommit(int idAbonament) throws SQLException {
        Vector<ContractePerioada> result = this.getDao().getAllPerioadeActiveForAbonament(idAbonament);
        return result;
    }

    public void updateContractStatusNoCommit(StatusContractView contract) throws SQLException {
        int idTipContract = contract.getIdTipContract();
        int idClient = contract.getIdClient();
        int contractId = contract.getId();
        this.updateContractStatusNoCommit(contractId, idTipContract, idClient);
    }

    public void updateContractStatusNoCommit(int contractId, int idTipContract, int idClient) throws SQLException {
        TipContract tc = this.getDao().getTipContractById(idTipContract);
        int period = tc.getPerioada();
        int graced = tc.getGraced();
        int renew = tc.getRenew();
        long dayMillis = DateUtils.dayMillis;
        int newStatus = 4;
        ContractePerioada gracedPerioada = null;
        boolean atLeastOnePeriodInactiva = false;
        Vector<ContractePerioada> perioade = this.getDao().getAllPerioadeActiveForAbonament(contractId);
        for (int i = 0; i < perioade.size(); ++i) {
            ContractePerioada contractePerioada = perioade.elementAt(i);
            int sedinteInContract = tc.getNrSedinte();
            if (sedinteInContract != -1 && contractePerioada.getSedinteConsumate() >= sedinteInContract) {
                this.getDao().setPerioadaStatus(contractePerioada.getId(), 2);
                continue;
            }
            Timestamp ts = contractePerioada.getStart();
            if (ts != null) {
                long validUntil = contractePerioada.getStop().getTime();
                long renewAt = validUntil - (long)renew * dayMillis;
                long suspendedAt = validUntil + (long)graced * dayMillis;
                long now = System.currentTimeMillis();
                if (now > suspendedAt) {
                    newStatus = 4;
                    this.getDao().setPerioadaStatus(contractePerioada.getId(), 2);
                    continue;
                }
                if (now > validUntil) {
                    newStatus = 3;
                    gracedPerioada = contractePerioada;
                    continue;
                }
                if (now > renewAt) {
                    newStatus = 2;
                    if (gracedPerioada == null) break;
                    this.getDao().setPerioadaStatus(gracedPerioada.getId(), 2);
                    break;
                }
                newStatus = 1;
                if (gracedPerioada == null) break;
                this.getDao().setPerioadaStatus(gracedPerioada.getId(), 2);
                break;
            }
            atLeastOnePeriodInactiva = true;
        }
        if (atLeastOnePeriodInactiva) {
            newStatus = 1;
        }
        this.getDao().updateStatusForContract(contractId, newStatus);
        ClientLogic.getInstance().setLastUpdatedForClientNoCommit(idClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContractStatus(int contractId, int idTipContract, int idClient) {
        try {
            this.updateContractStatusNoCommit(contractId, idTipContract, idClient);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContractStatus(StatusContractView statusContractView) {
        try {
            this.updateContractStatusNoCommit(statusContractView);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<CardClientBean> getCardsForClient(int idClient) {
        try {
            Vector<CardClientBean> vector = this.getCardsForClientNoCommit(idClient);
            return vector;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
            Vector<CardClientBean> vector = new Vector<CardClientBean>();
            return vector;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Vector<CardClientBean> getCardsForClientNoCommit(int idClient) throws SQLException {
        Hashtable<String, Integer> criteria = new Hashtable<String, Integer>();
        criteria.put(Constants.CLIENT_KEY, idClient);
        Vector<StatusContractView> contracte = this.getContracteNoCommit(criteria);
        Vector<CardClientBean> result = new Vector<CardClientBean>();
        for (int i = 0; i < contracte.size(); ++i) {
            StatusContractView statusContractView = contracte.elementAt(i);
            CardClientBean ccb = new CardClientBean();
            ccb.setCard(statusContractView.getCard());
            ccb.setCardSecundar(statusContractView.getCardTemporar());
            ccb.setIdAbonament(statusContractView.getIdTipContract());
            ccb.setIdClient(idClient);
            ccb.setNumeAbonament(statusContractView.getNumeContract());
            result.add(ccb);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<TipContract> getTipContractSelected(int idClient) {
        Vector<TipContract> selectedContracts = new Vector<TipContract>();
        try {
            Hashtable<String, Integer> criteria = new Hashtable<String, Integer>();
            criteria.put(Constants.CLIENT_KEY, idClient);
            Vector<StatusContractView> contracteActive = this.getContracteNoCommit(criteria);
            for (StatusContractView statusContractView : contracteActive) {
                int idTipContract = statusContractView.getIdTipContract();
                TipContract tp = this.getTipContractByIdNoCommit(idTipContract);
                selectedContracts.add(tp);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return selectedContracts;
    }

    public void modificaTipAbonamentNoCommit(int idContract, int tipAbonamentNou) throws SQLException {
        this.getDao().updateTipAbonamentForAbonament(idContract, tipAbonamentNou);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modificaTipAbonament(int idContract, int tipAbonamentNou) {
        try {
            this.modificaTipAbonamentNoCommit(idContract, tipAbonamentNou);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modificaAbonamente(int idClient, Vector<TipContract> oldAbonamente, Vector<TipContract> newAbonamente, String card1, String card2) {
        try {
            Vector<TipContract> toAdd = new Vector<TipContract>();
            Vector<TipContract> toRemove = new Vector<TipContract>();
            for (TipContract tipContract : oldAbonamente) {
                if (newAbonamente.contains(tipContract)) continue;
                toRemove.add(tipContract);
            }
            for (TipContract tipContract : newAbonamente) {
                if (oldAbonamente.contains(tipContract)) continue;
                toAdd.add(tipContract);
            }
            if (toAdd.size() > 0) {
                for (TipContract tipContract : toAdd) {
                    this.addContractNoCommit(idClient, tipContract.getId(), -1, card1, card2, false, -1);
                }
            }
            if (toRemove.size() > 0) {
                for (TipContract tipContract : toRemove) {
                    Vector<StatusContractView> contracte = this.getStatusContracteByCard(card1);
                    for (StatusContractView statusContractView : contracte) {
                        if (statusContractView.getIdTipContract() != tipContract.getId()) continue;
                        this.deleteContractNoCommit(statusContractView);
                    }
                }
            }
            this.pool.commit();
            boolean bl = toRemove.size() > 0 || toAdd.size() > 0;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<StatusContractView> getStatusContracteByCard(String card) {
        try {
            Vector<StatusContractView> vector = this.getStatusContracteByCardNoCommit(card);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<StatusContractView> vector = new Vector<StatusContractView>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<StatusContractView> getStatusContracteByCardNoCommit(String card) throws SQLException {
        return this.getDao().getContract(card);
    }

    public void addCommentNoCommit(String comment, int idClient) throws SQLException {
        this.getDao().addComment(idClient, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComment(String comment, int idClient) {
        try {
            this.addCommentNoCommit(comment, idClient);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getComments(int idClient) {
        try {
            Vector vector = this.getDao().getComments(idClient);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public int createPerioadaAbonamentNoCommit(int idAbonament) throws SQLException {
        this.getDao().createPerioadaAbonament(idAbonament);
        int id = this.pool.requestConnection().getIndentityLocal();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDaysForcedToPerioadaCommit(int days, int idPerioada) {
        try {
            this.setDaysForcedToPerioada(days, idPerioada);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void setDaysForcedToPerioada(int days, int idPerioada) throws SQLException {
        this.getDao().setForcedDaysForPerioada(days, idPerioada);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean intrerupePerioada(PerioadaEntry pe, Timestamp dataIntrerupere) {
        try {
            this.dezactiveazaPerioadaNoCommit(pe.getId());
            this.updateStopForPerioadaNoCommit(pe.getId(), dataIntrerupere);
            int daysLeft = DateUtils.getDaysInPerioada(DateUtils.getStartOfDay(dataIntrerupere), pe.getStopTime()).size();
            int idPerioadaNoua = this.createPerioadaAbonamentNoCommit(pe.getIdContract());
            this.setDaysForcedToPerioada(daysLeft, idPerioadaNoua);
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContractePerioada getCurrentPerioada(int idAbonament) {
        try {
            ContractePerioada contractePerioada = this.getCurrentPerioadaNoCommit(idAbonament);
            return contractePerioada;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            ContractePerioada contractePerioada = null;
            return contractePerioada;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public ContractePerioada getCurrentPerioadaNoCommit(int idAbonament) throws SQLException {
        return this.getDao().getCurrentPerioadaForAbonamentClient(idAbonament);
    }

    public void addPaymentToContractNoCommit(Timestamp dateadd, ContractePerioada cp, double suma) throws SQLException {
        this.getDao().addPayment(cp.getId(), suma);
    }

    public String recordClientInNoCommit(StatusContractView statusContractView, Client c, Timestamp lastCheckIn, int abonamenteCheckInSeconds, String card, boolean consumeSedinte) throws SQLException {
        String result = null;
        int idContract = statusContractView.getId();
        if (lastCheckIn.getTime() + (long)abonamenteCheckInSeconds * DateUtils.secondsMillis < System.currentTimeMillis() || abonamenteCheckInSeconds <= 0) {
            ContractePerioada perioadaCurenta = this.getCurrentPerioadaNoCommit(idContract);
            for (int retries = 1; perioadaCurenta == null && retries > 0; --retries) {
                Logger.logDebug(this, "Perioada ACTIVA NEGASITA pt client " + c + " card : " + card);
                Vector<PerioadaEntry> perioadeAbonamentCurent = new Vector<PerioadaEntry>();
                Vector<PerioadaEntry> perioade = this.getPerioadeEntryNoCommit(c.getId());
                for (PerioadaEntry perioadaEntry : perioade) {
                    if (perioadaEntry.getIdTipContract() != statusContractView.getIdTipContract()) continue;
                    perioadeAbonamentCurent.add(perioadaEntry);
                }
                if (perioadeAbonamentCurent.size() > 0) {
                    PerioadaEntry pe = (PerioadaEntry)perioadeAbonamentCurent.get(0);
                    this.activeazaPerioada(pe.getId());
                    Logger.logDebug(this, "Gasit perioada libera cu id " + pe.getId() + ", am activat perioada !!");
                } else {
                    Logger.logDebug(this, "Perioada for client " + c + " card : " + card);
                }
                perioadaCurenta = this.getCurrentPerioadaNoCommit(idContract);
            }
            if (perioadaCurenta != null) {
                Logger.logDebug(this, "Perioada CURENTA pt client " + c + " card : " + card);
                if (consumeSedinte) {
                    this.addIntrareClientNoCommit(idContract);
                }
                PontajLogic.getInstance().punchClientInNoCommit(c.getId(), idContract, statusContractView.getNumeContract(), true);
                this.updateContractStatusNoCommit(statusContractView);
                Timestamp stop = perioadaCurenta.getStop();
                if (stop != null) {
                    result = Formatters.DATE_FORMAT_RO.format(stop);
                }
            }
        } else {
            Logger.logDebug(this, "DUBLARE in interval de " + abonamenteCheckInSeconds + " secunde pt client " + c + " card : " + card);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordClientOut(int idClient) {
        try {
            PontajLogic.getInstance().punchClientOut(idClient);
            this.pool.commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntrariPerioadaCurenta(StatusContractView scv) {
        try {
            ContractePerioada cp = this.getDao().getCurrentPerioadaForAbonamentClient(scv.getId());
            if (cp != null) {
                int n = cp.getSedinteConsumate();
                return n;
            }
            int n = -1;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIntrareClient(int idAbonament) {
        try {
            this.addIntrareClientNoCommit(idAbonament);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void addIntrareClientNoCommit(int idAbonament) throws SQLException {
        ContractePerioada cp = this.getDao().getCurrentPerioadaForAbonamentClient(idAbonament);
        if (cp != null) {
            int idPerioada = cp.getId();
            this.getDao().addIntrarePerioadaCurenta(idPerioada);
        }
    }

    public double getTotalPaymentsForPerioadaContractNoCommit(int idPerioada) throws SQLException {
        return this.getDao().getTotalPaymentsForPerioadaContract(idPerioada);
    }

    public ContractePerioada getPerioadaByIdNoCommit(int id) throws SQLException {
        return this.getDao().getPerioadaById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExpirare(int idTipContract, int idAbonament) {
        try {
            TipContract tc = ContracteLogic.getInstance().getTipContractById(idTipContract);
            ContractePerioada cp = ContracteLogic.getInstance().getCurrentPerioadaNoCommit(idAbonament);
            if (cp != null) {
                Timestamp exp = new Timestamp(cp.getStart().getTime() + DateUtils.dayMillis * (long)tc.getPerioada());
                String string = Formatters.DATE_FORMAT_RO.format(exp);
                return string;
            }
            String exp = "-";
            return exp;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            String string = "-";
            return string;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStopForPerioadaCommit(int idPerioada, Timestamp newStopTime) {
        try {
            this.updateStopForPerioadaNoCommit(idPerioada, newStopTime);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void updateStopForPerioada(PerioadaEntry pe, Timestamp newStopTime) throws SQLException {
        this.updateStopForPerioadaNoCommit(pe.getId(), newStopTime);
    }

    public void updateStopForPerioadaNoCommit(int idPerioada, Timestamp newStopTime) throws SQLException {
        this.getDao().updateStopDateForPerioada(idPerioada, newStopTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<PerioadaEntry> getPerioadeEntry(int idClient) {
        Vector<PerioadaEntry> result = new Vector();
        try {
            result = this.getPerioadeEntryNoCommit(idClient);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    private Vector<PerioadaEntry> getPerioadeEntryNoCommit(int idClient) throws SQLException {
        Vector<Object> result = new Vector();
        result = this.getDao().getAllPerioadeForClient(idClient);
        for (int i = 0; i < result.size(); ++i) {
            PerioadaEntry perioadaEntry = (PerioadaEntry)result.elementAt(i);
            if (perioadaEntry.getStartTime() != null && perioadaEntry.getStopTime() == null) {
                TipContract tc = this.getTipContractByIdNoCommit(perioadaEntry.getIdTipContract());
                int days = tc.getPerioada();
                Timestamp ts1 = perioadaEntry.getStartTime();
                long l1 = ts1.getTime();
                Date startDate = new Date(l1);
                Date newDate = DateUtils.addDaysToDate(startDate, days);
                Timestamp ts2 = new Timestamp(newDate.getTime());
                if (perioadaEntry.getForcedDays() > 0) {
                    ts2 = new Timestamp(DateUtils.addDaysToDate(startDate, perioadaEntry.getForcedDays()).getTime());
                }
                perioadaEntry.setStopTime(ts2);
                this.updateStopForPerioada(perioadaEntry, ts2);
            }
            if (!perioadaEntry.isPlataPartiala()) continue;
            double totalPlati = this.getDao().getTotalPaymentsForPerioadaContract(perioadaEntry.getId());
            perioadaEntry.setPlataPartialaPayedSum(totalPlati);
            Timestamp start = perioadaEntry.getStartTime();
            if (start == null) continue;
            TipContract tc = this.getTipContractByIdNoCommit(perioadaEntry.getIdTipContract());
            int ipProdus = tc.getIdProdus();
            double totalDePlata = this.priceInterface.getPriceForProductNoCommit(ipProdus);
            int totalZile = tc.getPerioada();
            int zileAcoperite = (int)((double)totalZile * totalPlati / totalDePlata);
            Date payedUntil = DateUtils.addDaysToDate(start, zileAcoperite);
            perioadaEntry.setPayedUntil(new Timestamp(payedUntil.getTime()));
        }
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientByIdAbonament(int idAbonament) {
        try {
            int n = this.getClientByIdAbonamentNoCommit(idAbonament);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private int getClientByIdAbonamentNoCommit(int idAbonament) throws SQLException {
        return this.getDao().getClientByIdAbonament(idAbonament);
    }

    public void setPriceInterface(ProductPriceInterface priceInterface) {
        this.priceInterface = priceInterface;
    }

    private int addClientPersFizica(String nume, String prenume) {
        String phone = "";
        String adresa = "";
        String oras = "";
        String fax = "";
        String mobil = "";
        String email = "";
        String web = "";
        String loculNasterii = "";
        String cetatenie = "";
        String nationalitate = "";
        Date dataNasterii = new Date();
        Date dataNumeului = new Date();
        String groups = "";
        return ClientLogic.getInstance().addPersFizica(nume, prenume, adresa, 1, oras, -1, -1, -1, phone, fax, mobil, email, web, loculNasterii, cetatenie, nationalitate, dataNasterii, null, "", dataNumeului, "", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incarcaTag(String card1, Component parent, int idUser, Vector<Location> locations) {
        try {
            TipContract tipContractTag;
            String s = VpConfig.getInstance().accesIncarcaTagTipAbonament;
            Vector tipContracteS = Utils.splitString(s, ',');
            if (tipContracteS.size() <= 0) {
                DialogUtils.errorDialog(parent, "accesIncarcaTagTipAbonament : necompletat", LangRoAll.nuPotContinua);
                boolean bl = false;
                return bl;
            }
            String tipContractAles = (String)tipContracteS.get(0);
            if (tipContracteS.size() > 1) {
                AbonamentChooser chooser = new AbonamentChooser(4, tipContracteS);
                tipContractAles = (String)chooser.getSelected();
            }
            if ((tipContractTag = this.getDao().getTipContractByName(tipContractAles)) == null) {
                DialogUtils.errorDialog(parent, "accesIncarcaTagTipAbonament : \"" + s + "\" negasit in baza !!", LangRoAll.nuPotContinua);
                boolean bl = false;
                return bl;
            }
            String tip1 = VpConfig.getInstance().accesTipPlataDefault;
            TipPlata tp = TipPlataProvider.getInstance().getTipPlataByNameNoCommit(tip1);
            if (tp == null) {
                DialogUtils.errorDialog(parent, "accesTipPlataDefault \"" + tip1 + "\" negasit in baza !!", LangRoAll.nuPotContinua);
                boolean bl = false;
                return bl;
            }
            if (!Validators.correctString(card1)) {
                DialogUtils.errorDialog(parent, "Card incorect", LangRoAll.nuPotContinua);
                boolean bl = false;
                return bl;
            }
            Product product = NomeclaturaLogic.getInstance().getProductByIdNoCommit(tipContractTag.getIdProdus());
            double suma = RestLogic.getInstance().getPriceForProductNoCommit(product.getId());
            int nrZile = -1;
            StatusContractView existingContract = null;
            Table currentTable = RestLogic.getInstance().getFirstFreeTableNoCommit(locations);
            while (existingContract == null) {
                Vector<StatusContractView> contracte = this.getDao().getContract(card1);
                for (int i = 0; i < contracte.size(); ++i) {
                    StatusContractView scv = contracte.elementAt(i);
                    if (scv.getIdTipContract() != tipContractTag.getId()) continue;
                    existingContract = scv;
                    break;
                }
                if (existingContract != null) continue;
                int idClient = -1;
                ClientPersFizica cpf = ClientLogic.getInstance().getPersFizicaByNameNoCommit(card1);
                idClient = cpf == null ? this.addClientPersFizica(card1, "Piscina") : cpf.getId();
                int idPromotion = -1;
                this.addContractNoCommit(idClient, tipContractTag.getId(), idPromotion, card1, card1, false, nrZile);
            }
            RestLogic.getInstance().printBonFiscalAlimentareContNoCommit(product.getId(), suma, currentTable, idUser, existingContract.getIdClient(), tp, existingContract.getIdPromotie(), null);
            int idPerioadaNoua = ContracteLogic.getInstance().createPerioadaAbonamentNoCommit(existingContract.getId());
            ContractePerioada cp = this.getPerioadaByIdNoCommit(idPerioadaNoua);
            ContracteLogic.getInstance().addPaymentToContractNoCommit(DateUtils.getCurrentTimestamp(), cp, suma);
            ContracteLogic.getInstance().updateContractStatusNoCommit(existingContract);
            String detaliiPlata = "Plata " + existingContract.getNumeContract() + " =" + Utils.getString2Decimals(suma);
            ContracteLogic.getInstance().addCommentNoCommit(Formatters.DATE_AND_TIME_FORMAT.format(new Date()) + ": " + detaliiPlata, existingContract.getIdClient());
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public PlanOrarBean getPlanOrarByExternalIdNoCommit(String extId) throws SQLException {
        return this.getDao().getPlanOrarByExternalId(extId);
    }

    public PlanOrarBean getPlanOrarByIdNoCommit(int id) throws SQLException {
        return this.getDao().getPlanOrarById(id);
    }

    public void addPlanOrarNoCommit(PlanOrarBean planOrarBean) throws SQLException {
        this.getDao().addPlanOrar(planOrarBean);
    }

    public void updatePlanOrarNoCommit(PlanOrarBean planOrarBean) throws SQLException {
        this.getDao().updatePlanOrar(planOrarBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String syncAdvancedControlLogic() {
        try {
            Vector cpf = ClientLogic.getInstance().getAllPersFiziceSorted();
            String lastUpdatedS = Config.getInstance().getStringNoCommit(lastSyncKey);
            Date lastSync = new Date();
            if (Validators.correctDate(lastUpdatedS, Formatters.FULL_TIMESTAMP)) {
                try {
                    lastSync = Formatters.FULL_TIMESTAMP.parse(lastUpdatedS);
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            Hashtable<String, String> planOrarToSync = new Hashtable<String, String>();
            Vector<PlanOrarBean> allPlanOrar = this.getDao().getAllPlanOrar();
            for (PlanOrarBean planOrarBean : allPlanOrar) {
                if (!planOrarBean.getLastModified().after(lastSync)) continue;
                planOrarToSync.put(planOrarBean.getExternalId(), planOrarBean.getOrar());
            }
            if (planOrarToSync.size() > 0) {
                for (ExternalDeviceListener listener : this.listeners) {
                    listener.syncTimezones(planOrarToSync);
                }
            }
            Vector<ClientPersFizica> toSync = new Vector<ClientPersFizica>();
            for (ClientPersFizica persFizica : cpf) {
                if (!persFizica.getLastUpdated().after(lastSync)) continue;
                toSync.add(persFizica);
            }
            Hashtable<String, String> authMap = new Hashtable<String, String>();
            Hashtable<String, ExternalReaderBean> usersMap = new Hashtable<String, ExternalReaderBean>();
            for (ClientPersFizica clientPersFizica : toSync) {
                CardClientBean cardClientBean;
                String card;
                Vector<StatusContractView> contractViews;
                StatusContractView contract;
                Vector<CardClientBean> carduri = this.getCardsForClientNoCommit(clientPersFizica.getId());
                if (carduri.size() == 0 || (contract = (contractViews = this.getStatusContracteByCardNoCommit(card = (cardClientBean = carduri.get(0)).getCard())).get(0)) == null) continue;
                int idTipAbonament = contract.getIdTipContract();
                TipContract tc = this.getTipContractByIdNoCommit(idTipAbonament);
                int idPlanOrar = tc.getIdOrar();
                PlanOrarBean planOrarBean = this.getDao().getPlanOrarById(idPlanOrar);
                String externalId = planOrarBean.getExternalId();
                String pin = clientPersFizica.getExternalId() + "";
                if (!Validators.correctInteger(pin) || pin.equals("0")) {
                    int pinNou = ClientLogic.getInstance().getNextExternalIdPersFizicaNoCommit();
                    clientPersFizica.setExternalId(pinNou);
                    ClientLogic.getInstance().setMExternalId(clientPersFizica.getIdPersFizica(), pinNou);
                    pin = pinNou + "";
                }
                authMap.put(pin, externalId);
                ExternalReaderBean externalReaderBean = new ExternalReaderBean();
                externalReaderBean.setCard(card);
                externalReaderBean.setPin(pin);
                int idAbonament = contract.getId();
                ContractePerioada cp = this.getCurrentPerioadaNoCommit(idAbonament);
                if (cp == null) {
                    externalReaderBean.setStart(DateUtils.addDaysToDate(new Date(), -2));
                    externalReaderBean.setStop(DateUtils.addDaysToDate(new Date(), -1));
                } else {
                    externalReaderBean.setStart(cp.getStart());
                    externalReaderBean.setStop(cp.getStop());
                }
                usersMap.put(pin, externalReaderBean);
            }
            if (usersMap.size() > 0) {
                for (ExternalDeviceListener listener : this.listeners) {
                    listener.syncUsers(usersMap);
                }
            }
            if (authMap.size() > 0) {
                for (ExternalDeviceListener listener : this.listeners) {
                    listener.syncAuth(authMap);
                }
            }
            Config.getInstance().updateValueNoCommit(lastSyncKey, Formatters.FULL_TIMESTAMP.format(new Date()));
            this.pool.commit();
            String string = null;
            return string;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            String string = e.getMessage();
            return string;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importClientiAdvancedControlUtils(String authFile, String expiryDatesFile, String numeFile, String carduriFile, String pictureFolder, Component parent) {
        int digits = Config.getInstance().getInt("codFidelitateLength", 10);
        try {
            Map<String, PlanOrarBean> usersPlanOrar = AdvancedControlUtils.processAuth(new File(authFile), parent);
            Map<String, Date> expiry = AdvancedControlUtils.getExpiryForUsers(new File(expiryDatesFile), parent);
            Map<String, String> names = AdvancedControlUtils.getUsersNames(new File(numeFile));
            Map<String, String> carduri = AdvancedControlUtils.getUsersCards(new File(carduriFile), digits);
            for (String pin : usersPlanOrar.keySet()) {
                PlanOrarBean planOrarBean = usersPlanOrar.get(pin);
                Date dezactivare = expiry.get(pin);
                String name = names.get(pin);
                String clientCard = carduri.get(pin);
                String pictureFile = pictureFolder + File.separator + clientCard + ".jpg";
                if (!new File(pictureFile).exists()) {
                    Logger.logDebug(this, "Picture missing at pin : " + pin + " card : " + clientCard);
                    pictureFile = null;
                }
                int idClientNew = ClientLogic.getInstance().addPersFizicaNoCommit(name, "", "", 1, "", -1, -1, -1, "", "", "", "", "", "", "", "", new Date(), pictureFile, new Date(), "");
                ClientLogic.getInstance().updateGroupsForPartnerNoCommit(idClientNew, "2");
                ClientPersFizica cpf = (ClientPersFizica)ClientLogic.getInstance().getClientByIdNoCommit(idClientNew);
                ClientLogic.getInstance().setMExternalId(cpf.getIdPersFizica(), Integer.parseInt(pin));
                Vector<TipContract> tpPosibile = ContracteLogic.getInstance().getTipContractByPlanOrarNoCommit(planOrarBean.getId());
                TipContract tipContractTag = null;
                if (tpPosibile.size() > 0) {
                    tipContractTag = tpPosibile.get(0);
                }
                if (tipContractTag == null) {
                    DialogUtils.errorDialog(parent, "Tip Abonament negasit pentru plan orar : " + planOrarBean.getExternalId() + " " + planOrarBean.getLabel(), LangRoAll.nuPotContinua);
                }
                int idAbonament = ContracteLogic.getInstance().addContractNoCommit(idClientNew, tipContractTag.getId(), -1, clientCard, clientCard, false, -1);
                if (pin.startsWith("747")) {
                    System.out.println("Found 747");
                }
                int idPerioada = ContracteLogic.getInstance().createPerioadaAbonamentNoCommit(idAbonament);
                ContracteLogic.getInstance().updateStopForPerioadaNoCommit(idPerioada, new Timestamp(dezactivare.getTime()));
                if (dezactivare.before(DateUtils.getCurrentTimestamp())) {
                    ContracteLogic.getInstance().dezactiveazaPerioadaNoCommit(idPerioada);
                    Logger.logDebug(this, "Perioada dezactivata : " + pin + " card : " + clientCard + " stop = " + Formatters.DATE_FORMAT_RO.format(dezactivare));
                } else {
                    ContracteLogic.getInstance().activeazaPerioadaNoCommit(idPerioada);
                    Logger.logDebug(this, "Perioada ACTIVA : " + pin + " card : " + clientCard + " stop = " + Formatters.DATE_FORMAT_RO.format(dezactivare));
                }
                StatusContractView scv = this.getStatusContracteByCardNoCommit(clientCard).get(0);
                this.updateContractStatusNoCommit(scv);
            }
            Config.getInstance().updateValueNoCommit(lastSyncKey, Formatters.FULL_TIMESTAMP.format(new Date()));
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prelungesteContract(StatusContractView scv, int idUser, Table table, Component panel) {
        boolean somethingToDo = true;
        boolean createPerioadaNoua = true;
        try {
            TipPlata tp = null;
            Vector<TipPlata> tipuriPlata = TipPlataProvider.getInstance().getTipPlataNoCommit();
            if (tipuriPlata.size() > 0) {
                TipPlataChooser tpc = new TipPlataChooser(4, tipuriPlata);
                tp = tpc.getSelected();
            }
            if (tp == null) {
                DialogUtils.errorDialog(panel, "Tip de plata nesetat. Plata neefectuata.", LangRoAll.nuPotContinua);
                somethingToDo = false;
            }
            if (somethingToDo) {
                TipContract tc = ContracteLogic.getInstance().getTipContractByIdNoCommit(scv.getIdTipContract());
                int ipProdus = tc.getIdProdus();
                double suma = RestLogic.getInstance().getPriceForProductNoCommit(ipProdus);
                ContractePerioada cp = null;
                double dePlata = 0.0;
                String detaliiPlata = "";
                if (scv.isPlataPartiala()) {
                    double rata;
                    dePlata = rata = suma * (double)scv.getNrZilePlataPartiala() / (double)tc.getPerioada();
                    Vector<ContractePerioada> perioadePtAbonament = ContracteLogic.getInstance().getAllPerioadeActiveForAbonamentNoCommit(scv.getId());
                    if (perioadePtAbonament.size() > 0) {
                        boolean gasitPerioadaIncompleta = false;
                        for (int i = 0; i < perioadePtAbonament.size(); ++i) {
                            cp = perioadePtAbonament.elementAt(i);
                            double totalPlatit = ContracteLogic.getInstance().getTotalPaymentsForPerioadaContractNoCommit(cp.getId());
                            if (!(suma > totalPlatit)) continue;
                            dePlata = suma - totalPlatit;
                            if (dePlata >= 2.0 * rata) {
                                dePlata = rata;
                            }
                            gasitPerioadaIncompleta = true;
                            break;
                        }
                        if (gasitPerioadaIncompleta) {
                            createPerioadaNoua = false;
                        } else if (DialogUtils.confirmDialog(panel, "Platim in avans", LangRoAll.confirmare)) {
                            dePlata = rata;
                        } else {
                            somethingToDo = false;
                        }
                    } else {
                        dePlata = rata;
                    }
                    if (somethingToDo) {
                        String s = DialogUtils.inputDialog(panel, Utils.getString2Decimals(dePlata), "Introduceti suma de plata");
                        if (!Validators.correctDouble(s)) {
                            DialogUtils.errorDialog(panel, "Valoarea trebuie sa fie un numar", LangRoAll.nuPotContinua);
                            somethingToDo = false;
                        }
                        dePlata = Utils.parseDouble(s);
                        detaliiPlata = "Plata " + scv.getNumeContract() + " =" + Utils.getString2Decimals(dePlata);
                    }
                } else {
                    dePlata = suma;
                    detaliiPlata = "Plata " + scv.getNumeContract() + " =" + Utils.getString2Decimals(dePlata);
                }
                if (somethingToDo) {
                    detaliiPlata = detaliiPlata + " Plata prin: " + tp.getLabel();
                    RestLogic.getInstance().printBonFiscalAlimentareContNoCommit(ipProdus, dePlata, table, idUser, scv.getIdClient(), tp, scv.getIdPromotie(), null);
                    ClientLogic.getInstance().setLastUpdatedForClientNoCommit(scv.getIdClient());
                    if (createPerioadaNoua) {
                        int idPerioadaNoua = ContracteLogic.getInstance().createPerioadaAbonamentNoCommit(scv.getId());
                        cp = ContracteLogic.getInstance().getPerioadaByIdNoCommit(idPerioadaNoua);
                    }
                    ContracteLogic.getInstance().addPaymentToContractNoCommit(DateUtils.getCurrentTimestamp(), cp, dePlata);
                    ContracteLogic.getInstance().updateContractStatusNoCommit(scv);
                    ContracteLogic.getInstance().addCommentNoCommit(Formatters.DATE_AND_TIME_FORMAT.format(new Date()) + ": " + detaliiPlata, scv.getIdClient());
                }
            }
            this.pool.commit();
            boolean bl = somethingToDo;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }
}

