/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.acces.contracte;

import java.sql.Timestamp;
import ro.atreides.utils.DateUtils;

public class StatusContractView
implements Comparable {
    private int id;
    private int idTipContract;
    private int idClient;
    private int status;
    private int period;
    private int idPromotie = -1;
    private int nrSedinte;
    private int nrZilePlataPartiala;
    private String numeContract;
    private String card;
    private String cardTemporar;
    private String numeStatus;
    private String promotie;
    private String numeClient;
    private String vechime;
    private Timestamp lastPayment;
    private Timestamp addDate;
    private boolean plataPartiala;

    public int getNrZilePlataPartiala() {
        return this.nrZilePlataPartiala;
    }

    public void setNrZilePlataPartiala(int nrZilePlataPartiala) {
        this.nrZilePlataPartiala = nrZilePlataPartiala;
    }

    public boolean isPlataPartiala() {
        return this.plataPartiala;
    }

    public void setPlataPartiala(boolean plataPartiala) {
        this.plataPartiala = plataPartiala;
    }

    public int getNrSedinte() {
        return this.nrSedinte;
    }

    public void setNrSedinte(int nrSedinte) {
        this.nrSedinte = nrSedinte;
    }

    public String getNumeClient() {
        return this.numeClient;
    }

    public void setNumeClient(String numeClient) {
        this.numeClient = numeClient;
    }

    public String getPromotie() {
        return this.promotie;
    }

    public void setPromotie(String promotie) {
        this.promotie = promotie;
    }

    public int getIdPromotie() {
        return this.idPromotie;
    }

    public void setIdPromotie(int idPromotie) {
        this.idPromotie = idPromotie;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public void setLastPayment(Timestamp lastPayment) {
        this.lastPayment = lastPayment;
    }

    public Timestamp getLastPayment() {
        return this.lastPayment;
    }

    public void setAddDate(Timestamp addDate) {
        this.addDate = addDate;
    }

    public String getVechime() {
        return this.vechime;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getCardTemporar() {
        return this.cardTemporar;
    }

    public void setCardTemporar(String cardTemporar) {
        this.cardTemporar = cardTemporar;
    }

    public String getNumeStatus() {
        return this.numeStatus;
    }

    public String getCard() {
        return this.card;
    }

    public void setCard(String card) {
        this.card = card;
    }

    public int getIdClient() {
        return this.idClient;
    }

    public void setIdClient(int idClient) {
        this.idClient = idClient;
    }

    public int getIdTipContract() {
        return this.idTipContract;
    }

    public void setIdTipContract(int idTipContract) {
        this.idTipContract = idTipContract;
    }

    public String getNumeContract() {
        return this.numeContract;
    }

    public void setNumeContract(String numeContract) {
        this.numeContract = numeContract;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void compute() {
        switch (this.status) {
            case 1: {
                this.numeStatus = "ACTIV";
                break;
            }
            case 2: {
                this.numeStatus = "RENEW";
                break;
            }
            case 3: {
                this.numeStatus = "GRACED";
                break;
            }
            case 4: {
                this.numeStatus = "SUSPENDAT";
            }
        }
        long now = System.currentTimeMillis();
        long add = this.addDate.getTime();
        this.vechime = DateUtils.getDiferentaIntreOre(add, now);
    }

    public int compareTo(Object o) {
        int result = 0;
        StatusContractView scv = (StatusContractView)o;
        if (this.numeClient != null && scv.getNumeClient() != null) {
            result = this.numeClient.compareToIgnoreCase(scv.getNumeClient());
        }
        if (result != 0) {
            return result;
        }
        result = this.numeContract.compareToIgnoreCase(scv.getNumeContract());
        if (result != 0) {
            return result;
        }
        result = this.promotie.compareToIgnoreCase(scv.getPromotie());
        if (result != 0) {
            return result;
        }
        result = this.card.compareToIgnoreCase(scv.getCard());
        if (result != 0) {
            return result;
        }
        if (this.cardTemporar != null && scv.getCardTemporar() != null) {
            result = this.cardTemporar.compareToIgnoreCase(scv.getCardTemporar());
        }
        if (result != 0) {
            return result;
        }
        return this.id - scv.getId();
    }

    public String toString() {
        return this.getNumeContract();
    }
}

