/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.acces.soyal;

import java.io.IOException;
import java.io.InputStream;
import ro.atreides.utils.Utils;

public class SoyalUtils {
    public static byte[] readMessage(InputStream in) throws IOException {
        int size = 0;
        while (true) {
            int byteRead;
            if ((byteRead = in.read()) > 0) {
                if (byteRead != 126) continue;
                size = in.read();
                if (size > 0) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        byte[] buf = new byte[size + 2];
        buf[0] = 126;
        buf[1] = (byte)size;
        for (int i = 0; i < size; ++i) {
            int r = in.read();
            buf[i + 2] = (byte)r;
        }
        return buf;
    }

    public static byte[] getBytes(short[] shorts) {
        byte[] result = new byte[shorts.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(shorts[i] % 256);
        }
        return result;
    }

    public static short[] getLastEventLogMessage(int deviceId) {
        short[] r1 = new short[255];
        r1[0] = 37;
        r1[1] = 219;
        return SoyalUtils.wrapData(r1, deviceId, 2);
    }

    public static short[] enterOnlineMode(int deviceId) {
        short[] r1 = new short[255];
        r1[0] = 24;
        return SoyalUtils.wrapData(r1, deviceId, 1);
    }

    public static short[] getAuthOK(int deviceId) {
        short[] r1 = new short[255];
        r1[0] = 4;
        return SoyalUtils.wrapData(r1, deviceId, 1);
    }

    public static short[] getEraseEventLog(int deviceId) {
        short[] r1 = new short[255];
        r1[0] = 45;
        return SoyalUtils.wrapData(r1, deviceId, 1);
    }

    public static short[] getAuthFailed(int deviceId) {
        short[] r1 = new short[255];
        r1[0] = 5;
        return SoyalUtils.wrapData(r1, deviceId, 1);
    }

    public static short[] buildMessageFromReader(int deviceId) {
        short[] r1 = new short[]{11, 1, 49, 49, 22, 1, 31, 8, 8, 1, 0, 1, 0, 0, 24, 0, 0, 64, 1, 128, 84, 99, 18, 52, 86, 120};
        return SoyalUtils.wrapData(r1, deviceId, 26);
    }

    public static short[] wrapData(short[] data, int deviceId, int dataSize) {
        short sum;
        short xor;
        short[] result = new short[dataSize + 5];
        result[0] = 126;
        result[1] = (short)(dataSize + 3);
        result[2] = (short)deviceId;
        System.arraycopy(data, 0, result, 3, dataSize);
        result[result.length - 2] = xor = SoyalUtils.computeXOR(result, 2, result.length - 2);
        result[result.length - 1] = sum = SoyalUtils.computeSUM(result, 2, result.length - 1);
        return result;
    }

    public static short computeXOR(short[] data, int startIndex, int stopIndex) {
        short result = 255;
        for (int i = startIndex; i < stopIndex; ++i) {
            short d = data[i];
            result = (short)(result ^ d);
        }
        result = (short)(result % 256);
        return result;
    }

    public static short computeSUM(short[] data, int startIndex, int stopIndex) {
        short result = 0;
        for (int i = startIndex; i < stopIndex; ++i) {
            result = (short)(result + data[i]);
        }
        result = (short)(result % 256);
        return result;
    }

    public static boolean verifySUM(short[] data) {
        short declaredSUM = data[data.length - 1];
        short computedSUM = SoyalUtils.computeSUM(data, 2, data.length - 1);
        return declaredSUM == computedSUM;
    }

    public static short[] getShortArray(byte[] data) {
        short[] result = new short[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = data[i];
            if (result[i] >= 0) continue;
            int n = i;
            result[n] = (short)(result[n] + 256);
        }
        return result;
    }

    public static boolean verifyXOR(short[] data) {
        short declaredXOR = data[data.length - 2];
        short computedXOR = SoyalUtils.computeXOR(data, 2, data.length - 2);
        return declaredXOR == computedXOR;
    }

    public static String getCardNumberOnline(short[] data) {
        short siteHi = data[7];
        short siteLo = data[8];
        short cardHi = data[11];
        short cardLo = data[12];
        String site = siteHi * 256 + siteLo + "";
        site = Utils.getStringMaxSize(3, site, Character.valueOf('0'), true);
        String card = cardHi * 256 + cardLo + "";
        card = Utils.getStringMaxSize(5, card, Character.valueOf('0'), true);
        return site + "_" + card;
    }

    public static boolean isCardOnlineRead(short[] data) {
        return data[5] == 2;
    }

    public static boolean isCardOnlineResponse(short[] data) {
        return data[3] == 9;
    }

    public static int getOnlineReader(short[] data) {
        System.out.println("Get Online Reader " + data[4]);
        return data[4];
    }

    public static int getOnlineReaderExt(short[] data) {
        short readerInt = data[data.length - 3];
        System.out.println("Get Online Ext : data.legth = " + data.length + " ext : " + readerInt);
        return readerInt;
    }
}

