/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.clienti.AltAct;
import ro.atreides.clienti.BiCi;
import ro.atreides.clienti.ClientFilterInterface;
import ro.atreides.clienti.ClientFollowupReportEntry;
import ro.atreides.clienti.ClientIcon;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.ClientsLocationsBean;
import ro.atreides.clienti.CnpVerificationDummyImpl;
import ro.atreides.clienti.CnpVerificationInterface;
import ro.atreides.clienti.ContinentalAngajatiImportBean;
import ro.atreides.clienti.DataContactPFWarningDefaultImpl;
import ro.atreides.clienti.DataContactPJWarningDefaultImpl;
import ro.atreides.clienti.DateContactGrabber;
import ro.atreides.clienti.DateContactWarningInterface;
import ro.atreides.clienti.FisaCentralizator;
import ro.atreides.clienti.FisaClient;
import ro.atreides.clienti.PartenerGroup;
import ro.atreides.clienti.PersFizicaViewEntry;
import ro.atreides.clienti.PersJuridicaViewEntry;
import ro.atreides.clienti.ValoareContClient;
import ro.atreides.clienti.db.ClientiDao;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.promo.gui.PromotiiDialog;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.TranzactieContClient;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.servletsms.SmsServletBean;
import ro.atreides.users.User;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Country;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.MailUtils;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.documente.DocumenteLogic;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.multilanguage.LanguageLogic;
import ro.atreides.utils.myUtils.SwingPrintUtilities;
import ro.atreides.utils.plati.ConturiInterface;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class ClientLogic
extends EventGenerator
implements ConturiInterface {
    private static ClientLogic instance;
    private ConnectionPool pool;
    public static final String VAL_INCARCARE = "Val incarcare";
    public static final int FURNIZORI_GROUP_ID = 1;
    public static final int CLIENTI_GROUP_ID = 2;
    public static final int DELEGATI_GROUP_ID = 4;
    public static final String CLIENTI_GROUPS_KEY = "Grupuri";
    public static final String GROUPS_SOCIETATI_PROPRII_KEY = "pers_juridice_groups_societatiproprii";
    public static final int CLIENT_PICTURE_DX = 320;
    public static final int CLIENT_PICTURE_DY = 240;
    private boolean refreshPersJuridice = true;
    private boolean refreshPersFizice = true;
    private Vector<Client> allClients = new Vector();
    private Vector<ClientPersJuridica> allPersJuridiceSorted = new Vector();
    private Vector<ClientPersFizica> allPersFiziceSorted = new Vector();
    private Hashtable<Integer, Client> clientsHash = new Hashtable();
    private DateContactWarningInterface dateContactPJWarningImpl;
    private DateContactWarningInterface dateContactPFWarningImpl;
    private CnpVerificationInterface cnpVerificationInterface;
    private ClientFilterInterface clientFilterInterface;

    private ClientLogic() {
        this.pool = ConnectionPool.getInstance();
        this.dateContactPJWarningImpl = new DataContactPJWarningDefaultImpl();
        this.dateContactPFWarningImpl = new DataContactPFWarningDefaultImpl();
        String cnpValidationClass = Config.getInstance().getString("clientCnpVerificationClass", "ro.atreides.clienti.CnpVerificationRealImpl");
        try {
            this.cnpVerificationInterface = (CnpVerificationInterface)Class.forName(cnpValidationClass).newInstance();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            Logger.logError((Object)this, "CNP validation disabled");
            this.cnpVerificationInterface = new CnpVerificationDummyImpl();
        }
        String clientFilterS = Config.getInstance().getString("clientFilterClassname");
        if (Validators.correctString(clientFilterS)) {
            try {
                this.clientFilterInterface = (ClientFilterInterface)Class.forName(clientFilterS).newInstance();
            }
            catch (Exception e) {
                Logger.logException(this, e);
                Logger.logError((Object)this, "Client Filter disabled");
            }
        }
    }

    public DateContactWarningInterface getDateContactPFWarningImpl() {
        return this.dateContactPFWarningImpl;
    }

    public void setDateContactPFWarningImpl(DateContactWarningInterface dateContactPFWarningImpl) {
        this.dateContactPFWarningImpl = dateContactPFWarningImpl;
    }

    public DateContactWarningInterface getDateContactPJWarningImpl() {
        return this.dateContactPJWarningImpl;
    }

    public void setDateContactPJWarningImpl(DateContactWarningInterface dateContactPJWarningImpl) {
        this.dateContactPJWarningImpl = dateContactPJWarningImpl;
    }

    private synchronized ClientiDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        ClientiDao dao = null;
        while (dao == null) {
            dao = (ClientiDao)this.pool.getDao(ClientiDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(ClientiDao.class.getName(), connection);
        }
        return dao;
    }

    public static synchronized ClientLogic getInstance() {
        if (instance == null) {
            instance = new ClientLogic();
        }
        return instance;
    }

    public BiCi getBiCiByIdNoCommit(int id) throws SQLException {
        BiCi result = this.getDao().getBiCiById(id);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BiCi getBiCiById(int id) {
        try {
            BiCi result = this.getBiCiByIdNoCommit(id);
            this.pool.commit();
            BiCi biCi = result;
            return biCi;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            BiCi biCi = null;
            return biCi;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public AltAct getPassportByIdNoCommit(int id) throws SQLException {
        AltAct result = this.getDao().getAltActById(id);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AltAct getPassportById(int id) {
        try {
            AltAct result;
            AltAct altAct = result = this.getPassportByIdNoCommit(id);
            return altAct;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            AltAct altAct = null;
            return altAct;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePersFizicaLocally(ClientPersFizica client, String pictureFile, String grupuri) {
        try {
            this.savePersFizicaNoCommit(client, pictureFile, grupuri);
            this.refreshPersFizice = true;
            this.syncClientNoCommit(client);
            this.pool.commit();
            this.notifyListeners(41);
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public int getNextExternalIdPersFizicaNoCommit() throws SQLException {
        return this.getDao().getMaxExternalIdForPersFizica() + 1;
    }

    public void setMExternalId(int idPersFIzica, int externalId) throws SQLException {
        this.getDao().updateExternalIdForPersFizica(idPersFIzica, externalId);
    }

    public void savePersFizicaNoCommitNoNotify(ClientPersFizica client) throws SQLException {
        this.getDao().updatePersFizice(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePersFizicaLocallyNoNotify(ClientPersFizica client) {
        try {
            this.savePersFizicaNoCommitNoNotify(client);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void savePersFizicaNoCommit(ClientPersFizica client, String pictureFile, String grupuri) throws SQLException, FileNotFoundException {
        this.savePersFizicaNoCommitNoNotify(client);
        if (pictureFile != null) {
            File f = new File(pictureFile);
            int size = (int)f.length();
            FileInputStream fin = new FileInputStream(pictureFile);
            int idFile = DocumenteLogic.getInstance().addFileNoCommit(pictureFile, "", pictureFile, "", fin, size);
            this.getDao().updatePersFizicaPicture(client.getIdPersFizica(), idFile);
        }
        if (grupuri != null) {
            this.updateGroupsForPartnerNoCommit(client.getId(), grupuri);
        }
    }

    public void syncClientNoCommit(Client client) throws SQLException {
        if (client != null) {
            this.getDao().syncClient(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addBuletinLocally(String seria, String cnp, String nr, String sectia, Date eliberat, Date expira) {
        try {
            int idBuletin = this.getDao().addBiCi(seria, cnp, nr, sectia, eliberat, expira);
            this.pool.commit();
            int n = idBuletin;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addBuletinImported(String seria, String cnp, String nr, String sectia, Date eliberat, Date expira, String codSync) {
        try {
            int idBuletin = this.getDao().addBiCi(seria, cnp, nr, sectia, eliberat, expira);
            this.getDao().setCodSyncToBuletin(codSync, idBuletin);
            this.pool.commit();
            int n = idBuletin;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPasaportLocally(String seria, Date eliberat, Date expira, String tipAct) {
        try {
            int idPassport = this.getDao().addPassport(seria, eliberat, expira, tipAct);
            this.pool.commit();
            int n = idPassport;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPasaportImported(String seria, Date eliberat, Date expira, String tipAct, String codSync) {
        try {
            int idPassport = this.getDao().addPassport(seria, eliberat, expira, tipAct);
            this.getDao().setCodSyncToPasaport(codSync, idPassport);
            this.pool.commit();
            int n = idPassport;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBiCiLocally(BiCi toSave) {
        try {
            this.getDao().updateBiCi(toSave);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePasaportLocally(AltAct toSave) {
        try {
            this.getDao().updatePassport(toSave);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public int addPersFizicaNoCommit(String nume, String prenume, String adresa, int idTara, String oras, int idBi, int idPassport, int idPersJuridica, String telefonFix, String fax, String telefonMobil, String email, String paginaWeb, String loculNasterii, String cetatenie, String nationalitate, Date dataNasterii, String pictureFile, Date dataNumelui, String observatii) throws SQLException, IOException {
        ClientPersFizica pf = new ClientPersFizica(-1, -1, idBi, idPassport, nume, prenume, oras, adresa, idTara, idPersJuridica, telefonFix, fax, telefonMobil, email, paginaWeb, loculNasterii, cetatenie, nationalitate, dataNasterii, DateUtils.getCurrentTimestamp());
        pf.setDataNumelui(dataNumelui);
        pf.setObservatii(observatii);
        int idPersFizica = this.getDao().addClientPersFizica(pf);
        int idClient = this.getDao().addClient(-1, idPersFizica);
        if (pictureFile != null) {
            File f = new File(pictureFile);
            int size = (int)f.length();
            FileInputStream fin = new FileInputStream(pictureFile);
            int idFile = DocumenteLogic.getInstance().addFileNoCommit(pictureFile, "", pictureFile, "", fin, size);
            this.getDao().updatePersFizicaPicture(idPersFizica, idFile);
        }
        return idClient;
    }

    public int addPersFizicaShort(ClientPersFizica c, String groups, boolean mustSync) {
        return this.addPersFizica(c.getLastname(), c.getFirstname(), c.getAddress1(), c.getIdCountry(), c.getCity(), c.getIdBuletin(), c.getIdPassport(), c.getIdPersJuridica(), c.getTelefonFix(), c.getFax(), c.getTelefonMobil(), c.getEmail(), c.getPaginaWeb(), c.getLoculNasterii(), c.getCetatenie(), c.getNationalitate(), c.getDataNasterii(), null, groups, c.getDataNumelui(), c.getObservatii(), mustSync);
    }

    public int addPersFizicaShortNoCommit(ClientPersFizica c, String groups) throws SQLException, IOException {
        int idClient = this.addPersFizicaNoCommit(c.getLastname(), c.getFirstname(), c.getAddress1(), c.getIdCountry(), c.getCity(), c.getIdBuletin(), c.getIdPassport(), c.getIdPersJuridica(), c.getTelefonFix(), c.getFax(), c.getTelefonMobil(), c.getEmail(), c.getPaginaWeb(), c.getLoculNasterii(), c.getCetatenie(), c.getNationalitate(), c.getDataNasterii(), null, c.getDataNumelui(), c.getObservatii());
        this.updateGroupsForPartnerNoCommit(idClient, groups);
        return idClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPersFizica(String nume, String prenume, String adresa, int idTara, String oras, int idBi, int idPassport, int idPersJuridica, String telefonFix, String fax, String telefonMobil, String email, String paginaWeb, String loculNasterii, String cetatenie, String nationalitate, Date dataNasterii, String pictureFile, String grupuri, Date dataNumelui, String observatii, boolean mustSync) {
        try {
            int idClient = this.addPersFizicaNoCommit(nume, prenume, adresa, idTara, oras, idBi, idPassport, idPersJuridica, telefonFix, fax, telefonMobil, email, paginaWeb, loculNasterii, cetatenie, nationalitate, dataNasterii, pictureFile, dataNumelui, observatii);
            this.updateGroupsForPartnerNoCommit(idClient, grupuri);
            if (mustSync) {
                Client newClient = this.getClientByIdNoCommit(idClient);
                this.syncClientNoCommit(newClient);
            }
            if (this.clientFilterInterface != null) {
                this.clientFilterInterface.afterAddClientCommit(idClient);
            }
            this.pool.commit();
            this.refreshPersFizice = true;
            this.notifyListeners(41);
            int newClient = idClient;
            return newClient;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erasePersFizicaLocally(ClientPersFizica client) {
        try {
            this.erasePersFizicaNoCommit(client);
            this.pool.commit();
            this.refreshPersFizice = true;
            this.notifyListeners(41);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void erasePersFizicaNoCommit(ClientPersFizica client) throws SQLException {
        this.getDao().deleteBiCi(client.getIdBuletin());
        this.getDao().deletePassport(client.getIdPassport());
        this.getDao().deleteClientPersFizica(client.getIdPersFizica());
    }

    public ClientPersFizica getPersFizicaByIdNoCommit(int id) throws SQLException {
        ClientPersFizica result = this.getDao().getPersFizicaById(id);
        return result;
    }

    public ClientPersFizica getPersFizicaByFaxNoCommit(String id) throws SQLException {
        ClientPersFizica result = this.getDao().getPersFizicaByFax(id);
        return result;
    }

    public ClientPersFizica getPersFizicaByNameNoCommit(String name) throws SQLException {
        ClientPersFizica result = this.getDao().getPersFizicaByName(name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientPersFizica getPersFizicaById(int id) {
        try {
            ClientPersFizica clientPersFizica = this.getPersFizicaByIdNoCommit(id);
            return clientPersFizica;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            ClientPersFizica clientPersFizica = null;
            return clientPersFizica;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Client getClientByIdNoCommit(int id) throws SQLException {
        int idPersJuridica;
        Client result = null;
        int idPersFizica = this.getDao().getIdPersFizica(id);
        result = idPersFizica != -1 ? this.getPersFizicaByIdNoCommit(idPersFizica) : ((idPersJuridica = this.getDao().getIdPersJuridica(id)) != -1 ? this.getPersJuridicaByIdNoCommit(idPersJuridica) : null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getClientById(int id) {
        try {
            Client result;
            Client client = result = this.getClientByIdNoCommit(id);
            return client;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Client client = null;
            return client;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector getPersFiziceViewEntry(String numeFilter, String adresaFilter, String cnpFilter) {
        String numeFilterLowerCase = "";
        if (Validators.correctString(numeFilter)) {
            numeFilterLowerCase = numeFilter.toLowerCase();
        }
        String adresaFilterLowerCase = "";
        if (Validators.correctString(adresaFilter)) {
            adresaFilterLowerCase = adresaFilter.toLowerCase();
        }
        Vector<PersFizicaViewEntry> result = new Vector<PersFizicaViewEntry>();
        Vector allPersFizice = this.getAllPersFiziceSorted();
        for (ClientPersFizica element : allPersFizice) {
            boolean accept = true;
            if (Validators.correctString(cnpFilter)) {
                int idBuletin = element.getIdBuletin();
                if (idBuletin > 0) {
                    BiCi buletin = ClientLogic.getInstance().getBiCiById(idBuletin);
                    if (!buletin.getCnp().contains(cnpFilter)) {
                        accept = false;
                    }
                } else {
                    accept = false;
                }
            }
            if (Validators.correctString(numeFilterLowerCase) && !element.getFullNameLowerCase().contains(numeFilterLowerCase)) {
                accept = false;
            }
            if (Validators.correctString(adresaFilterLowerCase)) {
                String adresa = element.getAddress1().toLowerCase();
                String oras = element.getCity().toLowerCase();
                if (!adresa.contains(adresaFilterLowerCase) && !oras.contains(adresaFilterLowerCase)) {
                    accept = false;
                }
            }
            if (!accept) continue;
            PersFizicaViewEntry ve = this.getPersFizicaViewEntry(element);
            result.add(ve);
        }
        return result;
    }

    public PersFizicaViewEntry getPersFizicaViewEntry(ClientPersFizica element) {
        BiCi bici;
        PersFizicaViewEntry ve = new PersFizicaViewEntry();
        ve.setNume(element.getLastname());
        ve.setPrenuma(element.getFirstname());
        ve.setAdresa(element.getCity() + " " + element.getAddress1());
        String act = "";
        if (element.getIdBuletin() != -1 && (bici = this.getBiCiById(element.getIdBuletin())) != null) {
            act = act + "CI " + bici.getSeria() + " " + bici.getNumarul() + " ";
        }
        if (element.getIdPassport() != -1) {
            AltAct pass = this.getPassportById(element.getIdPassport());
            act = act + "Pasaport " + pass.getSeria();
        }
        ve.setAct(act);
        ve.setPersFizicaId(element.getIdPersFizica());
        ve.setClientObject(element);
        return ve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erasePersJuridicaLocally(ClientPersJuridica client) {
        try {
            this.erasePersJuridicaNoCommit(client);
            this.syncClientNoCommit(client);
            this.pool.commit();
            this.refreshPersJuridice = true;
            this.notifyListeners(42);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void erasePersJuridicaNoCommit(ClientPersJuridica client) throws SQLException {
        this.getDao().deleteClientPersJuridica(client.getIdPersJuridica());
    }

    public void savePersJuridicaShortNoCommitNoGroups(ClientPersJuridica client) throws SQLException {
        this.getDao().updatePersJuridica(client);
    }

    public void savePersJuridicaShortNoCommit(ClientPersJuridica client, String groups) throws SQLException {
        this.savePersJuridicaShortNoCommitNoGroups(client);
        this.updateGroupsForPartnerNoCommit(client.getId(), groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePersJuridica(ClientPersJuridica client, String nume, String cui, String j, String banca, String iban, String address, String city, int countryId, String punctDeLucru, String telefonFix, String fax, String telefonMobil, String email, String paginaWeb, String persoanaContact, double garantie, int idAgent, String observatii, int zileScadenta, double credit, String groups, String codFurnizor, String analiticFurnizor, String codClient, String analiticClient, String alias) {
        try {
            client.setCompanyName(nume);
            client.setCui(cui);
            client.setJ(j);
            client.setBank(banca);
            client.setBankIban(iban);
            client.setAddress1(address);
            client.setCity(city);
            client.setIdCountry(countryId);
            client.setPunctDeLucru(punctDeLucru);
            client.setTelefonFix(telefonFix);
            client.setFax(fax);
            client.setTelefonMobil(telefonMobil);
            client.setEmail(email);
            client.setPaginaWeb(paginaWeb);
            client.setPersoanaContact(persoanaContact);
            client.setGarantie(garantie);
            client.setIdAgent(idAgent);
            client.setObservatii(observatii);
            client.setNrZileScadenta(zileScadenta);
            client.setCredit(credit);
            client.setCodClient(codClient);
            client.setCodFurnizor(codFurnizor);
            client.setAnaliticClient(analiticClient);
            client.setAnaliticFurnizor(analiticFurnizor);
            client.setAlias(alias);
            this.getDao().updatePersJuridica(client);
            this.updateGroupsForPartnerNoCommit(client.getId(), groups);
            this.pool.commit();
            this.refreshPersJuridice = true;
            this.notifyListeners(42);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Vector getClientiPersJuridice() {
        Vector<Client> result = new Vector<Client>();
        Vector<Client> allClients = ClientLogic.getInstance().getPartnersInGroup(2, 1);
        for (int i = 0; i < allClients.size(); ++i) {
            Client client1 = allClients.elementAt(i);
            if (!(client1 instanceof ClientPersJuridica)) continue;
            result.add(client1);
        }
        return result;
    }

    public Vector getClientiPersFizice() {
        Vector<Client> result = new Vector<Client>();
        Vector<Client> allClients = ClientLogic.getInstance().getPartnersInGroup(2, 1);
        for (int i = 0; i < allClients.size(); ++i) {
            Client client1 = allClients.elementAt(i);
            if (!(client1 instanceof ClientPersFizica)) continue;
            result.add(client1);
        }
        return result;
    }

    public Vector getPersJuridiceViewEntry(Hashtable criteria) {
        Vector<PersJuridicaViewEntry> result = new Vector<PersJuridicaViewEntry>();
        Vector<ClientPersJuridica> allPersJuridice = this.getAllPersJuridiceSorted();
        String groupIds = (String)criteria.get(CLIENTI_GROUPS_KEY);
        if (groupIds == null) {
            groupIds = "";
        }
        Hashtable<Integer, Vector<PartenerGroup>> grupuri = this.getGroupsForPartnerAsHash(-1);
        Hashtable<Integer, Country> countries = LanguageLogic.getInstance().getAllCountriesAsHash();
        for (ClientPersJuridica element : allPersJuridice) {
            Vector<PartenerGroup> groups = grupuri.get(element.getId());
            boolean found = false;
            if (groups != null) {
                for (int i = 0; i < groups.size() && !found; ++i) {
                    PartenerGroup partenerGroup = groups.elementAt(i);
                    int idGrup = partenerGroup.getId();
                    if (!Utils.findInt(idGrup, groupIds, ',')) continue;
                    found = true;
                }
            }
            if (!found && Validators.correctString(groupIds)) continue;
            PersJuridicaViewEntry ve = new PersJuridicaViewEntry();
            ve.setClientObject(element);
            ve.setSocietate(element.getCompanyName());
            ve.setAdresa(element.getAddress1());
            ve.setBanca(element.getBank());
            ve.setIban(element.getBankIban());
            ve.setOras(element.getCity());
            Country c = countries.get(element.getIdCountry());
            ve.setTara(c.getName());
            ve.setCui(element.getCui());
            ve.setId(element.getIdPersJuridica());
            ve.setAlias(element.getAlias());
            result.add(ve);
        }
        return result;
    }

    public ClientPersJuridica getPersJuridicaByIdNoCommit(int id) throws SQLException {
        ClientPersJuridica result = this.getDao().getPersJuridicaById(id);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientPersJuridica getPersJuridicaById(int id) {
        try {
            ClientPersJuridica clientPersJuridica = this.getPersJuridicaByIdNoCommit(id);
            return clientPersJuridica;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            ClientPersJuridica clientPersJuridica = null;
            return clientPersJuridica;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void updateGroupsForPartnerNoCommit(int idPartner, String groups) throws SQLException {
        this.getDao().removeGroupsForPartner(idPartner);
        this.getDao().addPartnerToGroups(idPartner, groups);
    }

    public int addPersJuridicaNoCommit(String nume, String cui, String j, String adresa, int idTara, String oras, String banca, String iban, String punctDeLucru, String telefonFix, String fax, String telefonMobil, String email, String paginaWeb, String persoanaContact, double garantie, int idAgent, String observatii, int nrZileScadenta, double credit, String groups, String codFurnizor, String analiticFurnizor, String codClient, String analiticClient, String alias) throws SQLException {
        ClientPersJuridica pj = new ClientPersJuridica(-1, -1, nume, cui, j, adresa, oras, banca, iban, idTara, punctDeLucru, telefonFix, fax, telefonMobil, email, paginaWeb, persoanaContact, garantie, idAgent, observatii, nrZileScadenta, credit, codFurnizor, codClient, analiticFurnizor, analiticClient, alias, DateUtils.getCurrentTimestamp());
        int idPersJuridica = this.getDao().addClientPersJuridica(pj);
        int idClient = this.getDao().addClient(idPersJuridica, -1);
        this.updateGroupsForPartnerNoCommit(idClient, groups);
        if (this.clientFilterInterface != null) {
            this.clientFilterInterface.afterAddClientCommit(idClient);
        }
        return idClient;
    }

    public int addPersJuridicaShortNoCommit(ClientPersJuridica pj, String groups) throws SQLException {
        int idPersJuridica = this.getDao().addClientPersJuridica(pj);
        int idClient = this.getDao().addClient(idPersJuridica, -1);
        this.updateGroupsForPartnerNoCommit(idClient, groups);
        pj.setIdPersJuridica(idPersJuridica);
        pj.setId(idClient);
        if (this.clientFilterInterface != null) {
            this.clientFilterInterface.afterAddClientCommit(idClient);
        }
        return idClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPersJuridica(String nume, String cui, String j, String adresa, int idTara, String oras, String banca, String iban, String punctDeLucru, String telefonFix, String fax, String telefonMobil, String email, String paginaWeb, String persoanaContact, double garantie, int idAgent, String observatii, int nrZileScadenta, double credit, String groups, String codFurnizor, String analiticFurnizor, String codClient, String analiticClient, String alias, boolean mustSync) {
        try {
            int idClient = this.addPersJuridicaNoCommit(nume, cui, j, adresa, idTara, oras, banca, iban, punctDeLucru, telefonFix, fax, telefonMobil, email, paginaWeb, persoanaContact, garantie, idAgent, observatii, nrZileScadenta, credit, groups, codFurnizor, analiticFurnizor, codClient, analiticClient, alias);
            if (mustSync) {
                Client newClient = this.getClientByIdNoCommit(idClient);
                this.syncClientNoCommit(newClient);
            }
            this.pool.commit();
            this.refreshPersJuridice = true;
            this.notifyListeners(42);
            if (Config.getInstance().getBoolean("smsAtClientAdd")) {
                String message = Config.getInstance().getString("smsAtClientAddText");
                MailUtils.sendSms(telefonMobil, message);
            }
            int message = idClient;
            return message;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void refreshPersFiziceNoCommit() throws SQLException {
        this.allPersFiziceSorted = this.getDao().getAllPersoaneFizice();
        if (this.clientFilterInterface != null) {
            Vector<ClientPersFizica> allPersFiziceFiltered = new Vector<ClientPersFizica>();
            for (ClientPersFizica cpf : this.allPersFiziceSorted) {
                if (!this.clientFilterInterface.showClient(cpf)) continue;
                allPersFiziceFiltered.add(cpf);
            }
            this.allPersFiziceSorted = allPersFiziceFiltered;
        }
    }

    public void setClientFilterInterface(ClientFilterInterface clientFilterInterface) {
        this.clientFilterInterface = clientFilterInterface;
    }

    private void refreshPersJuridiceNoCommit() throws SQLException {
        this.allPersJuridiceSorted = this.getDao().getAllPersoaneJuridice();
    }

    private void refreshClientHash() {
        this.clientsHash.clear();
        for (Client client1 : this.allClients) {
            this.clientsHash.put(client1.getId(), client1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Vector<Client> getAllClientsSorted() {
        if (this.refreshPersJuridice || this.refreshPersFizice) {
            this.allClients.clear();
            try {
                this.refreshPersFiziceNoCommit();
                this.refreshPersJuridiceNoCommit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
            Collections.sort(this.allPersJuridiceSorted);
            this.allClients.addAll(this.allPersJuridiceSorted);
            Collections.sort(this.allPersFiziceSorted);
            this.allClients.addAll(this.allPersFiziceSorted);
            Collections.sort(this.allClients, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Client c1 = (Client)o1;
                    Client c2 = (Client)o2;
                    return c1.toString().compareToIgnoreCase(c2.toString());
                }
            });
            this.refreshClientHash();
            this.refreshPersJuridice = false;
            this.refreshPersFizice = false;
        }
        System.out.println("Get all clients sorted: AllClients size : " + this.allClients.size() + " , allPersJuridicesize: " + this.allPersJuridiceSorted.size() + " , allPersFizicesize : " + this.allPersFiziceSorted.size());
        return this.allClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Vector getAllPersFiziceSorted() {
        if (this.refreshPersFizice) {
            try {
                this.refreshPersFiziceNoCommit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
            Collections.sort(this.allPersFiziceSorted);
            this.refreshPersFizice = false;
            this.allClients.clear();
            this.allClients.addAll(this.allPersJuridiceSorted);
            this.allClients.addAll(this.allPersFiziceSorted);
            Collections.sort(this.allClients, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Client c1 = (Client)o1;
                    Client c2 = (Client)o2;
                    return c1.toString().compareToIgnoreCase(c2.toString());
                }
            });
            this.refreshClientHash();
        }
        return this.allPersFiziceSorted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientToActiveLocationsCommit(int idClient) {
        try {
            this.addClientToActiveLocationsNoCommit(idClient);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void addClientToActiveLocationsNoCommit(int idClient) throws SQLException {
        Vector locations = RestLogic.getInstance().getLocationsNoCommit(-1);
        for (Location location : locations) {
            if (!location.isActive()) continue;
            int idMapping = this.getDao().addClientLocationsMapping(location.getId(), idClient);
            this.getDao().setClientLocationsCodSync(idMapping, VpConfig.getInstance().codUnicDatabase + "_" + idMapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientLocationMappingBySync(String codLocatie, String codSyncClient, String codSyncMapping) {
        try {
            int idLocatie = -1;
            Location loc = RestLogic.getInstance().getLocationByCodNoCommit(codLocatie);
            if (loc != null) {
                idLocatie = loc.getId();
            }
            int idClientLocal = this.getDao().getClientIdByCodSync(codSyncClient);
            Client c = ClientLogic.getInstance().getClientByIdNoCommit(idClientLocal);
            this.getDao().addClientLocationsMappingWithSync(idLocatie, c.getId(), codSyncMapping);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Hashtable<Integer, ClientsLocationsBean> getClientLocationsMappingByIdLocatieNoCommit(int idLocatie) throws SQLException {
        return this.getDao().getClientLocationsMappingByIdLocatie(idLocatie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteClientLocationsMappingByCodSync(String codSync) {
        try {
            this.getDao().deleteClientsLocationsMappingByCodSync(codSync);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public boolean isClientInActiveLocationsNoCommit(int idClient) throws SQLException {
        return this.getDao().isClientInActiveLocations(idClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClientInActiveLocationsCommit(int idClient) {
        try {
            boolean bl = this.isClientInActiveLocationsNoCommit(idClient);
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Vector<ClientPersJuridica> getAllPersJuridiceSorted() {
        if (this.refreshPersJuridice) {
            try {
                this.refreshPersJuridiceNoCommit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
            Collections.sort(this.allPersJuridiceSorted);
            this.refreshPersJuridice = false;
            this.allClients.clear();
            this.allClients.addAll(this.allPersFiziceSorted);
            this.allClients.addAll(this.allPersJuridiceSorted);
            Collections.sort(this.allClients, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Client c1 = (Client)o1;
                    Client c2 = (Client)o2;
                    return c1.toString().compareToIgnoreCase(c2.toString());
                }
            });
            this.refreshClientHash();
        }
        return this.allPersJuridiceSorted;
    }

    public synchronized Client getClientFromHash(int idClient) {
        return this.clientsHash.get(idClient);
    }

    public Vector getClientByCod(String cod) {
        Vector v = this.getPersFiziceByCod(cod);
        if (v.size() > 0) {
            return v;
        }
        return this.getPersJuridiceByCod(cod);
    }

    public Client getClientByNameNoCommit(String name) throws SQLException {
        ClientPersFizica pf = this.getDao().getPersFizicaByName(name);
        if (pf != null) {
            return pf;
        }
        return this.getDao().getPersJuridiceByName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientPersFizica getPersFizicaByExternalCod(int cod) {
        try {
            ClientPersFizica pers;
            ClientPersFizica clientPersFizica = pers = this.getDao().getPersFizicaByExternalId(cod);
            return clientPersFizica;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            this.pool.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getPersFiziceByCod(String cod) {
        try {
            Vector result;
            Vector vector = result = this.getDao().getPersFiziceByCnpOrPassport(cod);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getPersJuridiceByCod(String cod) {
        try {
            Vector result;
            Vector vector = result = this.getPersJuridiceByCodNoCommit(cod);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector getPersJuridiceByCodNoCommit(String cod) throws SQLException {
        Vector result = this.getDao().getPersJuridiceByCui(cod);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAnjagati(int idPersJuridica) {
        Vector result = new Vector();
        try {
            result = this.getDao().getPersoaneFiziceForIdCompanie(idPersJuridica);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        Collections.sort(result);
        return result;
    }

    public static String getPhoneSwitchPrefixMode(String originalNumber) {
        if (originalNumber.startsWith("+4")) {
            return originalNumber.substring(2, originalNumber.length());
        }
        if (originalNumber.startsWith("0")) {
            return "+4" + originalNumber;
        }
        return originalNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Client> getAllByTelefon(String telefon) {
        Vector<Client> result = new Vector<Client>();
        try {
            String alternateNumber = ClientLogic.getPhoneSwitchPrefixMode(telefon);
            Vector<ClientPersFizica> cpfs = this.getDao().getPersFizicaByTelephone(telefon, alternateNumber);
            Vector<ClientPersJuridica> cpj = this.getDao().getPersJuridicaByTelephone(telefon, alternateNumber);
            result.addAll(cpfs);
            result.addAll(cpj);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getByTelefon(String telefon) {
        try {
            Vector<ClientPersJuridica> cpj;
            String alternateNumber = ClientLogic.getPhoneSwitchPrefixMode(telefon);
            Vector<ClientPersFizica> cpfs = this.getDao().getPersFizicaByTelephone(telefon, alternateNumber);
            Client cpf = null;
            if (cpfs.size() > 0) {
                cpf = cpfs.get(0);
            }
            if (cpf == null && (cpj = this.getDao().getPersJuridicaByTelephone(telefon, alternateNumber)).size() > 0) {
                cpf = cpj.get(0);
            }
            Client client = cpf;
            return client;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Client client = null;
            return client;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Client getClient(String cod) {
        Vector results = this.getClientByCod(cod);
        if (results.size() > 0) {
            return (Client)results.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector<TipCont> getAllConturi() {
        try {
            Vector<TipCont> result;
            Vector<TipCont> vector = result = this.getAllConturiNoCommit();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<TipCont> vector = new Vector<TipCont>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<TipCont> getAllConturiNoCommit() throws SQLException {
        return this.getDao().getConturi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TipCont getContById(int id) {
        try {
            TipCont result;
            TipCont tipCont = result = this.getDao().getTipContById(id);
            return tipCont;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            TipCont tipCont = null;
            return tipCont;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Hashtable<Integer, Double> getSoldStartNoCommit(int idClient, int tipCont, Timestamp data) throws SQLException {
        Hashtable<Integer, Double> result = this.getDao().getValoareCont(idClient, tipCont, data);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getSoldStart(int idClient, int tipCont, Timestamp data) {
        Hashtable<Object, Object> result = new Hashtable();
        try {
            result = this.getSoldStartNoCommit(idClient, tipCont, data);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCentralizatorClienti(Hashtable criteria) {
        int tipCont = (Integer)criteria.get("tip_cont");
        Date start = (Date)criteria.get(Constants.START_KEY);
        Date stop = (Date)criteria.get(Constants.STOP_KEY);
        int idLocatie = -1;
        Location idLocatieObj = (Location)criteria.get(Constants.LOCATIE_KEY);
        if (idLocatieObj != null) {
            idLocatie = idLocatieObj.getId();
        }
        Vector<Client> clienti = this.getAllClientsSorted();
        Vector<TipCont> conturi = this.getAllConturi();
        int valIncarcare = (Integer)criteria.get(VAL_INCARCARE);
        Object faraTranzactiiObj = criteria.get("Include clienti fara tranzactii");
        boolean faraTranzactii = faraTranzactiiObj != null;
        Vector<FisaCentralizator> result = new Vector<FisaCentralizator>();
        System.out.println("Nr clienti : " + clienti.size() + " nr conturi : " + conturi.size());
        long startTime = System.currentTimeMillis();
        try {
            Hashtable<Integer, ClientsLocationsBean> clientLocationsHash = null;
            if (idLocatie > 0) {
                clientLocationsHash = this.getClientLocationsMappingByIdLocatieNoCommit(idLocatie);
            }
            for (int j = 0; j < conturi.size(); ++j) {
                TipCont tc = conturi.elementAt(j);
                if (tipCont != -1 && tc.getId() != tipCont) continue;
                int idCont = tc.getId();
                Timestamp tStart = new Timestamp(start.getTime());
                Timestamp tStop = new Timestamp(stop.getTime());
                Hashtable<Integer, Double> initial = this.getSoldStartNoCommit(-1, idCont, tStart);
                Hashtable<Integer, Double> credit = this.getDao().getCredit(-1, idCont, tStart, tStop);
                Hashtable<Integer, Double> debit = this.getDao().getDebit(-1, idCont, tStart, tStop);
                Hashtable<Integer, Integer> incarcari = this.getDao().getIncarcari(-1, idCont, tStart, tStop, valIncarcare);
                for (int i = 0; i < clienti.size(); ++i) {
                    Client client1 = clienti.elementAt(i);
                    FisaCentralizator fc = new FisaCentralizator();
                    double initialV = 0.0;
                    Double f = initial.get(client1.getId());
                    if (f != null) {
                        initialV = f;
                    }
                    fc.setInitial(initialV);
                    double creditV = 0.0;
                    f = credit.get(client1.getId());
                    if (f != null) {
                        creditV = f;
                    }
                    fc.setCredit(creditV);
                    double debitV = 0.0;
                    f = debit.get(client1.getId());
                    if (f != null) {
                        debitV = f;
                    }
                    fc.setDebit(debitV);
                    if (!faraTranzactii && Utils.isValueZero(initialV) && Utils.isValueZero(creditV) && Utils.isValueZero(debitV)) continue;
                    int incarcariV = 0;
                    Integer in = incarcari.get(client1.getId());
                    if (in != null) {
                        incarcariV = in;
                    }
                    fc.setIncarcari(incarcariV);
                    fc.setFinalF(initialV + creditV + debitV);
                    fc.setNumeClient(client1.toString());
                    fc.setCont(tc.getLabel());
                    if (client1 instanceof ClientPersFizica) {
                        ClientPersFizica cpf = (ClientPersFizica)client1;
                        fc.setCodClient(cpf.getCity() + " " + cpf.getAddress1());
                    }
                    if (clientLocationsHash != null && clientLocationsHash.get(client1.getId()) == null) continue;
                    result.add(fc);
                }
            }
            long stopTime = System.currentTimeMillis();
            System.out.println("Durata: " + DateUtils.getDiferentaIntreOre(startTime, stopTime));
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<FisaClient> getFisaClient(Hashtable criteria) {
        int idClient = (Integer)criteria.get(Constants.CLIENT_KEY);
        int tipCont = (Integer)criteria.get("tip_cont");
        Date start = (Date)criteria.get(Constants.START_KEY);
        Date stop = (Date)criteria.get(Constants.STOP_KEY);
        try {
            Vector<FisaClient> result;
            Vector<FisaClient> vector = result = this.getDao().getFisaClient(idClient, tipCont, new Timestamp(start.getTime()), new Timestamp(stop.getTime()));
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<FisaClient> vector = new Vector<FisaClient>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ValoareContClient> getConturiClient(int idClient, int idTipCont) {
        Vector<ValoareContClient> result = new Vector();
        try {
            result = this.getConturiClientNoCommit(idClient, idTipCont);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector<ValoareContClient> getConturiClientNoCommit(int idClient, int idTipCont) throws SQLException {
        Vector<ValoareContClient> result = new Vector<ValoareContClient>();
        Vector<TipCont> conturi = this.getAllConturiNoCommit();
        for (int i = 0; i < conturi.size(); ++i) {
            TipCont t = conturi.elementAt(i);
            Hashtable<Integer, Double> val = this.getDao().getValoareCont(idClient, t.getId(), DateUtils.getCurrentTimestamp());
            Double f = val.get(idClient);
            if (f == null) continue;
            double val1 = f;
            ValoareContClient vc = new ValoareContClient();
            vc.setTipCont(t);
            vc.setNumeCont(t.getLabel());
            vc.setValoare(val1);
            if (idTipCont == -1) {
                if (val1 == 0.0) continue;
                result.add(vc);
                continue;
            }
            if (t.getId() != idTipCont) continue;
            result.add(vc);
        }
        return result;
    }

    public String getDetaliiConturi(int idClient) {
        String result = "";
        Vector<ValoareContClient> d = this.getConturiClient(idClient, -1);
        for (int i = 0; i < d.size(); ++i) {
            ValoareContClient o = d.elementAt(i);
            result = result + o.getNumeCont() + " = " + Utils.getString2Decimals(o.getValoare());
            if (d.size() - 1 <= i) continue;
            result = result + "; ";
        }
        return result;
    }

    public Double getTotalDetaliiConturi(int idClient) {
        Double result = new Double(0.0);
        Vector<ValoareContClient> d = this.getConturiClient(idClient, -1);
        for (int i = 0; i < d.size(); ++i) {
            ValoareContClient o = d.elementAt(i);
            result = result + o.getValoare();
        }
        return result;
    }

    public boolean existsPersFizicaByCodCas(String codCAS) throws SQLException {
        return this.getDao().existsPersFizicaByCodCas(codCAS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAngajatiContinental(Vector<ContinentalAngajatiImportBean> okList, Component parent, TipCont tipCont1, boolean normalizeCardSize, boolean useCodCas) {
        Vector<Promotion> promotii = PromotionLogic.getInstance().getFidelitatePromotions();
        if (promotii.size() <= 0) {
            DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.definitiCelPutinOPromotie, new String[0]), LangRoAll.nuPotContinua);
            return;
        }
        PromotiiDialog dialog = new PromotiiDialog(4, promotii);
        int idPromotie = promotii.get(0).getId();
        if (promotii.size() > 0) {
            idPromotie = dialog.getSelected();
        }
        PartenerGroup clientGroup = this.getParteneriGroupById(2);
        Vector<Integer> clientFilterInterfaceIds = new Vector<Integer>();
        try {
            for (ContinentalAngajatiImportBean bean : okList) {
                boolean alreadyExists = this.existsPersFizicaByCodCas(bean.getCodCAS());
                if (alreadyExists && useCodCas) {
                    Logger.logDebug(this, "Ignoring import bean for CAS : " + bean.getCodCAS());
                    continue;
                }
                int idClientNew = ClientLogic.getInstance().addPersFizicaNoCommit(useCodCas ? bean.getPrenume() + " " + bean.getNume() : bean.getNume(), useCodCas ? bean.getCodCAS() : bean.getPrenume(), "", 1, "", -1, -1, -1, bean.getNumarTelefon(), "", "", "", "", "", "", "", bean.getDataNasterii(), null, bean.getDataNumelui(), "");
                Client newClient = this.getClientByIdNoCommit(idClientNew);
                this.syncClientNoCommit(newClient);
                if (this.clientFilterInterface != null) {
                    clientFilterInterfaceIds.add(newClient.getId());
                }
                String cardFull = bean.getCodCard();
                if (normalizeCardSize) {
                    cardFull = Utils.getStringMaxSize(VpConfig.getInstance().codFidelitateLength, bean.getCodCard(), Character.valueOf('0'), true);
                }
                PromotionLogic.getInstance().addPromotionClientNoCommit(idClientNew, idPromotie, cardFull, cardFull);
                this.updateGroupsForPartnerNoCommit(idClientNew, clientGroup.getId() + "");
                this.adaugaTranzactieNoCommit(tipCont1.getId(), idClientNew, bean.getDisponibil(), LangRoAll.alimentareCont);
            }
            this.pool.commit();
            this.refreshPersFizice = true;
            this.notifyListeners(41);
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        this.notifyListeners(41);
        this.notifyListeners(42);
        if (this.clientFilterInterface != null) {
            this.clientFilterInterface.afterAddClientCommit(clientFilterInterfaceIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adaugaTranzactieClient(int idCont, int idClient, double valoare, String detalii) {
        try {
            int id = this.adaugaTranzactieNoCommit(idCont, idClient, valoare, detalii);
            this.pool.commit();
        }
        catch (SQLException e) {
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public int adaugaTranzactieNoCommit(int idCont, int idClient, double valoare, String detalii) throws SQLException {
        int id = this.getDao().adaugaTranzactieClient(idCont, idClient, valoare, detalii);
        this.getDao().updateCodSyncForTranzactie(VpConfig.getInstance().codUnicDatabase + "_" + id, id);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFisa(int idFisa) {
        try {
            this.getDao().deleteFisaClient(idFisa);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incarcaClientiDinExcel(String fullPath) {
        try {
            ExcelUtils.readExcel(new File(fullPath), new ExcelImportInterface(){
                String phone = "";
                String nume = "";
                String prenume = "";
                String adresa = "";
                String tara = "";
                String oras = "";
                String fax = "";
                String mobil = "";
                String email = "";
                String web = "";
                String loculNasterii = "";
                String cetatenie = "";
                String nationalitate = "";
                Date dataNasterii = new Date();
                Date dataNumeului = new Date();
                String companie = "";

                @Override
                public void lineEnd() {
                    boolean lineOk;
                    boolean bl = lineOk = Validators.correctString(this.nume) && Validators.correctString(this.prenume);
                    if (lineOk) {
                        int idPersJuridica = -1;
                        if (Validators.correctString(this.companie)) {
                            Vector v1 = ClientLogic.this.getPersJuridiceByCod(this.companie);
                            if (v1.size() > 0) {
                                ClientPersJuridica cpj = (ClientPersJuridica)v1.get(0);
                                idPersJuridica = cpj.getIdPersJuridica();
                            } else {
                                int clientAdded = ClientLogic.this.addPersJuridica(this.companie, this.companie, "", "", 1, "", "", "", "", "", "", "", "", "", "", 0.0, -1, "", 0, 0.0, "2", "", "", "", "", "", true);
                                ClientPersJuridica cpj = (ClientPersJuridica)ClientLogic.this.getClientById(clientAdded);
                                idPersJuridica = cpj.getIdPersJuridica();
                            }
                        }
                        ClientLogic.this.addPersFizica(this.nume, this.prenume, this.adresa, 1, this.oras, -1, -1, idPersJuridica, this.phone, this.fax, this.mobil, this.email, this.web, this.loculNasterii, this.cetatenie, this.nationalitate, this.dataNasterii, "", "2", this.dataNumeului, "", true);
                    }
                }

                @Override
                public void lineStart() {
                    this.phone = "";
                    this.nume = "";
                    this.prenume = "";
                    this.adresa = "";
                    this.tara = "";
                    this.oras = "";
                    this.fax = "";
                    this.mobil = "";
                    this.email = "";
                    this.web = "";
                    this.loculNasterii = "";
                    this.cetatenie = "";
                    this.nationalitate = "";
                    this.dataNasterii = new Date();
                }

                @Override
                public void sheetStart(String sheetName) {
                }

                @Override
                public void valueRead(int row, int column, String value) {
                    switch (column) {
                        case 0: {
                            this.phone = value;
                            break;
                        }
                        case 2: {
                            if (Validators.correctString(value)) {
                                Vector items = Utils.splitString(value, ' ');
                                this.nume = (String)items.get(0);
                                for (int i = 1; i < items.size(); ++i) {
                                    String o = (String)items.elementAt(i);
                                    this.prenume = this.prenume + o + " ";
                                }
                                break;
                            }
                        }
                        case 1: {
                            this.companie = value;
                        }
                    }
                }

                @Override
                public void sheetEnd(String sheetName) {
                }
            });
            this.pool.commit();
        }
        catch (Exception e) {
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Logger.logException(this, e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientIcon loadIcon(int idPersFizica) {
        ClientIcon result = new ClientIcon();
        ImageIcon img = null;
        if (idPersFizica != -1) {
            try {
                int idFile = -1;
                try {
                    idFile = this.getDao().getPictureForPersFizica(idPersFizica);
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                finally {
                    try {
                        this.pool.commit();
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    this.pool.releaseConnection();
                }
                if (idFile != -1) {
                    String fullPath = FileUtils.getTempDir() + File.separator + idPersFizica + "_" + idFile + ".jpg";
                    DocumenteLogic.getInstance().saveDocument(new File(fullPath), idFile);
                    img = Utils.getImageFromDiskAbsolutePath(fullPath, 320, 240);
                    result.setFullPath(fullPath);
                }
            }
            catch (Exception e2) {
                Logger.logException(this, e2);
                result = null;
            }
        }
        if (img == null) {
            img = Utils.getImageResource("nobody.gif");
        }
        result.setIcon(img);
        return result;
    }

    private JPanel getCardClientPanel(String pozaClient, String numeClient) {
        String macheta = Config.getInstance().getString("cardClientMachetaFile");
        String fullCardPath = FileUtils.getCurrentDir() + File.separator + macheta;
        int pictureX = Config.getInstance().getInt("cardClientPictureX");
        int pictureY = Config.getInstance().getInt("cardClientPictureY");
        int pictureDx = Config.getInstance().getInt("cardClientPictureDX");
        int pictureDy = Config.getInstance().getInt("cardClientPictureDY");
        int nameX = Config.getInstance().getInt("cardClientNameX");
        int nameY = Config.getInstance().getInt("cardClientNameY");
        int nameDx = Config.getInstance().getInt("cardClientNameDX");
        int nameDy = Config.getInstance().getInt("cardClientNameDY");
        int nameFontSize = Config.getInstance().getInt("cardClientNameFontSize");
        String cardClientNameFontColor = Config.getInstance().getString("cardClientNameFontColor");
        try {
            JPanel fullCard = GuiUtils.getCardClientPanel(fullCardPath, pozaClient, pictureX, pictureY, pictureDx, pictureDy, numeClient, nameX, nameY, nameDx, nameDy, nameFontSize, cardClientNameFontColor);
            return fullCard;
        }
        catch (MalformedURLException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    public void previewCardClient(String pozaClient, String numeClient) {
        JPanel panel = this.getCardClientPanel(pozaClient, numeClient);
        JDialog dia = DialogUtils.getJDialog(panel, GuiUtils.currentFrame, "Preview card: " + numeClient, 1.2);
        int cardClientMachetaDX = Config.getInstance().getInt("cardClientMachetaDX");
        int cardClientMachetaDY = Config.getInstance().getInt("cardClientMachetaDY");
        dia.setSize(new Dimension(cardClientMachetaDX, cardClientMachetaDY));
        dia.setVisible(true);
    }

    public void printCardClient(final String pozaClient, final String numeClient) {
        final int cardClientMachetaDX = Config.getInstance().getInt("cardClientMachetaDX");
        final int cardClientMachetaDY = Config.getInstance().getInt("cardClientMachetaDY");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanel panel = ClientLogic.this.getCardClientPanel(pozaClient, numeClient);
                panel.setPreferredSize(new Dimension(cardClientMachetaDX, cardClientMachetaDY));
                JFrame f = new JFrame();
                f.getContentPane().add(panel);
                f.pack();
                SwingPrintUtilities.writeImage(panel, 1.0, 1.0, "card.png", "png");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<PartenerGroup> getParteneriGroups() {
        try {
            int idLanguage = 1;
            User u = AdministrationPanel.loggedUser;
            if (u != null) {
                idLanguage = u.getLanguage();
            }
            Vector<PartenerGroup> vector = this.getDao().getParteneriGroups(idLanguage);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<PartenerGroup> vector = new Vector<PartenerGroup>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<PartenerGroup> getParteneriGroupsForPersoaneFizice() {
        try {
            int idLanguage = 1;
            User u = AdministrationPanel.loggedUser;
            if (u != null) {
                idLanguage = u.getLanguage();
            }
            Vector<PartenerGroup> allGroups = this.getDao().getParteneriGroups(idLanguage);
            Vector<PartenerGroup> result = new Vector<PartenerGroup>();
            for (PartenerGroup pfGroups : allGroups) {
                if (pfGroups.getLabel().equalsIgnoreCase("Furnizor")) continue;
                result.add(pfGroups);
            }
            Vector<PartenerGroup> vector = result;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<PartenerGroup> vector = new Vector<PartenerGroup>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartenerGroup getParteneriGroupById(int idGrup) {
        try {
            PartenerGroup partenerGroup = this.getDao().getParteneriGroupById(idGrup);
            return partenerGroup;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            PartenerGroup partenerGroup = null;
            return partenerGroup;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Integer, Vector<PartenerGroup>> getGroupsForPartnerAsHash(int idPartner) {
        try {
            int idLanguage = 1;
            User u = AdministrationPanel.loggedUser;
            if (u != null) {
                idLanguage = u.getLanguage();
            }
            Hashtable<Integer, Vector<PartenerGroup>> hashtable = this.getDao().getGroupsForPartner(idPartner, idLanguage);
            return hashtable;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Hashtable<Integer, Vector<PartenerGroup>> hashtable = new Hashtable<Integer, Vector<PartenerGroup>>();
            return hashtable;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<PartenerGroup> getGroupsForPartner(int idPartner) {
        Hashtable<Integer, Vector<PartenerGroup>> groupsForPartnerAsHash = this.getGroupsForPartnerAsHash(idPartner);
        Vector<PartenerGroup> result = new Vector<PartenerGroup>();
        for (Integer idPartener : groupsForPartnerAsHash.keySet()) {
            Vector<PartenerGroup> partenerGroups = groupsForPartnerAsHash.get(idPartener);
            for (PartenerGroup partenerGroup : partenerGroups) {
                result.add(partenerGroup);
            }
        }
        return result;
    }

    private Vector<Client> getPartnersInGroupNoCommit(int groupId, int status) throws SQLException {
        Vector<Client> result = new Vector<Client>();
        Vector<ClientPersFizica> persoaneFizice = this.getDao().getAllPersoaneFiziceInGrup(groupId, status);
        result.addAll(persoaneFizice);
        Vector<ClientPersJuridica> persoaneJuridice = this.getDao().getAllPersoaneJuridiceInGrup(groupId, status);
        result.addAll(persoaneJuridice);
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                Client c1 = (Client)o1;
                Client c2 = (Client)o2;
                return c1.toString().compareToIgnoreCase(c2.toString());
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Client> getPartnersInGroup(int groupId, int status) {
        try {
            Vector<Client> vector = this.getPartnersInGroupNoCommit(groupId, status);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Client> vector = new Vector<Client>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getPartnersInGroup(String groupKey, int status) {
        try {
            Vector vector = this.getPartnersInGroupNoCommit(groupKey, status);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector getPartnersInGroupNoCommit(String groupKey, int status) throws SQLException {
        int idGrup = this.getDao().getIdGrupByKey(groupKey);
        Vector<Client> partners = this.getPartnersInGroupNoCommit(idGrup, status);
        return partners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelegatToPersJuridica(ClientPersJuridica cpj, String nume, String prenume, String cnp, String numar, String serie, String sectie, Date eliberat, Date expirat) {
        try {
            this.getDao().addBiCi(serie, cnp, numar, sectie, eliberat, expirat);
            int idBuletin = this.pool.requestConnection().getIndentityLocal();
            int idClient = this.addPersFizicaNoCommit(nume, prenume, "", 1, "", idBuletin, -1, cpj.getIdPersJuridica(), "", "", "", "", "", "", "", "", new Date(), null, new Date(), "");
            this.updateGroupsForPartnerNoCommit(idClient, "4");
            this.pool.commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void comaseazaPersJuridice(Vector idClientiDeSters, int idClient) {
    }

    public void excelDateContactPersFizice(File reportFile, Vector selectedPartners) {
        try {
            ExcelUtils.writeExcel(reportFile, selectedPartners, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    ClientPersFizica entry = (ClientPersFizica)o;
                    try {
                        Label label = new Label(0, row, entry.getLastname());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getFirstname());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getAddress1());
                        sheet.addCell((WritableCell)label);
                        label = new Label(3, row, entry.getEmail());
                        sheet.addCell((WritableCell)label);
                        label = new Label(4, row, entry.getTelefonMobil());
                        sheet.addCell((WritableCell)label);
                        label = new Label(5, row, entry.getFax());
                        sheet.addCell((WritableCell)label);
                        label = new Label(6, row, entry.getTelefonFix());
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return new String[]{"Nume", "Prenume", "Adresa", "Email", "Mobil", "Fax", "Fix"};
                }

                @Override
                public String getSheetName() {
                    return "Date contact";
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, new Hashtable());
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void setLastUpdatedForClientNoCommit(int idClient) throws SQLException {
        this.getDao().setLastUpdatedForClient(idClient);
    }

    public void excelDateContactPersJuridice(File reportFile, Vector selectedPartners) {
        try {
            ExcelUtils.writeExcel(reportFile, selectedPartners, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    ClientPersJuridica entry = (ClientPersJuridica)o;
                    try {
                        Label label = new Label(0, row, entry.getCompanyName());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getAlias());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getPersoanaContact());
                        sheet.addCell((WritableCell)label);
                        label = new Label(3, row, entry.getAddress1());
                        sheet.addCell((WritableCell)label);
                        label = new Label(4, row, entry.getPunctDeLucru());
                        sheet.addCell((WritableCell)label);
                        label = new Label(5, row, entry.getCity());
                        sheet.addCell((WritableCell)label);
                        label = new Label(6, row, entry.getEmail());
                        sheet.addCell((WritableCell)label);
                        label = new Label(7, row, entry.getTelefonMobil());
                        sheet.addCell((WritableCell)label);
                        label = new Label(8, row, entry.getFax());
                        sheet.addCell((WritableCell)label);
                        label = new Label(9, row, entry.getTelefonFix());
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return new String[]{"Societate", "Alias", "Pers contact", "Adresa", "Punct lucru", "Oras", "Email", "Mobil", "Fax", "Fix"};
                }

                @Override
                public String getSheetName() {
                    return "Date contact";
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, new Hashtable());
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public Vector<String> collectEmailAddresses(String reportFile, Vector selectedPartners) {
        return this.collectInfo(reportFile, selectedPartners, new DateContactGrabber(){

            @Override
            public String getDataContact(Client cpj) {
                return cpj.getEmail();
            }
        });
    }

    public Vector<String> collectMobil(String reportFile, Vector selectedPartners) {
        return this.collectInfo(reportFile, selectedPartners, new DateContactGrabber(){

            @Override
            public String getDataContact(Client cpj) {
                return cpj.getTelefonMobil();
            }
        });
    }

    public Vector<String> collectFax(String reportFile, Vector selectedPartners) {
        return this.collectInfo(reportFile, selectedPartners, new DateContactGrabber(){

            @Override
            public String getDataContact(Client cpj) {
                return cpj.getFax();
            }
        });
    }

    public Vector<String> collectPostalAddress(String reportFile, Vector selectedPartners) {
        return this.collectInfo(reportFile, selectedPartners, new DateContactGrabber(){

            @Override
            public String getDataContact(Client cpj) {
                return cpj.getAddress1() + cpj.getCity();
            }
        });
    }

    public Vector<String> collectInfo(String reportFile, Vector selectedPartners, DateContactGrabber grabber) {
        Vector<String> result = new Vector<String>();
        StringBuffer resultSB = new StringBuffer();
        for (int i = 0; i < selectedPartners.size(); ++i) {
            Client client = (Client)selectedPartners.elementAt(i);
            String field = grabber.getDataContact(client);
            if (Validators.correctString(field)) {
                if (resultSB.length() > 0) {
                    resultSB.append(',');
                    resultSB.append(' ');
                }
                resultSB.append(field);
            }
            result.add(field);
        }
        if (reportFile != null) {
            try {
                FileUtils.writeTextToFile(reportFile, resultSB.toString());
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        return result;
    }

    public String getLastUpdatedStringForClientSelection(Client c) {
        Timestamp t = c.getLastUpdated();
        String text = Formatters.DATE_FORMAT.format(t);
        if (this.mustUpdateClient(c)) {
            text = "<html><font color=\"red\">" + text + "</font></html>";
        }
        return text;
    }

    public boolean mustUpdateClient(Client c) {
        int days = Config.getInstance().getInt("clientDaysUpdateDateContact", 180);
        Timestamp t = c.getLastUpdated();
        Date updateDay = DateUtils.addDaysToDate(new Date(t.getTime()), days);
        return updateDay.before(new Date());
    }

    public String verifyCNP(String cnp) {
        return this.cnpVerificationInterface.verifyCNP(cnp);
    }

    public Vector refreshAllClient() {
        this.refreshPersFizice = true;
        this.refreshPersJuridice = true;
        this.notifyListeners(41);
        this.notifyListeners(42);
        return this.getAllClientsSorted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportPartenerToXml(int idPartener, String targetFile) {
        try {
            Client c = this.getClientByIdNoCommit(idPartener);
            Vector<PartenerGroup> grupuri = this.getGroupsForPartner(c.getId());
            if (c != null) {
                this.updateCodSyncForLocalClient(c);
                if (c instanceof ClientPersFizica) {
                    this.exportPersFizicaToXml((ClientPersFizica)c, targetFile, grupuri);
                } else {
                    this.exportPersJuridicaToXml((ClientPersJuridica)c, targetFile, grupuri);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private void updateCodSyncForLocalClient(Client c) throws SQLException {
        ClientPersJuridica cpj;
        if (c instanceof ClientPersFizica) {
            AltAct altAct;
            int idAltAct;
            BiCi ci;
            int idBuletin;
            ClientPersFizica cpf = (ClientPersFizica)c;
            if (cpf.getCodSyncPersFizica() == null) {
                String codSync = VpConfig.getInstance().codUnicDatabase + "_" + cpf.getIdPersFizica();
                this.getDao().setCodSyncPersFizica(cpf.getIdPersFizica(), codSync);
                cpf.setCodSyncPersFizica(codSync);
            }
            if ((idBuletin = cpf.getIdBuletin()) > 0 && (ci = this.getDao().getBiCiById(idBuletin)) != null && ci.getCodSync() == null) {
                String codSync = VpConfig.getInstance().codUnicDatabase + "_" + idBuletin;
                this.getDao().setCodSyncToBuletin(codSync, idBuletin);
                ci.setCodSync(codSync);
            }
            if ((idAltAct = cpf.getIdPassport()) > 0 && (altAct = this.getDao().getAltActById(idAltAct)) != null && altAct.getCodSync() == null) {
                String codSync = VpConfig.getInstance().codUnicDatabase + "_" + idAltAct;
                this.getDao().setCodSyncToPasaport(codSync, idAltAct);
                altAct.setCodSync(codSync);
            }
        } else if (c instanceof ClientPersJuridica && (cpj = (ClientPersJuridica)c).getCodSyncPersJuridica() == null) {
            String codSync = VpConfig.getInstance().codUnicDatabase + "_" + cpj.getIdPersJuridica();
            this.getDao().setCodSyncPersFizica(cpj.getIdPersJuridica(), codSync);
            cpj.setCodSyncPersJuridica(codSync);
        }
        if (c.getCodSyncClient() == null) {
            String codSync = VpConfig.getInstance().codUnicDatabase + "_" + c.getId();
            this.getDao().setCodSyncClient(c.getId(), codSync);
            c.setCodSyncClient(codSync);
        }
    }

    private void exportPersFizicaToXml(ClientPersFizica c, String targetFile, Vector groups) throws Exception {
        this.exportClientToXml(c, targetFile, groups, "persoanaFizica");
    }

    private void exportPersJuridicaToXml(ClientPersJuridica c, String targetFile, Vector groups) throws Exception {
        this.exportClientToXml(c, targetFile, groups, "persoanaJuridica");
    }

    private void exportClientToXml(Client c, String targetFile, Vector groups, String name) throws Exception {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        bigFile.append("<document>\n");
        String auxAttributes = " groups=\"";
        for (int i = 0; i < groups.size(); ++i) {
            PartenerGroup partenerGroup = (PartenerGroup)groups.elementAt(i);
            String key = partenerGroup.getKey();
            String escaped = TextUtils.escapeForXML(key);
            auxAttributes = auxAttributes + escaped;
            if (i >= groups.size() - 1) continue;
            auxAttributes = auxAttributes + ",";
        }
        auxAttributes = auxAttributes + "\"";
        TextUtils.dumpToXml(c, bigFile, name, auxAttributes);
        if (c instanceof ClientPersFizica) {
            int idPassport;
            ClientPersFizica cp = (ClientPersFizica)c;
            int idBuletin = cp.getIdBuletin();
            if (idBuletin != -1) {
                BiCi biCiById = this.getBiCiById(idBuletin);
                TextUtils.dumpToXml(biCiById, bigFile, "buletin", "");
            }
            if ((idPassport = cp.getIdPassport()) != -1) {
                AltAct passportById = this.getPassportById(idPassport);
                TextUtils.dumpToXml(passportById, bigFile, "passport", "");
            }
        }
        bigFile.append("</document>");
        FileUtils.writeTextToFile(targetFile, bigFile.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupIdsFromGroupKeys(String keyString) {
        try {
            String string = this.getGroupIdsFromGroupKeysNoCommit(keyString);
            return string;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            String string = "";
            return string;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public String getGroupIdsFromGroupKeysNoCommit(String keyString) throws SQLException {
        String result = "";
        Vector keys = Utils.splitString(keyString, ',');
        for (int i = 0; i < keys.size(); ++i) {
            String s = (String)keys.elementAt(i);
            int idGrup = this.getDao().getIdGrupByKey(s);
            result = result + idGrup;
            if (i >= keys.size() - 1) continue;
            result = result + ",";
        }
        return result;
    }

    public String getVarstaForPF(ClientPersFizica cpf) {
        return DateUtils.getDiferentaIntreOre(cpf.getDataNasterii().getTime(), System.currentTimeMillis());
    }

    public String getCNPForClient(ClientPersFizica cpf) {
        int idBuletin = cpf.getIdBuletin();
        BiCi bul = this.getBiCiById(idBuletin);
        if (bul != null) {
            return bul.getCnp();
        }
        return "";
    }

    public String getCNPForClientNoCommit(ClientPersFizica cpf) throws SQLException {
        int idBuletin = cpf.getIdBuletin();
        BiCi bul = this.getBiCiByIdNoCommit(idBuletin);
        if (bul != null) {
            return bul.getCnp();
        }
        return "";
    }

    public String getCNPForPersFizica(ClientPersFizica cpf) {
        if (cpf != null) {
            String cnp = this.getCNPForClient(cpf);
            return cnp;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentToClient(String fileonDisk, String title, String categorie, int idClient) {
        try {
            int idFile = DocumenteLogic.getInstance().addFileShort(title, fileonDisk, fileonDisk);
            this.getDao().addFileToCLient(idClient, idFile, categorie);
            this.pool.commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDocumenteClient(int idClient) {
        try {
            Vector result;
            Vector vector = result = this.getDao().getFilesForClient(idClient);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientFollowup(int idClient, String scop, Date d) {
        try {
            this.getDao().addClientFollowUp(new Timestamp(d.getTime()), scop, idClient);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFollowUp(Hashtable criteria) {
        try {
            Date start = (Date)criteria.get(Constants.START_KEY);
            Date stop = (Date)criteria.get(Constants.STOP_KEY);
            Vector clienti = this.getDao().getClientFollowUp(-1, new Timestamp(start.getTime()), new Timestamp(stop.getTime()));
            for (int i = 0; i < clienti.size(); ++i) {
                ClientFollowupReportEntry clientFollowUp = (ClientFollowupReportEntry)clienti.elementAt(i);
                Client c = this.getClientByIdNoCommit(clientFollowUp.getIdClient());
                if (c instanceof ClientPersFizica) {
                    ClientPersFizica cpf = (ClientPersFizica)c;
                    clientFollowUp.setIdAngajat(cpf.getIdPersFizica());
                    clientFollowUp.setIdCompanie(cpf.getIdPersJuridica());
                    clientFollowUp.setNumeAngajat(cpf.toString());
                    ClientPersJuridica cpj = this.getPersJuridicaByIdNoCommit(cpf.getIdPersJuridica());
                    if (cpj != null) {
                        clientFollowUp.setNumeCompanie(cpj.toString());
                    } else {
                        clientFollowUp.setNumeCompanie("-");
                    }
                } else {
                    ClientPersJuridica cpj = (ClientPersJuridica)c;
                    clientFollowUp.setNumeCompanie(cpj.toString());
                    clientFollowUp.setNumeAngajat("-");
                    clientFollowUp.setIdAngajat(-1);
                    clientFollowUp.setIdCompanie(cpj.getIdPersJuridica());
                }
                clientFollowUp.setData(Formatters.DATE_FORMAT_RO.format(clientFollowUp.getScheduled()));
            }
            Vector vector = clienti;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<Client> getClientsSorted() {
        Vector<Client> allClients = ClientLogic.getInstance().getPartnersInGroup(2, 1);
        Collections.sort(allClients, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        return allClients;
    }

    public Vector<ClientPersJuridica> getSocietatiPropriiSorted() {
        Vector allClients = ClientLogic.getInstance().getPartnersInGroup(GROUPS_SOCIETATI_PROPRII_KEY, 1);
        Vector<ClientPersJuridica> result = new Vector<ClientPersJuridica>();
        for (Client client : allClients) {
            if (!(client instanceof ClientPersJuridica)) continue;
            result.add((ClientPersJuridica)client);
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        return result;
    }

    public boolean isPartnerInGroup(int idPartner, String groupKey) {
        Vector allClients = ClientLogic.getInstance().getPartnersInGroup(groupKey, 1);
        for (Client client : allClients) {
            if (client.getId() != idPartner) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranzactieContClient getTranzactieById(int idData) {
        try {
            TranzactieContClient result;
            TranzactieContClient tranzactieContClient = result = this.getDao().getTranzactieById(idData);
            return tranzactieContClient;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            TranzactieContClient tranzactieContClient = null;
            return tranzactieContClient;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranzactieContClient getTranzactieByCodSync(String codSync) {
        try {
            TranzactieContClient result;
            TranzactieContClient tranzactieContClient = result = this.getDao().getTranzactieByCodSync(codSync);
            return tranzactieContClient;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            TranzactieContClient tranzactieContClient = null;
            return tranzactieContClient;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTranzactieByRemoteId(String codSync) {
        try {
            this.getDao().deleteTranzactieByRemoteId(codSync);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTranzactieById(int id) {
        try {
            this.getDao().deleteTranzactieById(id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean adaugaTranzactieClientRemote(int tipcont, int idclient, double valoare, String detalii, String codSync, Timestamp data) {
        boolean result = false;
        try {
            result = this.getDao().adaugaTranzactieClientRemote(tipcont, idclient, valoare, detalii, data, codSync);
            this.pool.commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdPersFizicaFromIdClient(int idClient) {
        try {
            int n = this.getDao().getIdpersFizicaByIdclient(idClient);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdClientByCodSync(String codSync) {
        try {
            int n = this.getDao().getClientIdByCodSync(codSync);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void importOrUpdatePartenerFromXmlNew(String filename) throws IOException, SAXException {
        Utils.importXml(new DefaultHandler(){
            Client currentClient = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void endDocument() throws SAXException {
                if (this.currentClient != null) {
                    try {
                        if (VpConfig.isSyncRouter) {
                            ClientLogic.this.syncClientNoCommit(this.currentClient);
                        }
                        ClientLogic.this.pool.commit();
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                        try {
                            ClientLogic.this.pool.rollBack();
                        }
                        catch (SQLException e1) {
                            Logger.logException(this, (Exception)e);
                        }
                    }
                    finally {
                        ClientLogic.this.pool.releaseConnection();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                block60: {
                    if (qName.equalsIgnoreCase("persoanaJuridica")) {
                        ClientPersJuridica cpj = new ClientPersJuridica();
                        try {
                            TextUtils.loadAttributesBySetters(cpj, attributes);
                            String groupKeys = attributes.getValue("groups");
                            try {
                                String groupIds = ClientLogic.this.getGroupIdsFromGroupKeysNoCommit(groupKeys);
                                Vector pjs = ClientLogic.getInstance().getPersJuridiceByCodNoCommit(cpj.getCui());
                                if (pjs.size() > 0) {
                                    ClientPersJuridica existingCPJ = (ClientPersJuridica)pjs.get(0);
                                    cpj.setIdPersJuridica(existingCPJ.getIdPersJuridica());
                                    cpj.setId(existingCPJ.getId());
                                    if (cpj.getStatus() == 2) {
                                        ClientLogic.this.erasePersJuridicaNoCommit(cpj);
                                    } else {
                                        ClientLogic.this.savePersJuridicaShortNoCommit(cpj, groupIds);
                                    }
                                } else {
                                    ClientLogic.this.addPersJuridicaShortNoCommit(cpj, groupIds);
                                }
                                this.currentClient = cpj;
                                ClientLogic.this.pool.commit();
                                ClientLogic.this.refreshPersJuridice = true;
                            }
                            catch (SQLException e) {
                                Logger.logException(this, (Exception)e);
                                try {
                                    ClientLogic.this.pool.rollBack();
                                }
                                catch (SQLException e1) {
                                    Logger.logException(this, (Exception)e1);
                                }
                            }
                            finally {
                                ClientLogic.this.pool.releaseConnection();
                            }
                        }
                        catch (IllegalAccessException e) {
                            Logger.logException(this, (Exception)e);
                        }
                        catch (InvocationTargetException e) {
                            Logger.logException(this, (Exception)e);
                        }
                    } else if (qName.equalsIgnoreCase("persoanaFizica")) {
                        ClientPersFizica remoteClient = new ClientPersFizica();
                        try {
                            TextUtils.loadAttributesBySetters(remoteClient, attributes);
                            String groupKeys = attributes.getValue("groups");
                            try {
                                String groupIds = ClientLogic.this.getGroupIdsFromGroupKeysNoCommit(groupKeys);
                                ClientPersFizica localClient = ClientLogic.this.getPersFizicaByCodSyncNoCommit(remoteClient.getCodSyncPersFizica());
                                if (localClient != null) {
                                    if (remoteClient.getStatus() == 2) {
                                        ClientLogic.this.erasePersFizicaNoCommit(localClient);
                                    } else {
                                        remoteClient.setIdPersFizica(localClient.getIdPersFizica());
                                        remoteClient.setId(localClient.getId());
                                        remoteClient.setIdBuletin(localClient.getIdBuletin());
                                        remoteClient.setIdPassport(localClient.getIdPassport());
                                        this.currentClient = remoteClient;
                                        try {
                                            ClientLogic.this.savePersFizicaNoCommit(remoteClient, null, groupIds);
                                        }
                                        catch (FileNotFoundException e) {
                                            Logger.logException(this, (Exception)e);
                                        }
                                    }
                                } else {
                                    int idClient = ClientLogic.this.addPersFizicaShortNoCommit(remoteClient, groupIds);
                                    localClient = (ClientPersFizica)ClientLogic.getInstance().getClientByIdNoCommit(idClient);
                                    ClientLogic.this.setCodSyncPersFizicaNoCommit(localClient.getIdPersFizica(), remoteClient.getCodSyncPersFizica());
                                    ClientLogic.this.setCodSyncClientNoCommit(localClient.getId(), remoteClient.getCodSyncClient());
                                    remoteClient.setIdPersFizica(localClient.getIdPersFizica());
                                    remoteClient.setId(localClient.getId());
                                    this.currentClient = remoteClient;
                                }
                                ClientLogic.this.pool.commit();
                                ClientLogic.this.refreshPersFizice = true;
                            }
                            catch (Exception e) {
                                Logger.logException(this, e);
                                try {
                                    ClientLogic.this.pool.rollBack();
                                }
                                catch (SQLException e1) {
                                    Logger.logException(this, (Exception)e1);
                                }
                            }
                            finally {
                                ClientLogic.this.pool.releaseConnection();
                            }
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    } else if (qName.equalsIgnoreCase("buletin")) {
                        BiCi biCi = new BiCi(-1, "", "", "", "");
                        try {
                            TextUtils.loadAttributesBySetters(biCi, attributes);
                            BiCi biCiFound = ClientLogic.this.getBuletinFromCodSync(biCi.getCodSync());
                            if (biCiFound != null) {
                                ClientLogic.this.saveBiCiImported(biCi);
                                break block60;
                            }
                            int idBuletinNou = ClientLogic.this.addBuletinImported(biCi.getSeria(), biCi.getCnp(), biCi.getNumarul(), biCi.getSectia(), biCi.getDataEliberarii(), biCi.getDataExpirarii(), biCi.getCodSync());
                            ClientPersFizica cpf = (ClientPersFizica)this.currentClient;
                            cpf.setIdBuletin(idBuletinNou);
                            try {
                                ClientLogic.this.savePersFizicaNoCommitNoNotify(cpf);
                                ClientLogic.this.pool.commit();
                            }
                            catch (SQLException e) {
                                Logger.logException(this, (Exception)e);
                                try {
                                    ClientLogic.this.pool.rollBack();
                                }
                                catch (SQLException e1) {
                                    Logger.logException(this, (Exception)e);
                                }
                            }
                            finally {
                                ClientLogic.this.pool.releaseConnection();
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    } else if (qName.equalsIgnoreCase("passport")) {
                        AltAct passport = new AltAct(-1, "", "");
                        try {
                            TextUtils.loadAttributesBySetters(passport, attributes);
                            AltAct passportFound = ClientLogic.this.getPasaportFromCodSync(passport.getCodSync());
                            if (passportFound != null) {
                                if (!passportFound.equals(passport)) {
                                    ClientLogic.this.savePasaportImported(passport);
                                }
                                break block60;
                            }
                            int idPassportNou = ClientLogic.this.addPasaportImported(passport.getSeria(), passport.getDataEliberarii(), passport.getDataExpirarii(), passport.getTipAct(), passport.getCodSync());
                            ClientPersFizica cpf = (ClientPersFizica)this.currentClient;
                            cpf.setIdPassport(idPassportNou);
                            try {
                                ClientLogic.this.savePersFizicaNoCommitNoNotify(cpf);
                                ClientLogic.this.pool.commit();
                            }
                            catch (SQLException e) {
                                Logger.logException(this, (Exception)e);
                                try {
                                    ClientLogic.this.pool.rollBack();
                                }
                                catch (SQLException e1) {
                                    Logger.logException(this, (Exception)e);
                                }
                            }
                            finally {
                                ClientLogic.this.pool.releaseConnection();
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodSyncClient(int idClient, String codSync) {
        try {
            this.setCodSyncClientNoCommit(idClient, codSync);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void setCodSyncClientNoCommit(int idClient, String codSync) throws SQLException {
        this.getDao().setCodSyncClient(idClient, codSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodSyncPersFizica(int idPersFizica, String codSync) {
        try {
            this.setCodSyncPersFizicaNoCommit(idPersFizica, codSync);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void setCodSyncPersFizicaNoCommit(int idPersFizica, String codSync) throws SQLException {
        this.getDao().setCodSyncPersFizica(idPersFizica, codSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientPersFizica getPersFizicaByCodSync(String codSync) {
        try {
            ClientPersFizica clientPersFizica = this.getPersFizicaByCodSyncNoCommit(codSync);
            return clientPersFizica;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getClientByCodSync(String codSync) {
        try {
            Client client = this.getDao().getClientByCodSync(codSync);
            return client;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Client client = null;
            return client;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public ClientPersFizica getPersFizicaByCodSyncNoCommit(String codSync) throws SQLException {
        return this.getDao().getPersFizicaByCodSync(codSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean persFizicaExists(String nume, String prenume, java.sql.Date dataNasterii) {
        try {
            boolean bl = this.getDao().persFizicaExists(nume, prenume, dataNasterii);
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void exportClientsLocationsToXml(int idClientLocationMapping, String destinationFile, String deleteCodeSync) {
        bigFile = new StringBuffer();
        bigFile.append("<document>");
        if (deleteCodeSync == null) {
            try {
                mapping = this.getDao().getClientLocationMappingById(idClientLocationMapping);
                if (mapping == null) ** GOTO lbl43
                c = ClientLogic.getInstance().getClientByIdNoCommit(mapping.getIdClient());
                codLocatie = "";
                location = RestLogic.getInstance().getLocationByIdNoCommit(mapping.getIdLocation());
                if (location != null) {
                    codLocatie = location.getCod();
                }
                bigFile.append("<clientLocationMapping ");
                bigFile.append("\tcodLocation=\"" + codLocatie + "\"\n");
                bigFile.append("\tcodClient=\"" + c.getCodSyncClient() + "\"\n");
                bigFile.append("\tcodSync=\"" + mapping.getCodSync() + "\"\n");
                bigFile.append("/>\n");
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
        } else {
            bigFile.append("<clientLocationMapping ");
            bigFile.append("\tcodSync=\"" + deleteCodeSync + "\"\n");
            bigFile.append("\tdelete=\"delete\"\n");
            bigFile.append("/>\n");
        }
lbl43:
        // 4 sources

        bigFile.append("</document>");
        try {
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientsLocationsBean getClientLocationBeanByCodSync(String codSync) {
        try {
            ClientsLocationsBean mapping;
            ClientsLocationsBean clientsLocationsBean = mapping = this.getDao().getClientLocationsMappingByCodSync(codSync);
            return clientsLocationsBean;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            ClientsLocationsBean clientsLocationsBean = null;
            return clientsLocationsBean;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BiCi getBuletinFromCodSync(String codSync) {
        try {
            BiCi biCi = this.getDao().getBuletinByCodSync(codSync);
            return biCi;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AltAct getPasaportFromCodSync(String codSync) {
        try {
            AltAct altAct = this.getDao().getPasaportByCodSync(codSync);
            return altAct;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return null;
    }

    public void exportBuletinToXml(int idData, String destinationFile, String remote) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<document>");
        BiCi bici = this.getBiCiById(idData);
        if (bici != null) {
            bigFile.append("<buletin ");
            bigFile.append("\tid=\"" + bici.getId() + "\"\n");
            bigFile.append("\tseria=\"" + bici.getSeria() + "\"\n");
            bigFile.append("\tdata_eliberarii=\"" + bici.getDataEliberarii() + "\"\n");
            bigFile.append("\tdata_expirarii=\"" + bici.getDataExpirarii() + "\"\n");
            bigFile.append("\tcnp=\"" + bici.getCnp() + "\"\n");
            bigFile.append("\tnumarul=\"" + bici.getNumarul() + "\"\n");
            bigFile.append("\tsectia=\"" + bici.getSectia() + "\"\n");
            bigFile.append("\tcod_sync=\"" + bici.getCodSync() + "\"\n");
            bigFile.append("/>\n");
        }
        bigFile.append("</document>");
        try {
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void exportPasaportToXml(int idData, String destinationFile, String remote) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<document>");
        AltAct passport = this.getPassportById(idData);
        if (passport != null) {
            bigFile.append("<buletin ");
            bigFile.append("\tid=\"" + passport.getId() + "\"\n");
            bigFile.append("\tseria=\"" + passport.getSeria() + "\"\n");
            bigFile.append("\tdata_eliberarii=\"" + passport.getDataEliberarii() + "\"\n");
            bigFile.append("\tdata_expirarii=\"" + passport.getDataExpirarii() + "\"\n");
            bigFile.append("\ttip_act=\"" + passport.getTipAct() + "\"\n");
            bigFile.append("\tcod_sync=\"" + passport.getCodSync() + "\"\n");
            bigFile.append("/>\n");
        }
        bigFile.append("</document>");
        try {
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBiCiImported(BiCi toSave) {
        try {
            this.getDao().updateBiCiByCodSync(toSave);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePasaportImported(AltAct toSave) {
        try {
            this.getDao().updatePassportByCodSync(toSave);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNewServletSms(Vector<SmsServletBean> smses) {
        try {
            this.getDao().saveServletSms(smses);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<SmsServletBean> getAllNewSms() {
        try {
            Vector<SmsServletBean> vector = this.getDao().getAllNewSms();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<SmsServletBean> vector = null;
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreluatStatusToSms(Vector<SmsServletBean> sms) {
        try {
            this.getDao().setStatusToServletSms(sms, Constants.SMS_PRELUAT);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }
}

