/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti;

import java.sql.SQLException;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ro.atreides.clienti.ClientFilterInterface;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.ConnectionPool;

public class LocationBasedClientInterfaceImpl
implements ClientFilterInterface {
    static ExecutorService threadPool = Executors.newFixedThreadPool(3);

    @Override
    public boolean showClient(Client c) {
        return ClientLogic.getInstance().isClientInActiveLocationsCommit(c.getId());
    }

    @Override
    public void afterAddClientCommit(final Vector<Integer> idClient) {
        threadPool.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    for (Integer idc : idClient) {
                        ClientLogic.getInstance().addClientToActiveLocationsNoCommit(idc);
                    }
                    ConnectionPool.getInstance().commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                    try {
                        ConnectionPool.getInstance().rollBack();
                    }
                    catch (SQLException e1) {
                        Logger.logException(this, (Exception)e);
                    }
                }
                finally {
                    ConnectionPool.getInstance().releaseConnection();
                }
            }
        });
    }

    @Override
    public void afterAddClientCommit(int singleClientId) {
        Vector<Integer> ids = new Vector<Integer>();
        ids.add(singleClientId);
        this.afterAddClientCommit(ids);
    }
}

