/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.clienti.AltAct;
import ro.atreides.clienti.BiCi;
import ro.atreides.clienti.ClientFollowupReportEntry;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.ClientsLocationsBean;
import ro.atreides.clienti.DocumenteClient;
import ro.atreides.clienti.FisaClient;
import ro.atreides.clienti.PartenerGroup;
import ro.atreides.restaurant.base.TranzactieContClient;
import ro.atreides.restaurant.modules.servletsms.SmsServletBean;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.DaoInterface;

public class ClientiDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement isClientInActiveLocations;
    private PreparedStatement getLocatiiClientiMappingByCodSync;
    private PreparedStatement getLocatiiClientiMappingByIdLocatie;
    private PreparedStatement getLocatiiClientiMappingById;
    private PreparedStatement addLocatiiClientiMapping;
    private PreparedStatement addLocatiiClientiMappingWithSync;
    private PreparedStatement updateLocatiiClientiMappingCodSync;
    private PreparedStatement deleteLocatiiClientiMappingByCodSync;
    private PreparedStatement addClientFollowup;
    private PreparedStatement getClientFollowup;
    private PreparedStatement addClientPersFizica;
    private PreparedStatement selectAllPersFizice;
    private PreparedStatement selectAllPersFiziceInGroup;
    private PreparedStatement getPersFizicaById;
    private PreparedStatement getPersFiziceByIdCompanie;
    private PreparedStatement deletePersFizica;
    private PreparedStatement addBiCi;
    private PreparedStatement getBiCiById;
    private PreparedStatement deleteBiCi;
    private PreparedStatement setCodSyncToBiCi;
    private PreparedStatement setCodSyncToPasaport;
    private PreparedStatement addPassport;
    private PreparedStatement getPasaportById;
    private PreparedStatement deletePassport;
    private PreparedStatement updatePassport;
    private PreparedStatement updatePassportByCodSync;
    private PreparedStatement deleteAllPasapoarte;
    private PreparedStatement updatePersFizica;
    private PreparedStatement updateBiCi;
    private PreparedStatement getPersFizicaByTelephone;
    private PreparedStatement getPersFizicaByName;
    private PreparedStatement addClientPersJuridica;
    private PreparedStatement selectAllPersJuridice;
    private PreparedStatement selectAllPersJuridiceInGroup;
    private PreparedStatement getPersJuridicaById;
    private PreparedStatement getPersJuridicaByTelephone;
    private PreparedStatement deletePersJuridica;
    private PreparedStatement updatePersJuridica;
    private PreparedStatement addClient;
    private PreparedStatement getAllPersFiziceByCNP;
    private PreparedStatement getAllPersJuridicaByCui;
    private PreparedStatement getAllPersJuridicaByName;
    private PreparedStatement getIdPersFizica;
    private PreparedStatement getIdPersJuridica;
    private PreparedStatement getTipContById;
    private PreparedStatement getAllTipConturi;
    private PreparedStatement getValoareCont;
    private PreparedStatement getDebit;
    private PreparedStatement getCredit;
    private PreparedStatement getIncarcari;
    private PreparedStatement adaugaTranzactieClient;
    private PreparedStatement updateCodSyncForTranzactieClient;
    private PreparedStatement getTranzactieById;
    private PreparedStatement getTranzactieByCodSync;
    private PreparedStatement deleteTranzactieByRemoteId;
    private PreparedStatement deleteTranzactieById;
    private PreparedStatement adaugaTranzactieClientRemote;
    private PreparedStatement getPersFizicaByExternalId;
    private PreparedStatement getFisaClient;
    private PreparedStatement deleteFisaClient;
    private PreparedStatement setPictureForPersFizica;
    private PreparedStatement deletePictureForPersFizica;
    private PreparedStatement getPictureForPersFizica;
    private PreparedStatement getParteneriGroups;
    private PreparedStatement addPartnerToGroup;
    private PreparedStatement removeGroupsForPartner;
    private PreparedStatement getPartnersIdsForIdGroup;
    private PreparedStatement getGroupsForPartner;
    private PreparedStatement getParteneriGroupById;
    private PreparedStatement getIdGroupByKey;
    private PreparedStatement setLastUpdatedForClient;
    private PreparedStatement addDocumentToClient;
    private PreparedStatement getFilesForClient;
    private PreparedStatement getPersFizicaByFax;
    private PreparedStatement getMaxExternalIdForPersFizica;
    private PreparedStatement setExternalIdForPersFizica;
    private PreparedStatement getIdpersFizicaByIdclient;
    private PreparedStatement getIdAsociatCodExtern;
    private PreparedStatement existsPersoaneFiziceByCodCAS;
    private PreparedStatement setCodSyncClient;
    private PreparedStatement setCodSyncPersFizica;
    private PreparedStatement setCodSyncPersJuridica;
    private PreparedStatement getPersFizicaByCodSync;
    private PreparedStatement persFizicaExists;
    private PreparedStatement updateBiCiByCodSync;
    private PreparedStatement getBuletinByCodSync;
    private PreparedStatement getPasaportByCodSync;
    private PreparedStatement getClientByCodSync;
    private PreparedStatement setMustSyncPersFizice;
    private PreparedStatement setMustSyncPersJuridice;
    private PreparedStatement saveServletSms;
    private PreparedStatement getAllNewSms;
    private PreparedStatement updateSmsStatus;

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.setMustSyncPersFizice = this.connection.prepareStatement("update persoane_fizice set must_sync = ? where id = ?");
        this.setMustSyncPersJuridice = this.connection.prepareStatement("update persoane_juridice set must_sync = ? where id = ?");
        this.setCodSyncPersJuridica = this.connection.prepareStatement("update persoane_juridice set cod_sync_pj = ? where id = ?");
        this.deleteLocatiiClientiMappingByCodSync = this.connection.prepareStatement("delete from clients_locations where cod_sync = ?");
        this.isClientInActiveLocations = this.connection.prepareStatement("select * from clients_locations where id_client = ? and (id_location is null or id_location in ( select id from locations where locations.status = 1 ) )");
        String getLocatiiClientiMapping = "select cod_sync, id, id_client, coalesce(id_location, -1) as id_locatie from clients_locations ";
        this.getLocatiiClientiMappingByCodSync = this.connection.prepareStatement(getLocatiiClientiMapping + " where cod_sync = ?");
        this.getLocatiiClientiMappingByIdLocatie = this.connection.prepareStatement(getLocatiiClientiMapping + " where id_location = ?");
        this.getLocatiiClientiMappingById = this.connection.prepareStatement(getLocatiiClientiMapping + " where id = ?");
        this.addLocatiiClientiMapping = this.connection.prepareStatement("insert into clients_locations ( id_client, id_location ) values ( ?, ? )", 1);
        this.addLocatiiClientiMappingWithSync = this.connection.prepareStatement("insert into clients_locations ( id_client, id_location, cod_sync ) values ( ?, ?, ? )");
        this.updateLocatiiClientiMappingCodSync = this.connection.prepareStatement("update clients_locations set cod_sync = ? where id = ?");
        this.updateCodSyncForTranzactieClient = this.connection.prepareStatement("update cont_client set cod_sync = ? where id = ?");
        this.existsPersoaneFiziceByCodCAS = this.connection.prepareStatement("select id from persoane_fizice where prenume = ?");
        this.getIdAsociatCodExtern = this.connection.prepareStatement("select id from clienti where cod_sync_client = ?");
        this.setCodSyncClient = this.connection.prepareStatement("update clienti set cod_sync_client = ? where id = ?");
        this.setExternalIdForPersFizica = this.connection.prepareStatement("update persoane_fizice set external_id = ? where id = ?");
        this.setCodSyncPersFizica = this.connection.prepareStatement("update persoane_fizice set cod_sync_pf = ? where id = ?");
        this.getMaxExternalIdForPersFizica = this.connection.prepareStatement("select max(external_id) from persoane_fizice");
        this.getPersFizicaByFax = this.connection.prepareStatement("select * from pers_fizice where fax = ?");
        this.addClientFollowup = this.connection.prepareStatement("insert into client_follow_up(scheduled, scopul_declarat, id_client) values ( ? ,?, ?)");
        this.getClientFollowup = this.connection.prepareStatement("select * from client_follow_up where status = 1 and (id_client = ? or ? = -1) and scheduled >= ? and scheduled <= ?");
        this.addDocumentToClient = this.connection.prepareStatement("insert into client_attached_files ( categorie_document, id_client, id_file ) values ( ?, ?,? )");
        this.getFilesForClient = this.connection.prepareStatement("select client_attached_files.*, files.title from client_attached_files inner join files on client_attached_files.id_file = files.id where id_client = ?");
        this.setLastUpdatedForClient = this.connection.prepareStatement("update clienti set last_updated = CURRENT_TIMESTAMP where id = ?");
        this.getIdGroupByKey = this.connection.prepareStatement("select pers_juridice_groups.id as id_grup from pers_juridice_groups inner join keys on pers_juridice_groups.id_key = keys.id where keys.label = ? ");
        this.getPartnersIdsForIdGroup = this.connection.prepareStatement("select id_client from clients_groups where id_group = ?");
        this.addPartnerToGroup = this.connection.prepareStatement("insert into clients_groups ( id_client, id_group ) values ( ?, ? )");
        this.removeGroupsForPartner = this.connection.prepareStatement("delete from clients_groups where id_client = ?");
        this.getGroupsForPartner = this.connection.prepareStatement("select pers_juridice_groups.id as id_grup, keys.label as keyname, messages.label as nume_grup, clienti.id as id_client from clienti inner join clients_groups on clienti.id = clients_groups.id_client inner join pers_juridice_groups on clients_groups.id_group = pers_juridice_groups.id inner join keys on pers_juridice_groups.id_key = keys.id inner join messages on keys.id = messages.id_key where (clienti.id = ? or ? = -1)  and messages.id_lang = ?");
        this.getParteneriGroups = this.connection.prepareStatement("select pers_juridice_groups.id as id_grup, keys.label as keyname, messages.label as nume_grup from pers_juridice_groups inner join keys on pers_juridice_groups.id_key = keys.id inner join messages on keys.id = messages.id_key where messages.id_lang = ? and pers_juridice_groups.status = 1");
        this.getParteneriGroupById = this.connection.prepareStatement("select pers_juridice_groups.id as id_grup, keys.label as keyname, messages.label as nume_grup from pers_juridice_groups inner join keys on pers_juridice_groups.id_key = keys.id inner join messages on keys.id = messages.id_key where pers_juridice_groups.id = ?");
        String selectCont = "select tip_cont_client.id as id, messages.label as label, coalesce(tip_cont_client.produs_fictiv, -1) as produs from tip_cont_client inner join keys on tip_cont_client.id_key = keys.id inner join messages on keys.id = messages.id_key where id_lang = 1 and tip_cont_client.status = 1";
        this.getTipContById = this.connection.prepareStatement(selectCont + " and tip_cont_client.id = ?");
        this.getAllTipConturi = this.connection.prepareStatement(selectCont);
        this.getValoareCont = this.connection.prepareStatement("select sum(valoare) as valoare_cont, id_client from cont_client where (id_client = ? or ? = -1) and tip_cont = ? and data < ? group by id_client");
        this.adaugaTranzactieClient = this.connection.prepareStatement("insert into cont_client (id_client,tip_cont,valoare,detalii) values ( ?, ?, ?, ? ) ", 1);
        this.getFisaClient = this.connection.prepareStatement("select * from cont_client where id_client = ? and (tip_cont = ? OR ? = -1) and data >= ? and data < ?");
        this.getCredit = this.connection.prepareStatement("select sum(valoare) as valoare_cont, id_client from cont_client where (id_client = ? or ? = -1) and tip_cont = ? and data >= ? and data < ? and valoare > 0 group by id_client");
        this.getDebit = this.connection.prepareStatement("select sum(valoare) as valoare_cont, id_client from cont_client where (id_client = ? or ? = -1) and tip_cont = ? and data >= ? and data < ? and valoare < 0 group by id_client");
        this.getIncarcari = this.connection.prepareStatement("select count(id) as nr_incarcari, id_client from cont_client where (id_client = ? or ? = -1) and tip_cont = ? and data >= ? and data < ? and valoare > 0 and mod( round(valoare::numeric,2) , ?) = 0 group by id_client");
        this.deleteFisaClient = this.connection.prepareStatement("delete from cont_client where id = ?");
        this.addClientPersFizica = this.connection.prepareStatement("insert into persoane_fizice (nume, prenume, adresa, oras, idTara, idPasaport, idBuletin, id_pers_juridica, telefon_fix, fax,  telefon_mobil, email, pagina_web, locul_nasterii, cetatenie, nationalitate, data_nasterii, data_numelui, observatii )  values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )", 1);
        this.deletePersFizica = this.connection.prepareStatement("update persoane_fizice set status = 2 where id = ?");
        this.updatePersFizica = this.connection.prepareStatement("update persoane_fizice set nume = ?, prenume = ?, adresa = ?, oras = ?, idTara = ? ,idPasaport = ?, idBuletin = ? , id_pers_juridica = ?, telefon_fix = ?, fax = ?, telefon_mobil = ?, email = ?, pagina_web = ?, locul_nasterii = ?, cetatenie = ?, nationalitate = ?, data_nasterii = ?, data_numelui = ?, observatii = ? where id = ?");
        this.getIdPersFizica = this.connection.prepareStatement("select coalesce(idPersFizica, -1) as idPersFizica from clienti where id = ?");
        String selectPersFizice = "select persoane_fizice.id as idPersFizica, clienti.id as idClient, idBuletin, idPasaport, nume, prenume, oras, adresa, idTara, telefon_fix, fax, telefon_mobil, email, pagina_web, locul_nasterii, cetatenie, nationalitate, data_nasterii, data_numelui,  observatii,  coalesce( id_pers_juridica, -1) as idPersJuridica, persoane_fizice.status, last_updated, persoane_fizice.cod_sync_pf, clienti.cod_sync_client from persoane_fizice inner join clienti on persoane_fizice.id = clienti.idPersFizica";
        this.getPersFizicaByTelephone = this.connection.prepareStatement(selectPersFizice + " where (telefon_mobil = ? or telefon_fix = ? or telefon_mobil = ? or telefon_fix = ?) and persoane_fizice.status = " + 1);
        this.getPersFizicaByName = this.connection.prepareStatement(selectPersFizice + " where nume = ? and persoane_fizice.status = " + 1);
        this.selectAllPersFizice = this.connection.prepareStatement(selectPersFizice + " where persoane_fizice.status = " + 1);
        this.selectAllPersFiziceInGroup = this.connection.prepareStatement(selectPersFizice + " inner join clients_groups on clienti.id = clients_groups.id_client" + " where (clients_groups.id_group = ? or ? = " + -1 + " ) " + " and (persoane_fizice.status = ? or ? = " + -1 + " )");
        this.getPersFizicaById = this.connection.prepareStatement(selectPersFizice + " where persoane_fizice.id = ?");
        this.getPersFiziceByIdCompanie = this.connection.prepareStatement(selectPersFizice + " where persoane_fizice.id_pers_juridica = ?");
        this.getAllPersFiziceByCNP = this.connection.prepareStatement(selectPersFizice + " left outer join buletine on persoane_fizice.idBuletin = buletine.id" + " left outer join pasapoarte on persoane_fizice.idPasaport = pasapoarte.id" + " where buletine.cnp = ? or pasapoarte.seria = ? ");
        this.getPersFizicaByExternalId = this.connection.prepareStatement(selectPersFizice + " where persoane_fizice.external_id = ?");
        this.getPersFizicaByCodSync = this.connection.prepareStatement(selectPersFizice + " where persoane_fizice.cod_sync_pf = ?");
        this.persFizicaExists = this.connection.prepareStatement(selectPersFizice + " where persoane_fizice.nume = ? and persoane_fizice.prenume = ? " + " and persoane_fizice.data_nasterii = ?");
        this.addBiCi = this.connection.prepareStatement("insert into buletine ( cnp, seria, numarul, sectia, status, eliberat_la, expira_la) values (?, ?, ?, ?, 1, ?, ?)", 1);
        this.getBiCiById = this.connection.prepareStatement("select * from buletine where id = ?");
        this.deleteBiCi = this.connection.prepareStatement("update buletine set status = 2 where id = ?");
        this.updateBiCi = this.connection.prepareStatement("update buletine set cnp = ?, seria = ?, numarul = ?, sectia = ?, eliberat_la = ?, expira_la = ? where id = ?");
        this.updateBiCiByCodSync = this.connection.prepareStatement("update buletine set cnp = ?, seria = ?, numarul = ?, sectia = ?, eliberat_la = ?, expira_la = ? where cod_sync = ?");
        this.setCodSyncToBiCi = this.connection.prepareStatement("update buletine set cod_sync = ? where id = ?");
        this.getBuletinByCodSync = this.connection.prepareStatement("select * from buletine where cod_sync = ?");
        this.deleteAllPasapoarte = this.connection.prepareStatement("delete from pasapoarte");
        this.addPassport = this.connection.prepareStatement("insert into pasapoarte ( seria, status, eliberat_la, expira_la, tip_act ) values ( ?, 1, ?, ?, ?)", 1);
        this.getPasaportById = this.connection.prepareStatement("select * from pasapoarte where id = ?");
        this.deletePassport = this.connection.prepareStatement("update pasapoarte set status = 2 where id = ?");
        this.updatePassport = this.connection.prepareStatement("update pasapoarte set seria = ?, eliberat_la = ?, expira_la = ?, tip_act = ? where id = ?");
        this.updatePassportByCodSync = this.connection.prepareStatement("update pasapoarte set seria = ?, eliberat_la = ?, expira_la = ?, tip_act = ? where cod_sync = ?");
        this.setCodSyncToPasaport = this.connection.prepareStatement("update pasapoarte set cod_sync = ? where id = ?");
        this.getPasaportByCodSync = this.connection.prepareStatement("select * from pasapoarte where cod_sync = ?");
        this.addClientPersJuridica = this.connection.prepareStatement("insert into persoane_juridice ( nume, cui, j, adresa, oras, idTara, banca, iban, idReprezentantLegal, punct_lucru, telefon_fix, fax, telefon_mobil, email, pagina_web, persoana_contact, garantie, id_agent, observatii, nr_zile_scadenta, credit, cod_extern_furnizor, cod_extern_client, analitic_furnizor, analitic_client, alias, status ) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1 )", 1);
        this.deletePersJuridica = this.connection.prepareStatement("update persoane_juridice set status = 2 where id = ?");
        this.updatePersJuridica = this.connection.prepareStatement("update persoane_juridice set nume = ?, cui = ?, j = ?, adresa = ?, oras = ?, banca = ?, iban = ?, idReprezentantLegal = ?, idTara = ?, punct_lucru = ?, telefon_fix = ?, fax = ?, telefon_mobil = ?, email = ?, pagina_web = ?, persoana_contact = ?, garantie = ?, id_agent = ?, observatii = ?, nr_zile_scadenta = ?, credit = ?, cod_extern_furnizor = ?, cod_extern_client = ?, analitic_furnizor = ?, analitic_client = ?, alias = ? where id = ?");
        String selectPersJuridice = "select persoane_juridice.id as idPersJuridica, clienti.id as idClient, clienti.cod_sync_client, cui, j, adresa, oras, banca, nume, iban, idTara, punct_lucru, telefon_fix, fax, telefon_mobil, email, pagina_web, persoana_contact, garantie, coalesce(id_agent, -1) as id_agent, observatii, nr_zile_scadenta, credit, cod_extern_furnizor, cod_extern_client, analitic_furnizor, analitic_client, alias, persoane_juridice.status, last_updated from persoane_juridice inner join clienti on persoane_juridice.id = clienti.idPersJuridica";
        this.getPersJuridicaById = this.connection.prepareStatement(selectPersJuridice + " where persoane_juridice.id = ?");
        this.getPersJuridicaByTelephone = this.connection.prepareStatement(selectPersJuridice + " where (telefon_mobil = ? or telefon_fix = ? or telefon_mobil = ? or telefon_fix = ?) and persoane_juridice.status = " + 1);
        this.selectAllPersJuridice = this.connection.prepareStatement(selectPersJuridice + " where persoane_juridice.status = " + 1);
        this.selectAllPersJuridiceInGroup = this.connection.prepareStatement(selectPersJuridice + " inner join clients_groups on clienti.id = clients_groups.id_client" + " where" + " (clients_groups.id_group = ? or ? = " + -1 + " )" + " and (persoane_juridice.status = ? or ? = " + -1 + " )");
        this.getAllPersJuridicaByCui = this.connection.prepareStatement(selectPersJuridice + " where persoane_juridice.cui like ?");
        this.getAllPersJuridicaByName = this.connection.prepareStatement(selectPersJuridice + " where persoane_juridice.nume like ?");
        this.getIdPersJuridica = this.connection.prepareStatement("select coalesce(idPersJuridica, -1) as idPersJuridica from clienti where id = ?");
        this.addClient = this.connection.prepareStatement("insert into clienti ( idPersJuridica, idPersFizica, status ) values (?, ?, 1)", 1);
        this.setPictureForPersFizica = this.connection.prepareStatement("insert into persoane_fizice_picture (id_file, id_pers_fizica) values ( ?,?)");
        this.deletePictureForPersFizica = this.connection.prepareStatement("delete from persoane_fizice_picture where id_pers_fizica = ?");
        this.getPictureForPersFizica = this.connection.prepareStatement("select * from persoane_fizice_picture where id_pers_fizica = ?");
        this.getTranzactieById = this.connection.prepareStatement("select * from cont_client where id = ?");
        this.getTranzactieByCodSync = this.connection.prepareStatement("select * from cont_client where cod_sync = ?");
        this.deleteTranzactieByRemoteId = this.connection.prepareStatement("delete from cont_client where cod_sync = ?");
        this.adaugaTranzactieClientRemote = this.connection.prepareStatement("insert into cont_client (id_client,tip_cont,valoare,detalii,data,cod_sync) values ( ?, ?, ?, ?, ?, ? )");
        this.deleteTranzactieById = this.connection.prepareStatement("delete from cont_client where id = ?");
        this.getIdpersFizicaByIdclient = this.connection.prepareStatement("select idpersfizica from clienti where id = ?");
        this.saveServletSms = this.connection.prepareStatement("insert into sms_queue (mesaj, destinatar, status) values (?, ?, ?)");
        this.getAllNewSms = this.connection.prepareStatement("select * from sms_queue where status = " + Constants.SMS_NOU);
        this.updateSmsStatus = this.connection.prepareStatement("update sms_queue set status = ? where id = ?");
    }

    public void syncClient(Client c) throws SQLException {
        if (c instanceof ClientPersFizica) {
            ClientPersFizica cpf = (ClientPersFizica)c;
            int idPF = cpf.getIdPersFizica();
            this.syncPersFizica(idPF);
        } else {
            ClientPersJuridica cpj = (ClientPersJuridica)c;
            int idPJ = cpj.getIdPersJuridica();
            this.syncPersJuridica(idPJ);
        }
    }

    public void syncPersJuridica(int idPJ) throws SQLException {
        this.setMustSyncPersJuridice.setBoolean(1, true);
        this.setMustSyncPersJuridice.setInt(2, idPJ);
        this.setMustSyncPersJuridice.execute();
    }

    public void syncPersFizica(int idPF) throws SQLException {
        this.setMustSyncPersFizice.setBoolean(1, true);
        this.setMustSyncPersFizice.setInt(2, idPF);
        this.setMustSyncPersFizice.execute();
    }

    public boolean existsPersFizicaByCodCas(String codCAS) throws SQLException {
        boolean result = false;
        this.existsPersoaneFiziceByCodCAS.setString(1, codCAS);
        ResultSet rs = this.existsPersoaneFiziceByCodCAS.executeQuery();
        if (rs.next()) {
            result = true;
        }
        rs.close();
        return result;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ClientiDao(Connection connection) throws SQLException {
        this.connection = connection;
        this.buildPreparedStatements();
    }

    public Vector getPartnersIdsForIdGroup(int idGroup) throws SQLException {
        Vector<Integer> result = new Vector<Integer>();
        this.getPartnersIdsForIdGroup.setInt(1, idGroup);
        ResultSet rs = this.getPartnersIdsForIdGroup.executeQuery();
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        rs.close();
        return result;
    }

    public void removeGroupsForPartner(int idClient) throws SQLException {
        this.removeGroupsForPartner.setInt(1, idClient);
        this.removeGroupsForPartner.execute();
    }

    public Hashtable<Integer, Vector<PartenerGroup>> getGroupsForPartner(int idPartner, int idLanguage) throws SQLException {
        Hashtable<Integer, Vector<PartenerGroup>> result = new Hashtable<Integer, Vector<PartenerGroup>>();
        this.getGroupsForPartner.setInt(1, idPartner);
        this.getGroupsForPartner.setInt(2, idPartner);
        this.getGroupsForPartner.setInt(3, idLanguage);
        ResultSet rs = this.getGroupsForPartner.executeQuery();
        while (rs.next()) {
            PartenerGroup pg = this.getPartenerGroupFromResultSet(rs);
            int idPartener = rs.getInt("id_client");
            Vector<PartenerGroup> resultGroups = result.get(idPartener);
            if (resultGroups == null) {
                resultGroups = new Vector();
                result.put(idPartener, resultGroups);
            }
            resultGroups.add(pg);
        }
        rs.close();
        return result;
    }

    public void addPartnerToGroups(int idClient, String groups) throws SQLException {
        Vector ids = Utils.splitString(groups, ',');
        for (int i = 0; i < ids.size(); ++i) {
            String s = (String)ids.elementAt(i);
            int groupId = Integer.parseInt(s);
            this.addPartnerToGroup.setInt(1, idClient);
            this.addPartnerToGroup.setInt(2, groupId);
            this.addPartnerToGroup.execute();
        }
    }

    public Vector<PartenerGroup> getParteneriGroups(int idLanguage) throws SQLException {
        Vector<PartenerGroup> result = new Vector<PartenerGroup>();
        this.getParteneriGroups.setInt(1, idLanguage);
        ResultSet rs = this.getParteneriGroups.executeQuery();
        while (rs.next()) {
            PartenerGroup pg = this.getPartenerGroupFromResultSet(rs);
            result.add(pg);
        }
        rs.close();
        return result;
    }

    public PartenerGroup getParteneriGroupById(int idGrup) throws SQLException {
        PartenerGroup result = null;
        this.getParteneriGroupById.setInt(1, idGrup);
        ResultSet rs = this.getParteneriGroupById.executeQuery();
        if (rs.next()) {
            result = this.getPartenerGroupFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    private PartenerGroup getPartenerGroupFromResultSet(ResultSet rs) throws SQLException {
        PartenerGroup pg = new PartenerGroup();
        pg.setId(rs.getInt("id_grup"));
        pg.setLabel(rs.getString("nume_grup"));
        pg.setKey(rs.getString("keyname"));
        return pg;
    }

    public Vector<TipCont> getConturi() throws SQLException {
        Vector<TipCont> result = new Vector<TipCont>();
        ResultSet rs = this.getAllTipConturi.executeQuery();
        while (rs.next()) {
            TipCont c = this.getTipContFromResultSet(rs);
            result.add(c);
        }
        rs.close();
        return result;
    }

    private TipCont getTipContFromResultSet(ResultSet rs) throws SQLException {
        TipCont result = new TipCont();
        result.setId(rs.getInt("id"));
        result.setLabel(rs.getString("label"));
        result.setProdusFictiv(rs.getInt("produs"));
        return result;
    }

    public TipCont getTipContById(int id) throws SQLException {
        TipCont result = null;
        this.getTipContById.setInt(1, id);
        ResultSet rs = this.getTipContById.executeQuery();
        if (rs.next()) {
            result = this.getTipContFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, Double> getValoareCont(int idClient, int idCont, Timestamp data) throws SQLException {
        Hashtable<Integer, Double> result = new Hashtable<Integer, Double>();
        this.getValoareCont.setInt(1, idClient);
        this.getValoareCont.setInt(2, idClient);
        this.getValoareCont.setInt(3, idCont);
        this.getValoareCont.setTimestamp(4, data);
        ResultSet rs = this.getValoareCont.executeQuery();
        while (rs.next()) {
            double value = rs.getDouble("valoare_cont");
            int id = rs.getInt("id_client");
            result.put(id, value);
        }
        rs.close();
        return result;
    }

    public Integer adaugaTranzactieClient(int idCont, int idClient, double valoare, String detalii) throws SQLException {
        Integer result = null;
        this.adaugaTranzactieClient.setInt(1, idClient);
        this.adaugaTranzactieClient.setInt(2, idCont);
        this.adaugaTranzactieClient.setDouble(3, valoare);
        this.adaugaTranzactieClient.setString(4, detalii);
        this.adaugaTranzactieClient.execute();
        ResultSet generatedKeys = this.adaugaTranzactieClient.getGeneratedKeys();
        if (generatedKeys.next()) {
            result = generatedKeys.getInt(1);
        }
        generatedKeys.close();
        return result;
    }

    public void updateCodSyncForTranzactie(String codSync, int idTranzactie) throws SQLException {
        this.updateCodSyncForTranzactieClient.setString(1, codSync);
        this.updateCodSyncForTranzactieClient.setInt(2, idTranzactie);
        this.updateCodSyncForTranzactieClient.execute();
    }

    public Hashtable<Integer, Double> getCredit(int idClient, int tipCont, Timestamp start, Timestamp stop) throws SQLException {
        Hashtable<Integer, Double> result = new Hashtable<Integer, Double>();
        this.getCredit.setInt(1, idClient);
        this.getCredit.setInt(2, idClient);
        this.getCredit.setInt(3, tipCont);
        this.getCredit.setTimestamp(4, start);
        this.getCredit.setTimestamp(5, stop);
        ResultSet rs = this.getCredit.executeQuery();
        while (rs.next()) {
            double credit = rs.getDouble("valoare_cont");
            int id = rs.getInt("id_client");
            result.put(id, credit);
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, Double> getDebit(int idClient, int tipCont, Timestamp start, Timestamp stop) throws SQLException {
        Hashtable<Integer, Double> result = new Hashtable<Integer, Double>();
        this.getDebit.setInt(1, idClient);
        this.getDebit.setInt(2, idClient);
        this.getDebit.setInt(3, tipCont);
        this.getDebit.setTimestamp(4, start);
        this.getDebit.setTimestamp(5, stop);
        ResultSet rs = this.getDebit.executeQuery();
        while (rs.next()) {
            double credit = rs.getDouble("valoare_cont");
            int id = rs.getInt("id_client");
            result.put(id, credit);
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, Integer> getIncarcari(int idClient, int tipCont, Timestamp start, Timestamp stop, int valIncarcare) throws SQLException {
        Hashtable<Integer, Integer> result = new Hashtable<Integer, Integer>();
        this.getIncarcari.setInt(1, idClient);
        this.getIncarcari.setInt(2, idClient);
        this.getIncarcari.setInt(3, tipCont);
        this.getIncarcari.setTimestamp(4, start);
        this.getIncarcari.setTimestamp(5, stop);
        this.getIncarcari.setInt(6, valIncarcare);
        ResultSet rs = this.getIncarcari.executeQuery();
        while (rs.next()) {
            int credit = rs.getInt("nr_incarcari");
            int id = rs.getInt("id_client");
            result.put(id, credit);
        }
        rs.close();
        return result;
    }

    public Vector<FisaClient> getFisaClient(int idClient, int tipCont, Timestamp start, Timestamp stop) throws SQLException {
        Vector<FisaClient> result = new Vector<FisaClient>();
        double soldAnterior = 0.0;
        Hashtable<Integer, Double> val = this.getValoareCont(idClient, tipCont, start);
        if (val.get(idClient) != null) {
            soldAnterior = val.get(idClient);
        }
        FisaClient fc1 = new FisaClient();
        fc1.setData(Formatters.DATE_AND_TIME_FORMAT.format(start));
        fc1.setDetalii("Anterior");
        fc1.setSoldActual(soldAnterior);
        result.add(fc1);
        this.getFisaClient.setInt(1, idClient);
        this.getFisaClient.setInt(2, tipCont);
        this.getFisaClient.setInt(3, tipCont);
        this.getFisaClient.setTimestamp(4, start);
        this.getFisaClient.setTimestamp(5, stop);
        ResultSet rs = this.getFisaClient.executeQuery();
        while (rs.next()) {
            FisaClient fc = new FisaClient();
            fc.setIdFisa(rs.getInt("id"));
            fc.setData(Formatters.DATE_AND_TIME_FORMAT.format(rs.getTimestamp("data")));
            double valoare = rs.getDouble("valoare");
            if (valoare > 0.0) {
                fc.setCredit(valoare);
            } else if (valoare < 0.0) {
                fc.setDebit(-valoare);
            }
            fc.setDetalii(rs.getString("detalii"));
            fc.setSoldAnterior(soldAnterior);
            fc.compute();
            soldAnterior = fc.getSoldActual();
            result.add(fc);
        }
        rs.close();
        return result;
    }

    public void deleteFisaClient(int id) throws SQLException {
        this.deleteFisaClient.setInt(1, id);
        this.deleteFisaClient.execute();
    }

    public int getIdPersFizica(int idClient) throws SQLException {
        int result = -1;
        this.getIdPersFizica.setInt(1, idClient);
        ResultSet rs = this.getIdPersFizica.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public ClientPersFizica getPersFizicaByFax(String fax) throws SQLException {
        ClientPersFizica result = null;
        this.getPersFizicaByFax.setString(1, fax);
        int idPersFizica = -1;
        ResultSet rs = this.getPersFizicaByFax.executeQuery();
        if (rs.next()) {
            idPersFizica = rs.getInt("id");
        }
        rs.close();
        if (idPersFizica > 0) {
            result = this.getPersFizicaById(idPersFizica);
        }
        return result;
    }

    public int getIdPersJuridica(int idClient) throws SQLException {
        int result = -1;
        this.getIdPersJuridica.setInt(1, idClient);
        ResultSet rs = this.getIdPersJuridica.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public Vector getPersFiziceByCnpOrPassport(String cod) throws SQLException {
        Vector<ClientPersFizica> result = new Vector<ClientPersFizica>();
        this.getAllPersFiziceByCNP.setString(1, cod);
        this.getAllPersFiziceByCNP.setString(2, cod);
        ResultSet rs = this.getAllPersFiziceByCNP.executeQuery();
        while (rs.next()) {
            ClientPersFizica fizica = this.getPersFizicaFromRS(rs);
            result.add(fizica);
        }
        rs.close();
        return result;
    }

    public Vector getPersJuridiceByCui(String cui) throws SQLException {
        Vector<ClientPersJuridica> result = new Vector<ClientPersJuridica>();
        this.getAllPersJuridicaByCui.setString(1, "%" + cui + "%");
        ResultSet rs = this.getAllPersJuridicaByCui.executeQuery();
        while (rs.next()) {
            ClientPersJuridica juridica = this.getPersJuridicaFromRS(rs);
            result.add(juridica);
        }
        rs.close();
        return result;
    }

    public ClientPersJuridica getPersJuridiceByName(String name) throws SQLException {
        ClientPersJuridica result = null;
        this.getAllPersJuridicaByName.setString(1, "%" + name + "%");
        ResultSet rs = this.getAllPersJuridicaByName.executeQuery();
        if (rs.next()) {
            ClientPersJuridica juridica;
            result = juridica = this.getPersJuridicaFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Integer addClient(int idPersJuridica, int idPersFizica) throws SQLException {
        Integer result = null;
        if (idPersJuridica > 0) {
            this.addClient.setInt(1, idPersJuridica);
        } else {
            this.addClient.setNull(1, 4);
        }
        if (idPersFizica > 0) {
            this.addClient.setInt(2, idPersFizica);
        } else {
            this.addClient.setNull(2, 4);
        }
        this.addClient.execute();
        ResultSet generatedKeys = this.addClient.getGeneratedKeys();
        if (generatedKeys.next()) {
            result = generatedKeys.getInt(1);
        }
        generatedKeys.close();
        return result;
    }

    public Vector getAllPersoaneFizice() throws SQLException {
        Vector<ClientPersFizica> result = new Vector<ClientPersFizica>();
        ResultSet rs = this.selectAllPersFizice.executeQuery();
        while (rs.next()) {
            ClientPersFizica toAdd = this.getPersFizicaFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector<ClientPersFizica> getAllPersoaneFiziceInGrup(int idGrup, int status) throws SQLException {
        Vector<ClientPersFizica> result = new Vector<ClientPersFizica>();
        this.selectAllPersFiziceInGroup.setInt(1, idGrup);
        this.selectAllPersFiziceInGroup.setInt(2, idGrup);
        this.selectAllPersFiziceInGroup.setInt(3, status);
        this.selectAllPersFiziceInGroup.setInt(4, status);
        ResultSet rs = this.selectAllPersFiziceInGroup.executeQuery();
        while (rs.next()) {
            ClientPersFizica toAdd = this.getPersFizicaFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector getPersoaneFiziceForIdCompanie(int idCompanie) throws SQLException {
        Vector<ClientPersFizica> result = new Vector<ClientPersFizica>();
        this.getPersFiziceByIdCompanie.setInt(1, idCompanie);
        ResultSet rs = this.getPersFiziceByIdCompanie.executeQuery();
        while (rs.next()) {
            ClientPersFizica toAdd = this.getPersFizicaFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public ClientPersFizica getPersFizicaById(int id) throws SQLException {
        ClientPersFizica result = null;
        this.getPersFizicaById.setInt(1, id);
        ResultSet rs = this.getPersFizicaById.executeQuery();
        if (rs.next()) {
            result = this.getPersFizicaFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Vector<ClientPersFizica> getPersFizicaByTelephone(String phone, String alternateNumber) throws SQLException {
        Vector<ClientPersFizica> result = new Vector<ClientPersFizica>();
        this.getPersFizicaByTelephone.setString(1, phone);
        this.getPersFizicaByTelephone.setString(2, phone);
        this.getPersFizicaByTelephone.setString(3, alternateNumber);
        this.getPersFizicaByTelephone.setString(4, alternateNumber);
        ResultSet rs = this.getPersFizicaByTelephone.executeQuery();
        while (rs.next()) {
            ClientPersFizica toAdd = this.getPersFizicaFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public ClientPersFizica getPersFizicaByName(String name) throws SQLException {
        ClientPersFizica result = null;
        this.getPersFizicaByName.setString(1, name);
        ResultSet rs = this.getPersFizicaByName.executeQuery();
        if (rs.next()) {
            result = this.getPersFizicaFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Vector<ClientPersJuridica> getPersJuridicaByTelephone(String phone, String alternateNumber) throws SQLException {
        Vector<ClientPersJuridica> result = new Vector<ClientPersJuridica>();
        this.getPersJuridicaByTelephone.setString(1, phone);
        this.getPersJuridicaByTelephone.setString(2, phone);
        this.getPersJuridicaByTelephone.setString(3, alternateNumber);
        this.getPersJuridicaByTelephone.setString(4, alternateNumber);
        ResultSet rs = this.getPersJuridicaByTelephone.executeQuery();
        while (rs.next()) {
            ClientPersJuridica toadd = this.getPersJuridicaFromRS(rs);
            result.add(toadd);
        }
        rs.close();
        return result;
    }

    private ClientPersFizica getPersFizicaFromRS(ResultSet rs) throws SQLException {
        ClientPersFizica cp = new ClientPersFizica(rs.getInt("idClient"), rs.getInt("idPersFizica"), rs.getInt("idBuletin"), rs.getInt("idPasaport"), rs.getString("prenume"), rs.getString("nume"), rs.getString("oras"), rs.getString("adresa"), rs.getInt("idTara"), rs.getInt("idPersJuridica"), rs.getString("telefon_fix"), rs.getString("fax"), rs.getString("telefon_mobil"), rs.getString("email"), rs.getString("pagina_web"), rs.getString("locul_nasterii"), rs.getString("cetatenie"), rs.getString("nationalitate"), rs.getDate("data_nasterii"), rs.getTimestamp("last_updated"));
        cp.setStatus(rs.getInt("status"));
        cp.setCodSyncPersFizica(rs.getString("cod_sync_pf"));
        cp.setCodSyncClient(rs.getString("cod_sync_client"));
        cp.setDataNumelui(rs.getDate("data_numelui"));
        cp.setObservatii(rs.getString("observatii"));
        return cp;
    }

    public int addPassport(String seria, java.util.Date eliberat, java.util.Date expira, String tipAct) throws SQLException {
        this.addPassport.setString(1, seria);
        if (eliberat != null) {
            this.addPassport.setTimestamp(2, new Timestamp(eliberat.getTime()));
        } else {
            this.addPassport.setNull(2, 93);
        }
        if (expira != null) {
            this.addPassport.setTimestamp(3, new Timestamp(expira.getTime()));
        } else {
            this.addPassport.setNull(3, 93);
        }
        this.addPassport.setString(4, tipAct);
        this.addPassport.execute();
        int result = -1;
        ResultSet generatedKeys = this.addPassport.getGeneratedKeys();
        if (generatedKeys.next()) {
            result = generatedKeys.getInt(1);
        }
        generatedKeys.close();
        return result;
    }

    public void deletePassport(int id) throws SQLException {
        this.deletePassport.setInt(1, id);
        this.deletePassport.execute();
    }

    public void updatePassport(AltAct pas) throws SQLException {
        this.updatePassport.setString(1, pas.getSeria());
        if (pas.getDataEliberarii() != null) {
            this.updatePassport.setDate(2, new Date(pas.getDataEliberarii().getTime()));
        } else {
            this.updatePassport.setNull(2, 91);
        }
        if (pas.getDataExpirarii() != null) {
            this.updatePassport.setDate(3, new Date(pas.getDataExpirarii().getTime()));
        } else {
            this.updatePassport.setNull(3, 91);
        }
        this.updatePassport.setString(4, pas.getTipAct());
        this.updatePassport.setInt(5, pas.getId());
        this.updatePassport.execute();
    }

    public int addBiCi(String seria, String cnp, String nr, String sectia, java.util.Date eliberat, java.util.Date expira) throws SQLException {
        this.addBiCi.setString(1, cnp);
        this.addBiCi.setString(2, seria);
        this.addBiCi.setString(3, nr);
        this.addBiCi.setString(4, sectia);
        if (eliberat != null) {
            this.addBiCi.setTimestamp(5, new Timestamp(eliberat.getTime()));
        } else {
            this.addBiCi.setNull(5, 93);
        }
        if (expira != null) {
            this.addBiCi.setTimestamp(6, new Timestamp(expira.getTime()));
        } else {
            this.addBiCi.setNull(6, 93);
        }
        this.addBiCi.execute();
        int result = -1;
        ResultSet generatedKeys = this.addBiCi.getGeneratedKeys();
        if (generatedKeys.next()) {
            result = generatedKeys.getInt(1);
        }
        generatedKeys.close();
        return result;
    }

    public void deleteBiCi(int id) throws SQLException {
        this.deleteBiCi.setInt(1, id);
        this.deleteBiCi.execute();
    }

    public void updateBiCi(BiCi bi) throws SQLException {
        this.updateBiCi.setString(1, bi.getCnp());
        this.updateBiCi.setString(2, bi.getSeria());
        this.updateBiCi.setString(3, bi.getNumarul());
        this.updateBiCi.setString(4, bi.getSectia());
        if (bi.getDataEliberarii() != null) {
            this.updateBiCi.setDate(5, new Date(bi.getDataEliberarii().getTime()));
        } else {
            this.updateBiCi.setNull(5, 91);
        }
        if (bi.getDataExpirarii() != null) {
            this.updateBiCi.setDate(6, new Date(bi.getDataExpirarii().getTime()));
        } else {
            this.updateBiCi.setNull(6, 91);
        }
        this.updateBiCi.setInt(7, bi.getId());
        this.updateBiCi.execute();
    }

    public int addClientPersFizica(ClientPersFizica toAdd) throws SQLException {
        Integer result = -1;
        this.addClientPersFizica.setString(1, toAdd.getFirstname());
        this.addClientPersFizica.setString(2, toAdd.getLastname());
        this.addClientPersFizica.setString(3, toAdd.getAddress1());
        this.addClientPersFizica.setString(4, toAdd.getCity());
        this.addClientPersFizica.setInt(5, toAdd.getIdCountry());
        this.addClientPersFizica.setInt(6, toAdd.getIdPassport());
        this.addClientPersFizica.setInt(7, toAdd.getIdBuletin());
        if (toAdd.getIdPersJuridica() == -1) {
            this.addClientPersFizica.setNull(8, 4);
        } else {
            this.addClientPersFizica.setInt(8, toAdd.getIdPersJuridica());
        }
        this.addClientPersFizica.setString(9, toAdd.getTelefonFix());
        this.addClientPersFizica.setString(10, toAdd.getFax());
        this.addClientPersFizica.setString(11, toAdd.getTelefonMobil());
        this.addClientPersFizica.setString(12, toAdd.getEmail());
        this.addClientPersFizica.setString(13, toAdd.getPaginaWeb());
        this.addClientPersFizica.setString(14, toAdd.getLoculNasterii());
        this.addClientPersFizica.setString(15, toAdd.getCetatenie());
        this.addClientPersFizica.setString(16, toAdd.getNationalitate());
        this.addClientPersFizica.setDate(17, new Date(toAdd.getDataNasterii().getTime()));
        this.addClientPersFizica.setDate(18, new Date(toAdd.getDataNumelui().getTime()));
        this.addClientPersFizica.setString(19, toAdd.getObservatii());
        this.addClientPersFizica.execute();
        ResultSet generatedKeys = this.addClientPersFizica.getGeneratedKeys();
        if (generatedKeys.next()) {
            result = generatedKeys.getInt(1);
        }
        generatedKeys.close();
        return result;
    }

    public void deleteClientPersFizica(int id) throws SQLException {
        this.deletePersFizica.setInt(1, id);
        this.deletePersFizica.execute();
    }

    public AltAct getAltActById(int id) throws SQLException {
        AltAct result = null;
        this.getPasaportById.setInt(1, id);
        ResultSet rs = this.getPasaportById.executeQuery();
        if (rs.next()) {
            result = this.getAltActFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    private AltAct getAltActFromResultSet(ResultSet rs) throws SQLException {
        Date expira;
        AltAct result = new AltAct(rs.getInt("id"), rs.getString("seria"), rs.getString("tip_act"));
        Date eliberat = rs.getDate("eliberat_la");
        if (eliberat != null) {
            result.setDataEliberarii(new java.util.Date(eliberat.getTime()));
        }
        if ((expira = rs.getDate("expira_la")) != null) {
            result.setDataExpirarii(new java.util.Date(expira.getTime()));
        }
        result.setCodSync(rs.getString("cod_sync"));
        return result;
    }

    public BiCi getBiCiById(int id) throws SQLException {
        BiCi result = null;
        this.getBiCiById.setInt(1, id);
        ResultSet rs = this.getBiCiById.executeQuery();
        if (rs.next()) {
            result = this.getBiCiFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    private BiCi getBiCiFromResultSet(ResultSet rs) throws SQLException {
        Date expira;
        BiCi result = new BiCi(rs.getInt("id"), rs.getString("seria"), rs.getString("cnp"), rs.getString("numarul"), rs.getString("sectia"));
        Date eliberat = rs.getDate("eliberat_la");
        if (eliberat != null) {
            result.setDataEliberarii(new java.util.Date(eliberat.getTime()));
        }
        if ((expira = rs.getDate("expira_la")) != null) {
            result.setDataExpirarii(new java.util.Date(expira.getTime()));
        }
        result.setCodSync(rs.getString("cod_sync"));
        return result;
    }

    public Integer addClientPersJuridica(ClientPersJuridica toAdd) throws SQLException {
        Integer result = null;
        this.addClientPersJuridica.setString(1, toAdd.getCompanyName());
        this.addClientPersJuridica.setString(2, toAdd.getCui());
        this.addClientPersJuridica.setString(3, toAdd.getJ());
        this.addClientPersJuridica.setString(4, toAdd.getAddress1());
        this.addClientPersJuridica.setString(5, toAdd.getCity());
        this.addClientPersJuridica.setInt(6, toAdd.getIdCountry());
        this.addClientPersJuridica.setString(7, toAdd.getBank());
        this.addClientPersJuridica.setString(8, toAdd.getBankIban());
        this.addClientPersJuridica.setInt(9, toAdd.getLegalReprezentativeId());
        this.addClientPersJuridica.setString(10, toAdd.getPunctDeLucru());
        this.addClientPersJuridica.setString(11, toAdd.getTelefonFix());
        this.addClientPersJuridica.setString(12, toAdd.getFax());
        this.addClientPersJuridica.setString(13, toAdd.getTelefonMobil());
        this.addClientPersJuridica.setString(14, toAdd.getEmail());
        this.addClientPersJuridica.setString(15, toAdd.getPaginaWeb());
        this.addClientPersJuridica.setString(16, toAdd.getPersoanaContact());
        this.addClientPersJuridica.setDouble(17, toAdd.getGarantie());
        int idAgent = toAdd.getIdAgent();
        if (idAgent == -1) {
            this.addClientPersJuridica.setNull(18, 4);
        } else {
            this.addClientPersJuridica.setInt(18, idAgent);
        }
        this.addClientPersJuridica.setString(19, toAdd.getObservatii());
        this.addClientPersJuridica.setInt(20, toAdd.getNrZileScadenta());
        this.addClientPersJuridica.setDouble(21, toAdd.getCredit());
        this.addClientPersJuridica.setString(22, toAdd.getCodFurnizor());
        this.addClientPersJuridica.setString(23, toAdd.getCodClient());
        this.addClientPersJuridica.setString(24, toAdd.getAnaliticFurnizor());
        this.addClientPersJuridica.setString(25, toAdd.getAnaliticClient());
        this.addClientPersJuridica.setString(26, toAdd.getAlias());
        this.addClientPersJuridica.execute();
        ResultSet generatedKeys = this.addClientPersJuridica.getGeneratedKeys();
        if (generatedKeys.next()) {
            result = generatedKeys.getInt(1);
        }
        generatedKeys.close();
        return result;
    }

    public void deleteClientPersJuridica(int id) throws SQLException {
        this.deletePersJuridica.setInt(1, id);
        this.deletePersJuridica.execute();
    }

    public Vector<ClientPersJuridica> getAllPersoaneJuridice() throws SQLException {
        Vector<ClientPersJuridica> result = new Vector<ClientPersJuridica>();
        ResultSet rs = this.selectAllPersJuridice.executeQuery();
        while (rs.next()) {
            ClientPersJuridica toAdd = this.getPersJuridicaFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector<ClientPersJuridica> getAllPersoaneJuridiceInGrup(int idGrup, int status) throws SQLException {
        Vector<ClientPersJuridica> result = new Vector<ClientPersJuridica>();
        this.selectAllPersJuridiceInGroup.setInt(1, idGrup);
        this.selectAllPersJuridiceInGroup.setInt(2, idGrup);
        this.selectAllPersJuridiceInGroup.setInt(3, status);
        this.selectAllPersJuridiceInGroup.setInt(4, status);
        ResultSet rs = this.selectAllPersJuridiceInGroup.executeQuery();
        while (rs.next()) {
            ClientPersJuridica toAdd = this.getPersJuridicaFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public ClientPersJuridica getPersJuridicaById(int id) throws SQLException {
        ClientPersJuridica result = null;
        this.getPersJuridicaById.setInt(1, id);
        ResultSet rs = this.getPersJuridicaById.executeQuery();
        if (rs.next()) {
            result = this.getPersJuridicaFromRS(rs);
        }
        rs.close();
        return result;
    }

    private ClientPersJuridica getPersJuridicaFromRS(ResultSet rs) throws SQLException {
        ClientPersJuridica pj = new ClientPersJuridica(rs.getInt("idClient"), rs.getInt("idPersJuridica"), rs.getString("nume"), rs.getString("cui"), rs.getString("j"), rs.getString("adresa"), rs.getString("oras"), rs.getString("banca"), rs.getString("iban"), rs.getInt("idTara"), rs.getString("punct_lucru"), rs.getString("telefon_fix"), rs.getString("fax"), rs.getString("telefon_mobil"), rs.getString("email"), rs.getString("pagina_web"), rs.getString("persoana_contact"), rs.getDouble("garantie"), rs.getInt("id_agent"), rs.getString("observatii"), rs.getInt("nr_zile_scadenta"), rs.getDouble("credit"), rs.getString("cod_extern_furnizor"), rs.getString("cod_extern_client"), rs.getString("analitic_furnizor"), rs.getString("analitic_client"), rs.getString("alias"), rs.getTimestamp("last_updated"));
        pj.setStatus(rs.getInt("status"));
        pj.setCodSyncClient(rs.getString("cod_sync_client"));
        return pj;
    }

    public void updatePersJuridica(ClientPersJuridica toUpdate) throws SQLException {
        this.updatePersJuridica.setString(1, toUpdate.getCompanyName());
        this.updatePersJuridica.setString(2, toUpdate.getCui());
        this.updatePersJuridica.setString(3, toUpdate.getJ());
        this.updatePersJuridica.setString(4, toUpdate.getAddress1());
        this.updatePersJuridica.setString(5, toUpdate.getCity());
        this.updatePersJuridica.setString(6, toUpdate.getBank());
        this.updatePersJuridica.setString(7, toUpdate.getBankIban());
        this.updatePersJuridica.setInt(8, toUpdate.getLegalReprezentativeId());
        this.updatePersJuridica.setInt(9, toUpdate.getIdCountry());
        this.updatePersJuridica.setString(10, toUpdate.getPunctDeLucru());
        this.updatePersJuridica.setString(11, toUpdate.getTelefonFix());
        this.updatePersJuridica.setString(12, toUpdate.getFax());
        this.updatePersJuridica.setString(13, toUpdate.getTelefonMobil());
        this.updatePersJuridica.setString(14, toUpdate.getEmail());
        this.updatePersJuridica.setString(15, toUpdate.getPaginaWeb());
        this.updatePersJuridica.setString(16, toUpdate.getPersoanaContact());
        this.updatePersJuridica.setDouble(17, toUpdate.getGarantie());
        int idAgent = toUpdate.getIdAgent();
        if (idAgent == -1) {
            this.updatePersJuridica.setNull(18, 4);
        } else {
            this.updatePersJuridica.setInt(18, idAgent);
        }
        this.updatePersJuridica.setString(19, toUpdate.getObservatii());
        this.updatePersJuridica.setInt(20, toUpdate.getNrZileScadenta());
        this.updatePersJuridica.setDouble(21, toUpdate.getCredit());
        this.updatePersJuridica.setString(22, toUpdate.getCodFurnizor());
        this.updatePersJuridica.setString(23, toUpdate.getCodClient());
        this.updatePersJuridica.setString(24, toUpdate.getAnaliticFurnizor());
        this.updatePersJuridica.setString(25, toUpdate.getAnaliticClient());
        this.updatePersJuridica.setString(26, toUpdate.getAlias());
        this.updatePersJuridica.setInt(27, toUpdate.getIdPersJuridica());
        this.updatePersJuridica.execute();
        this.setLastUpdatedForClient.setInt(1, toUpdate.getId());
        this.setLastUpdatedForClient.execute();
    }

    public void updatePersFizice(ClientPersFizica client) throws SQLException {
        this.updatePersFizica.setString(1, client.getLastname());
        this.updatePersFizica.setString(2, client.getFirstname());
        this.updatePersFizica.setString(3, client.getAddress1());
        this.updatePersFizica.setString(4, client.getCity());
        this.updatePersFizica.setInt(5, client.getIdCountry());
        this.updatePersFizica.setInt(6, client.getIdPassport());
        this.updatePersFizica.setInt(7, client.getIdBuletin());
        if (client.getIdPersJuridica() == -1) {
            this.updatePersFizica.setNull(8, 4);
        } else {
            this.updatePersFizica.setInt(8, client.getIdPersJuridica());
        }
        this.updatePersFizica.setString(9, client.getTelefonFix());
        this.updatePersFizica.setString(10, client.getFax());
        this.updatePersFizica.setString(11, client.getTelefonMobil());
        this.updatePersFizica.setString(12, client.getEmail());
        this.updatePersFizica.setString(13, client.getPaginaWeb());
        this.updatePersFizica.setString(14, client.getLoculNasterii());
        this.updatePersFizica.setString(15, client.getCetatenie());
        this.updatePersFizica.setString(16, client.getNationalitate());
        this.updatePersFizica.setDate(17, new Date(client.getDataNasterii().getTime()));
        this.updatePersFizica.setDate(18, new Date(client.getDataNumelui().getTime()));
        this.updatePersFizica.setString(19, client.getObservatii());
        this.updatePersFizica.setInt(20, client.getIdPersFizica());
        this.updatePersFizica.execute();
        this.setLastUpdatedForClient.setInt(1, client.getId());
        this.setLastUpdatedForClient.execute();
    }

    public void setLastUpdatedForClient(int idClient) throws SQLException {
        this.setLastUpdatedForClient.setInt(1, idClient);
        this.setLastUpdatedForClient.execute();
    }

    public void updateExternalIdForPersFizica(int idPersFizica, int externalId) throws SQLException {
        this.setExternalIdForPersFizica.setInt(1, externalId);
        this.setExternalIdForPersFizica.setInt(2, idPersFizica);
        this.setExternalIdForPersFizica.execute();
    }

    public int getMaxExternalIdForPersFizica() throws SQLException {
        int result = 0;
        ResultSet rs = this.getMaxExternalIdForPersFizica.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void updatePersFizicaPicture(int idPersFizica, int idFile) throws SQLException {
        this.deletePictureForPersFizica.setInt(1, idPersFizica);
        this.deletePictureForPersFizica.execute();
        this.setPictureForPersFizica.setInt(1, idFile);
        this.setPictureForPersFizica.setInt(2, idPersFizica);
        this.setPictureForPersFizica.execute();
    }

    public int getPictureForPersFizica(int idPersFizica) throws SQLException {
        int result = -1;
        this.getPictureForPersFizica.setInt(1, idPersFizica);
        ResultSet rs = this.getPictureForPersFizica.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id_file");
        }
        rs.close();
        return result;
    }

    public int getIdGrupByKey(String key) throws SQLException {
        int result = -1;
        this.getIdGroupByKey.setString(1, key);
        ResultSet rs = this.getIdGroupByKey.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void addFileToCLient(int idClient, int idFile, String categorieDocument) throws SQLException {
        this.addDocumentToClient.setString(1, categorieDocument);
        this.addDocumentToClient.setInt(2, idClient);
        this.addDocumentToClient.setInt(3, idFile);
        this.addDocumentToClient.execute();
    }

    public Vector getFilesForClient(int idClient) throws SQLException {
        Vector<DocumenteClient> result = new Vector<DocumenteClient>();
        this.getFilesForClient.setInt(1, idClient);
        ResultSet rs = this.getFilesForClient.executeQuery();
        while (rs.next()) {
            DocumenteClient dc = new DocumenteClient();
            dc.setTitle(rs.getString("title"));
            dc.setIdFile(rs.getInt("id_file"));
            dc.setData(rs.getTimestamp("dateadd"));
            dc.setCategorieDocument(rs.getString("categorie_document"));
            result.add(dc);
        }
        rs.close();
        return result;
    }

    public void addClientFollowUp(Timestamp scheduled, String scop, int idClient) throws SQLException {
        this.addClientFollowup.setTimestamp(1, scheduled);
        this.addClientFollowup.setString(2, scop);
        this.addClientFollowup.setInt(3, idClient);
        this.addClientFollowup.execute();
    }

    public Vector getClientFollowUp(int idClient, Timestamp start, Timestamp stop) throws SQLException {
        Vector<ClientFollowupReportEntry> result = new Vector<ClientFollowupReportEntry>();
        this.getClientFollowup.setInt(1, idClient);
        this.getClientFollowup.setInt(2, idClient);
        this.getClientFollowup.setTimestamp(3, start);
        this.getClientFollowup.setTimestamp(4, stop);
        ResultSet rs = this.getClientFollowup.executeQuery();
        while (rs.next()) {
            ClientFollowupReportEntry cfu = new ClientFollowupReportEntry();
            cfu.setIdClient(rs.getInt("id_client"));
            cfu.setId(rs.getInt("id"));
            cfu.setScheduled(rs.getTimestamp("scheduled"));
            cfu.setScop(rs.getString("scopul_declarat"));
            result.add(cfu);
        }
        rs.close();
        return result;
    }

    public TranzactieContClient getTranzactieById(int id) throws SQLException {
        TranzactieContClient result = null;
        this.getTranzactieById.setInt(1, id);
        ResultSet rs = this.getTranzactieById.executeQuery();
        if (rs.next()) {
            result = this.getTranzactieFromRs(rs);
        }
        rs.close();
        return result;
    }

    public TranzactieContClient getTranzactieByCodSync(String codSync) throws SQLException {
        TranzactieContClient result = null;
        this.getTranzactieByCodSync.setString(1, codSync);
        ResultSet rs = this.getTranzactieByCodSync.executeQuery();
        if (rs.next()) {
            result = this.getTranzactieFromRs(rs);
        }
        rs.close();
        return result;
    }

    private TranzactieContClient getTranzactieFromRs(ResultSet rs) throws SQLException {
        TranzactieContClient result = new TranzactieContClient();
        result.setId(rs.getInt("id"));
        result.setTipCont(rs.getInt("tip_cont"));
        result.setIdClient(rs.getInt("id_client"));
        result.setData(rs.getTimestamp("data"));
        result.setValoare(rs.getDouble("valoare"));
        result.setDetalii(rs.getString("detalii"));
        result.setCodSync(rs.getString("cod_sync"));
        return result;
    }

    public void deleteTranzactieByRemoteId(String codSync) throws SQLException {
        this.deleteTranzactieByRemoteId.setString(1, codSync);
        this.deleteTranzactieByRemoteId.execute();
    }

    public void deleteTranzactieById(int id) throws SQLException {
        this.deleteTranzactieById.setInt(1, id);
        this.deleteTranzactieById.execute();
    }

    public boolean adaugaTranzactieClientRemote(int tipcont, int idclient, double valoare, String detalii, Timestamp data, String codSync) throws SQLException {
        this.adaugaTranzactieClientRemote.setInt(1, idclient);
        this.adaugaTranzactieClientRemote.setInt(2, tipcont);
        this.adaugaTranzactieClientRemote.setDouble(3, valoare);
        this.adaugaTranzactieClientRemote.setString(4, detalii);
        this.adaugaTranzactieClientRemote.setTimestamp(5, data);
        this.adaugaTranzactieClientRemote.setString(6, codSync);
        boolean result = this.adaugaTranzactieClientRemote.execute();
        return result;
    }

    public ClientPersFizica getPersFizicaByExternalId(int cod) throws SQLException {
        this.getPersFizicaByExternalId.setInt(1, cod);
        ResultSet rs = this.getPersFizicaByExternalId.executeQuery();
        ClientPersFizica c = null;
        if (rs.next()) {
            c = this.getPersFizicaFromRS(rs);
        }
        rs.close();
        return c;
    }

    public int getIdpersFizicaByIdclient(int idClient) throws SQLException {
        int result = -1;
        this.getIdpersFizicaByIdclient.setInt(1, idClient);
        ResultSet rs = this.getIdpersFizicaByIdclient.executeQuery();
        if (rs.next()) {
            result = rs.getInt("idpersfizica");
        }
        rs.close();
        return result;
    }

    public int getClientIdByCodSync(String codSync) throws SQLException {
        this.getIdAsociatCodExtern.setString(1, codSync);
        ResultSet rs = this.getIdAsociatCodExtern.executeQuery();
        int result = -1;
        if (rs.next()) {
            result = rs.getInt("id");
        }
        rs.close();
        return result;
    }

    public void setCodSyncClient(int idClient, String codSync) throws SQLException {
        this.setCodSyncClient.setString(1, codSync);
        this.setCodSyncClient.setInt(2, idClient);
        this.setCodSyncClient.executeUpdate();
    }

    public void setCodSyncPersFizica(int idPersFizica, String codSync) throws SQLException {
        this.setCodSyncPersFizica.setString(1, codSync);
        this.setCodSyncPersFizica.setInt(2, idPersFizica);
        this.setCodSyncPersFizica.executeUpdate();
    }

    public void setCodSyncPersJuridica(int idPersJuridica, String codSync) throws SQLException {
        this.setCodSyncPersJuridica.setString(1, codSync);
        this.setCodSyncPersJuridica.setInt(2, idPersJuridica);
        this.setCodSyncPersJuridica.executeUpdate();
    }

    public ClientPersFizica getPersFizicaByCodSync(String codSync) throws SQLException {
        ClientPersFizica result = null;
        this.getPersFizicaByCodSync.setString(1, codSync);
        ResultSet rs = this.getPersFizicaByCodSync.executeQuery();
        if (rs.next()) {
            result = this.getPersFizicaFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Client getClientByCodSync(String codSync) throws SQLException {
        int idClientLocal = this.getClientIdByCodSync(codSync);
        Client c = ClientLogic.getInstance().getClientByIdNoCommit(idClientLocal);
        return c;
    }

    public boolean persFizicaExists(String nume, String prenume, Date dataNasterii) throws SQLException {
        this.persFizicaExists.setString(1, nume);
        this.persFizicaExists.setString(2, prenume);
        this.persFizicaExists.setDate(3, dataNasterii);
        ResultSet rs = this.persFizicaExists.executeQuery();
        boolean result = false;
        if (rs.next()) {
            result = true;
        }
        rs.close();
        return result;
    }

    public boolean isClientInActiveLocations(int idClient) throws SQLException {
        boolean result = false;
        this.isClientInActiveLocations.setInt(1, idClient);
        ResultSet rs = this.isClientInActiveLocations.executeQuery();
        if (rs.next()) {
            result = true;
        }
        rs.close();
        return result;
    }

    public ClientsLocationsBean getClientLocationsMappingByCodSync(String codSync) throws SQLException {
        ClientsLocationsBean result = null;
        this.getLocatiiClientiMappingByCodSync.setString(1, codSync);
        ResultSet rs = this.getLocatiiClientiMappingByCodSync.executeQuery();
        if (rs.next()) {
            result = this.getClientLocationMappingFromRs(rs);
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, ClientsLocationsBean> getClientLocationsMappingByIdLocatie(int idLocatie) throws SQLException {
        Hashtable<Integer, ClientsLocationsBean> result = new Hashtable<Integer, ClientsLocationsBean>();
        this.getLocatiiClientiMappingByIdLocatie.setInt(1, idLocatie);
        ResultSet rs = this.getLocatiiClientiMappingByIdLocatie.executeQuery();
        while (rs.next()) {
            ClientsLocationsBean bean = this.getClientLocationMappingFromRs(rs);
            result.put(bean.getIdClient(), bean);
        }
        rs.close();
        return result;
    }

    public ClientsLocationsBean getClientLocationMappingById(int id) throws SQLException {
        ClientsLocationsBean result = null;
        this.getLocatiiClientiMappingById.setInt(1, id);
        ResultSet rs = this.getLocatiiClientiMappingById.executeQuery();
        if (rs.next()) {
            result = this.getClientLocationMappingFromRs(rs);
        }
        rs.close();
        return result;
    }

    private ClientsLocationsBean getClientLocationMappingFromRs(ResultSet rs) throws SQLException {
        ClientsLocationsBean result = new ClientsLocationsBean();
        result.setCodSync(rs.getString("cod_sync"));
        result.setId(rs.getInt("id"));
        result.setIdClient(rs.getInt("id_client"));
        result.setIdLocation(rs.getInt("id_locatie"));
        return result;
    }

    public int addClientLocationsMapping(int idLocation, int idClient) throws SQLException {
        this.addLocatiiClientiMapping.setInt(1, idClient);
        if (idLocation > 0) {
            this.addLocatiiClientiMapping.setInt(2, idLocation);
        } else {
            this.addLocatiiClientiMapping.setNull(2, 4);
        }
        this.addLocatiiClientiMapping.execute();
        int result = -1;
        ResultSet rs = this.addLocatiiClientiMapping.getGeneratedKeys();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void setClientLocationsCodSync(int idMapping, String codSync) throws SQLException {
        this.updateLocatiiClientiMappingCodSync.setString(1, codSync);
        this.updateLocatiiClientiMappingCodSync.setInt(2, idMapping);
        this.updateLocatiiClientiMappingCodSync.execute();
    }

    public void addClientLocationsMappingWithSync(int idLocation, int idClient, String codSync) throws SQLException {
        this.addLocatiiClientiMappingWithSync.setInt(1, idClient);
        if (idLocation > 0) {
            this.addLocatiiClientiMappingWithSync.setInt(2, idLocation);
        } else {
            this.addLocatiiClientiMappingWithSync.setNull(2, 4);
        }
        this.addLocatiiClientiMappingWithSync.setString(3, codSync);
        this.addLocatiiClientiMappingWithSync.execute();
    }

    public void deleteClientsLocationsMappingByCodSync(String codSync) throws SQLException {
        this.deleteLocatiiClientiMappingByCodSync.setString(1, codSync);
        this.deleteLocatiiClientiMappingByCodSync.execute();
    }

    public void setCodSyncToBuletin(String codSync, Integer idBuletin) throws SQLException {
        this.setCodSyncToBiCi.setString(1, codSync);
        this.setCodSyncToBiCi.setInt(2, idBuletin);
        this.setCodSyncToBiCi.executeUpdate();
    }

    public void setCodSyncToPasaport(String codSync, Integer idPasaport) throws SQLException {
        this.setCodSyncToPasaport.setString(1, codSync);
        this.setCodSyncToPasaport.setInt(2, idPasaport);
        this.setCodSyncToPasaport.executeUpdate();
    }

    public void updateBiCiByCodSync(BiCi bi) throws SQLException {
        this.updateBiCiByCodSync.setString(1, bi.getCnp());
        this.updateBiCiByCodSync.setString(2, bi.getSeria());
        this.updateBiCiByCodSync.setString(3, bi.getNumarul());
        this.updateBiCiByCodSync.setString(4, bi.getSectia());
        if (bi.getDataEliberarii() != null) {
            this.updateBiCiByCodSync.setDate(5, new Date(bi.getDataEliberarii().getTime()));
        } else {
            this.updateBiCiByCodSync.setNull(5, 91);
        }
        if (bi.getDataExpirarii() != null) {
            this.updateBiCiByCodSync.setDate(6, new Date(bi.getDataExpirarii().getTime()));
        } else {
            this.updateBiCiByCodSync.setNull(6, 91);
        }
        this.updateBiCiByCodSync.setString(7, bi.getCodSync());
        this.updateBiCiByCodSync.execute();
    }

    public void updatePassportByCodSync(AltAct pas) throws SQLException {
        this.updatePassportByCodSync.setString(1, pas.getSeria());
        if (pas.getDataEliberarii() != null) {
            this.updatePassportByCodSync.setDate(2, new Date(pas.getDataEliberarii().getTime()));
        } else {
            this.updatePassportByCodSync.setNull(2, 91);
        }
        if (pas.getDataExpirarii() != null) {
            this.updatePassportByCodSync.setDate(3, new Date(pas.getDataExpirarii().getTime()));
        } else {
            this.updatePassportByCodSync.setNull(3, 91);
        }
        this.updatePassportByCodSync.setString(4, pas.getTipAct());
        this.updatePassportByCodSync.setString(5, pas.getCodSync());
        this.updatePassportByCodSync.execute();
    }

    public BiCi getBuletinByCodSync(String codSync) throws SQLException {
        BiCi result = null;
        this.getBuletinByCodSync.setString(1, codSync);
        ResultSet rs = this.getBuletinByCodSync.executeQuery();
        if (rs.next()) {
            result = this.getBiCiFromResultSet(rs);
        }
        return result;
    }

    public AltAct getPasaportByCodSync(String codSync) throws SQLException {
        AltAct result = null;
        this.getPasaportByCodSync.setString(1, codSync);
        ResultSet rs = this.getPasaportByCodSync.executeQuery();
        if (rs.next()) {
            result = this.getAltActFromResultSet(rs);
        }
        return result;
    }

    public void saveServletSms(Vector<SmsServletBean> smses) throws SQLException {
        for (SmsServletBean sms : smses) {
            this.saveServletSms.setString(1, sms.getMessage());
            this.saveServletSms.setString(2, sms.getDestinatar());
            this.saveServletSms.setInt(3, Constants.SMS_NOU);
            this.saveServletSms.execute();
        }
    }

    public Vector<SmsServletBean> getAllNewSms() throws SQLException {
        Vector<SmsServletBean> result = new Vector<SmsServletBean>();
        ResultSet rs = this.getAllNewSms.executeQuery();
        while (rs.next()) {
            SmsServletBean sms = this.getSmsServletBeanFromRS(rs);
            result.add(sms);
        }
        return result;
    }

    public SmsServletBean getSmsServletBeanFromRS(ResultSet rs) throws SQLException {
        SmsServletBean sms = new SmsServletBean();
        sms.setId(rs.getInt("id"));
        sms.setMessage(rs.getString("mesaj"));
        sms.setDestinatar(rs.getString("destinatar"));
        sms.setStatus(rs.getInt("status"));
        sms.setError(rs.getString("eroare"));
        return sms;
    }

    public void setStatusToServletSms(Vector<SmsServletBean> sms, Integer status) throws SQLException {
        for (SmsServletBean sm : sms) {
            this.updateSmsStatus.setInt(1, status);
            this.updateSmsStatus.setInt(2, sm.getId());
            this.updateSmsStatus.executeUpdate();
        }
    }
}

