/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ro.atreides.clienti.ClientIcon;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientNumeProvider;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class ClientPicturePanel
extends JPanel {
    private JLabel img1;
    private String newPictureFile;
    private JButton printPreview;
    private JButton print;
    private String actualPicture;
    private ClientNumeProvider parent;

    public ClientPicturePanel(ClientNumeProvider parent) {
        this.parent = parent;
        this.display();
    }

    private void setImg(ImageIcon icon) {
        this.img1.setIcon(icon);
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 2;
        ClientIcon img2 = ClientLogic.getInstance().loadIcon(-1);
        ImageIcon icon = img2.getIcon();
        this.img1 = new JLabel();
        this.add((Component)this.img1, c);
        this.setImg(img2.getIcon());
        final JFrame panel = GuiUtils.currentFrame;
        c.fill = 0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.printPreview = new JButton("Preview card");
        this.printPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ClientPicturePanel.this.parent == null) {
                    return;
                }
                String nume = ClientPicturePanel.this.parent.getNumeClient();
                if (Validators.correctString(nume)) {
                    if (ClientPicturePanel.this.newPictureFile == null) {
                        ClientLogic.getInstance().previewCardClient(ClientPicturePanel.this.actualPicture, nume);
                    } else {
                        ClientLogic.getInstance().previewCardClient(ClientPicturePanel.this.newPictureFile, nume);
                    }
                } else {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Nume client incorect", LangRoAll.nuPotContinua);
                }
            }
        });
        this.add((Component)this.printPreview, c);
        this.printPreview.setFocusable(false);
        ++c.gridx;
        this.print = new JButton("Print card");
        this.print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ClientPicturePanel.this.parent == null) {
                    return;
                }
                String nume = ClientPicturePanel.this.parent.getNumeClient();
                if (Validators.correctString(nume)) {
                    if (DialogUtils.confirmDialog(panel, "Tiparim card", LangRoAll.confirmare)) {
                        if (ClientPicturePanel.this.newPictureFile == null) {
                            ClientLogic.getInstance().printCardClient(ClientPicturePanel.this.actualPicture, nume);
                        } else {
                            ClientLogic.getInstance().printCardClient(ClientPicturePanel.this.newPictureFile, nume);
                        }
                    }
                } else {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Nume client incorect", LangRoAll.nuPotContinua);
                }
            }
        });
        this.add((Component)this.print, c);
        this.print.setFocusable(false);
        this.setBorder(new TitledBorder("Poza - click pentru a schimba"));
    }

    public void reload(int idPersFizica) {
        ClientIcon icon = ClientLogic.getInstance().loadIcon(idPersFizica);
        this.setImg(icon.getIcon());
        this.newPictureFile = null;
        this.actualPicture = icon.getFullPath();
        if (this.actualPicture == null) {
            this.actualPicture = "";
        }
    }

    public void reload(String absolutePath) {
        String extensie = ".jpg";
        int extPoint = absolutePath.lastIndexOf(".");
        if (extPoint > 0) {
            extensie = absolutePath.substring(extPoint);
        }
        String now = Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date());
        String outputFile = FileUtils.getTempDir() + File.separator + now + extensie;
        try {
            FileUtils.copyFiles(new FileInputStream(absolutePath), new FileOutputStream(outputFile));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        ImageIcon img2 = Utils.getImageFromDiskAbsolutePath(outputFile, 320, 240);
        this.img1.setIcon(img2);
        this.newPictureFile = absolutePath;
    }

    public String getNewPictureFile() {
        return this.newPictureFile;
    }
}

