/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.gui.ComboUtils;

public class FinanciarePanel
extends JPanel {
    private JTextField observatii;
    private JTextField nrZileScadenta;
    private JTextField credit;
    private JTextField garantie;
    private JComboBox agenti;

    public FinanciarePanel() {
        this.display();
    }

    public void resetFields() {
        this.observatii.setText("");
        this.nrZileScadenta.setText("");
        this.credit.setText("");
        this.garantie.setText("");
        this.agenti.setSelectedIndex(0);
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        this.add((Component)new JLabel("Agentul"), c);
        ++c.gridx;
        this.agenti = new JComboBox();
        this.add((Component)this.agenti, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Zile scadenta"), c);
        ++c.gridx;
        this.nrZileScadenta = new JTextField("");
        this.add((Component)this.nrZileScadenta, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Credit"), c);
        ++c.gridx;
        this.credit = new JTextField("");
        this.add((Component)this.credit, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Observatii"), c);
        ++c.gridx;
        this.observatii = new JTextField("");
        this.add((Component)this.observatii, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Garantie"), c);
        ++c.gridx;
        this.garantie = new JTextField("");
        this.add((Component)this.garantie, c);
        Vector<User> users = UsersLogic.getInstance().getUsersInGroup("group_agenti");
        ComboUtils.replaceItemsForCombo(this.agenti, users);
        this.setBorder(new TitledBorder("Financiare"));
    }

    public void setIdAgent(int idAgent) {
        User u = UsersLogic.getInstance().getUserById(idAgent);
        if (u != null) {
            this.agenti.setSelectedItem(u);
        } else {
            this.agenti.setSelectedIndex(0);
        }
    }

    public int getIdAgent() {
        int idAgent = -1;
        if (ComboUtils.anythingButAllSelected(this.agenti)) {
            User u = (User)this.agenti.getSelectedItem();
            idAgent = u.getId();
        }
        return idAgent;
    }

    public void setGarantie(String toSet) {
        this.garantie.setText(toSet);
    }

    public String getGarantie() {
        return this.garantie.getText();
    }

    public String getCredit() {
        return this.credit.getText();
    }

    public void setCredit(String credit) {
        this.credit.setText(credit);
    }

    public String getNrZileScadenta() {
        return this.nrZileScadenta.getText();
    }

    public void setNrZileScadenta(String nrZileScadenta) {
        this.nrZileScadenta.setText(nrZileScadenta);
    }

    public String getObservatii() {
        return this.observatii.getText();
    }

    public void setObservatii(String observatii) {
        this.observatii.setText(observatii);
    }
}

