/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.FisaClient;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class FisaClientReport
extends AbstractReportPanel {
    public static final String[] columns = new String[]{LangRoAll.data, "Credit", "Debit", LangRoAll.detalii, "Sold"};
    private ReportInterface reportInterface;
    private JComboBox clienti;
    private JComboBox tipCont;
    private Hashtable printCriteria = new Hashtable();
    private JLabel soldInitialLabel;
    private JLabel soldFinalLabel;
    private JLabel creditLabel;
    private JLabel debitLabel;
    private double soldInitial;
    private double soldFinal;
    private double credit;
    private double debit;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Client c2 = (Client)this.clienti.getSelectedItem();
        result.put(Constants.CLIENT_KEY, Integer.valueOf(c2.getId()));
        this.printCriteria.put(Constants.CLIENT_KEY, c2.toString());
        TipCont tc = (TipCont)this.tipCont.getSelectedItem();
        result.put("tip_cont", Integer.valueOf(tc.getId()));
        this.printCriteria.put(LangRoAll.tipCont, tc.toString());
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ClientLogic.getInstance().getFisaClient(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    FisaClient fc = (FisaClient)o;
                    try {
                        Label label = new Label(0, row, fc.getData());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(1, row, fc.getCredit()));
                        sheet.addCell((WritableCell)new Number(2, row, fc.getDebit()));
                        Label label2 = new Label(3, row, fc.getDetalii());
                        sheet.addCell((WritableCell)label2);
                        sheet.addCell((WritableCell)new Number(4, row, fc.getSoldActual()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return FisaClientReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Fisa client";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FisaClient fc = (FisaClient)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fc.getData();
                    }
                    case 1: {
                        return Utils.getString2Decimals(fc.getCredit());
                    }
                    case 2: {
                        return Utils.getString2Decimals(fc.getDebit());
                    }
                    case 3: {
                        return fc.getDetalii();
                    }
                    case 4: {
                        return Utils.getString2Decimals(fc.getSoldActual());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Sold initial"), c);
        ++c.gridx;
        this.soldInitialLabel = new JLabel("");
        result.add((Component)this.soldInitialLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Credit"), c);
        ++c.gridx;
        this.creditLabel = new JLabel("");
        result.add((Component)this.creditLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Debit"), c);
        ++c.gridx;
        this.debitLabel = new JLabel("");
        result.add((Component)this.debitLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Sold final"), c);
        ++c.gridx;
        this.soldFinalLabel = new JLabel("");
        result.add((Component)this.soldFinalLabel, c);
        final FisaClientReport parent = this;
        ++c.gridx;
        JButton reglare = new JButton("Tranzactie manuala");
        reglare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client c2 = (Client)FisaClientReport.this.clienti.getSelectedItem();
                TipCont tc = (TipCont)FisaClientReport.this.tipCont.getSelectedItem();
                String valueS = DialogUtils.inputDialog(parent, "0", "Tranzactie manuala");
                if (!Validators.correctDouble(valueS)) {
                    DialogUtils.errorDialog(parent, LangRoAll.valoareIncorecta, LangRoAll.nuPotContinua);
                    return;
                }
                String detalii = DialogUtils.inputDialog(parent, "", "Detalii");
                double d = Double.valueOf(valueS);
                d = FloatUtils.roundDouble(d, 2);
                if (DialogUtils.confirmDialog(parent, "Adaugam tranzactia manuala in valoare de " + Utils.getString2Decimals(d) + " pentru " + c2 + " pe contul " + tc, LangRoAll.confirmare)) {
                    ClientLogic.getInstance().adaugaTranzactieClient(tc.getId(), c2.getId(), d, detalii);
                    DialogUtils.okDialog(parent, LangRoAll.operatieExecutata, LangRoAll.succes);
                    FisaClientReport.this.raport();
                } else {
                    DialogUtils.errorDialog(parent, LangRoAll.operatieEsuata, LangRoAll.eroare);
                }
            }
        });
        result.add((Component)reglare, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        buttonsPanel.add((Component)new JLabel("Cont"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tipCont = new JComboBox();
        buttonsPanel.add((Component)this.tipCont, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        buttonsPanel.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clienti = new JComboBox();
        buttonsPanel.add((Component)this.clienti, c);
        return buttonsPanel;
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.soldInitialLabel.setText(Utils.getString2Decimals(this.soldInitial));
        this.creditLabel.setText(Utils.getString2Decimals(this.credit));
        this.debitLabel.setText(Utils.getString2Decimals(this.debit));
        this.soldFinalLabel.setText(Utils.getString2Decimals(this.soldFinal));
    }

    private void computeTotals(Vector items) {
        this.soldInitial = 0.0;
        this.credit = 0.0;
        this.debit = 0.0;
        for (int i = 0; i < items.size(); ++i) {
            FisaClient o = (FisaClient)items.elementAt(i);
            this.credit += o.getCredit();
            this.debit += o.getDebit();
            if (i != 0) continue;
            this.soldInitial = o.getSoldActual();
        }
        this.soldFinal = this.soldInitial + this.credit - this.debit;
    }

    @Override
    public void doStuff() {
        this.refreshClienti();
        ComboUtils.replaceItemsForCombo(this.tipCont, ClientLogic.getInstance().getAllConturi(), false);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                FisaClientReport.this.refreshClienti();
            }

            @Override
            public String getName() {
                return "FisaClient_PF";
            }
        }, 41);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                FisaClientReport.this.refreshClienti();
            }

            @Override
            public String getName() {
                return "FisaClient_PJ";
            }
        }, 42);
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return 5;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getReportTitle() {
                return FisaClientReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return FisaClientReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                FisaClient fc = (FisaClient)row;
                switch (column) {
                    case 0: {
                        return fc.getData();
                    }
                    case 1: {
                        return Utils.getString2Decimals(fc.getCredit());
                    }
                    case 2: {
                        return Utils.getString2Decimals(fc.getDebit());
                    }
                    case 3: {
                        return fc.getDetalii();
                    }
                    case 4: {
                        return Utils.getString2Decimals(fc.getSoldActual());
                    }
                }
                return null;
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 1: {
                        return Utils.getString2Decimals(FisaClientReport.this.credit);
                    }
                    case 2: {
                        return Utils.getString2Decimals(FisaClientReport.this.debit);
                    }
                    case 4: {
                        return Utils.getString2Decimals(FisaClientReport.this.soldFinal);
                    }
                }
                return "";
            }
        };
        final FisaClientReport parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final FisaClient fc = (FisaClient)FisaClientReport.this.tm.getObjectAt(selRow);
                if (fc.getIdFisa() <= 0) {
                    return;
                }
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem delete = new JMenuItem(LangRoAll.sterge);
                popup.add(delete);
                popup.setInvoker(FisaClientReport.this.table);
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (VpConfig.getInstance().passwordAtStergereClient) {
                            User loggedUser = AdministrationPanel.loggedUser;
                            if (loggedUser != null) {
                                if (UsersLogic.getInstance().isUserInGroup(loggedUser.getId(), "group_manager_clienti")) {
                                    if (DialogUtils.confirmDialog(parent, "Doriti sa stergeti aceasta inregistrare", LangRoAll.confirmare)) {
                                        FisaClientReport.this.actuallyDeleteFisa(fc);
                                    }
                                } else {
                                    DialogUtils.errorDialog(parent, "Drepturi insuficiente", LangRoAll.nuPotContinua);
                                }
                            } else {
                                DialogUtils.errorDialog(parent, LangRoAll.neautentificat, LangRoAll.nuPotContinua);
                            }
                        } else {
                            FisaClientReport.this.actuallyDeleteFisa(fc);
                        }
                        popup.setVisible(false);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    private void actuallyDeleteFisa(FisaClient fc) {
        int ifFisa = fc.getIdFisa();
        ClientLogic.getInstance().deleteFisa(ifFisa);
        this.raport();
    }

    private void refreshClienti() {
        Vector<Client> c = ClientLogic.getInstance().getAllClientsSorted();
        ComboUtils.replaceItemsForCombo(this.clienti, c, false);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

