/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.gui;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientFollowupReportEntry;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.print.PrintLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class FollowUpReport
extends AbstractReportPanel {
    private ReportInterface pdfReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private static final String[] columns = new String[]{"Companie", "Angajat", "Scop", LangRoAll.data};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, String.class};

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Date> result = new Hashtable<String, Date>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        return null;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                ClientFollowupReportEntry se = (ClientFollowupReportEntry)data.elementAt(rowIndex);
                if (se == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return se.getNumeCompanie();
                    }
                    case 1: {
                        return se.getNumeAngajat();
                    }
                    case 2: {
                        return se.getScop();
                    }
                    case 3: {
                        return se.getData();
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        return null;
    }

    @Override
    public String getName() {
        return "FollowUp";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ClientLogic.getInstance().getFollowUp(criteria);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, null, this.data);
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    ClientFollowupReportEntry entry = (ClientFollowupReportEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, entry.getNumeCompanie());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, entry.getNumeAngajat());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, entry.getScop());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, entry.getData());
                        sheet.addCell((WritableCell)label);
                        ++column;
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return FollowUpReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    default: 
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    default: 
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return FollowUpReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return FollowUpReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                ClientFollowupReportEntry ie = (ClientFollowupReportEntry)row;
                if (ie == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return ie.getNumeCompanie();
                    }
                    case 1: {
                        return ie.getNumeAngajat();
                    }
                    case 2: {
                        return ie.getScop();
                    }
                    case 3: {
                        return ie.getData();
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

