/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import ro.atreides.clienti.AltAct;
import ro.atreides.clienti.BiCi;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientNumeProvider;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.PartenerGroup;
import ro.atreides.clienti.PersFizicaViewEntry;
import ro.atreides.clienti.gui.ClientPicturePanel;
import ro.atreides.clienti.gui.ClientiAddEditPanel;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Country;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.AdresaPanel;
import ro.atreides.utils.gui.BuletinPanel;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.MultiboxList;
import ro.atreides.utils.gui.NamePanel;
import ro.atreides.utils.gui.PasaportPanel;
import ro.atreides.utils.gui.PersFizicaLabelProvider;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.multilanguage.LanguageLogic;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class PersFizicaAddEditPanel
extends ClientiAddEditPanel
implements PersFizicaLabelProvider,
ClientNumeProvider {
    private ClientPersFizica client;
    private BiCi bi;
    private AltAct pasaport;
    private AdresaPanel adresaPanel;
    private NamePanel namePanel;
    private BuletinPanel buletinPanel;
    private PasaportPanel pasaportPanel;
    private ClientPicturePanel picturePanel;
    private int newClientId;
    private String newClientName;
    private MultiboxList multiBoxGroup;
    private JTextArea observatii;
    public static final int CNP_LENGTH = 13;
    private final Component parent = this;

    public boolean isShowAltActPanel() {
        return true;
    }

    public boolean isShowBuletinPanel() {
        return true;
    }

    public boolean isShowGrupuriPanel() {
        return true;
    }

    public boolean isShowPicturePanel() {
        return true;
    }

    @Override
    public boolean showCetatenie() {
        return true;
    }

    @Override
    public boolean showPrenume() {
        return true;
    }

    @Override
    public boolean showWeb() {
        return true;
    }

    @Override
    public boolean showLoculNasterii() {
        return true;
    }

    @Override
    public boolean showNationalitate() {
        return true;
    }

    @Override
    public JPanel buildContentPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.weighty = 0.8;
        c.gridheight = 3;
        this.namePanel = new NamePanel(this);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)this.namePanel, c);
        this.logic = ClientLogic.getInstance();
        ComboUtils.replaceItemsForCombo(this.namePanel.getPersJuridiceCombo(), this.logic.getAllPersJuridiceSorted());
        this.logic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(PersFizicaAddEditPanel.this.namePanel.getPersJuridiceCombo(), PersFizicaAddEditPanel.this.logic.getAllPersJuridiceSorted());
            }

            @Override
            public String getName() {
                return "PersFizicaAddEdit_persJuridice";
            }
        }, 42);
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridy = 0;
        c.gridx = 1;
        JPanel groupsPanel = this.getGrupPanel();
        if (this.isShowGrupuriPanel()) {
            result.add((Component)groupsPanel, c);
        }
        c.weighty = 0.0;
        c.gridy = 1;
        c.gridx = 1;
        this.adresaPanel = new AdresaPanel();
        final LanguageLogic langLogic = LanguageLogic.getInstance();
        this.adresaPanel.setCountries(langLogic.getAllCountries());
        langLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                PersFizicaAddEditPanel.this.adresaPanel.setCountries(langLogic.getAllCountries());
            }

            @Override
            public String getName() {
                return "PersFizicaAddEditPanelCountries";
            }
        }, 43);
        result.add((Component)this.adresaPanel, c);
        final PersFizicaAddEditPanel parent = this;
        c.gridy = 2;
        c.gridx = 1;
        c.weighty = 0.1;
        JTabbedPane tabbedPane = new JTabbedPane();
        this.observatii = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.observatii);
        this.picturePanel = new ClientPicturePanel(this);
        if (this.isShowPicturePanel()) {
            tabbedPane.add((Component)scrollPane, "Observatii");
            tabbedPane.add((Component)this.picturePanel, "Poza");
            result.add((Component)tabbedPane, c);
        } else {
            scrollPane.setBorder(new TitledBorder("Observatii"));
            result.add((Component)scrollPane, c);
        }
        this.picturePanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                String inputFile;
                if (DialogUtils.confirmDialog(parent, "Incarcam alta poza", LangRoAll.confirmare) && (inputFile = FileDialog.getLoadDialogLocation(parent, "Selectati poza in format jpg/png/gif", "gif,jpg,jpeg,png")) != null) {
                    PersFizicaAddEditPanel.this.picturePanel.reload(inputFile);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        c.weighty = 0.2;
        this.buletinPanel = new BuletinPanel();
        c.gridy = 3;
        c.gridx = 0;
        if (this.isShowBuletinPanel()) {
            result.add((Component)this.buletinPanel, c);
        }
        this.pasaportPanel = new PasaportPanel();
        c.gridx = 1;
        c.gridy = 3;
        if (this.isShowAltActPanel()) {
            result.add((Component)this.pasaportPanel, c);
        }
        return result;
    }

    @Override
    public String getNumeClient() {
        return this.namePanel.getNume() + " " + this.namePanel.getPrenume();
    }

    public String getNewClientName() {
        return this.newClientName;
    }

    public int getNewClientId() {
        return this.newClientId;
    }

    @Override
    public String getEmailName() {
        return "Email";
    }

    @Override
    public String getFaxName() {
        return "Fax";
    }

    @Override
    public String getPaginaWebName() {
        return "Pagina web";
    }

    @Override
    public String getTelefonMobilName() {
        return "Telefon mobil (sms)";
    }

    @Override
    public String getTelFixName() {
        return "Telefon fix (privat)";
    }

    @Override
    public String getCompanieName() {
        return "Companie";
    }

    @Override
    public String getNationalitateDefault() {
        String nationalitateDefault = Config.getInstance().getString("clientPersFizicaNationalitateDefault");
        return nationalitateDefault;
    }

    @Override
    public String getCetatenieDefault() {
        String nationalitateDefault = Config.getInstance().getString("clientPersFizicaCetatenieDefault");
        return nationalitateDefault;
    }

    private boolean verifyBiCi() {
        java.util.Date dataElib = this.buletinPanel.getDataEliberarii();
        if (dataElib == null) {
            DialogUtils.errorDialog(this, "Completati data eliberarii in formatul dat", LangRoAll.nuPotContinua);
            return false;
        }
        java.util.Date dataExp = this.buletinPanel.getDataExpirarii();
        if (dataExp == null) {
            DialogUtils.errorDialog(this, "Completati data expirarii in formatul dat", LangRoAll.nuPotContinua);
            return false;
        }
        String cnpOkString = this.logic.verifyCNP(this.buletinPanel.getCnp());
        if (cnpOkString != null) {
            DialogUtils.errorDialog(this, cnpOkString, "CNP invalid");
            this.buletinPanel.focusAndSelectCNP();
            return false;
        }
        String cnp = this.buletinPanel.getCnp();
        if (Validators.correctString(cnp)) {
            java.util.Date d = Utils.extractDateFromCNP(cnp);
            this.namePanel.setDataNasterii(d);
        } else {
            this.namePanel.setDataNasterii(new java.util.Date());
        }
        return true;
    }

    private boolean validateData() {
        boolean persFizicaExists;
        boolean one;
        if (this.namePanel.getNume() == null) {
            this.namePanel.setNume("");
        }
        if (this.namePanel.getPrenume() == null) {
            this.namePanel.setPrenume("");
        }
        boolean bl = one = (Validators.correctString(this.namePanel.getNume()) || Validators.correctString(this.namePanel.getPrenume())) && this.adresaPanel.getIdTara() != -1;
        if (!one) {
            return false;
        }
        if (this.client == null && (persFizicaExists = ClientLogic.getInstance().persFizicaExists(this.namePanel.getNume(), this.namePanel.getPrenume(), new Date(this.namePanel.getDataNasterii().getTime())))) {
            DialogUtils.errorDialog(this.parent, "Exista deja un client cu acelasi nume, prenume, data nasterii", LangRoAll.nuPotContinua);
            return false;
        }
        return true;
    }

    private void initialValues(ClientPersFizica client) {
        this.picturePanel.reload(client.getIdPersFizica());
        this.namePanel.setNume(client.getLastname());
        this.namePanel.setPrenume(client.getFirstname());
        this.namePanel.setTelFix(client.getTelefonFix());
        this.namePanel.setFax(client.getFax());
        this.namePanel.setTelMobil(client.getTelefonMobil());
        this.namePanel.setEmail(client.getEmail());
        this.namePanel.setWeb(client.getPaginaWeb());
        this.namePanel.setCetatenie(client.getCetatenie());
        this.namePanel.setNationalitate(client.getNationalitate());
        this.namePanel.setLoculNasterii(client.getLoculNasterii());
        this.namePanel.setDataNasterii(client.getDataNasterii());
        this.namePanel.setDataNumelui(client.getDataNumelui());
        int idPersJuridica = client.getIdPersJuridica();
        this.observatii.setText(client.getObservatii());
        if (idPersJuridica != -1) {
            ClientPersJuridica cpj = this.logic.getPersJuridicaById(idPersJuridica);
            this.namePanel.getPersJuridiceCombo().setSelectedItem(cpj);
        }
        this.adresaPanel.setOras(client.getCity());
        this.adresaPanel.setAdresa(client.getAddress1());
        Country c = LanguageLogic.getInstance().getCountryById(client.getIdCountry());
        this.adresaPanel.setTara(c);
        if (this.pasaport != null) {
            this.pasaportPanel.setSeria(this.pasaport.getSeria());
            this.pasaportPanel.setTipAct(this.pasaport.getTipAct());
            java.util.Date passExp = this.pasaport.getDataExpirarii();
            if (passExp != null) {
                this.pasaportPanel.setDataExpirarii(Formatters.DATE_FORMAT_RO.format(passExp));
            } else {
                this.pasaportPanel.setDataExpirarii("");
            }
            java.util.Date passElib = this.pasaport.getDataEliberarii();
            if (passElib != null) {
                this.pasaportPanel.setDataEliberarii(Formatters.DATE_FORMAT_RO.format(passElib));
            } else {
                this.pasaportPanel.setDataEliberarii("");
            }
        } else {
            this.pasaportPanel.initFields();
        }
        if (this.bi != null) {
            this.buletinPanel.setSeria(this.bi.getSeria());
            this.buletinPanel.setNumar(this.bi.getNumarul());
            this.buletinPanel.setCnp(this.bi.getCnp());
            this.buletinPanel.setSectia(this.bi.getSectia());
            java.util.Date biExp = this.bi.getDataExpirarii();
            if (biExp != null) {
                this.buletinPanel.setDataExpirarii(Formatters.DATE_FORMAT_RO.format(biExp));
            } else {
                this.buletinPanel.setDataExpirarii("");
            }
            java.util.Date biElib = this.bi.getDataEliberarii();
            if (biElib != null) {
                this.buletinPanel.setDataEliberarii(Formatters.DATE_FORMAT_RO.format(biElib));
            } else {
                this.buletinPanel.setDataEliberarii("");
            }
        } else {
            this.buletinPanel.initFields();
        }
        Vector<PartenerGroup> allItems = ClientLogic.getInstance().getParteneriGroupsForPersoaneFizice();
        this.multiBoxGroup.setSelectedItems(allItems, false);
        Vector<PartenerGroup> selectedItems = ClientLogic.getInstance().getGroupsForPartner(client.getId());
        this.multiBoxGroup.setSelectedItems(selectedItems, true);
    }

    private void clearFields() {
        this.adresaPanel.initFields();
        this.namePanel.initFields();
        this.pasaportPanel.initFields();
        this.buletinPanel.initFields();
        this.picturePanel.reload(-1);
        Vector<PartenerGroup> allItems = ClientLogic.getInstance().getParteneriGroupsForPersoaneFizice();
        this.multiBoxGroup.setSelectedItems(allItems, false);
        this.setClientSelectedGroups(allItems);
        this.observatii.setText("");
    }

    private void erase(ClientPersFizica client) {
        if (client != null) {
            this.logic.erasePersFizicaLocally(client);
        }
    }

    private void save() {
        String groups = "";
        Vector items = this.multiBoxGroup.getSelectedItems();
        for (int i = 0; i < items.size(); ++i) {
            PartenerGroup pg = (PartenerGroup)items.elementAt(i);
            groups = groups + pg.getId();
            if (i >= items.size() - 1) continue;
            groups = groups + ",";
        }
        int idPersJuridica = -1;
        JComboBox combo = this.namePanel.getPersJuridiceCombo();
        if (ComboUtils.anythingButAllSelected(combo)) {
            ClientPersJuridica cpj = (ClientPersJuridica)combo.getSelectedItem();
            idPersJuridica = cpj.getIdPersJuridica();
        }
        if (this.client != null) {
            int idBi = -1;
            if (this.bi == null) {
                if (Validators.correctString(this.buletinPanel.getSeria()) || Validators.correctString(this.buletinPanel.getNumar()) || Validators.correctString(this.buletinPanel.getCnp())) {
                    if (!this.verifyBiCi()) {
                        return;
                    }
                    idBi = this.logic.addBuletinLocally(this.buletinPanel.getSeria(), this.buletinPanel.getCnp(), this.buletinPanel.getNumar(), this.buletinPanel.getSectia(), this.buletinPanel.getDataEliberarii(), this.buletinPanel.getDataExpirarii());
                }
            } else {
                if (!this.verifyBiCi()) {
                    return;
                }
                idBi = this.bi.getId();
                this.bi.setSeria(this.buletinPanel.getSeria());
                this.bi.setCnp(this.buletinPanel.getCnp());
                this.bi.setNumarul(this.buletinPanel.getNumar());
                this.bi.setSectia(this.buletinPanel.getSectia());
                this.bi.setDataEliberarii(this.buletinPanel.getDataEliberarii());
                this.bi.setDataExpirarii(this.buletinPanel.getDataExpirarii());
                this.logic.saveBiCiLocally(this.bi);
            }
            int idPass = -1;
            if (this.pasaport == null) {
                if (Validators.correctString(this.pasaportPanel.getSeria())) {
                    idPass = this.logic.addPasaportLocally(this.pasaportPanel.getSeria(), this.pasaportPanel.getDataEliberarii(), this.pasaportPanel.getDataExpirarii(), this.pasaportPanel.getTipAct());
                }
            } else {
                idPass = this.pasaport.getId();
                this.pasaport.setSeria(this.pasaportPanel.getSeria());
                this.pasaport.setDataEliberarii(this.pasaportPanel.getDataEliberarii());
                this.pasaport.setDataExpirarii(this.pasaportPanel.getDataExpirarii());
                this.pasaport.setTipAct(this.pasaportPanel.getTipAct());
                this.logic.savePasaportLocally(this.pasaport);
            }
            this.client.setIdBuletin(idBi);
            this.client.setIdPassport(idPass);
            this.client.setAddress1(this.adresaPanel.getAdresa());
            this.client.setCity(this.adresaPanel.getOras());
            this.client.setFirstname(this.namePanel.getPrenume());
            this.client.setIdCountry(this.adresaPanel.getIdTara());
            this.client.setLastname(this.namePanel.getNume());
            this.client.setTelefonFix(this.namePanel.getTelFixField());
            this.client.setFax(this.namePanel.getFaxField());
            this.client.setTelefonMobil(this.namePanel.getTelMobilField());
            this.client.setEmail(this.namePanel.getEmailField());
            this.client.setPaginaWeb(this.namePanel.getWebField());
            this.client.setLoculNasterii(this.namePanel.getLoculNasterii());
            this.client.setCetatenie(this.namePanel.getCetatenie());
            this.client.setNationalitate(this.namePanel.getNationalitate());
            this.client.setDataNasterii(this.namePanel.getDataNasterii());
            this.client.setDataNumelui(this.namePanel.getDataNumelui());
            this.client.setObservatii(this.observatii.getText());
            this.client.setIdPersJuridica(idPersJuridica);
            this.logic.savePersFizicaLocally(this.client, this.picturePanel.getNewPictureFile(), groups);
            this.newClientName = this.namePanel.getNume() + " " + this.namePanel.getPrenume();
            DialogUtils.okDialog(this.parent, LangRoAll.operatieExecutata, LangRoAll.succes);
            this.setObjectToEdit(null);
            this.action.doAction();
        } else {
            int idBi = -1;
            if (Validators.correctString(this.buletinPanel.getSeria()) || Validators.correctString(this.buletinPanel.getNumar()) || Validators.correctString(this.buletinPanel.getCnp())) {
                if (!this.verifyBiCi()) {
                    return;
                }
                java.util.Date dataElib = this.buletinPanel.getDataEliberarii();
                java.util.Date dataExp = this.buletinPanel.getDataExpirarii();
                idBi = this.logic.addBuletinLocally(this.buletinPanel.getSeria(), this.buletinPanel.getCnp(), this.buletinPanel.getNumar(), this.buletinPanel.getSectia(), dataElib, dataExp);
            }
            int idPass = -1;
            if (Validators.correctString(this.pasaportPanel.getSeria())) {
                String tipAct = this.pasaportPanel.getTipAct();
                if (!Validators.correctString(tipAct)) {
                    DialogUtils.errorDialog(this, "Completati tipul actului", LangRoAll.nuPotContinua);
                    return;
                }
                java.util.Date dataElib = this.pasaportPanel.getDataEliberarii();
                if (dataElib == null) {
                    DialogUtils.errorDialog(this, "Completati data eliberarii in formatul dat", LangRoAll.nuPotContinua);
                    return;
                }
                java.util.Date dataExp = this.pasaportPanel.getDataExpirarii();
                if (dataExp == null) {
                    DialogUtils.errorDialog(this, "Completati data expirarii in formatul dat", LangRoAll.nuPotContinua);
                    return;
                }
                idPass = this.logic.addPasaportLocally(this.pasaportPanel.getSeria(), dataElib, dataExp, tipAct);
            }
            String pictureFile = this.picturePanel.getNewPictureFile();
            this.newClientId = this.logic.addPersFizica(this.namePanel.getNume(), this.namePanel.getPrenume(), this.adresaPanel.getAdresa(), this.adresaPanel.getIdTara(), this.adresaPanel.getOras(), idBi, idPass, idPersJuridica, this.namePanel.getTelFixField(), this.namePanel.getFaxField(), this.namePanel.getTelMobilField(), this.namePanel.getEmailField(), this.namePanel.getWebField(), this.namePanel.getLoculNasterii(), this.namePanel.getCetatenie(), this.namePanel.getNationalitate(), this.namePanel.getDataNasterii(), pictureFile, groups, this.namePanel.getDataNumelui(), this.observatii.getText(), true);
            this.newClientName = this.namePanel.getNume() + " " + this.namePanel.getPrenume();
            if (this.newClientId != -1) {
                DialogUtils.okDialog(this.parent, LangRoAll.operatieExecutata, LangRoAll.succes);
                this.setObjectToEdit(null);
                if (this.actionAtAdauga) {
                    this.action.doAction();
                }
            }
        }
    }

    public void setObjectToEdit(Object o) {
        super.switchSaveLabels(o);
        if (o != null) {
            PersFizicaViewEntry ve = (PersFizicaViewEntry)o;
            this.client = this.logic.getPersFizicaById(ve.getPersFizicaId());
            this.bi = this.logic.getBiCiById(this.client.getIdBuletin());
            this.pasaport = this.logic.getPassportById(this.client.getIdPassport());
            this.initialValues(this.client);
        } else {
            this.client = null;
            this.clearFields();
        }
    }

    public void setClientToEdit(Client c) {
        super.switchSaveLabels(c);
        if (c != null) {
            ClientPersFizica ve = (ClientPersFizica)c;
            this.client = this.logic.getPersFizicaById(ve.getIdPersFizica());
            this.bi = this.logic.getBiCiById(this.client.getIdBuletin());
            this.pasaport = this.logic.getPassportById(this.client.getIdPassport());
            this.initialValues(this.client);
        } else {
            this.client = null;
            this.clearFields();
        }
    }

    @Override
    public void saveButton() {
        if (this.validateData()) {
            this.save();
        }
    }

    @Override
    public void backButton() {
        this.setObjectToEdit(null);
        this.action.doAction();
    }

    @Override
    public void resetButton() {
        this.clearFields();
    }

    @Override
    public void deleteButton() {
        if (VpConfig.getInstance().passwordAtStergereClient) {
            User loggedUser = AdministrationPanel.loggedUser;
            if (loggedUser != null) {
                if (UsersLogic.getInstance().isUserInGroup(loggedUser.getId(), "group_manager_clienti")) {
                    this.actuallyEraseClient();
                } else {
                    DialogUtils.errorDialog(this.parent, "Drepturi insuficiente", LangRoAll.nuPotContinua);
                }
            } else {
                DialogUtils.errorDialog(this.parent, LangRoAll.neautentificat, LangRoAll.nuPotContinua);
            }
        } else {
            this.actuallyEraseClient();
        }
    }

    @Override
    public JButton addNewButton() {
        return null;
    }

    private void actuallyEraseClient() {
        this.erase(this.client);
        this.setObjectToEdit(null);
        this.action.doAction();
    }

    private JPanel getGrupPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.grup), c);
        ++c.gridx;
        Vector<PartenerGroup> allItems = ClientLogic.getInstance().getParteneriGroupsForPersoaneFizice();
        this.multiBoxGroup = new MultiboxList(allItems, 10);
        result.add((Component)this.multiBoxGroup, c);
        this.setClientSelectedGroups(allItems);
        result.setBorder(new TitledBorder("Grupuri"));
        return result;
    }

    public void setNewClientData(String telefonMobil, String firstAddress, String numeAdd, String emailAdd) {
        this.namePanel.setTelMobil(telefonMobil);
        this.namePanel.setNume(numeAdd);
        this.adresaPanel.setAdresa(firstAddress);
        this.namePanel.setEmail(emailAdd);
    }

    public void setClientGroup() {
        Vector<PartenerGroup> allItems = ClientLogic.getInstance().getParteneriGroupsForPersoaneFizice();
        this.multiBoxGroup.setSelectedItems(allItems, false);
        Vector<PartenerGroup> selectedItems = new Vector<PartenerGroup>();
        PartenerGroup pg = this.logic.getParteneriGroupById(2);
        selectedItems.add(pg);
        this.multiBoxGroup.setSelectedItems(selectedItems, true);
    }

    public void setClientSelectedGroups(Vector<PartenerGroup> items) {
        for (PartenerGroup item : items) {
            if (!item.getLabel().equals("Client")) continue;
            this.multiBoxGroup.setSelectedItem(item, true);
        }
    }
}

