/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ContinentalAngajatiImportBean;
import ro.atreides.clienti.PersFizicaViewEntry;
import ro.atreides.clienti.gui.ClientiPanel;
import ro.atreides.clienti.gui.PersFiziceCellRenderer;
import ro.atreides.restaurant.modules.servletsms.SmsLogic;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.HttpUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.sms.AndroidSmsSender;
import ro.atreides.utils.sms.SmsBean;

public class PersFizicaReport
extends AbstractReportPanel {
    private static final String[] columns = new String[]{"Nume", "Prenume", "Adresa", "Act identitate"};
    private JLabel numarLabel;
    private JLabel selectateLabel;
    private ClientiPanel main;
    private JTextField numeField;
    private JTextField adresaField;
    private JTextField cnpField;
    private Hashtable printCriteria = new Hashtable();
    private JButton stergeSelectia;
    private JButton comaseazaProduse;
    private JButton invertSelection;
    private JButton exportDateContact;
    private JButton importButton;
    private Vector selectedPartners = new Vector();
    private PersFiziceCellRenderer cellRenderer;
    private DoubleClicked action;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String cnp = this.cnpField.getText();
        if (Validators.correctString(cnp)) {
            result.put("CNP", cnp);
            this.printCriteria.put("CNP", cnp);
        } else {
            this.printCriteria.remove("CNP");
        }
        String nume = this.numeField.getText();
        if (Validators.correctString(nume)) {
            result.put("Nume", nume);
            this.printCriteria.put("Nume", nume);
        } else {
            this.printCriteria.remove("Nume");
        }
        String adresa = this.adresaField.getText();
        if (Validators.correctString(adresa)) {
            result.put("Adresa", adresa);
            this.printCriteria.put("Adresa", adresa);
        } else {
            this.printCriteria.remove("Adresa");
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("CNP"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.cnpField = new JTextField(20);
        result.add((Component)this.cnpField, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Nume"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.numeField = new JTextField(20);
        result.add((Component)this.numeField, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Adresa"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.adresaField = new JTextField(20);
        result.add((Component)this.adresaField, c);
        return result;
    }

    public Class[] buildTypes() {
        return new Class[]{String.class, String.class, String.class, String.class};
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PersFizicaViewEntry ve = (PersFizicaViewEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return ve.getNume();
                    }
                    case 1: {
                        return ve.getPrenuma();
                    }
                    case 2: {
                        return ve.getAdresa();
                    }
                    case 3: {
                        return ve.getAct();
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.1;
        c.weighty = 0.1;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Nr linii"), c);
        ++c.gridx;
        this.numarLabel = new JLabel("");
        result.add((Component)this.numarLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Selectate"), c);
        ++c.gridx;
        this.selectateLabel = new JLabel("");
        result.add((Component)this.selectateLabel, c);
        final PersFizicaReport parent = this;
        c.weightx = 1.0;
        ++c.gridx;
        this.invertSelection = new JButton("Invert selection");
        this.invertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int selected = 0;
                for (int i = 0; i < PersFizicaReport.this.data.size(); ++i) {
                    PersFizicaViewEntry pve = (PersFizicaViewEntry)PersFizicaReport.this.data.elementAt(i);
                    if (pve.isSelected()) {
                        pve.setSelected(false);
                        PersFizicaReport.this.selectedPartners.remove(pve.getClientObject());
                    } else {
                        PersFizicaReport.this.selectedPartners.add(pve.getClientObject());
                        pve.setSelected(true);
                    }
                    if (!pve.isSelected()) continue;
                    ++selected;
                }
                PersFizicaReport.this.selectateLabel.setText(selected + "");
                PersFizicaReport.this.tm.fireTableDataChanged();
            }
        });
        result.add((Component)this.invertSelection, c);
        ++c.gridx;
        this.exportDateContact = new JButton("Colecteaza date contact");
        this.exportDateContact.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem excelDateContact = new JMenuItem("Excel date contact");
                popup.add(excelDateContact);
                JMenuItem collectEmail = new JMenuItem("Exporta adrese email");
                popup.add(collectEmail);
                JMenuItem collectMobil = new JMenuItem("Exporta numere de mobil");
                popup.add(collectMobil);
                JMenuItem collectFax = new JMenuItem("Exporta numere fax");
                popup.add(collectFax);
                JMenuItem trimiteSMS = new JMenuItem("Trimite SMS");
                JMenuItem exportSMS = new JMenuItem("Export SMS");
                popup.add(exportSMS);
                excelDateContact.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile = FileDialog.getSaveDialogLocation(parent, LangRoAll.alegetiFisierulDestinatie, "xls");
                        if (inputFile != null) {
                            File f = new File(inputFile);
                            PersFizicaReport.this.exportDateContactExcel(f);
                            DialogUtils.okDialog(parent, "Export efectuat", LangRoAll.succes);
                        }
                        popup.setVisible(false);
                    }
                });
                collectEmail.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile = FileDialog.getSaveDialogLocation(parent, LangRoAll.alegetiFisierulDestinatie, "txt");
                        if (inputFile != null) {
                            ClientLogic.getInstance().collectEmailAddresses(inputFile, PersFizicaReport.this.selectedPartners);
                            DialogUtils.okDialog(parent, "Export efectuat", LangRoAll.succes);
                        }
                        popup.setVisible(false);
                    }
                });
                collectMobil.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile = FileDialog.getSaveDialogLocation(parent, LangRoAll.alegetiFisierulDestinatie, "txt");
                        if (inputFile != null) {
                            ClientLogic.getInstance().collectMobil(inputFile, PersFizicaReport.this.selectedPartners);
                            DialogUtils.okDialog(parent, "Export efectuat", LangRoAll.succes);
                        }
                        popup.setVisible(false);
                    }
                });
                collectFax.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile = FileDialog.getSaveDialogLocation(parent, LangRoAll.alegetiFisierulDestinatie, "txt");
                        if (inputFile != null) {
                            ClientLogic.getInstance().collectFax(inputFile, PersFizicaReport.this.selectedPartners);
                            DialogUtils.okDialog(parent, "Export efectuat", LangRoAll.succes);
                        }
                        popup.setVisible(false);
                    }
                });
                trimiteSMS.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (PersFizicaReport.this.selectedPartners.size() <= 0) {
                            DialogUtils.errorDialog(parent, "Nu ati selectat nimic", LangRoAll.nuPotContinua);
                            return;
                        }
                        String text = DialogUtils.inputDialog(parent, "Textul mesajului", "Textul mesajului");
                        Vector<String> destinations = ClientLogic.getInstance().collectMobil(null, PersFizicaReport.this.selectedPartners);
                        if (DialogUtils.confirmDialog(parent, "Doriti sa trimiteti mesajul \"" + text + "\" la " + destinations.size() + " numere ", LangRoAll.confirmare)) {
                            for (String mobil : destinations) {
                                SmsBean bean = new SmsBean();
                                bean.setMessage(text);
                                bean.setDestination(mobil);
                                AndroidSmsSender.getInstance().addSms(bean);
                            }
                        }
                    }
                });
                exportSMS.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String xmlContent;
                        if (PersFizicaReport.this.selectedPartners.size() <= 0) {
                            DialogUtils.errorDialog(parent, "Nu ati selectat nimic", LangRoAll.nuPotContinua);
                            return;
                        }
                        Vector<String> numbers = ClientLogic.getInstance().collectMobil(null, PersFizicaReport.this.selectedPartners);
                        Vector<String> destinations = SmsLogic.getCorrectNumberOfCellPhoneNumbers(numbers);
                        if (destinations.size() == 0) {
                            DialogUtils.errorDialog(parent, "Nici una din persoanele selectate nu are numarul de SMS configurat", LangRoAll.nuPotContinua);
                            return;
                        }
                        String text = DialogUtils.inputDialog(parent, "Textul mesajului", "Textul mesajului");
                        if (DialogUtils.confirmDialog(parent, "Doriti sa trimiteti mesajul \"" + text + "\" la " + destinations.size() + " numere ", LangRoAll.confirmare) && (xmlContent = SmsLogic.buildSmsXMLContent(destinations, text)) != null) {
                            String s = HttpUtils.postHttpPage(HttpUtils.smsServletAddress + "?xml=" + xmlContent);
                            if (s != null) {
                                DialogUtils.okDialog(parent, "SMS-uri transmise cu succes", LangRoAll.succes);
                            } else {
                                DialogUtils.errorDialog(parent, "Eroare la transmitere SMS", LangRoAll.nuPotContinua);
                                return;
                            }
                        }
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        result.add((Component)this.exportDateContact, c);
        final PersFizicaReport panel = this;
        ++c.gridx;
        this.importButton = new JButton(Utils.getTranslation("Import clienti"));
        this.importButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem importClientiDinExcel = new JMenuItem("Import clienti din excel ( card | CAS | prenume | nume | valoare cont | telefon | data nasterii | data numelui )");
                popup.add(importClientiDinExcel);
                importClientiDinExcel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de importat", "xls");
                        final String dateFormat = DialogUtils.inputDialog(panel, "MM/dd/yyyy", "Alegeti formatul de data corect !!!");
                        final Vector<ContinentalAngajatiImportBean> toImport = new Vector<ContinentalAngajatiImportBean>();
                        final Vector errors = new Vector();
                        Vector<TipCont> tipConts = ClientLogic.getInstance().getAllConturi();
                        TipCont tipCont = tipConts.get(0);
                        try {
                            ExcelUtils.readExcel(new File(inputFile), new ExcelImportInterface(){
                                ContinentalAngajatiImportBean currentBean;

                                @Override
                                public void valueRead(int row, int column, String value) {
                                    value = value.trim();
                                    value = value.replaceAll("`", "");
                                    this.currentBean.setLine(row + 1);
                                    switch (column) {
                                        case 0: {
                                            String cod = value.replaceAll("[^\\d.]", "");
                                            cod = cod.trim();
                                            this.currentBean.setCodCard(cod);
                                            break;
                                        }
                                        case 1: {
                                            String cod2 = value.replaceAll("[^\\d.]", "");
                                            cod2 = cod2.trim();
                                            this.currentBean.setCodCAS(cod2);
                                            break;
                                        }
                                        case 2: {
                                            this.currentBean.setPrenume(value);
                                            break;
                                        }
                                        case 3: {
                                            this.currentBean.setNume(value);
                                            break;
                                        }
                                        case 4: {
                                            if (!Validators.correctDouble(value)) break;
                                            this.currentBean.setDisponibil(Double.parseDouble(value));
                                            break;
                                        }
                                        case 5: {
                                            this.currentBean.setNumarTelefon(value);
                                            break;
                                        }
                                        case 6: {
                                            this.currentBean.setDataNasterii(DateUtils.getDateFromStringMultipleFormats(value, dateFormat));
                                            break;
                                        }
                                        case 7: {
                                            this.currentBean.setDataNumelui(DateUtils.getDateFromStringMultipleFormats(value, dateFormat));
                                        }
                                    }
                                }

                                @Override
                                public void lineEnd() {
                                    if (!this.currentBean.isEmpty()) {
                                        if (this.currentBean.isOk()) {
                                            toImport.add(this.currentBean);
                                        } else {
                                            errors.add(this.currentBean);
                                        }
                                    }
                                    this.currentBean = null;
                                }

                                @Override
                                public void lineStart() {
                                    this.currentBean = new ContinentalAngajatiImportBean();
                                }

                                @Override
                                public void sheetStart(String sheetName) {
                                }

                                @Override
                                public void sheetEnd(String sheetName) {
                                }
                            }, 1);
                        }
                        catch (IOException e1) {
                            Logger.logException(this, (Exception)e1);
                        }
                        catch (BiffException e1) {
                            Logger.logException(this, (Exception)((Object)e1));
                        }
                        if (errors.size() > 0) {
                            for (ContinentalAngajatiImportBean error : errors) {
                                Logger.logWarning(this, "Linia " + error.getLine() + " : " + error.toString());
                            }
                            DialogUtils.errorDialog(parent, "Exista erori la import. Consultati logul pentru detalii", LangRoAll.atentie);
                            if (!DialogUtils.confirmDialog(parent, "Continuam importul", LangRoAll.confirmare)) {
                                return;
                            }
                        }
                        ClientLogic.getInstance().importAngajatiContinental(toImport, parent, tipCont, false, false);
                        DialogUtils.okDialog(parent, LangRoAll.operatieExecutata, LangRoAll.succes);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        result.add((Component)this.importButton, c);
        ++c.gridx;
        this.stergeSelectia = new JButton("Sterge selectia");
        this.stergeSelectia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PersFizicaReport.this.clearSelection();
            }
        });
        result.add((Component)this.stergeSelectia, c);
        return result;
    }

    private void clearSelection() {
        this.selectedPartners.clear();
        this.selectateLabel.setText("0");
        for (int i = 0; i < this.data.size(); ++i) {
            PersFizicaViewEntry stockViewEntry = (PersFizicaViewEntry)this.data.elementAt(i);
            stockViewEntry.setSelected(false);
        }
        this.tm.fireTableDataChanged();
    }

    private void exportDateContactExcel(File reportFile) {
        ClientLogic.getInstance().excelDateContactPersFizice(reportFile, this.selectedPartners);
    }

    @Override
    public String getName() {
        return "Persoane fizice";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        String nume = (String)criteria.get("Nume");
        String adresa = (String)criteria.get("Adresa");
        String cnp = (String)criteria.get("CNP");
        return ClientLogic.getInstance().getPersFiziceViewEntry(nume, adresa, cnp);
    }

    @Override
    public void printPreview() {
        DialogUtils.errorDialog(GuiUtils.currentFrame, "Functie indisponibila.", LangRoAll.nuPotContinua);
    }

    @Override
    public void printReport() {
        DialogUtils.errorDialog(GuiUtils.currentFrame, "Functie indisponibila.", LangRoAll.nuPotContinua);
    }

    @Override
    public void refreshTotalPanel() {
        this.selectedPartners.clear();
        this.selectateLabel.setText("0");
        this.numarLabel.setText(this.data.size() + "");
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    PersFizicaViewEntry entry = (PersFizicaViewEntry)o;
                    try {
                        Label label = new Label(0, row, entry.getNume());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getPrenuma());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getAdresa());
                        sheet.addCell((WritableCell)label);
                        label = new Label(3, row, entry.getAct());
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return PersFizicaReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private void updateJTableColumns(JTable unu) {
        TableColumnModel colModel = unu.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(this.cellRenderer);
        }
    }

    @Override
    public void doStuff() {
        this.cellRenderer = new PersFiziceCellRenderer(this.tm);
        this.updateJTableColumns(this.table);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final PersFizicaViewEntry pve = (PersFizicaViewEntry)PersFizicaReport.this.tm.getObjectAt(selRow);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    if (!pve.isSelected()) {
                        PersFizicaReport.this.selectedPartners.add(pve.getClientObject());
                        PersFizicaReport.this.selectateLabel.setText(PersFizicaReport.this.selectedPartners.size() + "");
                    } else {
                        PersFizicaReport.this.selectedPartners.remove(pve.getClientObject());
                        PersFizicaReport.this.selectateLabel.setText(PersFizicaReport.this.selectedPartners.size() + "");
                    }
                    pve.setSelected(!pve.isSelected());
                    PersFizicaReport.this.tm.fireTableRowsUpdated(selRow, selRow);
                } else {
                    final JPopupMenu popup = new JPopupMenu();
                    JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
                    popup.add(modifica);
                    popup.setInvoker(PersFizicaReport.this.table);
                    modifica.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (PersFizicaReport.this.main != null) {
                                PersFizicaReport.this.main.editPersFizica(pve);
                            }
                            if (PersFizicaReport.this.action != null) {
                                PersFizicaReport.this.action.doubleClicked(pve);
                            }
                            popup.setVisible(false);
                        }
                    });
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    public void setMain(ClientiPanel main) {
        this.main = main;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    public void setAction(DoubleClicked action) {
        this.action = action;
    }
}

