/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.clienti.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.PartenerGroup;
import ro.atreides.clienti.PersJuridicaViewEntry;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.MultiboxList;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class PersJuridicaReport
extends AbstractReportPanel {
    private Hashtable printCriteria = new Hashtable();
    private MultiboxList grupuriCombo;
    private JButton stergeSelectia;
    private JButton comaseazaProduse;
    private JButton invertSelection;
    private JButton exportDateContact;
    private JLabel numarLabel;
    private JLabel selectateLabel;
    private static final String[] columns = new String[]{"Nr", "Alias", "Societate", "Oras", "CUI", "Probleme"};
    private Vector selectedPartners = new Vector();
    private DoubleClicked action;
    private static Comparator alias_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((PersJuridicaViewEntry)o1).getAlias();
            String c2 = ((PersJuridicaViewEntry)o2).getAlias();
            return c1.compareToIgnoreCase(c2);
        }
    };
    private static Comparator nume_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((PersJuridicaViewEntry)o1).getSocietate();
            String c2 = ((PersJuridicaViewEntry)o2).getSocietate();
            return c1.compareToIgnoreCase(c2);
        }
    };
    private static Comparator oras_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((PersJuridicaViewEntry)o1).getOras();
            String c2 = ((PersJuridicaViewEntry)o2).getOras();
            return c1.compareToIgnoreCase(c2);
        }
    };
    private static Comparator cui_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((PersJuridicaViewEntry)o1).getCui();
            String c2 = ((PersJuridicaViewEntry)o2).getCui();
            return c1.compareToIgnoreCase(c2);
        }
    };
    private static Comparator contact_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            PersJuridicaViewEntry p1 = (PersJuridicaViewEntry)o1;
            PersJuridicaViewEntry p2 = (PersJuridicaViewEntry)o2;
            int c1 = ClientLogic.getInstance().getDateContactPJWarningImpl().getAlertLevel(p1);
            int c2 = ClientLogic.getInstance().getDateContactPJWarningImpl().getAlertLevel(p2);
            return c1 - c2;
        }
    };

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String groupIds = "";
        String groupNames = "";
        Vector items = this.grupuriCombo.getSelectedItems();
        for (int i = 0; i < items.size(); ++i) {
            PartenerGroup pg = (PartenerGroup)items.elementAt(i);
            groupIds = groupIds + pg.getId();
            groupNames = groupNames + pg.getLabel();
            if (i >= items.size() - 1) continue;
            groupIds = groupIds + ",";
            groupNames = groupNames + ",";
        }
        result.put("Grupuri", groupIds);
        this.printCriteria.put("Grupuri", groupNames);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.grup), c);
        ++c.gridx;
        c.weightx = 1.0;
        Vector<PartenerGroup> allItems = ClientLogic.getInstance().getParteneriGroups();
        this.grupuriCombo = new MultiboxList(allItems, 10);
        this.grupuriCombo.setSelectedItems(allItems, false);
        result.add((Component)this.grupuriCombo, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PersJuridicaViewEntry ve = (PersJuridicaViewEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return rowIndex + 1 + "";
                    }
                    case 1: {
                        return ve.getAlias();
                    }
                    case 2: {
                        return ve.getSocietate();
                    }
                    case 3: {
                        return ve.getOras();
                    }
                    case 4: {
                        return ve.getCui();
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.1;
        c.weighty = 0.1;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Nr linii"), c);
        ++c.gridx;
        this.numarLabel = new JLabel("");
        result.add((Component)this.numarLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Selectate"), c);
        ++c.gridx;
        this.selectateLabel = new JLabel("");
        result.add((Component)this.selectateLabel, c);
        final PersJuridicaReport parent = this;
        c.weightx = 1.0;
        ++c.gridx;
        this.invertSelection = new JButton("Invert selection");
        this.invertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int selected = 0;
                for (int i = 0; i < PersJuridicaReport.this.data.size(); ++i) {
                    PersJuridicaViewEntry pve = (PersJuridicaViewEntry)PersJuridicaReport.this.data.elementAt(i);
                    if (pve.isSelected()) {
                        pve.setSelected(false);
                        PersJuridicaReport.this.selectedPartners.remove(pve.getClientObject());
                    } else {
                        PersJuridicaReport.this.selectedPartners.add(pve.getClientObject());
                        pve.setSelected(true);
                    }
                    if (!pve.isSelected()) continue;
                    ++selected;
                }
                PersJuridicaReport.this.selectateLabel.setText(selected + "");
                PersJuridicaReport.this.tm.fireTableDataChanged();
            }
        });
        result.add((Component)this.invertSelection, c);
        ++c.gridx;
        this.exportDateContact = new JButton("Colecteaza date contact");
        this.exportDateContact.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem excelDateContact = new JMenuItem("Excel date contact");
                popup.add(excelDateContact);
                JMenuItem collectEmail = new JMenuItem("Exporta adrese email");
                popup.add(collectEmail);
                JMenuItem collectMobil = new JMenuItem("Exporta numere de mobil");
                popup.add(collectMobil);
                JMenuItem collectFax = new JMenuItem("Exporta numere fax");
                popup.add(collectFax);
                excelDateContact.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile = FileDialog.getSaveDialogLocation(parent, LangRoAll.alegetiFisierulDestinatie, "xls");
                        if (inputFile != null) {
                            File f = new File(inputFile);
                            PersJuridicaReport.this.exportDateContactExcel(f);
                            DialogUtils.okDialog(parent, "Export efectuat", LangRoAll.succes);
                        }
                        popup.setVisible(false);
                    }
                });
                collectEmail.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile = FileDialog.getSaveDialogLocation(parent, LangRoAll.alegetiFisierulDestinatie, "txt");
                        if (inputFile != null) {
                            ClientLogic.getInstance().collectEmailAddresses(inputFile, PersJuridicaReport.this.selectedPartners);
                            DialogUtils.okDialog(parent, "Export efectuat", LangRoAll.succes);
                        }
                        popup.setVisible(false);
                    }
                });
                collectMobil.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile = FileDialog.getSaveDialogLocation(parent, LangRoAll.alegetiFisierulDestinatie, "txt");
                        if (inputFile != null) {
                            ClientLogic.getInstance().collectMobil(inputFile, PersJuridicaReport.this.selectedPartners);
                            DialogUtils.okDialog(parent, "Export efectuat", LangRoAll.succes);
                        }
                        popup.setVisible(false);
                    }
                });
                collectFax.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile = FileDialog.getSaveDialogLocation(parent, LangRoAll.alegetiFisierulDestinatie, "txt");
                        if (inputFile != null) {
                            ClientLogic.getInstance().collectFax(inputFile, PersJuridicaReport.this.selectedPartners);
                            DialogUtils.okDialog(parent, "Export efectuat", LangRoAll.succes);
                        }
                        popup.setVisible(false);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        result.add((Component)this.exportDateContact, c);
        ++c.gridx;
        this.stergeSelectia = new JButton("Sterge selectia");
        this.stergeSelectia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PersJuridicaReport.this.clearSelection();
            }
        });
        result.add((Component)this.stergeSelectia, c);
        return result;
    }

    private void exportDateContactExcel(File reportFile) {
        ClientLogic.getInstance().excelDateContactPersJuridice(reportFile, this.selectedPartners);
    }

    private void clearSelection() {
        this.selectedPartners.clear();
        this.selectateLabel.setText("0");
        for (int i = 0; i < this.data.size(); ++i) {
            PersJuridicaViewEntry stockViewEntry = (PersJuridicaViewEntry)this.data.elementAt(i);
            stockViewEntry.setSelected(false);
        }
        this.tm.fireTableDataChanged();
    }

    @Override
    public String getName() {
        return "Persoane juridice";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ClientLogic.getInstance().getPersJuridiceViewEntry(criteria);
    }

    public void setAction(DoubleClicked action) {
        this.action = action;
    }

    @Override
    public void printPreview() {
        DialogUtils.errorDialog(GuiUtils.currentFrame, "Functie indisponibila. Incercat Excel", LangRoAll.nuPotContinua);
    }

    @Override
    public void printReport() {
        DialogUtils.errorDialog(GuiUtils.currentFrame, "Functie indisponibila. Incercat Excel", LangRoAll.nuPotContinua);
    }

    @Override
    public void refreshTotalPanel() {
        this.selectedPartners.clear();
        this.selectateLabel.setText("0");
        this.numarLabel.setText(this.data.size() + "");
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    PersJuridicaViewEntry entry = (PersJuridicaViewEntry)o;
                    try {
                        sheet.addCell((WritableCell)new Number(0, row, (double)row));
                        Label label = new Label(1, row, entry.getAlias());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getSocietate());
                        sheet.addCell((WritableCell)label);
                        label = new Label(3, row, entry.getOras());
                        sheet.addCell((WritableCell)label);
                        label = new Label(4, row, entry.getCui());
                        sheet.addCell((WritableCell)label);
                        label = new Label(5, row, entry.getClientObject().getProblems());
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return PersJuridicaReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        this.updateJTableColumns(this.table);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final PersJuridicaViewEntry pve = (PersJuridicaViewEntry)PersJuridicaReport.this.tm.getObjectAt(selRow);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    if (!pve.isSelected()) {
                        PersJuridicaReport.this.selectedPartners.add(pve.getClientObject());
                        PersJuridicaReport.this.selectateLabel.setText(PersJuridicaReport.this.selectedPartners.size() + "");
                    } else {
                        PersJuridicaReport.this.selectedPartners.remove(pve.getClientObject());
                        PersJuridicaReport.this.selectateLabel.setText(PersJuridicaReport.this.selectedPartners.size() + "");
                    }
                    pve.setSelected(!pve.isSelected());
                    PersJuridicaReport.this.tm.fireTableRowsUpdated(selRow, selRow);
                } else {
                    final JPopupMenu popup = new JPopupMenu();
                    JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
                    popup.add(modifica);
                    popup.setInvoker(PersJuridicaReport.this.table);
                    modifica.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            popup.setVisible(false);
                            PersJuridicaReport.this.action.doubleClicked(pve);
                        }
                    });
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return alias_sorter;
            }
            case 2: {
                return nume_sorter;
            }
            case 3: {
                return oras_sorter;
            }
            case 4: {
                return cui_sorter;
            }
            case 5: {
                return contact_sorter;
            }
        }
        return null;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    private void updateJTableColumns(JTable unu) {
        TableColumnModel colModel = unu.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
        }
    }
}

