/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate;

import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.multilang.LangRoAll;

public class NirExcelFormulaProcessor
implements ExcelProcessor {
    private String name;
    private String societate;
    private String nrFactura;
    private String nrNir;
    private String furnizor;
    private String data;
    private String auto;
    private String comisiaReceptie;
    public static final String[] columns = new String[]{"N.c", "Denumire", "UM", "Cant", "Ppu f TVA", "Val f TVA", "TVA/UM", "TVA Total", "Total factura", "Adaos %", LangRoAll.suma, "Ppu amanunt f TVA", "TVA adaos com", "Ppu amanunt c TVA", "Val la ppu amanunt c TVA", "TVA/UM amanunt", "TVA Total"};

    public NirExcelFormulaProcessor(String name, String societate, String nrFactura, String nrNir, String furnizor, String data, String auto, String comisiaReceptie) {
        this.name = name;
        this.societate = societate;
        this.nrFactura = nrFactura;
        this.nrNir = nrNir;
        this.furnizor = furnizor;
        this.data = data;
        this.auto = auto;
        this.comisiaReceptie = comisiaReceptie;
    }

    @Override
    public int buildHeader(WritableSheet sheet, int startRow) {
        try {
            sheet.addCell((WritableCell)new Label(0, startRow, this.societate));
            sheet.addCell((WritableCell)new Label(5, startRow, "Nota intrare receptie nr " + this.nrNir));
            sheet.addCell((WritableCell)new Label(0, startRow + 1, "Subsemnatii " + this.comisiaReceptie));
            sheet.addCell((WritableCell)new Label(5, startRow + 1, "membri ai comisiei de receptie, am procedat la receptionarea valorilor furnizate de"));
            sheet.addCell((WritableCell)new Label(0, startRow + 2, this.furnizor));
            sheet.addCell((WritableCell)new Label(5, startRow + 2, "din " + this.data));
            sheet.addCell((WritableCell)new Label(0, startRow + 3, "cu auto " + this.auto));
            sheet.addCell((WritableCell)new Label(5, startRow + 3, "insotite de factura " + this.nrFactura));
            sheet.addCell((WritableCell)new Label(0, startRow + 4, "si am constatat urmatoarele"));
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        return 6;
    }

    @Override
    public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
        try {
            sheet.addCell((WritableCell)new Label(1, row, "TOTAL"));
            sheet.addCell((WritableCell)new Formula(5, row, "SUM(F" + firstTableRow + ":F" + lastTableRow + ")"));
            sheet.addCell((WritableCell)new Formula(7, row, "SUM(H" + firstTableRow + ":H" + lastTableRow + ")"));
            sheet.addCell((WritableCell)new Formula(8, row, "SUM(I" + firstTableRow + ":I" + lastTableRow + ")"));
            sheet.addCell((WritableCell)new Formula(14, row, "SUM(O" + firstTableRow + ":O" + lastTableRow + ")"));
            sheet.addCell((WritableCell)new Formula(16, row, "SUM(Q" + firstTableRow + ":Q" + lastTableRow + ")"));
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }

    @Override
    public void processLine(Object o, WritableSheet sheet, int row) {
        NirEntryFull e = (NirEntryFull)o;
        int n = row + 1;
        try {
            int column = 0;
            sheet.addCell((WritableCell)new Number(column, row, (double)e.getNrCrt()));
            sheet.addCell((WritableCell)new Label(++column, row, e.getDenumireProdus()));
            sheet.addCell((WritableCell)new Label(++column, row, e.getUm()));
            sheet.addCell((WritableCell)new Number(++column, row, FloatUtils.roundFloat(e.getCant(), 3)));
            sheet.addCell((WritableCell)new Number(++column, row, FloatUtils.roundFloat(e.getPpuc(), 2)));
            sheet.addCell((WritableCell)new Number(++column, row, e.getValoareCumparare()));
            sheet.addCell((WritableCell)new Number(++column, row, FloatUtils.roundFloat(e.getTvaPerUm(), 2)));
            sheet.addCell((WritableCell)new Number(++column, row, e.getTvaFurnizorTotal()));
            sheet.addCell((WritableCell)new Number(++column, row, e.getTotalFactura()));
            ++column;
            if (!e.isFacturaOnly()) {
                sheet.addCell((WritableCell)new Formula(column, row, "IF(N" + n + "<>0,IF(E" + n + "<>0,ROUND(ROUND(K" + n + "/E" + n + ",3)*100,2),0),0)"));
                sheet.addCell((WritableCell)new Formula(++column, row, "IF(N" + n + "<>0,ROUND(N" + n + "/1.19,2)-E" + n + ",0)"));
                sheet.addCell((WritableCell)new Formula(++column, row, "ROUND(N" + n + "/1.19,2)"));
                sheet.addCell((WritableCell)new Formula(++column, row, "ROUND(K" + n + "*0.19,2)"));
                sheet.addCell((WritableCell)new Number(++column, row, e.getPpuvtva()));
                sheet.addCell((WritableCell)new Formula(++column, row, "ROUND(D" + n + "*N" + n + ",2)"));
                sheet.addCell((WritableCell)new Formula(++column, row, "IF(N" + n + "<>0,G" + n + "+M" + n + ",0)"));
                sheet.addCell((WritableCell)new Formula(++column, row, "ROUND(D" + n + "*P" + n + ",2)"));
                ++column;
            }
        }
        catch (WriteException e1) {
            Logger.logException(this, (Exception)((Object)e1));
        }
    }

    @Override
    public String[] getColumns() {
        return columns;
    }

    @Override
    public String getSheetName() {
        return this.name;
    }
}

