/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.FacturiEntry;
import ro.atreides.contabilitate.gui.IntrariFurnizoriEntry;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.FacturiNeplatiteEntry;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.sql.SqlUtils;
import ro.atreides.utils.tva.Tva;

public class FacturiDao
implements DaoInterface {
    private PreparedStatement add;
    private PreparedStatement selectAll;
    private PreparedStatement delete;
    private PreparedStatement update;
    private PreparedStatement getById;
    private PreparedStatement getFacturi;
    private PreparedStatement getFacturiNeplatitePtFurnizor;
    private PreparedStatement deleteAll;
    private PreparedStatement setFacturaPlatita;
    private PreparedStatement getFurnizorForRegCasa;
    private Connection conn;

    public Connection getConn() {
        return this.conn;
    }

    public FacturiDao(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.getFurnizorForRegCasa = this.conn.prepareStatement("select id_furnizor from regcasa inner join fisa_plati on regcasa.id = fisa_plati.id_regcasa inner join facturi on fisa_plati.id_factura = facturi.id where regcasa.id = ?");
        this.setFacturaPlatita = this.conn.prepareStatement("update facturi set platit = ? where id = ?");
        this.add = this.conn.prepareStatement("insert into facturi ( id_furnizor, serie_factura, data, dateadd, auto, status, transfer_based, id_tip_cheltuiala, id_societatea_noastra, tip_factura,data_scadenta ) values ( ?, ?, CURRENT_DATE, ?, ?, 1, ?, ?, ?, ?, ?)");
        this.selectAll = this.conn.prepareStatement("select * from facturi where status = 1");
        this.getFacturi = this.conn.prepareStatement("select facturi.serie_factura as serie, facturi.dateadd as dateadd, facturi.totalgeneral_nou, facturi.id as id_factura, facturi.id_furnizor, facturi.id_tip_cheltuiala, facturi.id_societatea_noastra, facturi.tip_factura, facturi.data_scadenta, niruri.nr_nir as numar_nir from facturi inner join niruri on facturi.id = niruri.id_factura inner join documente on facturi.id = documente.id_factura where (documente.fiscal = ? or ? = -1) AND (id_furnizor = ? OR ? = -1 ) AND facturi.status = 1 AND facturi.dateadd >= ? and facturi.dateadd < ? AND (facturi.id_societatea_noastra = ? or ? = -1) AND (facturi.tip_factura = ? or ? = -1 ) AND (documente.comanda_type = ? or ? = -1 ) order by facturi.dateadd, id_furnizor");
        this.getFacturiNeplatitePtFurnizor = this.conn.prepareStatement("select facturi.*,  coalesce( ( select sum(suma) from fisa_plati where fisa_plati.id_factura = facturi.id ), 0) as suma_achitata from facturi inner join documente on facturi.id = documente.id_factura where (documente.fiscal = ? or ? = -1) and facturi.platit = 0 and id_furnizor = ? order by facturi.dateadd, facturi.id");
        this.getById = this.conn.prepareStatement("select facturi.*, documente.comanda_type  from facturi  inner join documente on facturi.id = documente.id_factura  where facturi.id = ?");
        this.delete = this.conn.prepareStatement("delete from facturi where id = ?");
        this.update = this.conn.prepareStatement("update facturi set total_nou = ?, totaltva_nou = ? , totalgeneral_nou = ?, dateadd = ?, serie_factura = ?, id_furnizor = ?, id_tip_cheltuiala = ?, transfer_based = ?, id_societatea_noastra = ?, tip_factura = ?, data_scadenta = ? where id = ?");
        this.deleteAll = this.conn.prepareStatement("delete from facturi");
    }

    public int getIdFurnizori(int idRegCasa) throws SQLException {
        int result = -1;
        this.getFurnizorForRegCasa.setInt(1, idRegCasa);
        ResultSet rs = this.getFurnizorForRegCasa.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void setFacturaPlatita(int idFactura, int status) throws SQLException {
        this.setFacturaPlatita.setInt(1, status);
        this.setFacturaPlatita.setInt(2, idFactura);
        this.setFacturaPlatita.execute();
    }

    public Vector<IntrariFurnizoriEntry> getIntrariFurnizori(int idMagazie, Timestamp start, Timestamp stop, int whatToPrint, int idSocietateaNoastra, String stocksSqlInSeq, Connection conn, int comandaType, Tva tvaFilter, boolean groupByTva) throws SQLException {
        int ficus = -1;
        switch (whatToPrint) {
            case 2: {
                ficus = 1;
                break;
            }
            case 3: {
                ficus = 0;
            }
        }
        String s = "select id_furnizor, facturi.serie_factura as serie,  facturi.dateadd as data, sum( factura_entries.ppuc_nou * factura_entries.cantitate_2 ) as valoare_furnizor, sum( factura_entries.ppuc_nou * factura_entries.cantitate_2 *tva_f.cota ) as valoare_tva_furnizor," + (groupByTva ? " tva_f.cota as cota_tva_furnizor, tva_v.cota as cota_tva_vz," : "") + " sum( (case when nir_entries.ppuvtva_nou < 0 then 0 else nir_entries.ppuvtva_nou end) * factura_entries.cantitate_2 ) as valoare_vz," + " coalesce(sum ( (case when nir_entries.ppuvtva_nou < 0 then 0 else nir_entries.ppuvtva_nou end) * factura_entries.cantitate_2 / (1 + tva_v.cota) * tva_v.cota ),0) as valoare_tva_vz" + " from facturi" + " inner join factura_entries on facturi.id = factura_entries.id_factura" + " inner join nir_entries on factura_entries.id = nir_entries.id_factura_entry" + " inner join tva tva_f on factura_entries.id_tva = tva_f.id" + " inner join documente on facturi.id = documente.id_factura" + " left outer join produse_Finite on factura_entries.id_ingredient = produse_finite.id_stock" + " left outer join products on produse_finite.id_product = products.id" + " left outer join subcategories on products.id_subcategory = subcategories.id" + " left outer join tva tva_v on tva_v.id = subcategories.id_tva" + " where" + " (documente.fiscal = " + ficus + " or " + ficus + " = " + -1 + ")" + " and (id_magazie = " + idMagazie + " or " + idMagazie + " = " + -1 + ")" + " AND facturi.dateadd >= '" + start + "' and facturi.dateadd < '" + stop + "'" + " AND (facturi.id_societatea_noastra = " + idSocietateaNoastra + " or " + idSocietateaNoastra + " = " + -1 + ")" + " AND (documente.comanda_type = " + comandaType + " or " + comandaType + " = " + -1 + ")" + (stocksSqlInSeq != null ? " AND factura_entries.id_ingredient in " + stocksSqlInSeq : "") + (tvaFilter != null ? " AND tva_f.id = " + tvaFilter.getId() : "") + " group by id_furnizor, serie_factura, dateadd" + (groupByTva ? ", tva_f.cota, tva_v.cota" : "") + " order by dateadd";
        Vector<IntrariFurnizoriEntry> result = new Vector<IntrariFurnizoriEntry>();
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        while (rs.next()) {
            IntrariFurnizoriEntry e = new IntrariFurnizoriEntry();
            e.setFactura(rs.getString("serie"));
            e.setData(Formatters.DATE_FORMAT_RO.format(rs.getTimestamp("data")));
            e.setDate(rs.getDate("data"));
            e.setIdFurnizor(rs.getInt("id_furnizor"));
            double valFurnizor = rs.getDouble("valoare_furnizor");
            e.setValFurnizor(valFurnizor);
            if (groupByTva) {
                double cota1 = rs.getDouble("cota_tva_furnizor");
                e.setCotaTvaFurnizor(cota1);
                e.setCotaTvaVz(rs.getDouble("cota_tva_vz"));
            }
            double valoare_tva_furnizor = rs.getDouble("valoare_tva_furnizor");
            e.setTvaFurnizor(valoare_tva_furnizor);
            e.setTotalFurnizor(valoare_tva_furnizor + valFurnizor);
            double valVz = rs.getDouble("valoare_vz");
            e.setValVz(valVz);
            double tvaVz = rs.getDouble("valoare_tva_vz");
            e.setTvaVz(tvaVz);
            double adaos = 0.0;
            if (valVz != 0.0) {
                adaos = valVz - tvaVz - valFurnizor;
            }
            e.setAdaos(adaos);
            result.add(e);
        }
        return result;
    }

    public void deleteAll() throws SQLException {
        this.deleteAll.execute();
    }

    public void add(int idFurnizor, String serie, Timestamp dateadd, String auto, boolean transferBased, int idTipCheltuiala, int idSocietateaNoastra, int tipFactura, Timestamp dataScadenta) throws SQLException {
        this.add.setInt(1, idFurnizor);
        this.add.setString(2, serie);
        this.add.setTimestamp(3, dateadd);
        this.add.setString(4, auto);
        this.add.setInt(5, transferBased ? 1 : 0);
        if (idTipCheltuiala == -1) {
            this.add.setNull(6, 4);
        } else {
            this.add.setInt(6, idTipCheltuiala);
        }
        if (idSocietateaNoastra > 0) {
            this.add.setInt(7, idSocietateaNoastra);
        } else {
            this.add.setNull(7, 4);
        }
        this.add.setInt(8, tipFactura);
        this.add.setTimestamp(9, dataScadenta);
        this.add.execute();
    }

    public void delete(int idFactura) throws SQLException {
        this.delete.setInt(1, idFactura);
        this.delete.execute();
    }

    public void update(Factura factura) throws SQLException {
        this.update.setDouble(1, factura.getTotal());
        this.update.setDouble(2, factura.getTotalTva());
        this.update.setDouble(3, factura.getTotalGeneral());
        this.update.setTimestamp(4, factura.getDateadd());
        this.update.setString(5, factura.getSerieFactura());
        this.update.setInt(6, factura.getIdFurnizor());
        int idTipCheltuiala = factura.getIdTipCheltuiala();
        if (idTipCheltuiala > 0) {
            this.update.setInt(7, idTipCheltuiala);
        } else {
            this.update.setNull(7, 4);
        }
        this.update.setInt(8, factura.isTransferBased() ? 1 : 0);
        int idSocNoastra = factura.getIdSocietateProprie();
        if (idSocNoastra > 0) {
            this.update.setInt(9, idSocNoastra);
        } else {
            this.update.setNull(9, 4);
        }
        this.update.setInt(10, factura.getTipFactura());
        this.update.setTimestamp(11, factura.getDataScadenta());
        this.update.setInt(12, factura.getId());
        this.update.execute();
    }

    public Factura getByIdNoCommit(int idFactura) throws SQLException {
        this.getById.setInt(1, idFactura);
        ResultSet rs = this.getById.executeQuery();
        Factura result = null;
        if (rs.next()) {
            result = this.getFacturaFromRs(rs);
        }
        rs.close();
        return result;
    }

    private Factura getFacturaFromRs(ResultSet rs) throws SQLException {
        int idSocietateaNoastra = rs.getInt("id_societatea_noastra");
        Factura f = new Factura(rs.getInt("id"), rs.getInt("id_furnizor"), rs.getString("serie_factura"), rs.getTimestamp("dateadd"), rs.getString("auto"), rs.getInt("transfer_based") == 1, rs.getInt("id_tip_cheltuiala"), idSocietateaNoastra > 0 ? idSocietateaNoastra : -1, rs.getInt("tip_factura"), rs.getTimestamp("data_scadenta"));
        f.setTotal(rs.getDouble("total_nou"));
        f.setTotalTva(rs.getDouble("totaltva_nou"));
        f.setTotalGeneral(rs.getDouble("totalgeneral_nou"));
        f.setComandaType(StockLogic.getInstance().getComandaTypeById(rs.getInt("comanda_type")));
        return f;
    }

    public Vector<Factura> getAll() throws SQLException {
        Vector<Factura> result = new Vector<Factura>();
        ResultSet rs = this.selectAll.executeQuery();
        while (rs.next()) {
            Factura f = this.getFacturaFromRs(rs);
            result.add(f);
        }
        rs.close();
        return result;
    }

    public Vector<FacturiEntry> getFacturi(int furnizorValue, Timestamp startDate, Timestamp stopDate, int whatToPrint, int idSocietateaNoastra, int tipFactura, int comandaType) throws SQLException {
        Vector<FacturiEntry> result = new Vector<FacturiEntry>();
        int ficus = -1;
        switch (whatToPrint) {
            case 2: {
                ficus = 1;
                break;
            }
            case 3: {
                ficus = 0;
            }
        }
        this.getFacturi.setInt(1, ficus);
        this.getFacturi.setInt(2, ficus);
        this.getFacturi.setInt(3, furnizorValue);
        this.getFacturi.setInt(4, furnizorValue);
        this.getFacturi.setTimestamp(5, startDate);
        this.getFacturi.setTimestamp(6, stopDate);
        this.getFacturi.setInt(7, idSocietateaNoastra);
        this.getFacturi.setInt(8, idSocietateaNoastra);
        this.getFacturi.setInt(9, tipFactura);
        this.getFacturi.setInt(10, tipFactura);
        this.getFacturi.setInt(11, comandaType);
        this.getFacturi.setInt(12, comandaType);
        ResultSet rs = this.getFacturi.executeQuery();
        while (rs.next()) {
            FacturiEntry f = new FacturiEntry();
            Timestamp d = rs.getTimestamp("dateadd");
            f.setDataEmiterii(d);
            f.setDataEmiteriiString(Formatters.DATE_AND_TIME_FORMAT.format(d));
            f.setIdFactura(rs.getInt("id_factura"));
            f.setIdFurnizor(rs.getInt("id_furnizor"));
            f.setNrFactura(rs.getString("serie"));
            f.setNrNir(rs.getString("numar_nir"));
            double total = rs.getDouble("totalgeneral_nou");
            f.setTotalGeneral(total);
            f.setIdSocietate(rs.getInt("id_societatea_noastra"));
            f.setTipFactura(ContaLogic.getInstance().getTipDocumentNirFromDb(rs.getInt("tip_factura")));
            result.add(f);
        }
        rs.close();
        return result;
    }

    public Vector getFacturiNeplatitePtFurnizor(int idFurnizor, int whatToPrint) throws SQLException {
        Vector<FacturiNeplatiteEntry> result = new Vector<FacturiNeplatiteEntry>();
        int ficus = -1;
        switch (whatToPrint) {
            case 2: {
                ficus = 1;
                break;
            }
            case 3: {
                ficus = 0;
            }
        }
        this.getFacturiNeplatitePtFurnizor.setInt(1, ficus);
        this.getFacturiNeplatitePtFurnizor.setInt(2, ficus);
        this.getFacturiNeplatitePtFurnizor.setInt(3, idFurnizor);
        ResultSet rs = this.getFacturiNeplatitePtFurnizor.executeQuery();
        while (rs.next()) {
            FacturiNeplatiteEntry f = new FacturiNeplatiteEntry();
            f.setDate(rs.getTimestamp("dateadd"));
            f.setPlatit(rs.getDouble("suma_achitata"));
            f.setTotal(rs.getDouble("totalgeneral_nou"));
            f.compute();
            f.setFactura(rs.getString("serie_factura"));
            f.setIdFactura(rs.getInt("id"));
            result.add(f);
        }
        rs.close();
        return result;
    }
}

