/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.contabilitate.Furnizor;
import ro.atreides.utils.db.DaoInterface;

public class FurnizoriDao
implements DaoInterface {
    private PreparedStatement add;
    private PreparedStatement selectAll;
    private PreparedStatement markDeleted;
    private PreparedStatement update;
    private PreparedStatement getById;
    private PreparedStatement deleteAll;
    private PreparedStatement getByCui;
    private PreparedStatement getByNume;
    private Connection conn;

    public FurnizoriDao(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    public Connection getConn() {
        return this.conn;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.add = this.conn.prepareStatement("insert into furnizori ( nume, cui, banca, iban, localitatea, adresa, j, autos, cod, analitic) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.selectAll = this.conn.prepareStatement("select * from furnizori where status = 1 order by nume");
        this.getById = this.conn.prepareStatement("select * from furnizori where id = ?");
        this.getByCui = this.conn.prepareStatement("select * from furnizori where cui = ?");
        this.getByNume = this.conn.prepareStatement("select * from furnizori where nume = ?");
        this.markDeleted = this.conn.prepareStatement("update furnizori set status = 2 where id = ?");
        this.update = this.conn.prepareStatement("update furnizori set nume = ?, j = ? , cui = ?, banca = ?, iban = ?, localitatea = ?, adresa =?, autos = ?, cod = ?, analitic = ? where id = ?");
        this.deleteAll = this.conn.prepareStatement("delete from furnizori");
    }

    public Furnizor getByNume(String nume) throws SQLException {
        Furnizor result = null;
        this.getByNume.setString(1, nume);
        ResultSet rs = this.getByNume.executeQuery();
        if (rs.next()) {
            result = this.getFromRs(rs);
        }
        rs.close();
        return result;
    }

    public Furnizor getByCui(String cui) throws SQLException {
        Furnizor result = null;
        this.getByCui.setString(1, cui);
        ResultSet rs = this.getByCui.executeQuery();
        if (rs.next()) {
            result = this.getFromRs(rs);
        }
        rs.close();
        return result;
    }

    public void deleteAll() throws SQLException {
        this.deleteAll.execute();
    }

    public void add(Furnizor fur) throws SQLException {
        this.add.setString(1, fur.getNume());
        this.add.setString(2, fur.getCui());
        this.add.setString(3, fur.getBanca());
        this.add.setString(4, fur.getIban());
        this.add.setString(5, fur.getLocalitate());
        this.add.setString(6, fur.getAdresa());
        this.add.setString(7, fur.getJ());
        this.add.setString(8, fur.getAutos());
        this.add.setString(9, fur.getCod());
        this.add.setString(10, fur.getAnalitic());
        this.add.execute();
    }

    public void markDeleted(Furnizor fur) throws SQLException {
        this.markDeleted.setInt(1, fur.getId());
        this.markDeleted.execute();
    }

    public void update(Furnizor fur) throws SQLException {
        this.update.setString(1, fur.getNume());
        this.update.setString(2, fur.getJ());
        this.update.setString(3, fur.getCui());
        this.update.setString(4, fur.getBanca());
        this.update.setString(5, fur.getIban());
        this.update.setString(6, fur.getLocalitate());
        this.update.setString(7, fur.getAdresa());
        this.update.setString(8, fur.getAutos());
        this.update.setString(9, fur.getCod());
        this.update.setString(10, fur.getAnalitic());
        this.update.setInt(11, fur.getId());
        this.update.execute();
    }

    public Vector getAll() throws SQLException {
        Vector<Furnizor> result = new Vector<Furnizor>();
        ResultSet rs = this.selectAll.executeQuery();
        while (rs.next()) {
            Furnizor f = this.getFromRs(rs);
            result.add(f);
        }
        rs.close();
        return result;
    }

    private Furnizor getFromRs(ResultSet rs) throws SQLException {
        Furnizor f = new Furnizor(rs.getInt("id"), rs.getString("nume"), rs.getString("j"), rs.getString("cui"), rs.getString("iban"), rs.getString("banca"), rs.getString("localitatea"), rs.getString("adresa"), rs.getString("cod"), rs.getString("analitic"));
        f.setAutos(rs.getString("autos"));
        return f;
    }

    public Furnizor getById(int idFur) throws SQLException {
        this.getById.setInt(1, idFur);
        ResultSet rs = this.getById.executeQuery();
        if (rs.next()) {
            Furnizor f = this.getFromRs(rs);
            return f;
        }
        rs.close();
        return null;
    }
}

