/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.contabilitate.Nir;
import ro.atreides.contabilitate.db.NiruriDiferente;
import ro.atreides.utils.db.DaoInterface;

public class NiruriDao
implements DaoInterface {
    private PreparedStatement add;
    private PreparedStatement selectAll;
    private PreparedStatement delete;
    private PreparedStatement update;
    private PreparedStatement getFacturaId;
    private PreparedStatement getById;
    private PreparedStatement getLastNrNir;
    private PreparedStatement getByFacturaId;
    private PreparedStatement deleteAllNiruri;
    private PreparedStatement addNirDiff;
    private PreparedStatement deleteNirDiff;
    private PreparedStatement getNirDiff;
    private PreparedStatement isNrNirTaken;
    private PreparedStatement getByNrNir;
    private Connection conn;

    public NiruriDao(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    public Connection getConn() {
        return this.conn;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.isNrNirTaken = this.conn.prepareStatement("select niruri.* from niruri inner join facturi on niruri.id_factura = facturi.id where to_number(coalesce(nr_nir,'0'), '99999999') = ? and (id_societatea_noastra = ? or ? = -1)");
        this.addNirDiff = this.conn.prepareStatement("insert into niruri_diferente ( id_nir, diff_valoare, diff_tva ) values ( ?, ?, ?) ");
        this.getNirDiff = this.conn.prepareStatement("select * from niruri_diferente where id_nir = ?");
        this.deleteNirDiff = this.conn.prepareStatement("delete from niruri_diferente where id_nir = ?");
        this.add = this.conn.prepareStatement("insert into niruri ( id_factura, nr_nir, status ) values ( ?, ?, 1)");
        this.selectAll = this.conn.prepareStatement("select * from niruri where status = 1");
        this.getById = this.conn.prepareStatement("select * from niruri where id = ?");
        this.getByNrNir = this.conn.prepareStatement("select * from niruri where nr_nir = ?");
        this.getFacturaId = this.conn.prepareStatement("select id_factura from niruri where id = ?");
        this.delete = this.conn.prepareStatement("delete from niruri where id = ?");
        this.update = this.conn.prepareStatement("update niruri set total_nou = ?, totaltva_nou = ?, totalgeneral_nou = ?, status = ?, nr_nir = ? where id = ?");
        this.getLastNrNir = this.conn.prepareStatement("select to_number(coalesce(nr_nir,'0'), '99999999') as nr_nir_integer from niruri inner join facturi on niruri.id_factura = facturi.id where facturi.id_societatea_noastra = ? or ? = -1 order by dateadd desc");
        this.getByFacturaId = this.conn.prepareStatement("select * from niruri where id_factura = ?");
        this.deleteAllNiruri = this.conn.prepareStatement("delete from niruri");
    }

    public boolean isNrNirTaken(int nr, int idSocietateaNoastra) throws SQLException {
        this.isNrNirTaken.setInt(1, nr);
        this.isNrNirTaken.setInt(2, idSocietateaNoastra);
        this.isNrNirTaken.setInt(3, idSocietateaNoastra);
        ResultSet rs = this.isNrNirTaken.executeQuery();
        boolean result = false;
        if (rs.next()) {
            result = true;
        }
        rs.close();
        return result;
    }

    public void updateNirDiff(int idNir, double diffValoare, double diffTva) throws SQLException {
        this.deleteNirDiff.setInt(1, idNir);
        this.deleteNirDiff.execute();
        this.addNirDiff(idNir, diffValoare, diffTva);
    }

    private void addNirDiff(int idNir, double diffValoare, double diffTva) throws SQLException {
        this.addNirDiff.setInt(1, idNir);
        this.addNirDiff.setDouble(2, diffValoare);
        this.addNirDiff.setDouble(3, diffTva);
        this.addNirDiff.execute();
    }

    public NiruriDiferente getNirDiff(int idNir) throws SQLException {
        this.getNirDiff.setInt(1, idNir);
        ResultSet rs = this.getNirDiff.executeQuery();
        NiruriDiferente result = null;
        if (rs.next()) {
            result = new NiruriDiferente(rs.getInt("id"), rs.getInt("id_nir"), rs.getDouble("diff_tva"), rs.getDouble("diff_valoare"));
        }
        rs.close();
        return result;
    }

    public void deleteAll() throws SQLException {
        this.deleteAllNiruri.execute();
    }

    public int getLastNrNir(int idSocietateaNoastra) throws SQLException {
        this.getLastNrNir.setInt(1, idSocietateaNoastra);
        this.getLastNrNir.setInt(2, idSocietateaNoastra);
        ResultSet rs = this.getLastNrNir.executeQuery();
        int result = 0;
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void add(int idFactura, int numarNir) throws SQLException {
        this.add.setInt(1, idFactura);
        this.add.setInt(2, numarNir);
        this.add.execute();
    }

    public void delete(Nir fur) throws SQLException {
        this.delete.setInt(1, fur.getId());
        this.delete.execute();
    }

    public void update(int idNir, int numar, int status, double total, double tva, double totalCuTva) throws SQLException {
        this.update.setDouble(1, total);
        this.update.setDouble(2, tva);
        this.update.setDouble(3, totalCuTva);
        this.update.setInt(4, status);
        this.update.setInt(5, numar);
        this.update.setInt(6, idNir);
        this.update.execute();
    }

    public Nir getById(int idNir) throws SQLException {
        this.getById.setInt(1, idNir);
        ResultSet rs = this.getById.executeQuery();
        Nir result = null;
        if (rs.next()) {
            result = this.getFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Nir getByNrNir(int nrNir) throws SQLException {
        this.getByNrNir.setInt(1, nrNir);
        ResultSet rs = this.getByNrNir.executeQuery();
        Nir result = null;
        if (rs.next()) {
            result = this.getFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Nir getByFacturaId(int idFactura) throws SQLException {
        this.getByFacturaId.setInt(1, idFactura);
        ResultSet rs = this.getByFacturaId.executeQuery();
        Nir result = null;
        if (rs.next()) {
            result = this.getFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Vector getAll() throws SQLException {
        Vector<Nir> result = new Vector<Nir>();
        ResultSet rs = this.selectAll.executeQuery();
        while (rs.next()) {
            Nir f = this.getFromResultSet(rs);
            result.add(f);
        }
        rs.close();
        return result;
    }

    private Nir getFromResultSet(ResultSet rs) throws SQLException {
        Nir f = new Nir(rs.getInt("id"), rs.getInt("id_factura"), rs.getInt("nr_nir"), rs.getDouble("total_nou"), rs.getDouble("totaltva_nou"), rs.getDouble("totalgeneral_nou"), rs.getInt("status"));
        return f;
    }

    public int getFacturaIdNoCommit(int nirId) throws SQLException {
        this.getFacturaId.setInt(1, nirId);
        ResultSet rs = this.getFacturaId.executeQuery();
        int result = -1;
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }
}

