/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.export;

import java.awt.Component;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import ro.atreides.contabilitate.export.ContaExportBean;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class ContaGenericExport {
    public static ContaExportBean exportDateConta(Component parent, Date d1, Date d2) {
        boolean ok;
        ContaExportBean result = new ContaExportBean();
        int anStop = DateUtils.getYearFromDate(d2);
        int lunaStop = DateUtils.getMonthFromDate(d2);
        int lunaStart = DateUtils.getMonthFromDate(d1);
        int anStart = DateUtils.getYearFromDate(d1);
        if (anStart != anStop || lunaStart != lunaStop) {
            DialogUtils.errorDialog(parent, "Exportul se poate face pe maxim o luna calendaristica", LangRoAll.nuPotContinua);
            return null;
        }
        String destinationPath = Config.getInstance().getString("contaExportDir", "saga");
        File dir = new File(destinationPath = new File(destinationPath).getAbsolutePath());
        if (dir.exists() && dir.isFile()) {
            DialogUtils.errorDialog(parent, "Fisierul " + destinationPath + " ar trebui sa fie director. Va rugam sa-l stergeti.", LangRoAll.nuPotContinua);
            return null;
        }
        if (!dir.exists() && !(ok = dir.mkdirs())) {
            DialogUtils.errorDialog(parent, "Nu am putut crea directorul " + destinationPath + ". Verificati drepturile de scriere.", LangRoAll.nuPotContinua);
            return null;
        }
        String destinationPath1 = destinationPath + File.separator + Formatters.currentDateAndTimeForFileSystem.format(new Date());
        new File(destinationPath1).mkdirs();
        result.setDestinationPath(destinationPath1);
        result.setD1(d1);
        result.setD2(d2);
        result.setAnStart(anStart);
        result.setLunaStart(lunaStart);
        return result;
    }

    public static ContaExportBean exportDateConta(Component parent) {
        Date d1 = DateUtils.getFirstDayOfCurrentMonth();
        String s1 = Formatters.DATE_AND_TIME_FORMAT.format(d1);
        String start = DialogUtils.inputDialog(parent, s1, "Introduceti data de start");
        if (!Validators.correctDate(start, Formatters.DATE_AND_TIME_FORMAT)) {
            DialogUtils.errorDialog(parent, "Format de data incorect", LangRoAll.nuPotContinua);
            return null;
        }
        try {
            d1 = Formatters.DATE_AND_TIME_FORMAT.parse(start);
        }
        catch (ParseException e) {
            // empty catch block
        }
        int lunaStart = DateUtils.getMonthFromDate(d1);
        int anStart = DateUtils.getYearFromDate(d1);
        Date d2 = DateUtils.getFirstDay(lunaStart - 1, anStart);
        d2 = DateUtils.advanceOneMonth(d2);
        d2 = DateUtils.addDaysToDate(d2, -1);
        d2 = DateUtils.getEndOfDay(d2);
        String s2 = Formatters.DATE_AND_TIME_FORMAT.format(d2);
        String stop = DialogUtils.inputDialog(parent, s2, "Introduceti data de stop");
        if (!Validators.correctDate(stop, Formatters.DATE_AND_TIME_FORMAT)) {
            DialogUtils.errorDialog(parent, "Format de data incorect", LangRoAll.nuPotContinua);
            return null;
        }
        d2 = DateUtils.getEndOfDay(d2);
        try {
            d2 = Formatters.DATE_AND_TIME_FORMAT.parse(stop);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return ContaGenericExport.exportDateConta(parent, d1, d2);
    }
}

