/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.gui.AgedDebtorsEntry;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.print.PrintLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.SimpleDateSelector;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class AgedDebtorsReport
extends AbstractReportPanel {
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JComboBox tipCombo;
    public static String[] columns;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        stopDate = DateUtils.advanceOneDay(stopDate);
        stopDate = DateUtils.addMillisToDate(stopDate, -1L);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put("Facturat pana la", Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        String tip = (String)this.tipCombo.getSelectedItem();
        if (tip.equalsIgnoreCase("pana la data")) {
            this.printCriteria.put("Colectat pana la", Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        } else {
            this.printCriteria.put("Colectat pana la", Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(new Date()));
        }
        result.put("Colectat", tip);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Colectat"), c);
        ++c.gridx;
        this.tipCombo = new JComboBox();
        result.add((Component)this.tipCombo, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(4), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                AgedDebtorsEntry fe = (AgedDebtorsEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fe.getClient();
                    }
                    case 1: {
                        return Utils.getString2Decimals(fe.get_0_30());
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.get_31_60());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.get_61_90());
                    }
                    case 4: {
                        return Utils.getString2Decimals(fe.get_91_120());
                    }
                    case 5: {
                        return Utils.getString2Decimals(fe.get_121_180());
                    }
                    case 6: {
                        return Utils.getString2Decimals(fe.getOver180());
                    }
                    case 7: {
                        return Utils.getString2Decimals(fe.getTotal());
                    }
                    case 8: {
                        return Utils.getString2Decimals(fe.getTva());
                    }
                }
                return Utils.getString2Decimals(fe.getValue(columnIndex - 9));
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        return null;
    }

    @Override
    public String getName() {
        return "Aged Debtors";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ContaLogic.getInstance().getAgedDebtorsReport(criteria);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    AgedDebtorsEntry fe = (AgedDebtorsEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, fe.getClient());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, fe.get_0_30()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.get_31_60()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.get_61_90()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.get_91_120()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.get_121_180()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getOver180()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getTotal()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getTva()));
                        ++column;
                        while (column < columns.length) {
                            sheet.addCell((WritableCell)new Number(column, row, fe.getValue(column - 9)));
                            ++column;
                        }
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return AgedDebtorsReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                if (column == 0) {
                    return 3;
                }
                return 2;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    default: 
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return AgedDebtorsReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return AgedDebtorsReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                AgedDebtorsEntry fe = (AgedDebtorsEntry)row;
                switch (column) {
                    case 0: {
                        return fe.getClient();
                    }
                    case 1: {
                        return Utils.getString2Decimals(fe.get_0_30());
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.get_31_60());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.get_61_90());
                    }
                    case 4: {
                        return Utils.getString2Decimals(fe.get_91_120());
                    }
                    case 5: {
                        return Utils.getString2Decimals(fe.get_121_180());
                    }
                    case 6: {
                        return Utils.getString2Decimals(fe.getOver180());
                    }
                    case 7: {
                        return Utils.getString2Decimals(fe.getTotal());
                    }
                    case 8: {
                        return Utils.getString2Decimals(fe.getTva());
                    }
                }
                return Utils.getString2Decimals(fe.getValue(column - 9));
            }
        };
        this.tipCombo.addItem("pana la data");
        this.tipCombo.addItem("la zi");
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return new SimpleDateSelector();
    }

    static {
        Vector categories = NomeclaturaLogic.getInstance().getCategoriiPrincipale();
        int columnSize = 8;
        if (Config.getInstance().getBoolean("agedDebtorsShowCategories")) {
            columnSize += 1 + categories.size();
        }
        columns = new String[columnSize];
        AgedDebtorsReport.columns[0] = LangRoAll.client;
        AgedDebtorsReport.columns[1] = "0-30";
        AgedDebtorsReport.columns[2] = "31-60";
        AgedDebtorsReport.columns[3] = "61-90";
        AgedDebtorsReport.columns[4] = "91-120";
        AgedDebtorsReport.columns[5] = "121-180";
        AgedDebtorsReport.columns[6] = "> 180";
        AgedDebtorsReport.columns[7] = LangRoAll.total;
        if (Config.getInstance().getBoolean("agedDebtorsShowCategories")) {
            AgedDebtorsReport.columns[8] = LangRoAll.tva;
            for (int i = 0; i < categories.size(); ++i) {
                Categorie categorie = (Categorie)categories.elementAt(i);
                AgedDebtorsReport.columns[i + 9] = categorie.getName();
            }
        }
    }
}

