/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class AutosTableModel
extends AbstractTableModel {
    private Vector data = new Vector();
    private static final String[] columns = new String[]{"Numar inmatriculare"};

    public AutosTableModel(String commaSeparatedAutos) {
        this.buildData(commaSeparatedAutos);
    }

    public void setAutos(String commaSeparatedAutos) {
        this.buildData(commaSeparatedAutos);
        this.fireTableDataChanged();
    }

    private void buildData(String commaSeparatedAutos) {
        this.data = new Vector();
        if (commaSeparatedAutos == null) {
            commaSeparatedAutos = "";
        }
        StringTokenizer token = new StringTokenizer(commaSeparatedAutos, ",");
        while (token.hasMoreTokens()) {
            this.data.add(token.nextToken());
        }
    }

    public String getAutos() {
        String result = "";
        for (String element : this.data) {
            result = result + element + ",";
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return (String)this.data.elementAt(rowIndex);
    }

    public void refresh(String commaSeparatedAutos) {
        this.buildData(commaSeparatedAutos);
        this.fireTableDataChanged();
    }

    public String getAutoAtRow(int row) {
        return (String)this.data.elementAt(row);
    }
}

