/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jxl.read.biff.BiffException;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import net.miginfocom.swing.MigLayout;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.Nir;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.contabilitate.gui.EditNirAddEntryInterface;
import ro.atreides.contabilitate.imports.GenericFacturaXlsImporter;
import ro.atreides.contabilitate.imports.GenericFacturaXlsImporterInterface;
import ro.atreides.contabilitate.imports.ciel.CielInventarDeschidereImporter;
import ro.atreides.contabilitate.imports.ciel.CielInvertarLaZiImporterFromExcel;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.simplestocks.SimpleStockDiff;
import ro.atreides.stocks.Lot;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.ReceptieFromStockInterface;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ContaExportMapping;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ObjectEventListener;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.TimedPermissionsInterface;
import ro.atreides.utils.Unit;
import ro.atreides.utils.UnitsProvider;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.SwitchToList;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.units.UnitsLogic;

public class EditNirPanel
extends ReflectedJPanel
implements CleanupRequired,
EditNirAddEntryInterface {
    private Vector stockDiffQuantities = new Vector();
    private TimedPermissionsInterface timePermission;
    private ContaLogic contaLogic;
    private Component parent;
    private UnitsProvider unitsProvider;
    private StockLogic stockLogic;
    private JComboBox furnizori;
    private JComboBox tipDocument;
    private JComboBox tva;
    private JComboBox magazii;
    private JComboBox societati;
    private JComboBox tipComanda;
    private XComboBox produse;
    private JTextField serieFactura;
    private JTextField produsFacturaText;
    private JTextField umText;
    private JTextField adaosText;
    private JTextField pretCuTvaText;
    private JTextField pretFaraTvaText;
    private JTextField nrPachete;
    private JTextField valoareAchizitieText;
    private JTextField numarNir;
    private JTextField reducereText;
    private JTextField cantitateNeta;
    private JTextField time;
    private JTextField codBareTF;
    private JTextField valoareFactura;
    private JTextField valoareTvaTotal;
    private JTextField valoareTvaProdus;
    private JTextField cheltuieliAsociate;
    private JTextField cheltuieliPeProdus;
    private JTextField tvaCheltuieli;
    private JTextField cursValutar;
    private JTextField lotNumar;
    private JButton adauga;
    private JButton salveaza;
    private JButton inapoi;
    private JRadioButton adaosRadio;
    private JRadioButton pretCuTvaRadio;
    private JRadioButton pretFaraTvaRadio;
    private JRadioButton faraPretRadio;
    private ButtonGroup pretGroup;
    private MDateEntryField data;
    private MDateEntryField lotDataExpirare;
    private MDateEntryField scadenta;
    private JPanel dateProdus;
    private double oldPrice;
    private JLabel totalFactura;
    private JLabel totalTvaFurnizorLabel;
    private JLabel totalFacturaCuTva;
    private JLabel totalAmanuntCuTvaLabel;
    private JLabel totalAdaosLabel;
    private JLabel totalTvaLabel;
    private JLabel diferenteValoareLabel;
    private JLabel diferenteTvaLabel;
    private JLabel diferenteTotaleLabel;
    private AbstractTM itemsTm;
    private double valoareFurnizor;
    private double tvaFurnizor;
    private double totalFurnizor;
    private double totalAmanuntCuTva;
    private double totalAmanuntFaraTva;
    private double totalTvaAmanunt;
    private double cotaTva1;
    private double totalAdaos;
    private SwitchToList action;
    private Factura factura;
    private Nir nir;
    private JRadioButton cuIncarcare;
    private JRadioButton faraIncarcare;
    private FocusTraversalPolicy focus;
    private boolean fiscal = true;
    private boolean cheltuieliExists = false;
    private FilterableComboBoxModel comboModel;
    private ObjectEventListener addEntriesObjectListener;
    private ObjectEventListener addNotaEntriesVectorListener;
    private NirEntryFull lineToEdit = null;
    private Vector<Integer> idLoturiToRemove = new Vector();
    public static final String[] columns = new String[]{"N.c", LangRoAll.denumire, "UM", "Cant", "Magazie", "Ppu f TVA", "Val f TVA", "TVA/UM", "TVA Total", "Total factura", "Adaos %", LangRoAll.suma, "Ppu amanunt f TVA", "TVA adaos com", "Ppu amanunt c TVA", "Val la ppu amanunt f TVA", "Val la ppu amanunt c TVA", "TVA/UM amanunt", "TVA Total"};

    @Override
    public void doStuff() {
    }

    public void setTimePermission(TimedPermissionsInterface timePermission) {
        this.timePermission = timePermission;
    }

    public EditNirPanel(ContaLogic nirLogic, Component parent) {
        this.contaLogic = nirLogic;
        this.parent = parent;
        this.stockLogic = StockLogic.getInstance();
        this.unitsProvider = nirLogic.getUnitsProvider();
        this.init();
        if (this.produse.getItemCount() > 0) {
            this.produse.setSelectedIndex(0);
            this.updateUnitateMasura();
            this.updateProductName();
        }
    }

    public void setFactura(Factura f, Nir nir) {
        DialogUtils.okDialog(this.parent, "ATENTIE ! Modificarile pe care le faceti afecteaza o factura deja salvata", LangRoAll.confirmare);
        DialogUtils.okDialog(this.parent, "DACA NU DORITI SA SALVATI FOLOSITI BUTONUL INAPOI ", LangRoAll.atentie);
        this.factura = f;
        this.nir = nir;
        Vector<NirEntryFull> newData = this.contaLogic.getDataForNir(nir.getId());
        this.updateVectorNirWithSecondLine(newData);
        this.itemsTm.refresh(newData);
        this.valoareFactura.setText(Utils.getString2Decimals(f.getTotal()));
        this.valoareTvaTotal.setText(Utils.getString2Decimals(f.getTotalTva()));
        this.updateTotals();
        this.inapoi.setEnabled(true);
        this.numarNir.setText("" + nir.getNumarNir());
        this.serieFactura.setText(this.factura.getSerieFactura());
        this.furnizori.setSelectedItem(ClientLogic.getInstance().getClientById(this.factura.getIdFurnizor()));
        this.tipDocument.setSelectedItem((Object)ContaLogic.getInstance().getTipDocumentNirFromDb(this.factura.getTipFactura()));
        this.data.setValue((Date)this.factura.getDateadd());
        this.scadenta.setValue((Date)this.factura.getDataScadenta());
        this.time.setText(Formatters.TIME_FORMAT.format(this.factura.getDateadd()));
        if (f.isTransferBased()) {
            this.faraIncarcare.doClick();
        } else {
            this.cuIncarcare.doClick();
        }
        this.tipComanda.setSelectedItem((Object)this.factura.getComandaType());
        this.stockDiffQuantities = new Vector();
    }

    public void setAction(SwitchToList action) {
        this.action = action;
    }

    private Stock getStockFromCodBare() {
        String cod = this.codBareTF.getText().trim().replaceAll("\n", "");
        Product p = NomeclaturaLogic.getInstance().getProductByCodBare(cod);
        if (p != null) {
            int s = this.contaLogic.getInter().getStockForProduct(p.getId());
            return this.stockLogic.getStockById(s);
        }
        return null;
    }

    private boolean updateProdusByCod() {
        Stock s = this.getStockFromCodBare();
        if (s != null) {
            this.produse.setSelectedItem(s);
            return true;
        }
        return false;
    }

    private void updateUnitateMasuraCod() {
        Stock s = this.getStockFromCodBare();
        if (s != null) {
            this.updateUnitateMasura(s);
        }
    }

    private void updateUnitateMasura() {
        Stock s = (Stock)this.produse.getSelectedItem();
        this.updateUnitateMasura(s);
    }

    private void updateUnitateMasura(Stock s) {
        if (s != null) {
            Integer idUnit = s.getIdUnit();
            Unit u = this.unitsProvider.getUnitById(idUnit);
            this.umText.setText(u.getLabel());
        }
    }

    private void updateproductNameCod() {
        Stock s = this.getStockFromCodBare();
        if (s != null) {
            this.updateProductName(s);
        }
    }

    private void updateProductName() {
        Stock s = (Stock)this.produse.getSelectedItem();
        this.updateProductName(s);
    }

    private void updateProductName(Stock s) {
        if (s != null) {
            String productName = s.getLabel();
            this.produsFacturaText.setText(productName);
        }
        this.updateTva(s);
    }

    private void updateTva(Stock s) {
        if (((ContaLogic.TIP_DOCUMENT_NIR)((Object)this.tipDocument.getSelectedItem())).equals((Object)ContaLogic.TIP_DOCUMENT_NIR.BorderouAchizitii)) {
            this.setTvaProdusZero();
            return;
        }
        double tva = Config.getInstance().getDouble("tvaProcent");
        if (Utils.isValueZero(tva)) {
            this.setTvaProdusZero();
        } else {
            Client furnizor = (Client)this.furnizori.getSelectedItem();
            if (furnizor != null) {
                if (this.contaLogic.isPlatitorTva(furnizor.getId())) {
                    int idProduct;
                    if (s != null && (idProduct = this.stockLogic.getProductForStockFromDB(s.getId())) > 0) {
                        Product productById = NomeclaturaLogic.getInstance().getProductById(idProduct);
                        Categorie c = NomeclaturaLogic.getInstance().getCategoryById(productById.getIdCategorie());
                        int idTva = c.getIdTva();
                        Tva correctTva = TvaLogic.getInstance().getTvaById(idTva);
                        this.tva.setSelectedItem(correctTva);
                    }
                } else {
                    this.setTvaProdusZero();
                }
            }
        }
    }

    private void setTvaProdusZero() {
        Tva zeroTva = TvaLogic.getInstance().getTvaByCota(0.0);
        this.tva.setSelectedItem(zeroTva);
    }

    private boolean isMagazieDeMarfa() {
        Magazie m = (Magazie)this.magazii.getSelectedItem();
        return m != null && m.isMagazieMarfa();
    }

    private void updateMagazie() {
        Magazie m;
        Stock s = (Stock)this.produse.getSelectedItem();
        if (s != null && (m = this.contaLogic.getLastMagazieIntrareForStock(s.getId())) != null) {
            this.magazii.setSelectedItem(m);
        }
    }

    private void updatePrice() {
        Stock s = (Stock)this.produse.getSelectedItem();
        if (s == null) {
            return;
        }
        this.updatePrice(s);
        double pretMediuAchizitie = 0.0;
        pretMediuAchizitie = this.contaLogic.getPretAchizitieForStock(s.getId(), 0.0, false);
        this.valoareAchizitieText.setText(Utils.getString2Decimals(pretMediuAchizitie));
    }

    private void updatePrice(Stock s) {
        if (s != null) {
            if (this.isMagazieDeMarfa() || this.stockLogic.isProdusFinit(s.getId())) {
                double price = this.stockLogic.getCatalogPriceForStock(s.getId());
                this.pretCuTvaText.setText(Utils.getString2Decimals(price));
                Product p = this.stockLogic.getProductForStock(s.getId());
                Categorie cat = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
                Tva t = TvaLogic.getInstance().getTvaById(cat.getIdTva());
                double tvaNoi = t.getCota();
                TvaLogic.getInstance();
                double priceFaraTva = TvaLogic.getPretFaraTva(price, tvaNoi);
                this.pretFaraTvaText.setText(Utils.getString2Decimals(priceFaraTva));
                this.pretCuTvaRadio.requestFocus();
                this.oldPrice = price;
            } else {
                this.pretCuTvaText.setText("");
                this.pretFaraTvaText.setText("");
                this.faraPretRadio.setSelected(true);
                this.oldPrice = 0.0;
            }
        }
    }

    private Component checkMagazieProduseCompatibility(Component succesComponent, Component produseComponent, Component magazieComponent) {
        Product p;
        Stock s = (Stock)this.produse.getSelectedItem();
        if (s == null) {
            System.out.println("Stock s is null: return focus to produse");
            return produseComponent;
        }
        if (this.isMagazieDeMarfa() && (p = this.stockLogic.getProductForStock(s.getId())) == null) {
            Magazie m = (Magazie)this.magazii.getSelectedItem();
            DialogUtils.errorDialog(this.parent, "Magazia " + m.getLabel() + " nu accepta materii prime ! Alegeti alta magazie !", LangRoAll.nuPotContinua);
            return magazieComponent;
        }
        return succesComponent;
    }

    private void init() {
        this.furnizori = new JComboBox();
        this.tipDocument = new JComboBox();
        this.refreshTipDocumentItems();
        this.tipComanda = new JComboBox();
        this.refreshTipComandaItems();
        this.societati = new JComboBox();
        ComboUtils.replaceItemsForCombo(this.societati, ClientLogic.getInstance().getSocietatiPropriiSorted(), false);
        boolean xComboSearchInProduct = Config.getInstance().getBoolean("XComboSearchInProduct");
        this.comboModel = new FilterableComboBoxModel(StockLogic.getInstance().getPowerSearchStocks());
        this.produse = new XComboBox(this.comboModel, xComboSearchInProduct);
        this.produse.setPrototypeDisplayValue("111111111111111111111111111111111");
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                EditNirPanel.this.refreshFurnizoriCombo();
            }

            @Override
            public String getName() {
                return "EditNirPanelFurnizoriListener";
            }
        }, 42);
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                EditNirPanel.this.comboModel.refresh(StockLogic.getInstance().getPowerSearchStocks());
            }

            @Override
            public String getName() {
                return "EditNirPanelStockListener";
            }
        }, 26);
        this.magazii = new JComboBox();
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                EditNirPanel.this.refreshMagaziiCombo();
            }

            @Override
            public String getName() {
                return "EditNirPanelMagaziiListener";
            }
        }, 27);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        this.add((Component)this.getTopPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        JPanel total = this.getTotalFacturaPanel();
        this.add((Component)total, c);
        ++c.gridx;
        JPanel buttons = this.getButtonsPanel();
        this.add((Component)buttons, c);
        this.focus = new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (GuiUtils.isXComboBox(aComponent)) {
                    EditNirPanel.this.updateUnitateMasura();
                    EditNirPanel.this.updateProductName();
                    EditNirPanel.this.updateMagazie();
                    Component target = EditNirPanel.this.checkMagazieProduseCompatibility(EditNirPanel.this.valoareAchizitieText, EditNirPanel.this.produse, EditNirPanel.this.magazii);
                    if (target == EditNirPanel.this.valoareAchizitieText) {
                        EditNirPanel.this.updatePrice();
                    }
                    return target;
                }
                if (aComponent.equals(EditNirPanel.this.codBareTF)) {
                    return EditNirPanel.this.valoareAchizitieText;
                }
                if (aComponent.equals(EditNirPanel.this.produsFacturaText)) {
                    return EditNirPanel.this.valoareAchizitieText;
                }
                if (aComponent.equals(EditNirPanel.this.tva)) {
                    return EditNirPanel.this.umText;
                }
                if (aComponent.equals(EditNirPanel.this.umText)) {
                    return EditNirPanel.this.valoareAchizitieText;
                }
                if (aComponent.equals(EditNirPanel.this.magazii)) {
                    Component target = EditNirPanel.this.checkMagazieProduseCompatibility(EditNirPanel.this.valoareAchizitieText, EditNirPanel.this.produse, EditNirPanel.this.magazii);
                    if (target == EditNirPanel.this.valoareAchizitieText) {
                        EditNirPanel.this.updatePrice();
                    }
                    return target;
                }
                if (aComponent.equals(EditNirPanel.this.valoareAchizitieText)) {
                    return EditNirPanel.this.cheltuieliPeProdus;
                }
                if (aComponent.equals(EditNirPanel.this.valoareTvaProdus)) {
                    return EditNirPanel.this.cantitateNeta;
                }
                if (aComponent.equals(EditNirPanel.this.reducereText)) {
                    return EditNirPanel.this.valoareTvaProdus;
                }
                if (aComponent.equals(EditNirPanel.this.cantitateNeta)) {
                    return EditNirPanel.this.nrPachete;
                }
                if (aComponent.equals(EditNirPanel.this.adaosText)) {
                    return EditNirPanel.this.adauga;
                }
                if (aComponent.equals(EditNirPanel.this.pretCuTvaText)) {
                    return EditNirPanel.this.adauga;
                }
                if (aComponent.equals(EditNirPanel.this.pretFaraTvaText)) {
                    return EditNirPanel.this.adauga;
                }
                if (aComponent.equals(EditNirPanel.this.nrPachete)) {
                    if (EditNirPanel.this.isMagazieDeMarfa()) {
                        return EditNirPanel.this.pretCuTvaText;
                    }
                    return EditNirPanel.this.adauga;
                }
                if (aComponent.equals(EditNirPanel.this.adauga)) {
                    return EditNirPanel.this.valoareAchizitieText;
                }
                if (aComponent.equals(EditNirPanel.this.valoareFactura)) {
                    return EditNirPanel.this.valoareTvaTotal;
                }
                if (aComponent.equals(EditNirPanel.this.valoareTvaTotal)) {
                    return EditNirPanel.this.cheltuieliAsociate;
                }
                if (aComponent.equals(EditNirPanel.this.cheltuieliAsociate)) {
                    return EditNirPanel.this.tvaCheltuieli;
                }
                if (aComponent.equals(EditNirPanel.this.tvaCheltuieli)) {
                    return EditNirPanel.this.cursValutar;
                }
                if (aComponent.equals(EditNirPanel.this.cursValutar)) {
                    return EditNirPanel.this.serieFactura;
                }
                if (aComponent.equals(EditNirPanel.this.cheltuieliPeProdus)) {
                    return EditNirPanel.this.reducereText;
                }
                return this.getDefaultComponent(aContainer);
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return null;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return EditNirPanel.this.produse;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return EditNirPanel.this.produse;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return EditNirPanel.this.adauga;
            }
        };
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(this.focus);
        this.addEntriesObjectListener = new ObjectEventListener(){

            @Override
            public void dataChanged(Object o) {
                EditNirPanel.this.itemsTm.refresh(new Vector());
                Hashtable hash = (Hashtable)o;
                Vector note = (Vector)hash.get("NoteView");
                Client c = (Client)((Hashtable)o).get("Furnizor");
                EditNirPanel.this.furnizori.setSelectedItem(c);
                EditNirPanel.this.tipComanda.setSelectedItem((Object)StockLogic.COMANDA_TYPE.TEMPORARA);
                EditNirPanel.this.addNotaEntries(note);
            }

            @Override
            public String getName() {
                return "AdaugareNir_adaugaComandaFurnizor";
            }
        };
        GenericListenersLogic.getInstance().addObjectListener(this.addEntriesObjectListener, Constants.ADD_NOTE_KEY);
        this.addNotaEntriesVectorListener = new ObjectEventListener(){

            @Override
            public void dataChanged(Object o) {
                Vector nirs = (Vector)o;
                EditNirPanel.this.addNirEntriesFull(nirs);
            }

            @Override
            public String getName() {
                return "AdaugareNir_nirEntryFullVector";
            }
        };
        GenericListenersLogic.getInstance().addObjectListener(this.addNotaEntriesVectorListener, Constants.ADD_NIR_ENTRY_FULL_KEY);
    }

    private JPanel getTopPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        JPanel dateFactura = this.getFacturaPanel();
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)dateFactura, c);
        c.weightx = 1.0;
        this.dateProdus = this.getProdusPanel();
        ++c.gridx;
        result.add((Component)this.dateProdus, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        JPanel nirTable = this.getNirTablePanel();
        result.add((Component)nirTable, c);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addEntry() {
        String valoareTvaFurnizor;
        Date lotExpirare;
        String lotNr;
        double cantPachet;
        double reducere;
        String unitName;
        String productName;
        double cant;
        double adaos;
        double pret;
        double pretTva;
        double valoareAchizitie;
        int idUnit;
        int idProduct;
        block43: {
            String value = null;
            idProduct = -1;
            idUnit = -1;
            valoareAchizitie = -1.0;
            pretTva = -1.0;
            pret = -1.0;
            adaos = -1.0;
            cant = 0.0;
            Stock ing = (Stock)this.produse.getSelectedItem();
            idProduct = ing.getId();
            idUnit = ing.getIdUnit();
            productName = this.produsFacturaText.getText();
            unitName = this.umText.getText();
            if (!Validators.correctString(productName)) {
                DialogUtils.errorDialog(this.parent, "Va rugam completati produsul", LangRoAll.nuPotContinua);
                return;
            }
            if (!Validators.correctString(unitName)) {
                DialogUtils.errorDialog(this.parent, "Va rugam completati unitatea de masura", LangRoAll.nuPotContinua);
                return;
            }
            String cantPachetS = this.cantitateNeta.getText();
            if (!Validators.correctDouble(cantPachetS)) {
                DialogUtils.errorDialog(this.parent, "Cantitatea pe pachet trebuie sa fie un numar", LangRoAll.nuPotContinua);
                this.cantitateNeta.requestFocus();
                return;
            }
            String cantS = this.nrPachete.getText();
            if (!Validators.correctDouble(cantS)) {
                DialogUtils.errorDialog(this.parent, "Numar pachete trebuie sa fie un numar", LangRoAll.nuPotContinua);
                this.nrPachete.requestFocus();
                return;
            }
            String reducereTextS = this.reducereText.getText();
            if (!Validators.correctDouble(reducereTextS)) {
                DialogUtils.errorDialog(this.parent, "Reducerea trebuie sa fie un numar", LangRoAll.nuPotContinua);
                this.reducereText.requestFocus();
                return;
            }
            String valoareAchizitieS = this.valoareAchizitieText.getText();
            if (!Validators.correctDouble(valoareAchizitieS)) {
                DialogUtils.errorDialog(this.parent, "Valoarea de achizitie trebuie sa fie un numar", LangRoAll.nuPotContinua);
                this.valoareAchizitieText.requestFocus();
                return;
            }
            reducere = Utils.parseDouble(reducereTextS);
            cantPachet = Utils.parseDouble(cantPachetS);
            cant = Utils.parseDouble(cantS);
            if (cant == 0.0) {
                DialogUtils.errorDialog(this.parent, "Numar pachete trebuie sa fie diferit de 0", LangRoAll.nuPotContinua);
                this.nrPachete.requestFocus();
                return;
            }
            lotNr = null;
            lotExpirare = null;
            if (VpConfig.getInstance().lotNrRequired) {
                try {
                    lotExpirare = this.lotDataExpirare.getValue();
                }
                catch (ParseException e) {
                    // empty catch block
                }
                if (lotExpirare == null) {
                    DialogUtils.errorDialog(this.parent, "Completati corect data expirarii", LangRoAll.nuPotContinua);
                    return;
                }
                lotNr = this.lotNumar.getText();
                if (!Validators.correctString(lotNr)) {
                    DialogUtils.errorDialog(this.parent, "Completati corect numarul lotului", LangRoAll.nuPotContinua);
                    return;
                }
            }
            valoareAchizitie = Utils.parseDouble(valoareAchizitieS);
            String cheltuieliPeProdus = this.cheltuieliPeProdus.getText();
            double cheltuieli = 0.0;
            if (Validators.correctDouble(cheltuieliPeProdus) && this.cheltuieliExists) {
                cheltuieli = Double.valueOf(cheltuieliPeProdus);
                valoareAchizitie += cheltuieli;
            }
            try {
                if (this.adaosRadio.isSelected()) {
                    value = this.adaosText.getText();
                    adaos = Utils.parseDouble(value);
                    break block43;
                }
                if (this.pretCuTvaRadio.isSelected()) {
                    value = this.pretCuTvaText.getText();
                    pretTva = Utils.parseDouble(value);
                    break block43;
                }
                if (this.pretFaraTvaRadio.isSelected()) {
                    value = this.pretFaraTvaText.getText();
                    pret = Utils.parseDouble(value);
                } else if (this.isMagazieDeMarfa()) {
                    DialogUtils.errorDialog(this.parent, "Va rugam completati pretul de vanzare sau adaosul", LangRoAll.nuPotContinua);
                    return;
                }
            }
            catch (NumberFormatException e1) {
                DialogUtils.errorDialog(this.parent, "Verificati corectitudinea datelor", LangRoAll.nuPotContinua);
                return;
            }
        }
        Tva t = (Tva)this.tva.getSelectedItem();
        double tvaNoi = TvaLogic.getInstance().getCotaTva();
        Product p = this.stockLogic.getProductForStock(idProduct);
        if (p != null) {
            Categorie cat = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
            Tva t1 = TvaLogic.getInstance().getTvaById(cat.getIdTva());
            tvaNoi = t1.getCota();
        }
        if (!Validators.correctDouble(valoareTvaFurnizor = this.valoareTvaProdus.getText())) {
            DialogUtils.errorDialog(this.parent, "Completati corect valoarea TVA", LangRoAll.nuPotContinua);
            this.valoareTvaProdus.setText("");
            this.valoareTvaProdus.requestFocus();
            return;
        }
        double totalTvaFurnizor = Utils.parseDouble(valoareTvaFurnizor);
        if (Utils.isValueZero(TvaLogic.getInstance().getCotaTva())) {
            valoareAchizitie += totalTvaFurnizor;
            totalTvaFurnizor = 0.0;
        }
        double pretUnitarAcz = valoareAchizitie / (cant *= cantPachet);
        pretUnitarAcz = pretUnitarAcz * (100.0 - reducere) / 100.0;
        totalTvaFurnizor = totalTvaFurnizor * (100.0 - reducere) / 100.0;
        if (cant == 0.0) {
            DialogUtils.errorDialog(this.parent, "Cantitatea incorecta", LangRoAll.nuPotContinua);
            return;
        }
        Magazie m = (Magazie)this.magazii.getSelectedItem();
        if (!this.contaLogic.isStockInDeposit(idProduct, m.getId()) && !DialogUtils.confirmDialog(this.parent, "Introducem produsul " + productName + " in magazia " + m.getLabel(), LangRoAll.confirmare)) {
            return;
        }
        double cvf = 1.0;
        String cursValutarS = this.cursValutar.getText();
        if (Validators.correctDouble(cursValutarS)) {
            cvf = Double.valueOf(cursValutarS);
        }
        if (pretUnitarAcz != -1.0) {
            pretUnitarAcz *= cvf;
        }
        if (adaos != -1.0) {
            adaos *= cvf;
        }
        if (pret != -1.0) {
            pret *= cvf;
        }
        if (pretTva != -1.0) {
            pretTva *= cvf;
        }
        if (totalTvaFurnizor != -1.0) {
            totalTvaFurnizor *= cvf;
        }
        NirEntryFull toAdd = new NirEntryFull(-1, -1, idProduct, productName, unitName, cant, pretUnitarAcz, adaos, pret, pretTva, totalTvaFurnizor, idUnit, tvaNoi, m.getId(), m.getLabel(), t.getId());
        toAdd.setNrCrt(this.itemsTm.getData().size() + 1);
        toAdd.compute();
        double pretCuTva = toAdd.getPpuvtva();
        if (pretCuTva > 0.0 && pretCuTva != this.oldPrice) {
            boolean doModify;
            boolean bl = doModify = !VpConfig.getInstance().nirPriceModificationAskForConfirmation || DialogUtils.confirmDialog(this.parent, "Modificam pretul de vanzare", LangRoAll.confirmare);
            if (doModify) {
                try {
                    Date dataFac = this.data.getValue();
                    String dataFacturii = Formatters.DATE_FORMAT_RO.format(dataFac);
                    if (!DialogUtils.confirmDialog(this, "Pretul de vanzare va fi modificat LA DATA FACTURII (" + dataFacturii + ") !!! . Continuam", LangRoAll.confirmare)) {
                        return;
                    }
                    boolean modifyOldStuff = DialogUtils.confirmDialog(this, "Doriti modificarea pretului la cantitatile existente", LangRoAll.confirmare);
                    this.stockLogic.modificaPret(toAdd.getIngredientId(), pretCuTva, modifyOldStuff, new Timestamp(dataFac.getTime()));
                }
                catch (ParseException e) {
                    Logger.logException(this, (Exception)e);
                    return;
                }
            }
        }
        if (p != null) {
            this.addSecondLineToNirEntryFull(toAdd, p.getId());
        }
        SimpleStockDiff addedDiff = new SimpleStockDiff();
        addedDiff.setIdMagazie(m.getId());
        addedDiff.setIdStock(idProduct);
        addedDiff.setQuantity(cant);
        this.stockDiffQuantities.add(addedDiff);
        Vector entries = this.itemsTm.getData();
        if (this.lineToEdit != null) {
            boolean replace = DialogUtils.confirmDialog(this.parent, "Inlocuiesc inregistrarea originala? DA = inlocuire, NU = duplicare", LangRoAll.confirmare);
            if (replace) {
                int originalPosition = this.lineToEdit.getPositionForEdit();
                entries.removeElementAt(originalPosition);
                int idLotExistent = this.lineToEdit.getIdLot();
                toAdd.setIdLot(idLotExistent);
                Lot existingLot = this.lineToEdit.getLot();
                if (existingLot == null) {
                    existingLot = this.stockLogic.getLotByIdCommit(idLotExistent);
                }
                if (existingLot == null) {
                    DialogUtils.errorDialog(this.parent, "Lotul cu id-ul " + idLotExistent + " nu exista. ", LangRoAll.atentie);
                    return;
                }
                existingLot.setNr(lotNr);
                existingLot.setExpirare(lotExpirare);
                toAdd.setLot(existingLot);
            } else {
                Lot newLot = new Lot();
                newLot.setExpirare(lotExpirare);
                newLot.setNr(lotNr);
                toAdd.setIdLot(-1);
                toAdd.setLot(newLot);
            }
        } else {
            Lot newLot = new Lot();
            newLot.setExpirare(lotExpirare);
            newLot.setNr(lotNr);
            toAdd.setIdLot(-1);
            toAdd.setLot(newLot);
        }
        entries.add(toAdd);
        this.itemsTm.fireTableDataChanged();
        this.initFields();
        this.updateTotals();
        this.produsFacturaText.setText(productName);
        this.umText.setText(unitName);
        this.codBareTF.setText("");
        this.produse.setSelectedItem(null);
        this.produse.requestFocus();
    }

    private void addSecondLineToNirEntryFull(NirEntryFull toAdd, int idProduct) {
        Vector<String> barcodes = NomeclaturaLogic.getInstance().getAllBarCodesByIdProd(idProduct);
        String secondLine = "";
        switch (barcodes.size()) {
            case 1: {
                secondLine = secondLine + barcodes.get(0);
                break;
            }
            case 0: {
                break;
            }
            default: {
                secondLine = secondLine + barcodes.get(0);
                for (int i = 1; i < barcodes.size(); ++i) {
                    secondLine = secondLine + ", " + barcodes.get(i);
                }
            }
        }
        toAdd.setCodBare(NomeclaturaLogic.getInstance().getLongBarcodeByIdProd(idProduct));
        toAdd.setSecondLine(secondLine);
    }

    private void updateVectorNirWithSecondLine(Vector<NirEntryFull> nirs) {
        for (NirEntryFull nir : nirs) {
            Product prod = this.stockLogic.getProductForStock(nir.getIngredientId());
            if (prod == null) {
                System.out.println("NULL");
                continue;
            }
            this.addSecondLineToNirEntryFull(nir, prod.getId());
        }
    }

    @Override
    @Deprecated
    public void addEntry(int idStock, String productName, String unitName, double cant, double ppuc, double pretTva, int idUnit, int idMagazie, String magazie, int idTva) {
        double tvaNoi = TvaLogic.getInstance().getCotaTva();
        Product p = this.stockLogic.getProductForStock(idStock);
        if (p != null) {
            Categorie cat = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
            Tva t = TvaLogic.getInstance().getTvaById(cat.getIdTva());
            tvaNoi = t.getCota();
        }
        NirEntryFull toAdd = new NirEntryFull(-1, -1, idStock, productName, unitName, cant, ppuc, -1.0, -1.0, pretTva, tvaNoi, idUnit, tvaNoi, idMagazie, magazie, idTva);
        toAdd.setNrCrt(this.itemsTm.getData().size() + 1);
        toAdd.compute();
        Vector entries = this.itemsTm.getData();
        entries.add(toAdd);
        this.itemsTm.fireTableDataChanged();
        this.initFields();
        this.updateTotals();
    }

    public void addEntryFixedTva(int idStock, String productName, String unitName, double cant, double ppuc, double pretTva, int idUnit, int idMagazie, String magazie, double tvaNoi, int idTva) {
        this.addEntryFixedTvaFixedPriceV(idStock, productName, unitName, cant, ppuc, pretTva, idUnit, idMagazie, magazie, tvaNoi, idTva, -1.0);
    }

    public void addEntryFixedTvaFixedPriceV(int idStock, String productName, String unitName, double cant, double ppuc, double pretTva, int idUnit, int idMagazie, String magazie, double tvaNoi, int idTva, double ppuv) {
        NirEntryFull toAdd = new NirEntryFull(-1, -1, idStock, productName, unitName, cant, ppuc, -1.0, ppuv, pretTva, tvaNoi, idUnit, tvaNoi, idMagazie, magazie, idTva);
        this.addNirEntryFull(toAdd);
    }

    public void addNirEntriesFull(Vector<NirEntryFull> entries) {
        for (NirEntryFull entry : entries) {
            this.addNirEntryFull(entry);
        }
    }

    private void addNirEntryFull(NirEntryFull toAdd) {
        toAdd.setNrCrt(this.itemsTm.getData().size() + 1);
        toAdd.compute();
        Vector entries = this.itemsTm.getData();
        entries.add(toAdd);
        this.itemsTm.fireTableDataChanged();
        this.initFields();
        this.updateTotals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFacturaCsv(String facturaCsv, char delimiter) {
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(facturaCsv));
            Magazie m = (Magazie)this.magazii.getSelectedItem();
            String line = reader.readLine();
            int lineNr = 1;
            while (line != null) {
                double pretVz;
                Double valAcz;
                Double cant;
                Vector tokens = Utils.splitString(line, delimiter);
                String cod = (String)tokens.get(0);
                String um = (String)tokens.get(1);
                Unit unit = UnitsLogic.getInstance().getUnitByName(um);
                int idUnit = -1;
                idUnit = unit == null ? UnitsLogic.getInstance().addUnit(um) : unit.getId();
                ContaExportMapping mapping = this.contaLogic.getWinmentorExportInterface().getContaExportMappingForCodExtern(cod);
                if (mapping != null) {
                    String pretvzS;
                    cant = Utils.parseDouble((String)tokens.get(2));
                    valAcz = Utils.parseDouble((String)tokens.get(3));
                    pretVz = -1.0;
                    String tipContabil = (String)tokens.get(5);
                    if (!tipContabil.equalsIgnoreCase("mp") && Validators.correctDouble(pretvzS = (String)tokens.get(4))) {
                        pretVz = Utils.parseDouble(pretvzS);
                    }
                } else {
                    DialogUtils.errorDialog(this.parent, "Mapare inexistenta pt cod WinMentor: " + cod + " la linia " + lineNr + ". Anulez tot! Actualizati nomenclatorul de articole !! ", LangRoAll.nuPotContinua);
                    this.resetAfterEdit();
                    return;
                }
                double pretUnitar = valAcz / cant;
                int idStock = mapping.getIdStock();
                Stock stock = this.stockLogic.getStockById(idStock);
                int idTva = 1;
                this.addEntry(idStock, stock.getLabel(), um, cant, pretUnitar, pretVz, idUnit, m.getId(), m.getLabel(), idTva);
                line = reader.readLine();
                ++lineNr;
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        finally {
            try {
                ConnectionPool.getInstance().commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    private void importFacturaXls(File facturaXls) {
        try {
            final StringBuffer errorsAtLine = new StringBuffer();
            final Sectie first = NomeclaturaLogic.getInstance().getAllSectii().get(0);
            final int idSectie = first.getId();
            final Tva tva = TvaLogic.getInstance().getTvas().get(0);
            GenericFacturaXlsImporter importer = new GenericFacturaXlsImporter(new GenericFacturaXlsImporterInterface(){

                @Override
                public void importLine(String magazia, String categoria, String numeProdus, String um, String codBare, double cantitate, double pretAchizitie, double pretVanzare, int line) {
                    Magazie m = EditNirPanel.this.stockLogic.getMagazieByLabel(magazia);
                    if (m == null) {
                        Logger.logWarning(this, "Linia " + line + " : Magazia " + magazia + " nu exista.");
                        return;
                    }
                    Unit unit = UnitsLogic.getInstance().getUnitByName(um);
                    int idUnit = -1;
                    idUnit = unit == null ? UnitsLogic.getInstance().addUnit(um) : unit.getId();
                    if (idUnit > 0) {
                        int idStock = EditNirPanel.this.contaLogic.importNirProductFromExcel(um, magazia, numeProdus, pretVanzare, codBare, categoria, idUnit, line, idSectie, first, tva);
                        if (idStock > 0) {
                            EditNirPanel.this.addEntry(idStock, numeProdus, um, cantitate, pretAchizitie, pretVanzare, idUnit, m.getId(), m.getLabel(), tva.getId());
                        }
                    } else {
                        Logger.logWarning(this, "Linia " + line + " este definita incorect si va fi ignorata.");
                        errorsAtLine.append(line + ", ");
                    }
                }
            });
            ExcelUtils.readExcel(facturaXls, importer);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (BiffException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }

    private void importInventarCielLaZiDinExcel(File facturaXls, Magazie magazie) {
        try {
            ExcelUtils.readExcel(facturaXls, new CielInvertarLaZiImporterFromExcel(this.parent, this.stockLogic, magazie, this));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (BiffException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }

    private void importInventarCielDeschidere(String csvFile, Magazie magazie) {
        CielInventarDeschidereImporter importer = new CielInventarDeschidereImporter(this.stockLogic, magazie, this);
        importer.importInventarDeschidere(csvFile);
    }

    private void updateTotals() {
        this.valoareFurnizor = this.contaLogic.computeValoareFactura(this.itemsTm.getData());
        this.tvaFurnizor = this.contaLogic.computeTvaFactura(this.itemsTm.getData());
        this.totalFurnizor = this.contaLogic.computeTotalFactura(this.itemsTm.getData());
        this.totalAmanuntCuTva = this.contaLogic.getTotalAmanuntGeneral(this.itemsTm.getData());
        this.totalAmanuntFaraTva = this.contaLogic.getTotalAmanunt(this.itemsTm.getData());
        this.totalTvaAmanunt = this.contaLogic.getTotalAmanuntTva(this.itemsTm.getData());
        this.totalAdaos = this.contaLogic.getTotalAdaos(this.itemsTm.getData());
        double cursValutarF = 1.0;
        String cursValutarS = this.cursValutar.getText();
        if (Validators.correctDouble(cursValutarS)) {
            cursValutarF = Double.valueOf(cursValutarS);
        }
        this.totalFactura.setText(Utils.getString2Decimals(this.valoareFurnizor));
        this.totalTvaFurnizorLabel.setText(Utils.getString2Decimals(this.tvaFurnizor));
        this.totalFacturaCuTva.setText(Utils.getString2Decimals(this.totalFurnizor));
        this.totalAmanuntCuTvaLabel.setText(Utils.getString2Decimals(this.totalAmanuntCuTva));
        this.totalAdaosLabel.setText(Utils.getString2Decimals(this.totalAdaos));
        this.totalTvaLabel.setText(Utils.getString2Decimals(this.totalTvaAmanunt));
        if (!this.cheltuieliExists) {
            this.valoareFactura.setText(Utils.getString2Decimals(this.valoareFurnizor / cursValutarF));
            this.valoareTvaTotal.setText(Utils.getString2Decimals(this.tvaFurnizor / cursValutarF));
        }
        this.updateDiferente();
    }

    private void updateDiferente() {
        String cursValutarS;
        String valCheltS;
        String tvaCheltuieliS;
        String tvaFactS;
        double valFact = 0.0;
        double tvaFact = 0.0;
        double tvaChelt = 0.0;
        double valChelt = 0.0;
        double cursValutarF = 1.0;
        String valFactS = this.valoareFactura.getText();
        if (Validators.correctDouble(valFactS)) {
            valFact = Utils.parseDouble(valFactS);
        }
        if (Validators.correctDouble(tvaFactS = this.valoareTvaTotal.getText())) {
            tvaFact = Utils.parseDouble(tvaFactS);
        }
        if (Validators.correctDouble(tvaCheltuieliS = this.tvaCheltuieli.getText())) {
            tvaChelt = Utils.parseDouble(tvaCheltuieliS);
        }
        if (Validators.correctDouble(valCheltS = this.cheltuieliAsociate.getText())) {
            valChelt = Utils.parseDouble(valCheltS);
        }
        if (Validators.correctDouble(cursValutarS = this.cursValutar.getText())) {
            cursValutarF = Double.valueOf(cursValutarS);
        }
        double diffVal = (this.valoareFurnizor / cursValutarF - valFact) * cursValutarF;
        double diffTva = (this.tvaFurnizor / cursValutarF - tvaFact) * cursValutarF;
        double diffTotal = diffTva + diffVal;
        this.diferenteValoareLabel.setText(Utils.getString2Decimals(diffVal));
        this.diferenteTvaLabel.setText(Utils.getString2Decimals(diffTva));
        this.diferenteTotaleLabel.setText(Utils.getString2Decimals(diffTotal));
    }

    private void refreshFurnizoriCombo() {
        this.furnizori.removeAllItems();
        Vector<Client> c = this.contaLogic.getFurnizori(1);
        for (Client element : c) {
            this.furnizori.addItem(element);
        }
    }

    private void refreshMagaziiCombo() {
        this.magazii.removeAllItems();
        Vector<Magazie> c = new Vector<Magazie>(this.stockLogic.getMagazii());
        for (Magazie element : c) {
            this.magazii.addItem(element);
        }
    }

    private void refreshTipDocumentItems() {
        this.tipDocument.removeAllItems();
        for (ContaLogic.TIP_DOCUMENT_NIR tip_document_nir : ContaLogic.TIP_DOCUMENT_NIR.values()) {
            this.tipDocument.addItem(tip_document_nir);
        }
    }

    private void refreshTipComandaItems() {
        this.tipComanda.removeAllItems();
        for (StockLogic.COMANDA_TYPE comandaType : StockLogic.COMANDA_TYPE.values()) {
            this.tipComanda.addItem(comandaType);
        }
    }

    private JPanel getProdusPanel() {
        JPanel result = new JPanel();
        result.setLayout((LayoutManager)new MigLayout("", "[] [grow] [shrink 0] [grow] [shrink 0] "));
        result.setBorder(new TitledBorder("Date produse"));
        result.add(new JLabel(LangRoAll.produs));
        result.add((Component)this.produse, "growx, span 3");
        result.add(new JLabel("Cantitate neta"));
        this.cantitateNeta = new JTextField(6);
        result.add((Component)this.cantitateNeta, "growx, wrap");
        result.add(new JLabel(LangRoAll.codBare));
        this.codBareTF = new JTextField(10);
        this.codBareTF.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        if (EditNirPanel.this.updateProdusByCod()) {
                            EditNirPanel.this.updateUnitateMasura();
                            EditNirPanel.this.updateProductName();
                            EditNirPanel.this.updatePrice();
                            EditNirPanel.this.updateMagazie();
                            EditNirPanel.this.valoareAchizitieText.requestFocus();
                            break;
                        }
                        EditNirPanel.this.initFields();
                        break;
                    }
                }
            }
        });
        this.codBareTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                String text = EditNirPanel.this.codBareTF.getText();
                if (text.length() > 0) {
                    EditNirPanel.this.codBareTF.setSelectionStart(0);
                    EditNirPanel.this.codBareTF.setSelectionEnd(text.length());
                }
            }
        });
        result.add((Component)this.codBareTF, "growx, span 3");
        result.add(new JLabel("Numar pachete"));
        this.nrPachete = new JTextField(6);
        result.add((Component)this.nrPachete, "growx,wrap");
        result.add(new JLabel("Pe factura"));
        this.produsFacturaText = new JTextField(10);
        result.add((Component)this.produsFacturaText, "growx, span 3");
        this.adaosRadio = new JRadioButton("Adaos %");
        result.add(this.adaosRadio);
        this.adaosText = new JTextField(6);
        result.add((Component)this.adaosText, "growx,wrap");
        result.add(new JLabel(LangRoAll.tva));
        this.tva = new JComboBox();
        Vector<Tva> tvas = TvaLogic.getInstance().getTvas();
        for (Tva element : tvas) {
            this.tva.addItem(element);
        }
        result.add((Component)this.tva, "growx");
        result.add(new JLabel("U.M."));
        this.umText = new JTextField(6);
        result.add((Component)this.umText, "growx");
        this.pretCuTvaRadio = new JRadioButton("Pret vz cu tva");
        result.add(this.pretCuTvaRadio);
        this.pretCuTvaText = new JTextField(6);
        result.add((Component)this.pretCuTvaText, "growx,wrap");
        result.add(new JLabel("Magazie"));
        result.add((Component)this.magazii, "growx, span 3");
        this.pretFaraTvaRadio = new JRadioButton("Pret vz f tva");
        result.add(this.pretFaraTvaRadio);
        this.pretFaraTvaText = new JTextField(6);
        result.add((Component)this.pretFaraTvaText, "growx,wrap");
        result.add(new JLabel("Valoare"));
        this.valoareAchizitieText = new JTextField(10);
        result.add((Component)this.valoareAchizitieText, "growx");
        result.add(new JLabel("Cheltuieli"));
        this.cheltuieliPeProdus = new JTextField(6);
        result.add((Component)this.cheltuieliPeProdus, "growx, span 1");
        this.faraPretRadio = new JRadioButton("Fara pret vz");
        result.add((Component)this.faraPretRadio, "growx, wrap");
        result.add(new JLabel("Reducere %"));
        this.reducereText = new JTextField(6);
        result.add((Component)this.reducereText, "growx, span 1");
        result.add(new JLabel("TVA"));
        this.valoareTvaProdus = new JTextField(10);
        result.add((Component)this.valoareTvaProdus, "growx");
        this.adauga = new JButton(LangRoAll.adauga);
        this.adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditNirPanel.this.addEntry();
            }
        });
        result.add((Component)this.adauga, "span 2, wrap, growx");
        result.add(new JLabel("Nr LOT"));
        this.lotNumar = new JTextField(10);
        result.add((Component)this.lotNumar, "growx, span 1");
        result.add(new JLabel("Expira"));
        this.lotDataExpirare = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.lotDataExpirare.setValue(new Date());
        this.lotDataExpirare.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this.lotDataExpirare.setConstraints((MDateSelectorConstraints)c1);
        this.lotDataExpirare.setToolTipText("Data expirare");
        this.lotDataExpirare.setMinimum(DateUtils.getStartOfCentury());
        this.lotDataExpirare.setShowTodayButton(true);
        result.add((Component)this.lotDataExpirare, "growx, span 1, wrap");
        this.pretGroup = new ButtonGroup();
        this.pretGroup.add(this.adaosRadio);
        this.pretGroup.add(this.pretCuTvaRadio);
        this.pretGroup.add(this.pretFaraTvaRadio);
        this.pretGroup.add(this.faraPretRadio);
        this.refreshMagaziiCombo();
        this.initFields();
        this.addFocusListeners();
        return result;
    }

    private void addFocusListeners() {
        this.valoareAchizitieText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.setSelectionForTextField(EditNirPanel.this.valoareAchizitieText);
            }

            @Override
            public void focusLost(FocusEvent e) {
                EditNirPanel.this.computeValoareTva();
                EditNirPanel.this.computeCheltuieliOnProduct();
            }
        });
        this.valoareTvaProdus.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.setSelectionForTextField(EditNirPanel.this.valoareTvaProdus);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.adaosRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditNirPanel.this.adaosText.requestFocus();
            }
        });
        this.adaosText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.setSelectionForTextField(EditNirPanel.this.adaosText);
                EditNirPanel.this.adaosRadio.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                Stock s = (Stock)EditNirPanel.this.produse.getSelectedItem();
                if (EditNirPanel.this.isMagazieDeMarfa()) {
                    String ad = EditNirPanel.this.adaosText.getText();
                    double f = Utils.parseDouble(ad);
                    EditNirPanel.this.updatePreturiVzCfAdaos(f /= 100.0, s.getId());
                }
            }
        });
        this.pretCuTvaRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditNirPanel.this.pretCuTvaText.requestFocus();
            }
        });
        this.pretCuTvaText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.setSelectionForTextField(EditNirPanel.this.pretCuTvaText);
                EditNirPanel.this.pretCuTvaRadio.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                EditNirPanel.this.updateAdaos(EditNirPanel.this.pretCuTvaText);
            }
        });
        this.pretFaraTvaRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditNirPanel.this.pretFaraTvaText.requestFocus();
            }
        });
        this.pretFaraTvaText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.setSelectionForTextField(EditNirPanel.this.pretFaraTvaText);
                EditNirPanel.this.pretFaraTvaRadio.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                EditNirPanel.this.updateAdaos(EditNirPanel.this.pretFaraTvaText);
            }
        });
        this.cantitateNeta.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.setSelectionForTextField(EditNirPanel.this.cantitateNeta);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.nrPachete.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.setSelectionForTextField(EditNirPanel.this.nrPachete);
            }

            @Override
            public void focusLost(FocusEvent e) {
                EditNirPanel.this.updateAdaos(EditNirPanel.this.nrPachete);
            }
        });
        this.cheltuieliAsociate.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String cheltuieliAsociateText = EditNirPanel.this.cheltuieliAsociate.getText();
                if (Validators.correctDouble(cheltuieliAsociateText)) {
                    EditNirPanel.this.cheltuieliExists = true;
                } else {
                    EditNirPanel.this.cheltuieliExists = false;
                }
            }
        });
        this.cursValutar.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                EditNirPanel.this.updateDiferente();
            }
        });
        this.adaosRadio.setFocusable(false);
        this.pretCuTvaRadio.setFocusable(false);
        this.pretFaraTvaRadio.setFocusable(false);
    }

    private void computeValoareTva() {
        ContaLogic.TIP_DOCUMENT_NIR tip = (ContaLogic.TIP_DOCUMENT_NIR)((Object)this.tipDocument.getSelectedItem());
        if (tip == null) {
            String message = "Tip document is null : " + this.tipDocument.getSelectedItem();
            System.out.println("Message : " + message);
            Logger.logWarning(this, message);
        } else {
            switch (tip) {
                case Factura: {
                    this.computeTvaByValue();
                    break;
                }
                case BonFiscal: {
                    this.splitValoareForBonFiscal();
                    break;
                }
                case BorderouAchizitii: {
                    this.splitValoareForBonFiscal(0.0);
                }
            }
        }
    }

    private void computeCheltuieliOnProduct() {
        EditNirPanel parent = this;
        String cheltuieliAsociateText = this.cheltuieliAsociate.getText();
        double totalCheltuieli = 0.0;
        if (Validators.correctDouble(cheltuieliAsociateText)) {
            totalCheltuieli = Double.valueOf(cheltuieliAsociateText);
        }
        if (totalCheltuieli > 0.0) {
            String valoareFacturaText = this.valoareFactura.getText();
            double totalFactura = 0.0;
            if (Validators.correctDouble(valoareFacturaText)) {
                totalFactura = Double.valueOf(valoareFacturaText);
            }
            if (totalFactura > 0.0) {
                String valoareAchizitieProd = this.valoareAchizitieText.getText();
                double valoareProd = 0.0;
                if (Validators.correctDouble(valoareAchizitieProd)) {
                    valoareProd = Double.valueOf(valoareAchizitieProd);
                }
                Double cheltuieliProd = valoareProd * totalCheltuieli / (totalFactura - totalCheltuieli);
                this.cheltuieliPeProdus.setText(Utils.getString2Decimals(cheltuieliProd));
                String tvaCheltS = this.tvaCheltuieli.getText();
                double tvaChelt = 0.0;
                if (Validators.correctDouble(tvaCheltS)) {
                    tvaChelt = Double.valueOf(tvaCheltS);
                }
                String cheltProdS = this.cheltuieliPeProdus.getText();
                double cheltProd = 0.0;
                if (Validators.correctDouble(cheltProdS)) {
                    cheltProd = Double.valueOf(cheltProdS);
                }
                double tvaCheltPeProd = tvaChelt * cheltProd / totalCheltuieli;
                String valoareTvaProdS = this.valoareTvaProdus.getText();
                double valoareTvaProd = 0.0;
                if (Validators.correctDouble(valoareTvaProdS)) {
                    valoareTvaProd = Double.valueOf(valoareTvaProdS);
                }
                this.valoareTvaProdus.setText(Utils.getString3Decimals(tvaCheltPeProd + valoareTvaProd));
            } else {
                DialogUtils.errorDialog(parent, "Introduceti TOTAL Val/TVA", LangRoAll.nuPotContinua);
                this.valoareAchizitieText.setText("");
                this.valoareTvaProdus.setText("");
                this.valoareFactura.requestFocus();
            }
        }
    }

    private void computeTvaByValue() {
        Tva productTva = (Tva)this.tva.getSelectedItem();
        double bazaTva = Utils.parseDouble(this.valoareAchizitieText.getText());
        double tva = bazaTva * productTva.getCota();
        this.valoareTvaProdus.setText(Utils.getString3Decimals(tva));
    }

    private void splitValoareForBonFiscal() {
        Tva productTva = (Tva)this.tva.getSelectedItem();
        this.splitValoareForBonFiscal(productTva.getCota());
    }

    private void splitValoareForBonFiscal(double cotaTva) {
        double totalCuTva = Utils.parseDouble(this.valoareAchizitieText.getText());
        double bazaTva = totalCuTva / (1.0 + cotaTva);
        double tva = totalCuTva - bazaTva;
        this.valoareAchizitieText.setText(Utils.getString6Decimals(bazaTva));
        this.valoareTvaProdus.setText(Utils.getString6Decimals(tva));
    }

    private void updatePreturiVzCfAdaos(double adaos, int idStock) {
        String cantPachetS = this.cantitateNeta.getText();
        if (!Validators.correctDouble(cantPachetS)) {
            DialogUtils.errorDialog(this.parent, "Cantitatea pe pachet trebuie sa fie un numar", LangRoAll.nuPotContinua);
            this.cantitateNeta.requestFocus();
            return;
        }
        String cantS = this.nrPachete.getText();
        if (!Validators.correctDouble(cantS)) {
            DialogUtils.errorDialog(this.parent, "Numar pachete trebuie sa fie un numar", LangRoAll.nuPotContinua);
            this.nrPachete.requestFocus();
            return;
        }
        String pc = this.valoareAchizitieText.getText();
        if (!Validators.correctDouble(pc)) {
            DialogUtils.errorDialog(this.parent, "Valoarea de achizitie trebuie sa fie un numar", LangRoAll.nuPotContinua);
            this.valoareAchizitieText.requestFocus();
            return;
        }
        String reducereTextS = this.reducereText.getText();
        if (!Validators.correctDouble(reducereTextS)) {
            DialogUtils.errorDialog(this.parent, "Reducerea trebuie sa fie un numar", LangRoAll.nuPotContinua);
            this.reducereText.requestFocus();
            return;
        }
        Tva t = (Tva)this.tva.getSelectedItem();
        double tvaNoi = t.getCota();
        double valoareAchizitie = Utils.parseDouble(pc);
        double cant = Utils.parseDouble(cantS);
        double cantPachet = Utils.parseDouble(cantPachetS);
        double reducere = Utils.parseDouble(reducereTextS);
        double pretUnitarAcz = valoareAchizitie / (cant *= cantPachet);
        pretUnitarAcz = pretUnitarAcz * (100.0 - reducere) / 100.0;
        double pretFaraTva = pretUnitarAcz * (1.0 + adaos);
        double pretCuTva = pretFaraTva * (1.0 + tvaNoi);
        this.pretCuTvaText.setText(Utils.getString2Decimals(pretCuTva));
        this.pretFaraTvaText.setText(Utils.getString2Decimals(pretFaraTva));
    }

    private void updateAdaos(Component originator) {
        Stock s = (Stock)this.produse.getSelectedItem();
        if (s != null && this.isMagazieDeMarfa()) {
            Product p;
            String cantPachetS = this.cantitateNeta.getText();
            if (!Validators.correctDouble(cantPachetS)) {
                return;
            }
            String cantS = this.nrPachete.getText();
            if (!Validators.correctDouble(cantS)) {
                return;
            }
            String pc = this.valoareAchizitieText.getText();
            if (!Validators.correctDouble(pc)) {
                return;
            }
            String reducereTextS = this.reducereText.getText();
            if (!Validators.correctDouble(reducereTextS)) {
                return;
            }
            String pretVzCuTvaS = this.pretCuTvaText.getText();
            String pretVzFaraTvaS = this.pretFaraTvaText.getText();
            if (originator.equals(this.nrPachete) || originator.equals(this.pretCuTvaText)) {
                if (!Validators.correctDouble(pretVzCuTvaS)) {
                    return;
                }
            } else if (originator.equals(this.pretFaraTvaText)) {
                if (!Validators.correctDouble(pretVzFaraTvaS)) {
                    return;
                }
            } else {
                return;
            }
            if ((p = this.stockLogic.getProductForStock(s.getId())) != null) {
                double adaos;
                double valoareAchizitie = Utils.parseDouble(pc);
                double cant = Utils.parseDouble(cantS);
                double cantPachet = Utils.parseDouble(cantPachetS);
                double reducere = Utils.parseDouble(reducereTextS);
                double pretUnitarAcz = valoareAchizitie / (cant *= cantPachet);
                pretUnitarAcz = pretUnitarAcz * (100.0 - reducere) / 100.0;
                double pretVzFaraTva = 0.0;
                if (originator.equals(this.nrPachete) || originator.equals(this.pretCuTvaText)) {
                    pretVzFaraTva = Utils.parseDouble(pretVzCuTvaS);
                    Categorie cat = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
                    Tva t1 = TvaLogic.getInstance().getTvaById(cat.getIdTva());
                    double tvaNoi = t1.getCota();
                    pretVzFaraTva /= 1.0 + tvaNoi;
                } else if (originator.equals(this.pretFaraTvaText)) {
                    pretVzFaraTva = Utils.parseDouble(pretVzFaraTvaS);
                }
                double pretVzCuTva = Utils.parseDouble(pretVzCuTvaS);
                if (this.whatToPrint == 3) {
                    adaos = (pretVzCuTva / pretUnitarAcz - 1.0) * 100.0;
                    this.adaosText.setText(Utils.getString2Decimals(adaos));
                } else if (this.whatToPrint == 2) {
                    adaos = (pretVzFaraTva / pretUnitarAcz - 1.0) * 100.0;
                    this.adaosText.setText(Utils.getString2Decimals(adaos));
                }
            }
        }
    }

    private void initFields() {
        this.lineToEdit = null;
        this.adaosText.setText("");
        this.pretCuTvaText.setText("");
        this.pretFaraTvaText.setText("");
        this.produsFacturaText.setText("");
        this.umText.setText("");
        this.nrPachete.setText("");
        this.valoareAchizitieText.setText("");
        this.reducereText.setText("0");
        this.cantitateNeta.setText("1");
        this.faraPretRadio.doClick();
        this.codBareTF.setText("");
        this.valoareTvaProdus.setText("");
        this.cheltuieliPeProdus.setText("");
        this.lotNumar.setText("");
        this.lotDataExpirare.setValue(null);
    }

    private JPanel getFacturaPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date factura"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        this.numarNir = new JTextField(10);
        this.numarNir.setText("" + this.contaLogic.getNextNrNir(this.getIdSocietateaNoastra(), false));
        if (FacturiLogic.getInstance().isMultipleSocietatiEnabled()) {
            c.weightx = 0.0;
            result.add((Component)new JLabel("Societatea"), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = 2;
            result.add((Component)this.societati, c);
            c.gridx = 0;
            ++c.gridy;
            this.societati.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditNirPanel.this.numarNir.setText("" + EditNirPanel.this.contaLogic.getNextNrNir(EditNirPanel.this.getIdSocietateaNoastra(), false));
                }
            });
        }
        c.gridwidth = 1;
        result.add((Component)new JLabel("Furnizor"), c);
        this.refreshFurnizoriCombo();
        c.gridx = 1;
        c.gridwidth = 2;
        result.add((Component)this.furnizori, c);
        c.gridwidth = 1;
        if (VpConfig.getInstance().futureStocksEnabled) {
            ++c.gridy;
            c.gridx = 0;
            result.add((Component)new JLabel("TIP COMANDA"), c);
            c.gridx = 1;
            c.gridwidth = 2;
            result.add((Component)this.tipComanda, c);
            c.gridwidth = 1;
        }
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Tip Document"), c);
        c.gridx = 1;
        c.gridwidth = 2;
        result.add((Component)this.tipDocument, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Serie factura"), c);
        c.gridx = 1;
        c.gridwidth = 2;
        this.serieFactura = new JTextField(10);
        result.add((Component)this.serieFactura, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        c.gridx = 1;
        c.gridwidth = 1;
        this.data = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.data.setValue(new Date());
        this.data.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this.data.setConstraints((MDateSelectorConstraints)c1);
        this.data.setToolTipText("Alege data");
        this.data.setMinimum(DateUtils.getStartOfCentury());
        this.data.setShowTodayButton(true);
        result.add((Component)this.data, c);
        ++c.gridx;
        this.time = new JTextField();
        this.time.setText("07:00");
        result.add((Component)this.time, c);
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel(LangRoAll.scadenta), c);
        ++c.gridx;
        this.scadenta = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.scadenta.setValue(new Date());
        this.scadenta.setEditable(true);
        this.scadenta.setConstraints((MDateSelectorConstraints)c1);
        this.scadenta.setToolTipText("Data scadenta");
        this.scadenta.setMinimum(DateUtils.getStartOfCentury());
        this.scadenta.setShowTodayButton(true);
        result.add((Component)this.scadenta, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Numar nir"), c);
        c.gridx = 1;
        c.gridwidth = 2;
        result.add((Component)this.numarNir, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Incarca stoc"), c);
        c.gridwidth = 1;
        ++c.gridx;
        this.cuIncarcare = new JRadioButton("Da");
        result.add((Component)this.cuIncarcare, c);
        ++c.gridx;
        this.faraIncarcare = new JRadioButton("Nu");
        result.add((Component)this.faraIncarcare, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("TOTAL Val/tva"), c);
        c.gridwidth = 1;
        ++c.gridx;
        this.valoareFactura = new JTextField(3);
        result.add((Component)this.valoareFactura, c);
        ++c.gridx;
        this.valoareTvaTotal = new JTextField(3);
        result.add((Component)this.valoareTvaTotal, c);
        this.valoareFactura.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EditNirPanel.this.updateDiferente();
            }
        });
        this.valoareTvaTotal.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EditNirPanel.this.updateDiferente();
            }
        });
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Cheltuieli Val/tva"), c);
        c.gridwidth = 1;
        ++c.gridx;
        this.cheltuieliAsociate = new JTextField(3);
        result.add((Component)this.cheltuieliAsociate, c);
        ++c.gridx;
        this.tvaCheltuieli = new JTextField(3);
        result.add((Component)this.tvaCheltuieli, c);
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel("Curs Valutar"), c);
        c.gridwidth = 2;
        ++c.gridx;
        this.cursValutar = new JTextField(3);
        result.add((Component)this.cursValutar, c);
        this.cuIncarcare.doClick();
        ButtonGroup bt = new ButtonGroup();
        bt.add(this.cuIncarcare);
        bt.add(this.faraIncarcare);
        return result;
    }

    private JPanel getTotalFacturaPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.total));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 3, 1, 3);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Valoare la furnizor"), c);
        c.gridx = 1;
        this.totalFactura = new JLabel("0");
        result.add((Component)this.totalFactura, c);
        c.gridy = 1;
        c.gridx = 0;
        result.add((Component)new JLabel("TVA furnizor"), c);
        c.gridx = 1;
        this.totalTvaFurnizorLabel = new JLabel("0");
        result.add((Component)this.totalTvaFurnizorLabel, c);
        c.gridy = 2;
        c.gridx = 0;
        result.add((Component)new JLabel("Total furnizor"), c);
        c.gridx = 1;
        this.totalFacturaCuTva = new JLabel("0");
        result.add((Component)this.totalFacturaCuTva, c);
        c.gridy = 0;
        c.gridx = 2;
        result.add((Component)new JLabel("Total adaos"), c);
        c.gridx = 3;
        this.totalAdaosLabel = new JLabel("0");
        result.add((Component)this.totalAdaosLabel, c);
        c.gridy = 1;
        c.gridx = 2;
        result.add((Component)new JLabel("Total amanunt cu tva"), c);
        c.gridx = 3;
        this.totalAmanuntCuTvaLabel = new JLabel("0");
        result.add((Component)this.totalAmanuntCuTvaLabel, c);
        c.gridy = 2;
        c.gridx = 2;
        result.add((Component)new JLabel("Total tva"), c);
        c.gridx = 3;
        this.totalTvaLabel = new JLabel("0");
        result.add((Component)this.totalTvaLabel, c);
        c.gridy = 0;
        c.gridx = 4;
        result.add((Component)new JLabel("Diferente valoare"), c);
        c.gridx = 5;
        this.diferenteValoareLabel = new JLabel("0");
        result.add((Component)this.diferenteValoareLabel, c);
        c.gridy = 1;
        c.gridx = 4;
        result.add((Component)new JLabel("Diferente TVA"), c);
        c.gridx = 5;
        this.diferenteTvaLabel = new JLabel("0");
        result.add((Component)this.diferenteTvaLabel, c);
        c.gridy = 2;
        c.gridx = 4;
        result.add((Component)new JLabel("Diferente Total"), c);
        c.gridx = 5;
        this.diferenteTotaleLabel = new JLabel("0");
        result.add((Component)this.diferenteTotaleLabel, c);
        return result;
    }

    private JPanel getNirTablePanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date factura"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        this.itemsTm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                NirEntryFull e = (NirEntryFull)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return new Integer(e.getNrCrt());
                    }
                    case 1: {
                        return "<html><b>" + e.getDenumireProdus() + "</b><br/><i>(" + e.getSecondLine() + ")</i></html>";
                    }
                    case 2: {
                        return e.getUm();
                    }
                    case 3: {
                        return Utils.getString3Decimals(e.getCant());
                    }
                    case 4: {
                        return e.getMagazie();
                    }
                    case 5: {
                        double ppucf = e.getPpuc();
                        String stringFloat = String.valueOf(ppucf);
                        Double aDouble = Double.valueOf(stringFloat);
                        return Utils.getString6Decimals(aDouble);
                    }
                    case 6: {
                        return Utils.getString3Decimals(e.getValoareCumparare());
                    }
                    case 7: {
                        return Utils.getString3Decimals(e.getTvaPerUm());
                    }
                    case 8: {
                        return Utils.getString3Decimals(e.getTvaFurnizorTotal());
                    }
                    case 9: {
                        return Utils.getString3Decimals(e.getTotalFactura());
                    }
                    case 10: {
                        return e.isFacturaOnly() ? "" : Utils.getString2Decimals(e.getAdaosProcent());
                    }
                    case 11: {
                        return e.isFacturaOnly() ? "" : Utils.getString2Decimals(e.getTotalAdaos());
                    }
                    case 12: {
                        return e.isFacturaOnly() ? "" : Utils.getString2Decimals(e.getPpuv());
                    }
                    case 13: {
                        return e.isFacturaOnly() ? "" : Utils.getString2Decimals(e.getTvaAferentAdaosComercial());
                    }
                    case 14: {
                        return e.isFacturaOnly() ? "" : Utils.getString2Decimals(e.getPpuvtva());
                    }
                    case 15: {
                        return e.isFacturaOnly() ? "" : Utils.getString2Decimals(e.getValoareaLaPretAmanuntFaraTva());
                    }
                    case 16: {
                        return e.isFacturaOnly() ? "" : Utils.getString2Decimals(e.getValoareaLaPretAmanuntCuTva());
                    }
                    case 17: {
                        return e.isFacturaOnly() ? "" : Utils.getString2Decimals(e.getTvaPerUMAmanunt());
                    }
                    case 18: {
                        return e.isFacturaOnly() ? "" : Utils.getString2Decimals(e.getTvaTotalAmanunt());
                    }
                }
                return null;
            }
        });
        final JTable table = new JTable(this.itemsTm);
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                final int selRow = source.rowAtPoint(e.getPoint());
                if (selRow != -1) {
                    final NirEntryFull nef = (NirEntryFull)EditNirPanel.this.itemsTm.getData().elementAt(selRow);
                    int modifiers = e.getModifiers();
                    if ((modifiers & 8) > 0 || (modifiers & 4) > 0) {
                        final JPopupMenu popup = new JPopupMenu();
                        JMenuItem sterge = new JMenuItem(LangRoAll.sterge);
                        sterge.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                popup.setVisible(false);
                                EditNirPanel.this.eraseEntry(nef, selRow);
                            }
                        });
                        popup.add(sterge);
                        JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
                        modifica.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                popup.setVisible(false);
                                EditNirPanel.this.editEntry(nef, selRow);
                            }
                        });
                        popup.add(modifica);
                        if (nef.getIdLot() > 0) {
                            JMenuItem tiparesteEtichete = new JMenuItem(LangRoAll.tiparesteEtichetele);
                            tiparesteEtichete.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Vector<NirEntryFull> toPrint = new Vector<NirEntryFull>();
                                    toPrint.add(nef);
                                    String s = DialogUtils.inputDialog(EditNirPanel.this.parent, "1", LangRoAll.numarCopii);
                                    if (Validators.correctInteger(s)) {
                                        int i = Integer.parseInt(s);
                                        EditNirPanel.this.contaLogic.printEticheteReceptieLot(toPrint, i);
                                    }
                                }
                            });
                            popup.add(tiparesteEtichete);
                        }
                        popup.setInvoker(table);
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    } else if (e.getClickCount() >= 2 && DialogUtils.confirmDialog(EditNirPanel.this.parent, "Doriti sa stergeti acest produs", LangRoAll.confirmare)) {
                        EditNirPanel.this.eraseEntry(nef, selRow);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        table.setAutoResizeMode(0);
        JScrollPane scroll = new JScrollPane(table);
        result.add((Component)scroll, c);
        GuiUtils.updateJTableRowSize(table, VpConfig.getInstance().touchTableFontSize);
        return result;
    }

    private void eraseEntry(NirEntryFull nef, int selRow) {
        int idLot = nef.getIdLot();
        if (idLot > 0) {
            this.idLoturiToRemove.add(idLot);
        }
        SimpleStockDiff outDiff = new SimpleStockDiff();
        outDiff.setIdMagazie(nef.getIdMagazie());
        outDiff.setIdStock(nef.getIngredientId());
        outDiff.setQuantity(-nef.getCant());
        this.stockDiffQuantities.add(outDiff);
        this.itemsTm.getData().removeElementAt(selRow);
        this.itemsTm.fireTableDataChanged();
        this.updateTotals();
    }

    private void editEntry(NirEntryFull nef, int selRow) {
        nef.setPositionForEdit(selRow);
        this.lineToEdit = nef;
        int idStock = nef.getIngredientId();
        Stock s = this.stockLogic.getStockById(idStock);
        this.produse.setSelectedItem(s);
        String peFactura = nef.getDenumireProdus();
        this.produsFacturaText.setText(peFactura);
        int idTva = nef.getIdTva();
        Tva t = TvaLogic.getInstance().getTvaById(idTva);
        this.tva.setSelectedItem(t);
        String um = nef.getUm();
        this.umText.setText(um);
        int idMag = nef.getIdMagazie();
        Magazie m = this.stockLogic.getMagazieById(idMag);
        this.magazii.setSelectedItem(m);
        this.valoareAchizitieText.setText(Utils.getString2Decimals(nef.getValoareCumparare()));
        this.valoareTvaProdus.setText(Utils.getString2Decimals(nef.getTvaFurnizorTotal()));
        this.oldPrice = nef.getPpuvtva();
        this.cantitateNeta.setText("1");
        this.nrPachete.setText(Utils.getString2Decimals(nef.getCant()));
        if (nef.isFacturaOnly()) {
            this.pretCuTvaText.setText("");
            this.faraPretRadio.doClick();
            this.faraPretRadio.setSelected(true);
        } else {
            this.pretCuTvaText.setText(Utils.getString2Decimals(nef.getPpuvtva()));
            this.pretCuTvaRadio.doClick();
            this.pretCuTvaRadio.setSelected(true);
        }
        Lot lot = nef.getLot();
        if (nef.getIdLot() > 0) {
            if (lot == null) {
                lot = this.stockLogic.getLotByIdCommit(nef.getIdLot());
            }
            if (lot == null) {
                DialogUtils.errorDialog(this.parent, "Lot inexistent " + nef.getIdLot(), LangRoAll.atentie);
            } else {
                nef.setLot(lot);
                if (lot.getExpirare() != null && Validators.correctString(lot.getNr())) {
                    this.lotDataExpirare.setValue(lot.getExpirare());
                    this.lotNumar.setText(lot.getNr());
                }
            }
        }
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        this.salveaza = new JButton(LangRoAll.salveaza);
        this.salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditNirPanel.this.saveNir()) {
                    EditNirPanel.this.cuIncarcare.doClick();
                    EditNirPanel.this.valoareFactura.setText("");
                    EditNirPanel.this.valoareTvaTotal.setText("");
                    EditNirPanel.this.cheltuieliAsociate.setText("");
                    EditNirPanel.this.tvaCheltuieli.setText("");
                    EditNirPanel.this.cursValutar.setText("");
                }
            }
        });
        result.add((Component)this.salveaza, c);
        final EditNirPanel panel = this;
        ++c.gridx;
        JButton importButton = new JButton("Import");
        importButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem preiaPreturiDeAchizitie = new JMenuItem("Preia preturi de achizitie");
                preiaPreturiDeAchizitie.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (DialogUtils.confirmDialog(panel, "Preluam preturile de achizitie din viitor", LangRoAll.confirmare)) {
                            if (EditNirPanel.this.factura == null) {
                                DialogUtils.errorDialog(panel, "Salvati documentul intai", LangRoAll.nuPotContinua);
                                return;
                            }
                            Vector all = EditNirPanel.this.itemsTm.getData();
                            EditNirPanel.this.contaLogic.updatePreturiAchizitieDinViitor(all, EditNirPanel.this.factura.getDateadd());
                            EditNirPanel.this.itemsTm.fireTableDataChanged();
                            EditNirPanel.this.updateTotals();
                        }
                    }
                });
                popup.add(preiaPreturiDeAchizitie);
                JMenuItem importFacturaFurnizoriXml = new JMenuItem("Import factura furnizori xml");
                importFacturaFurnizoriXml.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile;
                        Magazie magazie = (Magazie)EditNirPanel.this.magazii.getSelectedItem();
                        if (magazie != null && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul", "xml")) != null) {
                            EditNirPanel.this.contaLogic.importNiruriFromFactura(inputFile, magazie, panel);
                        }
                    }
                });
                popup.add(importFacturaFurnizoriXml);
                JMenuItem importFacturaExcel = new JMenuItem("Import factura furnizori excel");
                importFacturaExcel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        String inputFile;
                        String coloane = "magazia,categoria,numeprodus,unitate masura,codbare,cantitate,pretachizitie,pretvanzare";
                        if (DialogUtils.confirmDialog(panel, "Fisierul trebuie sa aiba coloanele \"" + coloane + "\". Continuam", LangRoAll.confirmare) && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de importat", "xls")) != null) {
                            EditNirPanel.this.importFacturaXls(new File(inputFile));
                        }
                    }
                });
                popup.add(importFacturaExcel);
                JMenuItem importWinmentorBonTransfer = new JMenuItem("Import bon transfer WinMentor");
                importWinmentorBonTransfer.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (DialogUtils.confirmDialog(panel, "Ati actualizat produsele de la ultima modificare", LangRoAll.confirmare)) {
                            String inputFile;
                            String coloane = "cod;um;cant;val_acz;pret_vz_cu_tva;tipcontabil";
                            if (DialogUtils.confirmDialog(panel, "Fisierul trebuie sa aiba coloanele \"" + coloane + "\". Continuam", LangRoAll.confirmare) && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de importat", "txt")) != null) {
                                EditNirPanel.this.importFacturaCsv(inputFile, ';');
                            }
                        }
                    }
                });
                popup.add(importWinmentorBonTransfer);
                JMenuItem importStocXml = new JMenuItem("Import stoc backup xml");
                importStocXml.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de stocuri", "xml");
                        if (inputFile != null) {
                            EditNirPanel.this.stockLogic.importBalantaFromXml(inputFile, new NirPanelImportXmlImpl(), EditNirPanel.this.stockLogic, EditNirPanel.this.parent);
                        }
                    }
                });
                popup.add(importStocXml);
                JMenuItem importFacturaXml = new JMenuItem("Import factura backup xml");
                importFacturaXml.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul", "xml");
                        if (inputFile != null) {
                            EditNirPanel.this.contaLogic.readFacturaXml(inputFile, new NirPanelImportXmlImpl(), EditNirPanel.this.getIdSocietateaNoastra());
                        }
                    }
                });
                popup.add(importFacturaXml);
                JMenuItem importInventarCielLaZiDinExcel = new JMenuItem("Import inventar Ciel la zi");
                importInventarCielLaZiDinExcel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile;
                        Magazie m = (Magazie)EditNirPanel.this.magazii.getSelectedItem();
                        if (DialogUtils.confirmDialog(panel, "Importam inventar Ciel (la zi) in magazia \"" + m.getLabel() + "\"", LangRoAll.confirmare) && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de importat", "xls")) != null) {
                            EditNirPanel.this.importInventarCielLaZiDinExcel(new File(inputFile), m);
                        }
                    }
                });
                popup.add(importInventarCielLaZiDinExcel);
                JMenuItem importInventarCielDeschidere = new JMenuItem("Import inventar Ciel deschidere");
                importInventarCielDeschidere.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile;
                        Magazie m = (Magazie)EditNirPanel.this.magazii.getSelectedItem();
                        if (DialogUtils.confirmDialog(panel, "Importam inventar Ciel (deschidere) in magazia \"" + m.getLabel() + "\"", LangRoAll.confirmare) && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de importat", "txt,csv")) != null) {
                            EditNirPanel.this.importInventarCielDeschidere(inputFile, m);
                        }
                    }
                });
                popup.add(importInventarCielDeschidere);
                JMenuItem importNirEntriesFromExcel = new JMenuItem("Import fisa VCont Excel");
                importNirEntriesFromExcel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile;
                        Magazie m = (Magazie)EditNirPanel.this.magazii.getSelectedItem();
                        Tva t = (Tva)EditNirPanel.this.tva.getSelectedItem();
                        if (DialogUtils.confirmDialog(panel, "Importam fisa VCont Excel in magazie \"" + m.getLabel() + "\"", LangRoAll.confirmare) && (inputFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de importat", "xls")) != null) {
                            EditNirPanel.this.importNirEntriesFromExcel(new File(inputFile), m, t);
                        }
                    }
                });
                popup.add(importNirEntriesFromExcel);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        result.add((Component)importButton, c);
        ++c.gridx;
        this.inapoi = new JButton(LangRoAll.inapoi);
        this.inapoi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditNirPanel.this.factura = null;
                EditNirPanel.this.nir = null;
                EditNirPanel.this.inapoi.setEnabled(false);
                EditNirPanel.this.resetAfterEdit();
                EditNirPanel.this.updateTotals();
                EditNirPanel.this.action.doAction();
            }
        });
        this.inapoi.setEnabled(false);
        result.add((Component)this.inapoi, c);
        return result;
    }

    private void resetAfterEdit() {
        this.idLoturiToRemove.clear();
        this.numarNir.setText("" + this.contaLogic.getNextNrNir(this.getIdSocietateaNoastra(), false));
        this.serieFactura.setText("");
        Date currentDate = new Date();
        this.data.setValue(currentDate);
        this.time.setText("07:00");
        this.itemsTm.refresh(new Vector());
        this.stockDiffQuantities = new Vector();
        this.cuIncarcare.doClick();
        this.valoareFactura.setText("");
        this.valoareTvaTotal.setText("");
        this.cheltuieliAsociate.setText("");
        this.tvaCheltuieli.setText("");
        this.cursValutar.setText("");
        this.tipDocument.setSelectedItem((Object)ContaLogic.TIP_DOCUMENT_NIR.Factura);
        this.initFields();
    }

    public int getIdSocietateaNoastra() {
        int idSocietate = -1;
        if (FacturiLogic.getInstance().isMultipleSocietatiEnabled()) {
            if (ComboUtils.anythingButAllSelected(this.societati)) {
                ClientPersJuridica cpj = (ClientPersJuridica)this.societati.getSelectedItem();
                idSocietate = cpj.getIdPersJuridica();
            } else {
                DialogUtils.errorDialog(this.parent, "Adaugati o societate proprie. Eroare de configurare !!", LangRoAll.nuPotContinua);
            }
        }
        return idSocietate;
    }

    private boolean saveNir() {
        if (this.factura != null && !DialogUtils.confirmDialog(this.parent, "ATENTIE ! Modificarile facute afecteaza o factura deja salvata. Continuati", LangRoAll.confirmare)) {
            DialogUtils.okDialog(this.parent, "FOLOSITI BUTONUL INAPOI si adaugati o factura noua de la inceput", LangRoAll.atentie);
            return false;
        }
        int idSocietateaNoastra = this.getIdSocietateaNoastra();
        try {
            String etichetePath;
            int idNir;
            String tvaFactS;
            String valFactur;
            Client f = (Client)this.furnizori.getSelectedItem();
            int idFurnizor = f.getId();
            String serie = this.serieFactura.getText();
            if (!Validators.correctString(serie)) {
                DialogUtils.errorDialog(this.parent, "Va rugam completati seria", LangRoAll.nuPotContinua);
                return false;
            }
            Date d = DateUtils.setTimeToDate((Component)this, this.data, this.time);
            if (d == null) {
                return false;
            }
            Timestamp dataFactura = new Timestamp(d.getTime());
            Date sc = DateUtils.setTimeToDate((Component)this, this.scadenta, "00:00");
            if (sc == null) {
                return false;
            }
            Timestamp dataScadenta = new Timestamp(sc.getTime());
            if (this.timePermission != null && !this.timePermission.canModify(dataFactura)) {
                DialogUtils.errorDialog(this.parent, this.timePermission.getModifyError(), LangRoAll.nuPotContinua);
                return false;
            }
            String nrNirS = this.numarNir.getText();
            int nrNir = -1;
            if (Validators.correctString(nrNirS)) {
                try {
                    nrNir = Integer.parseInt(nrNirS);
                }
                catch (NumberFormatException e) {
                    DialogUtils.errorDialog(this.parent, "Va rugam completati corect numarul nir-ului", LangRoAll.nuPotContinua);
                    return false;
                }
            }
            double valFact = 0.0;
            double tvaFact = 0.0;
            String valFactS = this.valoareFactura.getText();
            if (!Validators.correctDouble(valFactS)) {
                DialogUtils.errorDialog(this.parent, "Va rugam completati valoarea facturii", LangRoAll.nuPotContinua);
                this.valoareFactura.requestFocus();
                return false;
            }
            valFact = Utils.parseDouble(valFactS);
            if (this.cheltuieliExists && Validators.correctDouble(valFactur = this.totalFactura.getText())) {
                valFact = Utils.parseDouble(valFactur);
            }
            if (!Validators.correctDouble(tvaFactS = this.valoareTvaTotal.getText())) {
                DialogUtils.errorDialog(this.parent, "Va rugam completati valoarea tva", LangRoAll.nuPotContinua);
                this.valoareTvaTotal.requestFocus();
                return false;
            }
            tvaFact = Utils.parseDouble(tvaFactS);
            double diffVal = this.valoareFurnizor - valFact;
            double diffTva = this.tvaFurnizor - tvaFact;
            Vector items = this.itemsTm.getData();
            if (items.size() <= 0) {
                DialogUtils.errorDialog(this.parent, "Va rugam adaugati cel putin un produs", LangRoAll.nuPotContinua);
                return false;
            }
            this.fiscal = this.whatToPrint != 3;
            boolean transferBased = true;
            if (this.cuIncarcare.isSelected()) {
                transferBased = false;
            } else {
                if (!DialogUtils.confirmDialog(this.parent, "Ati ales sa nu incarcati stocul. Este corect", LangRoAll.confirmare)) {
                    return false;
                }
                transferBased = true;
            }
            ContaLogic.TIP_DOCUMENT_NIR tipD = (ContaLogic.TIP_DOCUMENT_NIR)((Object)this.tipDocument.getSelectedItem());
            StockLogic.COMANDA_TYPE comandaType = StockLogic.COMANDA_TYPE.EFECTUAT;
            if (VpConfig.getInstance().futureStocksEnabled) {
                comandaType = (StockLogic.COMANDA_TYPE)((Object)this.tipComanda.getSelectedItem());
            }
            if (this.factura == null) {
                boolean canAdd = this.contaLogic.canAddNir(dataFactura);
                if (!canAdd) {
                    DialogUtils.errorDialog(this, "Data este mai mica decat ultima validare", LangRoAll.nuPotContinua);
                    return false;
                }
                int nrNirAutomat = this.contaLogic.getNextNrNir(this.getIdSocietateaNoastra(), false);
                int lastNirNr = this.contaLogic.getLastNirNr(this.getIdSocietateaNoastra());
                if (lastNirNr > nrNir && !DialogUtils.confirmDialog(this.parent, "Ultimul numar de NIR din baza este " + lastNirNr + " , insistati sa folositi numarul " + nrNir, LangRoAll.confirmare)) {
                    DialogUtils.okDialog(this.parent, "Incercati din nou cu numarul " + (lastNirNr + 1), LangRoAll.atentie);
                    this.numarNir.setText(this.contaLogic.getNextNrNir(this.getIdSocietateaNoastra(), false) + "");
                    return false;
                }
                if (nrNir != nrNirAutomat) {
                    if (this.contaLogic.isNrNirTaken(nrNir, this.getIdSocietateaNoastra())) {
                        if (!Config.getInstance().getBoolean("contaAllowNumarNirRewrite")) {
                            DialogUtils.okDialog(this.parent, "Numar nir " + nrNir + " deja folosit. Incercati din nou cu numarul generat automat", LangRoAll.atentie);
                            this.numarNir.setText(this.contaLogic.getNextNrNir(this.getIdSocietateaNoastra(), false) + "");
                            return false;
                        }
                        if (!DialogUtils.confirmDialog(this.parent, "Numar nir " + nrNir + " deja folosit. Insistati sa folositi acest numar", LangRoAll.confirmare)) {
                            DialogUtils.okDialog(this.parent, "Incercati din nou cu numarul generat automat", LangRoAll.atentie);
                            this.numarNir.setText(this.contaLogic.getNextNrNir(this.getIdSocietateaNoastra(), false) + "");
                            return false;
                        }
                    }
                    if (!DialogUtils.confirmDialog(this.parent, "Numarul automat de NIR este " + nrNirAutomat + " , insistati sa folositi numarul " + nrNir, LangRoAll.confirmare)) {
                        DialogUtils.okDialog(this.parent, "Incercati din nou cu numarul generat automat", LangRoAll.atentie);
                        this.numarNir.setText(this.contaLogic.getNextNrNir(this.getIdSocietateaNoastra(), false) + "");
                        return false;
                    }
                }
                if ((idNir = this.contaLogic.addNir(serie, "", dataFactura, idFurnizor, nrNir, items, transferBased, this.stockDiffQuantities, this.fiscal, this.totalAmanuntFaraTva, this.totalTvaAmanunt, this.totalAmanuntCuTva, valFact, tvaFact, valFact + tvaFact, diffVal, diffTva, idSocietateaNoastra, tipD.getTip(), comandaType, dataScadenta)) == -1) {
                    return false;
                }
                if (nrNir != nrNirAutomat) {
                    if (DialogUtils.confirmDialog(this.parent, "Doriti ca urmatorul numar generat automat sa fie " + (nrNir + 1), LangRoAll.confirmare)) {
                        this.numarNir.setText(this.contaLogic.getNextNrNir(this.getIdSocietateaNoastra(), false, nrNir) + "");
                    }
                } else {
                    this.numarNir.setText(this.contaLogic.getNextNrNir(this.getIdSocietateaNoastra(), true) + "");
                }
            } else {
                this.factura.setTransferBased(transferBased);
                this.factura.setIdSocietateProprie(idSocietateaNoastra);
                boolean ok = this.contaLogic.updateNir(serie, "", dataFactura, idFurnizor, nrNir, items, this.factura, this.nir, this.parent, this.stockDiffQuantities, this.fiscal, this.totalAmanuntFaraTva, this.totalTvaAmanunt, this.totalAmanuntCuTva, valFact, tvaFact, valFact + tvaFact, diffVal, diffTva, tipD.getTip(), comandaType, this.idLoturiToRemove, dataScadenta);
                if (!ok) {
                    return false;
                }
                idNir = this.nir.getId();
            }
            String societate = Config.getInstance().getString("societate");
            if (idSocietateaNoastra > 0) {
                ClientPersJuridica cpj = ClientLogic.getInstance().getPersJuridicaById(idSocietateaNoastra);
                societate = cpj.getCompanyName();
            }
            this.contaLogic.reprintNir(this, idNir, items, societate);
            if (this.factura == null) {
                this.contaLogic.printEticheteReceptieLot(this, items);
            }
            if ((etichetePath = this.contaLogic.printEticheteReceptieA4(this, items)) != null) {
                DialogUtils.okDialog(this.parent, "Etichetele au fost salvate pe disk la " + etichetePath, LangRoAll.succes);
            }
            this.itemsTm.refresh(new Vector());
            this.numarNir.setText("" + this.contaLogic.getNextNrNir(this.getIdSocietateaNoastra(), false));
            this.initFields();
            this.updateTotals();
            this.resetAfterEdit();
            if (this.factura != null) {
                this.factura = null;
                this.nir = null;
                this.action.doAction();
            }
        }
        catch (NumberFormatException e1) {
            DialogUtils.errorDialog(this.parent, "Verificati corectitudinea datelor", LangRoAll.nuPotContinua);
            return false;
        }
        this.serieFactura.setText("");
        return true;
    }

    @Override
    public void cleanup() {
        this.furnizori.removeAllItems();
        this.tipDocument.removeAllItems();
        this.magazii.removeAllItems();
        GenericListenersLogic.getInstance().removeObjectListener(this.addEntriesObjectListener);
        GenericListenersLogic.getInstance().removeObjectListener(this.addNotaEntriesVectorListener);
    }

    private void importNirEntriesFromExcel(File importFile, final Magazie m, final Tva t) {
        try {
            ExcelUtils.readExcel(importFile, new ExcelImportInterface(){
                String nume = "";
                String um = "buc";
                String numeFurnizor = "";
                int cantitate;
                double pretAchizitie;
                double valoareAchizitie;
                int line = 1;
                NirEntryFull nef = new NirEntryFull();

                @Override
                public void valueRead(int row, int column, String value) {
                    switch (column) {
                        case 2: {
                            this.nume = value;
                            break;
                        }
                        case 4: {
                            this.um = value;
                            break;
                        }
                        case 5: {
                            if (!Validators.correctInteger(value)) break;
                            this.cantitate = Integer.valueOf(value);
                            break;
                        }
                        case 6: {
                            if (!Validators.correctDouble(value)) break;
                            this.pretAchizitie = Utils.parseDouble(value);
                            break;
                        }
                        case 7: {
                            if (!Validators.correctDouble(value)) break;
                            this.valoareAchizitie = Utils.parseDouble(value);
                            break;
                        }
                        case 10: {
                            this.numeFurnizor = value;
                            break;
                        }
                        case 11: {
                            break;
                        }
                        case 12: {
                            break;
                        }
                        case 13: {
                            break;
                        }
                    }
                }

                @Override
                public void lineEnd() {
                    Product product = this.lookForProduct(this.nume);
                    if (product != null) {
                        Stock stock = StockLogic.getInstance().getStockByCodUnicCommit(product.getCodSync());
                        if (stock != null) {
                            Unit u = UnitsLogic.getInstance().getUnitByName(this.um.toLowerCase());
                            this.nef = new NirEntryFull(-1, -1, stock.getId(), product.getName(), this.um, this.cantitate, this.pretAchizitie, -1.0, -1.0, -1.0, t.getCota() * this.valoareAchizitie, u.getId(), t.getCota() * this.pretAchizitie, m.getId(), m.getLabel(), t.getId());
                            this.nef.setNrCrt(EditNirPanel.this.itemsTm.getData().size() + 1);
                            this.nef.compute();
                            SimpleStockDiff addedDiff = new SimpleStockDiff();
                            addedDiff.setIdMagazie(m.getId());
                            addedDiff.setIdStock(product.getId());
                            addedDiff.setQuantity(this.cantitate);
                            EditNirPanel.this.stockDiffQuantities.add(addedDiff);
                            Vector entries = EditNirPanel.this.itemsTm.getData();
                            entries.add(this.nef);
                        } else {
                            Logger.logError((Object)this, "*Import VContExcel* Nu se gaseste stocul asociat produsului de la linia - " + this.line);
                        }
                    } else {
                        Logger.logError((Object)this, "*Import VContExcel* Nu se gaseste produsul de la linia - " + this.line);
                    }
                    ++this.line;
                }

                @Override
                public void lineStart() {
                    this.nef = new NirEntryFull();
                }

                @Override
                public void sheetStart(String sheetName) {
                }

                @Override
                public void sheetEnd(String sheetName) {
                    EditNirPanel.this.itemsTm.fireTableDataChanged();
                    EditNirPanel.this.updateTotals();
                }

                private Product lookForProduct(String name) {
                    return NomeclaturaLogic.getInstance().lookForProductByBarcodeInName(name);
                }
            });
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (BiffException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }

    public void addNotaEntries(Vector<NirEntryFull> note) {
        for (NirEntryFull nota : note) {
            Tva t = TvaLogic.getInstance().getTvaByCota(0.0);
            double cota = 1.0 + t.getCota();
            double pretTVA = nota.getPpuc() * cota;
            this.addEntryFixedTvaFixedPriceV(nota.getIngredientId(), nota.getDenumireProdus(), nota.getUm(), nota.getCant(), nota.getPpuc(), -1.0, nota.getIdUnit(), nota.getIdMagazie(), nota.getMagazie(), 0.0, t.getId(), -1.0);
        }
        Vector data = this.itemsTm.getData();
        this.updateVectorNirWithSecondLine(data);
        this.itemsTm.refresh(data);
    }

    class NirPanelImportXmlImpl
    implements ReceptieFromStockInterface {
        NirPanelImportXmlImpl() {
        }

        @Override
        public Magazie getMagazieForStock(int magazieFromFile) {
            return EditNirPanel.this.stockLogic.getMagazieById(magazieFromFile);
        }

        @Override
        public void addNirItem(int idStock, String productName, String unitName, double cant, double ppuc, double pretCuTva, int idUnit, int idMagazie, String magazie, boolean incarcaStoc, double cotaTva, int idTva) {
            EditNirPanel.this.addEntry(idStock, productName, unitName, cant, ppuc, pretCuTva, idUnit, idMagazie, magazie, idTva);
        }

        @Override
        public void addNir(int nrNir, int idFurnizor, String auto, String serieFactura, Timestamp dataT, double total, double totalTva, double totalGeneral, int idSocietateaNoastra, int tipFactura, Timestamp scadenta) {
        }

        @Override
        public boolean okSoFar() {
            return true;
        }
    }
}

