/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.FacturiEntry;
import ro.atreides.contabilitate.Nir;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.winmentor.WinmentorExportLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class FacturiReport
extends AbstractReportPanel
implements CleanupRequired {
    private ContaLogic logic;
    private JComboBox furnizoriCombo;
    private JComboBox societati;
    private JComboBox tipComanda;
    private double totalFacturi;
    private JLabel totalFactLabel;
    private DoubleClicked action;
    public static final String[] columns = new String[]{"Furnizor", LangRoAll.factura, "Nr Nir", LangRoAll.data, LangRoAll.total};
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    private static Comparator total_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            FacturiEntry item1 = (FacturiEntry)o1;
            FacturiEntry item2 = (FacturiEntry)o2;
            return item1.getTotalGeneral() < item2.getTotalGeneral() ? -1 : 1;
        }
    };
    private static Comparator date_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            FacturiEntry item1 = (FacturiEntry)o1;
            FacturiEntry item2 = (FacturiEntry)o2;
            return item1.getDataEmiterii().before(item2.getDataEmiterii()) ? -1 : 1;
        }
    };
    private static Comparator client_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            FacturiEntry item1 = (FacturiEntry)o1;
            FacturiEntry item2 = (FacturiEntry)o2;
            return item1.getFurnizor().compareToIgnoreCase(item2.getFurnizor());
        }
    };
    private static Comparator serie_numar_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            FacturiEntry item1 = (FacturiEntry)o1;
            FacturiEntry item2 = (FacturiEntry)o2;
            return item1.getNrFactura().compareToIgnoreCase(item2.getNrFactura());
        }
    };
    private static Comparator nir_numar_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            FacturiEntry item1 = (FacturiEntry)o1;
            FacturiEntry item2 = (FacturiEntry)o2;
            return item1.getNrNir().compareToIgnoreCase(item2.getNrNir());
        }
    };

    public FacturiReport() {
        this.logic = ContaLogic.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.furnizoriCombo)) {
            Client f = (Client)this.furnizoriCombo.getSelectedItem();
            result.put("facturi_furnizor_key", f.getId());
        }
        this.printCriteria.remove("Societate");
        if (FacturiLogic.getInstance().isMultipleSocietatiEnabled() && ComboUtils.anythingButAllSelected(this.societati)) {
            ClientPersJuridica societate = (ClientPersJuridica)this.societati.getSelectedItem();
            result.put("Societate", societate);
            this.printCriteria.put("Societate", societate.getCompanyName());
        }
        if (ComboUtils.anythingButAllSelected(this.tipComanda)) {
            StockLogic.COMANDA_TYPE c = (StockLogic.COMANDA_TYPE)((Object)this.tipComanda.getSelectedItem());
            result.put("Comanda Type", (Object)c);
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        this.societati = new JComboBox();
        c.gridy = 0;
        c.gridx = 0;
        if (FacturiLogic.getInstance().isMultipleSocietatiEnabled()) {
            c.weightx = 0.0;
            result.add((Component)new JLabel("Societatea"), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.societati, c);
            ++c.gridy;
            c.gridx = 0;
        }
        c.weightx = 0.0;
        result.add((Component)new JLabel("Furnizor"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.furnizoriCombo = new JComboBox();
        result.add((Component)this.furnizoriCombo, c);
        this.tipComanda = new JComboBox();
        if (VpConfig.getInstance().futureStocksEnabled) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            result.add((Component)new JLabel("Tip Comanda"), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.tipComanda, c);
        }
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FacturiEntry fe = (FacturiEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fe.getFurnizor();
                    }
                    case 1: {
                        return fe.getNrFactura();
                    }
                    case 2: {
                        return fe.getNrNir();
                    }
                    case 3: {
                        return fe.getDataEmiteriiString();
                    }
                    case 4: {
                        return Utils.getString2Decimals(fe.getTotalGeneral());
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Total facturi"), c);
        ++c.gridx;
        this.totalFactLabel = new JLabel("");
        result.add((Component)this.totalFactLabel, c);
        final FacturiReport parent = this;
        ++c.gridx;
        JButton sterge = new JButton("Sterge TOATE facturile afisate");
        sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(parent, "Doriti sa stergeti TOATE facturile afisate", LangRoAll.confirmare) && DialogUtils.confirmDialog(parent, "Aceasta operatie este IREVERSIBILA. Sunteti sigur", LangRoAll.confirmare)) {
                    for (int i = 0; i < FacturiReport.this.data.size(); ++i) {
                        FacturiEntry nv = (FacturiEntry)FacturiReport.this.data.elementAt(i);
                        ContaLogic.getInstance().deleteFactura(nv.getIdFactura(), parent);
                    }
                    FacturiReport.this.tm.refresh(FacturiReport.this.logic.getFacturi(FacturiReport.this.criteria, FacturiReport.this.whatToPrint));
                }
            }
        });
        result.add((Component)sterge, c);
        ++c.gridx;
        JButton reproceseazaFisaStoc = new JButton(LangRoAll.reproceseazaFisaStoc);
        reproceseazaFisaStoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(parent, LangRoAll.putemDereglaFisaStoc, LangRoAll.confirmare)) {
                    for (int i = 0; i < FacturiReport.this.data.size(); ++i) {
                        FacturiEntry nv = (FacturiEntry)FacturiReport.this.data.elementAt(i);
                        FacturiReport.this.logic.reprocessFisaStocForNir(nv);
                    }
                }
            }
        });
        result.add((Component)reproceseazaFisaStoc, c);
        ++c.gridx;
        JButton export = new JButton("Export");
        export.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem exportWinmentor = new JMenuItem("Export WinMentor");
                exportWinmentor.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (DialogUtils.confirmDialog(parent, "Exportam datele pentru WinMentor", LangRoAll.confirmare)) {
                            String saveDir = WinmentorExportLogic.getInstance().exportDateWinMentorFacturiReport(parent, FacturiReport.this.data);
                            if (saveDir != null) {
                                DialogUtils.okDialog(parent, "Datele au fost salvate la " + saveDir, LangRoAll.succes);
                            } else {
                                DialogUtils.errorDialog(parent, "Export esuat", LangRoAll.eroare);
                            }
                        }
                    }
                });
                menu.add(exportWinmentor);
                JMenuItem exportDeverJSON = new JMenuItem("Export Dever");
                exportDeverJSON.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (DialogUtils.confirmDialog(parent, "Exportam factura in format JSON", LangRoAll.confirmare) && FacturiReport.this.criteria.get(Constants.START_KEY) != null) {
                            Date oDate1 = (Date)FacturiReport.this.criteria.get(Constants.START_KEY);
                            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm");
                            String date1String = formatter.format(oDate1);
                            Date oDate2 = (Date)FacturiReport.this.criteria.get(Constants.STOP_KEY);
                            String date2String = formatter.format(oDate2);
                            boolean b = ContaLogic.getInstance().exportFacturaNirToJSON(FacturiReport.this.tm.getData(), date1String, date2String);
                            if (b) {
                                DialogUtils.okDialog(parent, "Exportul a fost efectuat", LangRoAll.succes);
                            } else {
                                DialogUtils.errorDialog(parent, "Export esuat", LangRoAll.eroare);
                            }
                        }
                    }
                });
                menu.add(exportDeverJSON);
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        result.add((Component)export, c);
        return result;
    }

    public void setAction(DoubleClicked action) {
        this.action = action;
    }

    @Override
    public String getName() {
        return "Facturi";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return this.logic.getFacturi(criteria, this.whatToPrint);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.totalFactLabel.setText(Utils.getString2Decimals(this.totalFacturi));
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    FacturiEntry entry = (FacturiEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, entry.getFurnizor());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, entry.getNrNir());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, entry.getNrFactura());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, entry.getDataEmiteriiString());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getTotalGeneral()));
                        ++column;
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return FacturiReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.furnizoriCombo, this.logic.getFurnizori(-1), true);
        ComboUtils.replaceItemsForCombo(this.tipComanda, StockLogic.getComandaTypeCollection(), true);
        ComboUtils.replaceItemsForCombo(this.societati, ClientLogic.getInstance().getSocietatiPropriiSorted());
        final FacturiReport parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final FacturiEntry fe = (FacturiEntry)FacturiReport.this.data.elementAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem reprint = new JMenuItem("Retipareste NIR");
                JMenuItem excel = new JMenuItem("Exporta in excel");
                JMenuItem delete = new JMenuItem("Sterge factura");
                JMenuItem modifica = new JMenuItem("Modifica factura");
                JMenuItem exportXml = new JMenuItem("Exporta in xml");
                JMenuItem excelFormule = new JMenuItem("Exporta in excel cu formule");
                JMenuItem exportWinmentor = new JMenuItem("Exporta in Winmentor");
                popup.add(delete);
                popup.add(modifica);
                popup.add(reprint);
                popup.add(excel);
                popup.add(exportXml);
                popup.add(exportWinmentor);
                if (Config.getInstance().getBoolean("excelFormule")) {
                    popup.add(excelFormule);
                }
                reprint.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String societate = Config.getInstance().getString("societate");
                        if (fe.getIdSocietate() > 0) {
                            ClientPersJuridica cpj = ClientLogic.getInstance().getPersJuridicaById(fe.getIdSocietate());
                            societate = cpj.getCompanyName();
                        }
                        FacturiReport.this.logic.reprintNir(FacturiReport.this.table, fe.getIdFactura(), societate);
                        popup.setVisible(false);
                    }
                });
                excel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JFileChooser fileChooser = new JFileChooser();
                        int retValue = fileChooser.showSaveDialog(FacturiReport.this.table);
                        if (retValue == 0) {
                            File reportFile = fileChooser.getSelectedFile();
                            FacturiReport.this.logic.excelNir(fe.getIdFactura(), reportFile);
                            DialogUtils.okDialog(FacturiReport.this.table, "Nirul a fost salvat pe disc la " + reportFile.getAbsolutePath(), "Nir salvat");
                        }
                        popup.setVisible(false);
                    }
                });
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (DialogUtils.confirmDialog(FacturiReport.this.table, "Stergem factura", LangRoAll.confirmare) && ContaLogic.getInstance().deleteFactura(fe.getIdFactura(), FacturiReport.this.table)) {
                            DialogUtils.okDialog(FacturiReport.this.table, "Operatie efectuata", LangRoAll.succes);
                        }
                        popup.setVisible(false);
                        FacturiReport.this.raport();
                    }
                });
                modifica.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        popup.setVisible(false);
                        Factura f = FacturiReport.this.logic.getFacturaById(fe.getIdFactura());
                        FacturiReport.this.action.doubleClicked(f);
                    }
                });
                exportXml.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        popup.setVisible(false);
                        String inputFile = FileDialog.getSaveDialogLocation(parent, LangRoAll.alegetiFisierulDestinatie, "xml");
                        if (inputFile != null) {
                            Factura f = FacturiReport.this.logic.getFacturaById(fe.getIdFactura());
                            Nir n = FacturiReport.this.logic.getNirByFacturaId(f.getId());
                            FacturiReport.this.logic.exportFacturaXml(inputFile, f, n);
                            DialogUtils.okDialog(FacturiReport.this.table, "Nirul a fost exportat la " + inputFile, "Nir exportat");
                        }
                    }
                });
                excelFormule.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        String file = FacturiReport.this.logic.excelNirCuFormule(fe.getIdFactura());
                        if (Validators.correctString(file)) {
                            DialogUtils.okDialog(FacturiReport.this.table, "Nirul a fost salvat pe disc la " + file, "Nir salvat");
                        }
                    }
                });
                exportWinmentor.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (DialogUtils.confirmDialog(parent, "Exportam factura in WinMentor", LangRoAll.confirmare)) {
                            Vector<FacturiEntry> data = new Vector<FacturiEntry>();
                            data.add(fe);
                            String saveDir = WinmentorExportLogic.getInstance().exportDateWinMentorFacturiReport(parent, data);
                            if (saveDir != null) {
                                DialogUtils.okDialog(parent, "Factura a fost salvata la " + saveDir, LangRoAll.succes);
                            } else {
                                DialogUtils.errorDialog(parent, "Export esuat", LangRoAll.eroare);
                            }
                        }
                    }
                });
                popup.setInvoker(FacturiReport.this.table);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 4: {
                        return FacturiReport.this.totalFactLabel.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return FacturiReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return FacturiReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                FacturiEntry fe = (FacturiEntry)row;
                switch (column) {
                    case 0: {
                        return fe.getFurnizor();
                    }
                    case 1: {
                        return fe.getNrFactura();
                    }
                    case 2: {
                        return fe.getNrNir();
                    }
                    case 3: {
                        return fe.getDataEmiteriiString();
                    }
                    case 4: {
                        return Utils.getString2Decimals(fe.getTotalGeneral());
                    }
                }
                return null;
            }
        };
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(FacturiReport.this.furnizoriCombo, FacturiReport.this.logic.getFurnizori(-1), true);
                ComboUtils.replaceItemsForCombo(FacturiReport.this.societati, ClientLogic.getInstance().getSocietatiPropriiSorted());
            }

            @Override
            public String getName() {
                return "FacturiReport_persJuridica";
            }
        }, 42);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return client_sorter;
            }
            case 1: {
                return serie_numar_sorter;
            }
            case 2: {
                return nir_numar_sorter;
            }
            case 3: {
                return date_sorter;
            }
            case 4: {
                return total_sorter;
            }
        }
        return null;
    }

    private void computeTotals(Vector items) {
        this.totalFacturi = 0.0;
        for (FacturiEntry element : items) {
            this.totalFacturi += element.getTotalGeneral();
        }
    }

    @Override
    public void cleanup() {
        this.furnizoriCombo.removeAllItems();
    }

    @Override
    public void exportToXml() {
        String inputFile = FileDialog.getSaveDialogLocation(this, LangRoAll.alegetiFisierulDestinatie, "xml");
        if (inputFile != null) {
            this.logic.exportFacturiToXml(this.data, inputFile);
            DialogUtils.okDialog(this, "Nirurile au fost exportate la " + inputFile, "Niruri exportate");
        }
    }

    @Override
    public boolean showXmlButton() {
        return true;
    }
}

