/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.gui.IntrariFurnizoriEntry;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;

public class IntrariFurnizoriReport
extends AbstractReportPanel
implements CleanupRequired {
    private Hashtable printCriteria = new Hashtable();
    private ReportInterface reportInterface;
    private JComboBox magazii;
    private JComboBox societati;
    private JComboBox tipProdus;
    private JComboBox tipComanda;
    private JComboBox tvaCombo;
    private JComboBox grupareCombo;
    public static final String[] columns = new String[]{"Furnizor", "CUI", LangRoAll.factura, LangRoAll.data, "Val la fur", LangRoAll.tva + " %", LangRoAll.tva, "Total fur", "Adaos", "Val vz", LangRoAll.tva + " %", LangRoAll.tva};
    private JLabel totalValFurnizor;
    private JLabel totalTvaFurnizor;
    private JLabel totalGeneralFurnizor;
    private JLabel totalAdaos;
    private JLabel totalValVz;
    private JLabel totalTva;
    private static Comparator furnizoriSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            IntrariFurnizoriEntry ri1 = (IntrariFurnizoriEntry)o1;
            IntrariFurnizoriEntry ri2 = (IntrariFurnizoriEntry)o2;
            return ri1.getFurnizor().compareToIgnoreCase(ri2.getFurnizor());
        }
    };
    private static Comparator cuiSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            IntrariFurnizoriEntry ri1 = (IntrariFurnizoriEntry)o1;
            IntrariFurnizoriEntry ri2 = (IntrariFurnizoriEntry)o2;
            return ri1.getCui().compareToIgnoreCase(ri2.getCui());
        }
    };
    private static Comparator facturaSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            IntrariFurnizoriEntry ri1 = (IntrariFurnizoriEntry)o1;
            IntrariFurnizoriEntry ri2 = (IntrariFurnizoriEntry)o2;
            return ri1.getFactura().compareToIgnoreCase(ri2.getFactura());
        }
    };
    private static Comparator dataSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            IntrariFurnizoriEntry ri1 = (IntrariFurnizoriEntry)o1;
            IntrariFurnizoriEntry ri2 = (IntrariFurnizoriEntry)o2;
            return ri1.getData().compareToIgnoreCase(ri2.getData());
        }
    };

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        String tipValue;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.magazii)) {
            Magazie m = (Magazie)this.magazii.getSelectedItem();
            result.put("id_magazie", m.getId());
            this.printCriteria.put("Magazie", m.getLabel());
        } else {
            result.put("id_magazie", -1);
            this.printCriteria.remove("Magazie");
        }
        this.printCriteria.remove("Societate");
        if (FacturiLogic.getInstance().isMultipleSocietatiEnabled() && ComboUtils.anythingButAllSelected(this.societati)) {
            ClientPersJuridica societate = (ClientPersJuridica)this.societati.getSelectedItem();
            result.put("Societate", societate);
            this.printCriteria.put("Societate", societate.getCompanyName());
        }
        if ((tipValue = (String)this.tipProdus.getSelectedItem()).equalsIgnoreCase("Finit")) {
            result.put("finit_ingredient", 2);
        } else if (tipValue.equalsIgnoreCase("Ingredient")) {
            result.put("finit_ingredient", 1);
        } else {
            result.put("finit_ingredient", -1);
        }
        this.printCriteria.put("finit_ingredient", tipValue);
        if (ComboUtils.anythingButAllSelected(this.tipComanda)) {
            StockLogic.COMANDA_TYPE c = (StockLogic.COMANDA_TYPE)((Object)this.tipComanda.getSelectedItem());
            result.put("Comanda Type", (Object)c);
        }
        if (ComboUtils.anythingButAllSelected(this.tvaCombo)) {
            Tva tvaCat = (Tva)this.tvaCombo.getSelectedItem();
            result.put(LangRoAll.tva, tvaCat);
            this.printCriteria.put(LangRoAll.tva, tvaCat.getId());
        } else {
            this.printCriteria.remove(LangRoAll.tva);
        }
        if (ComboUtils.anythingButAllSelected(this.grupareCombo)) {
            String g = (String)this.grupareCombo.getSelectedItem();
            result.put(Constants.GRUPARE_KEY, g);
            this.printCriteria.put(Constants.GRUPARE_KEY, g);
        } else {
            this.printCriteria.remove(Constants.GRUPARE_KEY);
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 0.0;
        this.societati = new JComboBox();
        c.gridy = 0;
        c.gridx = 0;
        if (FacturiLogic.getInstance().isMultipleSocietatiEnabled()) {
            c.weightx = 0.0;
            result.add((Component)new JLabel("Societatea"), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.societati, c);
            ++c.gridy;
            c.gridx = 0;
        }
        c.weightx = 0.0;
        result.add((Component)new JLabel("Magazie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.magazii = new JComboBox();
        result.add((Component)this.magazii, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Finit/ingredient"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tipProdus = new JComboBox();
        result.add((Component)this.tipProdus, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.tva), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tvaCombo = new JComboBox();
        result.add((Component)this.tvaCombo, c);
        this.tipComanda = new JComboBox();
        if (VpConfig.getInstance().futureStocksEnabled) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            result.add((Component)new JLabel("Tip Comanda"), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.tipComanda, c);
        }
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.grupare), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.grupareCombo = new JComboBox();
        result.add((Component)this.grupareCombo, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                IntrariFurnizoriEntry sqv = (IntrariFurnizoriEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return sqv.getFurnizor();
                    }
                    case 1: {
                        return sqv.getCui();
                    }
                    case 2: {
                        return sqv.getFactura();
                    }
                    case 3: {
                        return sqv.getData();
                    }
                    case 4: {
                        return Utils.getString2Decimals(sqv.getValFurnizor());
                    }
                    case 5: {
                        return sqv.getCotaTvaFurnizorPretty();
                    }
                    case 6: {
                        return Utils.getString2Decimals(sqv.getTvaFurnizor());
                    }
                    case 7: {
                        return Utils.getString2Decimals(sqv.getTotalFurnizor());
                    }
                    case 8: {
                        return Utils.getString2Decimals(sqv.getAdaos());
                    }
                    case 9: {
                        return Utils.getString2Decimals(sqv.getValVz());
                    }
                    case 10: {
                        return sqv.getCotaTvaVzPretty();
                    }
                    case 11: {
                        return Utils.getString2Decimals(sqv.getTvaVz());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Val la furnizor"), c);
        ++c.gridx;
        this.totalValFurnizor = new JLabel("");
        result.add((Component)this.totalValFurnizor, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.tva), c);
        ++c.gridx;
        this.totalTvaFurnizor = new JLabel("");
        result.add((Component)this.totalTvaFurnizor, c);
        ++c.gridx;
        result.add((Component)new JLabel("Total furnizor"), c);
        ++c.gridx;
        this.totalGeneralFurnizor = new JLabel("");
        result.add((Component)this.totalGeneralFurnizor, c);
        ++c.gridx;
        result.add((Component)new JLabel("Adaos"), c);
        ++c.gridx;
        this.totalAdaos = new JLabel("");
        result.add((Component)this.totalAdaos, c);
        ++c.gridx;
        result.add((Component)new JLabel("Total la pret vanzare"), c);
        ++c.gridx;
        this.totalValVz = new JLabel("");
        result.add((Component)this.totalValVz, c);
        ++c.gridx;
        result.add((Component)new JLabel("Din care tva"), c);
        ++c.gridx;
        this.totalTva = new JLabel("");
        result.add((Component)this.totalTva, c);
        return result;
    }

    @Override
    public String getName() {
        return "Intrari furnizori";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        Vector result = ContaLogic.getInstance().getIntrariFurnizori(criteria, this.whatToPrint);
        return result;
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void refreshTotalPanel() {
        double totalValFurnizor = 0.0;
        double totalTvaFurnizor = 0.0;
        double totalGeneralFurnizor = 0.0;
        double totalAdaos = 0.0;
        double totalVz = 0.0;
        double totalTvaVz = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            IntrariFurnizoriEntry o = (IntrariFurnizoriEntry)this.data.elementAt(i);
            totalValFurnizor += o.getValFurnizor();
            totalTvaFurnizor += o.getTvaFurnizor();
            totalGeneralFurnizor += o.getTotalFurnizor();
            totalAdaos += o.getAdaos();
            totalVz += o.getValVz();
            totalTvaVz += o.getTvaVz();
        }
        this.totalValFurnizor.setText(Utils.getString2Decimals(totalValFurnizor));
        this.totalTvaFurnizor.setText(Utils.getString2Decimals(totalTvaFurnizor));
        this.totalGeneralFurnizor.setText(Utils.getString2Decimals(totalGeneralFurnizor));
        this.totalAdaos.setText(Utils.getString2Decimals(totalAdaos));
        this.totalValVz.setText(Utils.getString2Decimals(totalVz));
        this.totalTva.setText(Utils.getString2Decimals(totalTvaVz));
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    IntrariFurnizoriEntry entry = (IntrariFurnizoriEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column++, row, entry.getFurnizor());
                        sheet.addCell((WritableCell)label);
                        label = new Label(column++, row, entry.getCui());
                        sheet.addCell((WritableCell)label);
                        label = new Label(column++, row, entry.getFactura());
                        sheet.addCell((WritableCell)label);
                        label = new Label(column++, row, entry.getData());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(column++, row, entry.getValFurnizor()));
                        label = new Label(column++, row, entry.getCotaTvaFurnizorPretty());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(column++, row, entry.getTvaFurnizor()));
                        sheet.addCell((WritableCell)new Number(column++, row, entry.getTotalFurnizor()));
                        sheet.addCell((WritableCell)new Number(column++, row, entry.getAdaos()));
                        sheet.addCell((WritableCell)new Number(column++, row, entry.getValVz()));
                        label = new Label(column++, row, entry.getCotaTvaVzPretty());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(column++, row, entry.getTvaVz()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return IntrariFurnizoriReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.magazii, StockLogic.getInstance().getMagazii());
        ComboUtils.replaceItemsForCombo(this.tipComanda, StockLogic.getComandaTypeCollection(), true);
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(IntrariFurnizoriReport.this.magazii, StockLogic.getInstance().getMagazii());
            }

            @Override
            public String getName() {
                return "StockViewPanel_magazii";
            }
        }, 27);
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 2;
                    }
                    case 2: {
                        return 2;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 4: {
                        return IntrariFurnizoriReport.this.totalValFurnizor.getText();
                    }
                    case 5: {
                        return IntrariFurnizoriReport.this.totalTvaFurnizor.getText();
                    }
                    case 6: {
                        return IntrariFurnizoriReport.this.totalGeneralFurnizor.getText();
                    }
                    case 7: {
                        return IntrariFurnizoriReport.this.totalAdaos.getText();
                    }
                    case 8: {
                        return IntrariFurnizoriReport.this.totalValVz.getText();
                    }
                    case 9: {
                        return IntrariFurnizoriReport.this.totalTva.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return IntrariFurnizoriReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return IntrariFurnizoriReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                IntrariFurnizoriEntry sqv = (IntrariFurnizoriEntry)row;
                switch (column) {
                    case 0: {
                        return sqv.getFurnizor();
                    }
                    case 1: {
                        return sqv.getCui();
                    }
                    case 2: {
                        return sqv.getFactura();
                    }
                    case 3: {
                        return sqv.getData();
                    }
                    case 4: {
                        return Utils.getString2Decimals(sqv.getValFurnizor());
                    }
                    case 5: {
                        return sqv.getCotaTvaFurnizorPretty();
                    }
                    case 6: {
                        return Utils.getString2Decimals(sqv.getTvaFurnizor());
                    }
                    case 7: {
                        return Utils.getString2Decimals(sqv.getTotalFurnizor());
                    }
                    case 8: {
                        return Utils.getString2Decimals(sqv.getAdaos());
                    }
                    case 9: {
                        return Utils.getString2Decimals(sqv.getValVz());
                    }
                    case 10: {
                        return sqv.getCotaTvaVzPretty();
                    }
                    case 11: {
                        return Utils.getString2Decimals(sqv.getTvaVz());
                    }
                }
                return null;
            }
        };
        this.tipProdus.addItem("All");
        this.tipProdus.addItem("Finit");
        this.tipProdus.addItem("Ingredient");
        ComboUtils.replaceItemsForCombo(this.societati, ClientLogic.getInstance().getSocietatiPropriiSorted());
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(IntrariFurnizoriReport.this.societati, ClientLogic.getInstance().getSocietatiPropriiSorted());
            }

            @Override
            public String getName() {
                return "IntrariFurnizoriReport_persJuridica";
            }
        }, 42);
        ComboUtils.replaceItemsForCombo(this.tvaCombo, TvaLogic.getInstance().getTvas(), true);
        this.grupareCombo.addItem("All");
        this.grupareCombo.addItem("Dupa TVA");
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return furnizoriSorter;
            }
            case 1: {
                return cuiSorter;
            }
            case 2: {
                return facturaSorter;
            }
            case 3: {
                return dataSorter;
            }
        }
        return null;
    }

    @Override
    public void cleanup() {
        this.magazii.removeAllItems();
    }
}

