/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JTabbedPane;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.Nir;
import ro.atreides.contabilitate.gui.EditNirPanel;
import ro.atreides.contabilitate.gui.FacturiReport;
import ro.atreides.contabilitate.gui.IntrariFurnizoriReport;
import ro.atreides.contabilitate.gui.IntrariReport;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.SwitchToList;

public class NirPanel
extends ReflectedJPanel
implements CleanupRequired {
    private ContaLogic logic = ContaLogic.getInstance();
    private EditNirPanel eNirPanel;
    private IntrariFurnizoriReport intrariReport;
    private FacturiReport facturi;
    private IntrariReport intrari;
    private JTabbedPane _tabbedPane;

    private void init() {
        this.setLayout(new GridBagLayout());
        this.eNirPanel = new EditNirPanel(this.logic, this);
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.add((Component)this.eNirPanel, "Adaugare nir");
        this.facturi = new FacturiReport();
        this.facturi.doStuff();
        this._tabbedPane.add((Component)this.facturi, this.facturi.getName());
        this.facturi.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                Factura factura = (Factura)o;
                Nir n = NirPanel.this.logic.getNirByFacturaId(factura.getId());
                NirPanel.this.eNirPanel.setFactura(factura, n);
                NirPanel.this._tabbedPane.setSelectedComponent(NirPanel.this.eNirPanel);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this.eNirPanel.setAction(new SwitchToList(){

            @Override
            public void doAction() {
                NirPanel.this._tabbedPane.setSelectedComponent(NirPanel.this.facturi);
            }
        });
        this.intrari = new IntrariReport();
        this.intrari.doStuff();
        this._tabbedPane.add((Component)this.intrari, this.intrari.getName());
        this.intrariReport = new IntrariFurnizoriReport();
        this.intrariReport.doStuff();
        this._tabbedPane.add((Component)this.intrariReport, this.intrariReport.getName());
        int max = this._tabbedPane.getTabCount();
        for (int i = 0; i < max; ++i) {
            ReflectedJPanel panel = (ReflectedJPanel)this._tabbedPane.getComponentAt(i);
            panel.setUserLogInterface(this.userLogInterface);
            this._tabbedPane.setBackgroundAt(i, Constants.BO_TAB_LEVEL_TWO_COLOR);
        }
        GuiUtilsRest.addPiratGuiMouseListenerForReports(this._tabbedPane);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this._tabbedPane, c);
    }

    @Override
    public void doStuff() {
        this.init();
    }

    @Override
    public void cleanup() {
        this.eNirPanel.cleanup();
        this.intrariReport.cleanup();
        this.intrari.cleanup();
        this.facturi.cleanup();
    }
}

