/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.IncasariClientiEntry;
import ro.atreides.print.PrintLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class PlatiFurnizoriReport
extends AbstractReportPanel {
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JLabel totalCollectedLabel;
    public static final String[] columns = new String[]{LangRoAll.client, LangRoAll.factura, "Data platii", LangRoAll.suma};
    private JComboBox clientiCombo;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Integer>> result = new Hashtable<String, Comparable<Integer>>();
        Object client = this.clientiCombo.getSelectedItem();
        if (ComboUtils.anythingButAllSelected(this.clientiCombo)) {
            Client c = (Client)client;
            result.put(Constants.CLIENT_KEY, Integer.valueOf(c.getId()));
            this.printCriteria.put(Constants.CLIENT_KEY, c.toString());
        } else {
            result.put(Constants.CLIENT_KEY, Integer.valueOf(-1));
            this.printCriteria.remove(Constants.CLIENT_KEY);
        }
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        this.printCriteria.put(LangRoAll.dataRaportarii, Formatters.DATE_AND_TIME_FORMAT.format(new Date()));
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ContaLogic.getInstance().getPlatiInPerioada(criteria, this.whatToPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    IncasariClientiEntry fe = (IncasariClientiEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, fe.getClient());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, fe.getNumarFactura());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, fe.getDataPlata());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getSuma()));
                        ++column;
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return PlatiFurnizoriReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Detalii plati";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(4), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                IncasariClientiEntry fe = (IncasariClientiEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fe.getClient();
                    }
                    case 1: {
                        return fe.getNumarFactura();
                    }
                    case 2: {
                        return fe.getDataPlata();
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getSuma());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Total Platit"), c);
        ++c.gridx;
        this.totalCollectedLabel = new JLabel("");
        result.add((Component)this.totalCollectedLabel, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Furnizor"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clientiCombo = new JComboBox();
        result.add((Component)this.clientiCombo, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        double totalPlatit = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            IncasariClientiEntry o = (IncasariClientiEntry)this.data.elementAt(i);
            totalPlatit += o.getSuma();
        }
        this.totalCollectedLabel.setText(Utils.getString2Decimals(totalPlatit));
    }

    @Override
    public void doStuff() {
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 3: {
                        return PlatiFurnizoriReport.this.totalCollectedLabel.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return PlatiFurnizoriReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return PlatiFurnizoriReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                IncasariClientiEntry fe = (IncasariClientiEntry)row;
                switch (column) {
                    case 0: {
                        return fe.getClient();
                    }
                    case 1: {
                        return fe.getNumarFactura();
                    }
                    case 2: {
                        return fe.getDataPlata();
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getSuma());
                    }
                }
                return null;
            }
        };
        ComboUtils.replaceItemsForCombo(this.clientiCombo, ContaLogic.getInstance().getFurnizori(-1), true);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(PlatiFurnizoriReport.this.clientiCombo, ContaLogic.getInstance().getFurnizori(-1), false);
            }

            @Override
            public String getName() {
                return "PlatiFurnizoriReport_clienti";
            }
        }, 42);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

