/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.RegistruCasaEntry;
import ro.atreides.contabilitate.TipRegistru;
import ro.atreides.contabilitate.saga.SagaExportLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.FacturiNeplatiteEntry;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateAndTimeChooser;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class RegCasaPanel
extends AbstractReportPanel {
    private DateAndTimeChooser plataChooser;
    private DateAndTimeChooser incasareChooser;
    public static final String[] columns = new String[]{"Cont", "Nr. act casa", "Nr. anexa", "Explicatii", LangRoAll.incasari, "Plati", LangRoAll.data};
    private JLabel totalIncasari;
    private JLabel totalPlati;
    private JLabel soldFinal;
    private JLabel soldInitial;
    private ContaLogic contaLogic;
    private JComboBox cont;
    private JComboBox contSursa;
    private JComboBox contDestinatie;
    private Hashtable printCriteria = new Hashtable();
    private double totalIn;
    private double totalOut;
    private double totalLeft;
    private double totalStart;
    private JTextField valoarePlata;
    private JTextField anexaPlati;
    private JTextField actCasaPlati;

    public RegCasaPanel(ContaLogic contaLogic) {
        this.contaLogic = contaLogic;
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.cont)) {
            TipRegistru m = (TipRegistru)this.cont.getSelectedItem();
            result.put("id_cont_key", Integer.valueOf(m.getId()));
            this.printCriteria.put("id_cont_key", m.getLabel());
        } else {
            result.put("id_cont_key", Integer.valueOf(-1));
            this.printCriteria.remove("id_cont_key");
        }
        return result;
    }

    @Override
    public void printReport() {
        String d1 = (String)this.printCriteria.get(LangRoAll.start);
        String d2 = (String)this.printCriteria.get(LangRoAll.stop);
        this.contaLogic.printRegistruCasa(this.data, "", d1 + " - " + d2, this.totalIn, this.totalOut, this.totalStart, this.totalLeft);
    }

    @Override
    public void printPreview() {
        String d1 = (String)this.printCriteria.get(LangRoAll.start);
        String d2 = (String)this.printCriteria.get(LangRoAll.stop);
        this.contaLogic.previewRegistruCasa(this.data, "", d1 + " - " + d2, this.totalIn, this.totalOut, this.totalStart, this.totalLeft);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        int idCont = (Integer)criteria.get("id_cont_key");
        Date start = (Date)criteria.get(Constants.START_KEY);
        Date stop = (Date)criteria.get(Constants.STOP_KEY);
        return this.contaLogic.getRegistruCasa(start, stop, idCont, this.whatToPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    RegistruCasaEntry entry = (RegistruCasaEntry)o;
                    try {
                        Label label = new Label(0, row, entry.getNrActCasa());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getNrAnexa());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getExplicatii());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(3, row, entry.getIncasari()));
                        sheet.addCell((WritableCell)new Number(4, row, entry.getPlati()));
                        label = new Label(5, row, entry.getDataAsString());
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return RegCasaPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Registru casa";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RegistruCasaEntry entry = (RegistruCasaEntry)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return entry.getNumeCont();
                    }
                    case 1: {
                        return entry.getNrActCasa();
                    }
                    case 2: {
                        return entry.getNrAnexa();
                    }
                    case 3: {
                        return entry.getExplicatii();
                    }
                    case 4: {
                        return entry.isPlata() ? "" : Utils.getString2Decimals(entry.getIncasari());
                    }
                    case 5: {
                        return entry.isPlata() ? Utils.getString2Decimals(entry.getPlati()) : "";
                    }
                    case 6: {
                        return entry.getDataAsString();
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        return this.tm;
    }

    private String getDetaliiPlata(Vector plati) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < plati.size(); ++i) {
            FacturiNeplatiteEntry o = (FacturiNeplatiteEntry)plati.elementAt(i);
            sb.append(o.getFactura());
            sb.append("=");
            sb.append(Utils.getString2Decimals(o.getPlatimAcum()));
            sb.append(',');
        }
        return sb.toString();
    }

    private double getTotal(Vector plati) {
        double result = 0.0;
        for (int i = 0; i < plati.size(); ++i) {
            FacturiNeplatiteEntry o = (FacturiNeplatiteEntry)plati.elementAt(i);
            result += o.getPlatimAcum();
        }
        return result;
    }

    private JPanel getAddPlataPanel() {
        final JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Act casa"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.actCasaPlati = new JTextField(25);
        result.add((Component)this.actCasaPlati, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Valoare plata"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.valoarePlata = new JTextField(25);
        result.add((Component)this.valoarePlata, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.plataChooser = new DateAndTimeChooser("Alege data platii");
        result.add((Component)this.plataChooser, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Numar anexa"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.anexaPlati = new JTextField(25);
        result.add((Component)this.anexaPlati, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Explicatii"), c);
        ++c.gridx;
        c.weightx = 1.0;
        final JTextField explain = new JTextField(25);
        result.add((Component)explain, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        JButton set = new JButton(LangRoAll.adauga);
        set.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double total = Utils.parseDouble(RegCasaPanel.this.valoarePlata.getText());
                    String ac = RegCasaPanel.this.actCasaPlati.getText();
                    String exp = explain.getText();
                    String an = RegCasaPanel.this.anexaPlati.getText();
                    if (!ComboUtils.anythingButAllSelected(RegCasaPanel.this.cont)) {
                        DialogUtils.errorDialog(result, "Alegeti contul destinatie", LangRoAll.nuPotContinua);
                        RegCasaPanel.this.cont.requestFocus();
                        return;
                    }
                    TipRegistru tr = (TipRegistru)RegCasaPanel.this.cont.getSelectedItem();
                    int idCont = tr.getId();
                    Date d = RegCasaPanel.this.plataChooser.getDateAndTime();
                    if (d == null) {
                        return;
                    }
                    boolean fiscal = true;
                    fiscal = RegCasaPanel.this.whatToPrint != 3;
                    RegCasaPanel.this.contaLogic.addPlata(ac, an, exp, total, idCont, d, new Vector(), fiscal, -1);
                    Map o = ContaLogic.getInstance().buildMapForPlata(ac, exp, d, total, an, tr.toString());
                    GenericListenersLogic.getInstance().notifyObjectListeners(1, o);
                    RegCasaPanel.this.raport();
                    RegCasaPanel.this.actCasaPlati.setText("");
                    RegCasaPanel.this.valoarePlata.setText("");
                    explain.setText("");
                    RegCasaPanel.this.anexaPlati.setText("");
                }
                catch (NumberFormatException e1) {
                    DialogUtils.errorDialog(result, "Valoare incorecta", LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)set, c);
        result.setBorder(new TitledBorder("Adauga plata"));
        return result;
    }

    private JPanel getAddIncasariPanel() {
        final JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Nr act casa"), c);
        c.weightx = 1.0;
        final JTextField codZ = new JTextField(25);
        ++c.gridx;
        result.add((Component)codZ, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Nr anexa"), c);
        c.weightx = 1.0;
        final JTextField anexa = new JTextField(25);
        ++c.gridx;
        result.add((Component)anexa, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.incasareChooser = new DateAndTimeChooser("Alege data incasarii");
        result.add((Component)this.incasareChooser, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Explicatii"), c);
        final JTextField explain = new JTextField(25);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)explain, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Incasare"), c);
        c.weightx = 1.0;
        final JTextField valoareZ = new JTextField(25);
        ++c.gridx;
        result.add((Component)valoareZ, c);
        ++c.gridx;
        c.weighty = 1.0;
        c.weightx = 0.0;
        c.gridwidth = 2;
        JButton set = new JButton(LangRoAll.adauga);
        set.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String cod = codZ.getText();
                    double total = Utils.parseDouble(valoareZ.getText());
                    String an = anexa.getText();
                    String ex = LangRoAll.incasari;
                    if (Validators.correctString(explain.getText())) {
                        ex = explain.getText();
                    }
                    if (!ComboUtils.anythingButAllSelected(RegCasaPanel.this.cont)) {
                        DialogUtils.errorDialog(result, "Alegeti contul destinatie", LangRoAll.nuPotContinua);
                        RegCasaPanel.this.cont.requestFocus();
                        return;
                    }
                    TipRegistru tr = (TipRegistru)RegCasaPanel.this.cont.getSelectedItem();
                    int idCont = tr.getId();
                    Date d = RegCasaPanel.this.incasareChooser.getDateAndTime();
                    if (d == null) {
                        return;
                    }
                    boolean fiscal = true;
                    fiscal = RegCasaPanel.this.whatToPrint != 3;
                    RegCasaPanel.this.contaLogic.addIncasare(total, cod, an, ex, idCont, d, new Vector(), fiscal, -1);
                    Map o = ContaLogic.getInstance().builIncasareFortataMap(cod, ex, Formatters.DATE_FORMAT_RO.format(d), String.valueOf(total), anexa.getText());
                    GenericListenersLogic.getInstance().notifyObjectListeners(88, o);
                    RegCasaPanel.this.raport();
                    codZ.setText("");
                    valoareZ.setText("");
                    anexa.setText("");
                    explain.setText("");
                }
                catch (NumberFormatException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
        });
        result.add((Component)set, c);
        result.setBorder(new TitledBorder("Adauga incasare"));
        return result;
    }

    private JPanel getAdaugaTransferPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Cont sursa"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.contSursa = new JComboBox();
        result.add((Component)this.contSursa, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Comision cont sursa"), c);
        c.weightx = 1.0;
        final JTextField comisionSursa = new JTextField(25);
        ++c.gridx;
        result.add((Component)comisionSursa, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Act casa"), c);
        c.weightx = 1.0;
        final JTextField actCasa = new JTextField("Transfer");
        ++c.gridx;
        result.add((Component)actCasa, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Cont destinatie"), c);
        c.weightx = 1.0;
        this.contDestinatie = new JComboBox();
        ++c.gridx;
        result.add((Component)this.contDestinatie, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Comision cont destinatie"), c);
        c.weightx = 1.0;
        final JTextField comisionDestinatie = new JTextField(25);
        ++c.gridx;
        result.add((Component)comisionDestinatie, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Explicatii"), c);
        final JTextField explicatii = new JTextField(25);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)explicatii, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Suma"), c);
        c.weightx = 1.0;
        final JTextField sumaField = new JTextField(25);
        ++c.gridx;
        result.add((Component)sumaField, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        ++c.gridx;
        c.weightx = 1.0;
        final DateAndTimeChooser dataTranzactiei = new DateAndTimeChooser("Alege data incasarii");
        result.add((Component)dataTranzactiei, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Nr anexa"), c);
        c.weightx = 1.0;
        final JTextField nrAnexa = new JTextField(25);
        ++c.gridx;
        result.add((Component)nrAnexa, c);
        c.fill = 1;
        c.gridx = 6;
        c.gridy = 0;
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 3;
        c.gridwidth = 2;
        JButton addTranzactie = new JButton(LangRoAll.adauga);
        addTranzactie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String comisionDestinatieS;
                TipRegistru destinatie;
                TipRegistru sursa = (TipRegistru)RegCasaPanel.this.contSursa.getSelectedItem();
                if (sursa.equals(destinatie = (TipRegistru)RegCasaPanel.this.contDestinatie.getSelectedItem())) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Conturile sursa si destinatie trebuie sa fie diferite", LangRoAll.eroare);
                    return;
                }
                Date d = dataTranzactiei.getDateAndTime();
                if (d == null) {
                    return;
                }
                String actCasaS = actCasa.getText();
                String explicatiiS = explicatii.getText();
                String nrAnexaS = nrAnexa.getText();
                double suma = 0.0;
                double comisionSursaFloat = 0.0;
                double comisionDestinatieFloat = 0.0;
                String sumaS = sumaField.getText();
                if (sumaS.isEmpty() || !sumaS.isEmpty() && !Validators.correctDouble(sumaS)) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Suma incorecta", LangRoAll.eroare);
                    return;
                }
                suma = Double.valueOf(sumaS);
                String comisionSursaS = comisionSursa.getText();
                if (!comisionSursaS.isEmpty() && !Validators.correctDouble(comisionSursaS)) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Comision cont sursa incorect", LangRoAll.eroare);
                    return;
                }
                if (!comisionSursaS.isEmpty()) {
                    comisionSursaFloat = Double.valueOf(comisionSursaS);
                }
                if (!(comisionDestinatieS = comisionDestinatie.getText()).isEmpty() && !Validators.correctDouble(comisionDestinatieS)) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Comision cont destinatie incorect", LangRoAll.eroare);
                    return;
                }
                if (!comisionDestinatieS.isEmpty()) {
                    comisionDestinatieFloat = Double.valueOf(comisionDestinatieS);
                }
                boolean fiscal = true;
                fiscal = RegCasaPanel.this.whatToPrint != 3;
                RegCasaPanel.this.contaLogic.addPlata(actCasaS, nrAnexaS, explicatiiS, suma, sursa.getId(), d, new Vector(), fiscal, -1);
                Map plataSumaMap = ContaLogic.getInstance().buildMapForPlata(actCasaS, explicatiiS, d, suma, nrAnexaS, sursa.toString());
                GenericListenersLogic.getInstance().notifyObjectListeners(1, plataSumaMap);
                if (comisionSursaFloat > 0.0) {
                    RegCasaPanel.this.contaLogic.addPlata(actCasaS, nrAnexaS, LangRoAll.comision, comisionSursaFloat, sursa.getId(), d, new Vector(), fiscal, -1);
                    Map plataComisionSursaMap = ContaLogic.getInstance().buildMapForPlata(actCasaS, LangRoAll.comision, d, comisionSursaFloat, nrAnexaS, sursa.toString());
                    GenericListenersLogic.getInstance().notifyObjectListeners(1, plataComisionSursaMap);
                }
                RegCasaPanel.this.contaLogic.addIncasare(suma, actCasaS, nrAnexaS, explicatiiS, destinatie.getId(), d, new Vector(), fiscal, -1);
                Map incasareSumaMap = ContaLogic.getInstance().builIncasareFortataMap(actCasaS, LangRoAll.comision, Formatters.DATE_FORMAT_RO.format(d), String.valueOf(suma), nrAnexaS);
                GenericListenersLogic.getInstance().notifyObjectListeners(88, incasareSumaMap);
                if (comisionSursaFloat > 0.0) {
                    RegCasaPanel.this.contaLogic.addIncasare(comisionDestinatieFloat, actCasaS, nrAnexaS, LangRoAll.comision, destinatie.getId(), d, new Vector(), fiscal, -1);
                    Map incasareComisionDestinatieMap = ContaLogic.getInstance().builIncasareFortataMap(actCasaS, LangRoAll.comision, Formatters.DATE_FORMAT_RO.format(d), String.valueOf(comisionDestinatieFloat), nrAnexaS);
                    GenericListenersLogic.getInstance().notifyObjectListeners(88, incasareComisionDestinatieMap);
                }
                sumaField.setText("");
                comisionSursa.setText("");
                comisionDestinatie.setText("");
                actCasa.setText("Transfer");
                explicatii.setText("");
                nrAnexa.setText("");
                RegCasaPanel.this.raport();
            }
        });
        result.add((Component)addTranzactie, c);
        result.setBorder(new TitledBorder("Adauga transfer"));
        return result;
    }

    @Override
    public void exportToDbf() {
        if (Config.getInstance().getBoolean("sagaExportEnabled") && DialogUtils.confirmDialog(this, "Exportam datele pentru Saga", LangRoAll.confirmare)) {
            String saveDir = SagaExportLogic.getInstance().exportDateSaga(this, this.contaLogic.getPriceInterface());
            if (saveDir != null) {
                DialogUtils.okDialog(this, "Datele au fost salvate la " + saveDir, LangRoAll.succes);
            } else {
                DialogUtils.errorDialog(this, "Export esuat", LangRoAll.eroare);
            }
        }
    }

    @Override
    protected void dbf() {
        this.exportToDbf();
    }

    @Override
    public boolean showDbfButton() {
        return true;
    }

    private JPanel getTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        this.soldInitial = new JLabel();
        this.soldFinal = new JLabel();
        this.totalIncasari = new JLabel();
        this.totalPlati = new JLabel();
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Sold initial"), c);
        ++c.gridx;
        result.add((Component)this.soldInitial, c);
        ++c.gridx;
        result.add((Component)new JLabel("Total incasari"), c);
        ++c.gridx;
        result.add((Component)this.totalIncasari, c);
        ++c.gridx;
        result.add((Component)new JLabel("Total plati"), c);
        ++c.gridx;
        result.add((Component)this.totalPlati, c);
        ++c.gridx;
        result.add((Component)new JLabel("Sold final"), c);
        ++c.gridx;
        result.add((Component)this.soldFinal, c);
        result.setBorder(new TitledBorder(LangRoAll.total));
        return result;
    }

    @Override
    protected boolean totalPanelLabel() {
        return false;
    }

    private void computeTotals(Vector items) {
        this.totalIn = 0.0;
        this.totalOut = 0.0;
        this.totalLeft = 0.0;
        this.totalStart = 0.0;
        for (int i = 0; i < items.size(); ++i) {
            RegistruCasaEntry o = (RegistruCasaEntry)items.elementAt(i);
            this.totalIn += o.getIncasari();
            this.totalOut += o.getPlati();
            if (i != 0) continue;
            this.totalStart = o.getIncasari();
            this.totalIn = 0.0;
        }
        this.totalLeft = this.totalStart + this.totalIn - this.totalOut;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.gridx = 0;
        c.fill = 2;
        c.gridy = 0;
        JTabbedPane tab = new JTabbedPane();
        tab.add((Component)this.getAddPlataPanel(), "Adauga plata");
        tab.add((Component)this.getAddIncasariPanel(), "Adauga incasare");
        tab.add((Component)this.getAdaugaTransferPanel(), "Adauga transfer");
        result.add((Component)tab, c);
        ++c.gridy;
        result.add((Component)this.getTotalPanel(), c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        buttonsPanel.add((Component)new JLabel("Cont"), c);
        ++c.gridx;
        this.cont = new JComboBox();
        buttonsPanel.add((Component)this.cont, c);
        return buttonsPanel;
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.totalIncasari.setText(Utils.getString2Decimals(this.totalIn));
        this.totalPlati.setText(Utils.getString2Decimals(this.totalOut));
        this.soldFinal.setText(Utils.getString2Decimals(this.totalLeft));
        this.soldInitial.setText(Utils.getString2Decimals(this.totalStart));
    }

    @Override
    public void doStuff() {
        Vector tipRegistre = this.contaLogic.getAllTipRegistru(AdministrationPanel.loggedUser.getLanguage());
        ComboUtils.replaceItemsForCombo(this.cont, tipRegistre);
        ComboUtils.replaceItemsForCombo(this.contSursa, (Collection)tipRegistre, false);
        ComboUtils.replaceItemsForCombo(this.contDestinatie, (Collection)tipRegistre, false);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RegistruCasaEntry entry;
                int selRow = RegCasaPanel.this.table.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2 && (entry = (RegistruCasaEntry)RegCasaPanel.this.tm.getObjectAt(selRow)).getId() > 0 && DialogUtils.confirmDialog(RegCasaPanel.this.table, "Stergem aceasta inregistrare", LangRoAll.confirmare)) {
                    RegCasaPanel.this.contaLogic.removeRegCasaEntry(entry);
                }
                RegCasaPanel.this.raport();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

