/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.imports.ciel;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.units.UnitsLogic;

public class CielFacturiCumparareImporter {
    private ConnectionPool pool = ConnectionPool.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFacturiCumparare(String borderouInputFile, String tranzatiiInputFile, int idSocietateaNoastra) {
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(borderouInputFile));
            String line = reader.readLine();
            int lineNumber = 1;
            while (line != null) {
                Vector fields = Utils.splitStringKeepStructure(line, '|', ' ');
                String nrDocument = (String)fields.get(0);
                String dataS = (String)fields.get(1);
                try {
                    Date d = Formatters.CIEL_NIR_IMPORT_FORMAT.parse(dataS);
                    Timestamp dataT = new Timestamp(d.getTime());
                    String furnizorS = (String)fields.get(4);
                    Vector ff = Utils.splitString(furnizorS, ':');
                    String furnizorCod = (String)ff.get(0);
                    String furnizorName = (String)ff.get(1);
                    furnizorName = furnizorName.trim();
                    Client furnizor = ClientLogic.getInstance().getClientByNameNoCommit(furnizorName);
                    if (furnizor != null) {
                        String magazieS = (String)fields.get(5);
                        Magazie m = StockLogic.getInstance().getMagazieByLabel(magazieS);
                        if (m != null) {
                            String valoareFaraTvaS = (String)fields.get(11);
                            String valoareTvaS = (String)fields.get(12);
                            String valoareTotalaS = (String)fields.get(13);
                            valoareFaraTvaS = valoareFaraTvaS.replaceAll(",", "");
                            valoareTvaS = valoareTvaS.replaceAll(",", "");
                            valoareTotalaS = valoareTotalaS.replaceAll(",", "");
                            double val1 = Utils.parseDouble(valoareFaraTvaS);
                            double val2 = Utils.parseDouble(valoareTvaS);
                            double val3 = Utils.parseDouble(valoareTotalaS);
                            double cotaTva = val3 / val1 - 1.0;
                            double tvaNoi = TvaLogic.getInstance().getCotaTva();
                            Vector items = this.importItemsForFactura(tranzatiiInputFile, nrDocument, m, cotaTva, tvaNoi, furnizorName);
                            cotaTva = FloatUtils.roundFloat(cotaTva, 2);
                            Tva tva = TvaLogic.getInstance().getTvaByCota(cotaTva);
                            if (tva != null) {
                                int nrNir = ContaLogic.getInstance().getNextNrNir(idSocietateaNoastra, true);
                                int idNir = ContaLogic.getInstance().addNirNoCommit(nrDocument + "", "", dataT, furnizor.getId(), nrNir, items, false, new Vector(), true, idSocietateaNoastra, ContaLogic.TIP_DOCUMENT_NIR.Factura.getTip(), StockLogic.COMANDA_TYPE.EFECTUAT, dataT);
                                ContaLogic.getInstance().closeNirNoCommit(idNir, 0.0, 0.0, 0.0, val1, val2, val3);
                            } else {
                                Logger.logWarning(this, "Linia: " + lineNumber + " TVA " + cotaTva + " nu a fost gasit . Linie ignorata");
                            }
                        } else {
                            Logger.logWarning(this, "Linia: " + lineNumber + " Magazia " + magazieS + " nu a fost gasita . Linie ignorata");
                        }
                    } else {
                        Logger.logWarning(this, "Linia: " + lineNumber + " Furnizorul " + furnizorName + " nu a fost gasita . Linie ignorata");
                    }
                }
                catch (ParseException e) {
                    Logger.logException(this, (Exception)e);
                    Logger.logWarning(this, "ParseException: Linia: " + lineNumber + ": " + line);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Logger.logException(this, (Exception)e);
                    Logger.logWarning(this, "ArrayIndexOutOfBoundsException: Linia: " + lineNumber + ": " + line);
                }
                line = reader.readLine();
                ++lineNumber;
            }
            this.pool.commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Vector importItemsForFactura(String inputFile, String nrDocument, Magazie m, double cotaTva, double tvaNoi, String furnizor) throws IOException, SQLException {
        Vector<NirEntryFull> result = new Vector<NirEntryFull>();
        LineNumberReader reader = new LineNumberReader(new FileReader(inputFile));
        String line = reader.readLine();
        int lineNumber = 1;
        while (line != null) {
            if (line.startsWith(nrDocument)) {
                Vector fields = Utils.splitStringKeepStructure(line, '|', ' ');
                String fur = (String)fields.get(1);
                if (furnizor.equalsIgnoreCase(fur)) {
                    String codS = (String)fields.get(2);
                    String quantityS = (String)fields.get(4);
                    String valoareS = (String)fields.get(8);
                    Product p = NomeclaturaLogic.getInstance().getProductByCodBareNoCommit(codS);
                    if (p != null) {
                        int idStock = StockLogic.getInstance().getStockInterface().getIdStockForProductNoCommit(p.getId());
                        if (idStock != -1) {
                            Stock stock = StockLogic.getInstance().getStockById(idStock);
                            int idUnit = stock.getIdUnit();
                            Unit u = UnitsLogic.getInstance().getUnitByIdNoCommit(idUnit);
                            if (u != null) {
                                String productName = stock.getLabel();
                                String unitName = u.getLabel();
                                double q = Utils.parseDouble(quantityS);
                                double valoare = Utils.parseDouble(valoareS);
                                double pretUnitar = valoare / q;
                                NirEntryFull toAdd = new NirEntryFull(-1, -1, stock.getId(), productName, unitName, q, pretUnitar, -1.0, -1.0, -1.0, cotaTva, idUnit, tvaNoi, m.getId(), m.getLabel(), 1);
                                toAdd.setNrCrt(result.size() + 1);
                                toAdd.compute();
                                result.add(toAdd);
                            } else {
                                Logger.logWarning(this, "Linia: " + lineNumber + "Unitatea de masura asociata produsului : " + p.getName() + " nu exista in baza de date . Linie ignorata");
                            }
                        } else {
                            Logger.logWarning(this, "Linia: " + lineNumber + "Stocul asociat produsului : " + p.getName() + " nu exista in baza de date . Linie ignorata");
                        }
                    } else {
                        Logger.logWarning(this, "Linia: " + lineNumber + " Codul " + codS + " nu exista in baza de date . Linie ignorata");
                    }
                } else {
                    Logger.logWarning(this, "Linia: " + lineNumber + " Caut furnizorul " + furnizor + " dar am gasit " + fur + " . Linie ignorata");
                }
            }
            line = reader.readLine();
            ++lineNumber;
        }
        return result;
    }
}

